/*
 * Decompiled with CFR 0.152.
 */
package nbs_tetris;

import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import nbs_tetris.TetrisItem;
import nbs_tetris.TetrisView;
import nbs_tetris.tetrisMIDlet;

public class PreferencesForm
extends Form
implements CommandListener {
    private Command cancel_cmd;
    private Command default_cmd;
    private Command help_cmd;
    private TextField initial_rate_field;
    private ChoiceGroup lng_choice;
    private tetrisMIDlet midlet = tetrisMIDlet.getInstance();
    private TextField minimum_rate_field;
    private TextField next_level_delta_field;
    private TextField next_level_devider_field;
    private ChoiceGroup orientation_choice;
    private ChoiceGroup prohib_elements_choice;
    private Command save_cmd = new Command(this.midlet.getI18n("save"), 1, 0);
    private ChoiceGroup show_anim_ondel;
    private ChoiceGroup show_grid_choice;
    private ChoiceGroup siemens_bug_choiche;
    private ChoiceGroup usenonstd_elements_choice;

    public PreferencesForm() {
        super("");
        this.cancel_cmd = new Command(this.midlet.getI18n("cancel"), 1, 1);
        this.default_cmd = new Command(this.midlet.getI18n("default"), 1, 2);
        this.help_cmd = new Command(this.midlet.getI18n("help"), 1, 3);
        this.setTitle(this.midlet.getI18n("preferences"));
        try {
            this.setCommandListener(this);
            String[] stringArray = new String[]{this.midlet.getI18n("english"), this.midlet.getI18n("russian")};
            this.lng_choice = new ChoiceGroup(this.midlet.getI18n("language"), 1, stringArray, null);
            if (this.midlet.getLng().equals("ru")) {
                this.lng_choice.setSelectedIndex(1, true);
            } else {
                this.lng_choice.setSelectedIndex(0, true);
            }
            this.append((Item)this.lng_choice);
            stringArray[0] = this.midlet.getI18n("horizontal");
            stringArray[1] = this.midlet.getI18n("vertical");
            this.orientation_choice = new ChoiceGroup(this.midlet.getI18n("orientation"), 1, stringArray, null);
            if (this.midlet.getTetris().getOrientation() == 1) {
                this.orientation_choice.setSelectedIndex(0, true);
            } else {
                this.orientation_choice.setSelectedIndex(1, true);
            }
            this.append((Item)this.orientation_choice);
            stringArray[0] = this.midlet.getI18n("enable");
            stringArray[1] = this.midlet.getI18n("disable");
            this.show_grid_choice = new ChoiceGroup(this.midlet.getI18n("show_grid"), 1, stringArray, null);
            if (this.midlet.getTetris().isShow_grid()) {
                this.show_grid_choice.setSelectedIndex(0, true);
            } else {
                this.show_grid_choice.setSelectedIndex(1, true);
            }
            this.append((Item)this.show_grid_choice);
            this.show_anim_ondel = new ChoiceGroup(this.midlet.getI18n("show_anim_ondel"), 1, stringArray, null);
            if (this.midlet.getTetris().isShow_animation_on_removing_line()) {
                this.show_anim_ondel.setSelectedIndex(0, true);
            } else {
                this.show_anim_ondel.setSelectedIndex(1, true);
            }
            this.append((Item)this.show_anim_ondel);
            int n = TetrisItem.ELEMENT_MAPS.length - 7;
            String[] stringArray2 = new String[n];
            Image[] imageArray = new Image[n];
            String string = this.midlet.getI18n("use_element");
            boolean[] blArray = new boolean[n];
            n = 0;
            while (n < stringArray2.length) {
                stringArray2[n] = string;
                imageArray[n] = Image.createImage((String)("/res/element" + (7 + n) + ".png"));
                int n2 = 1;
                blArray[n] = (this.midlet.getTetris().getProhibition_elements() & (n2 <<= n + 7)) > 0;
                ++n;
            }
            this.prohib_elements_choice = new ChoiceGroup(this.midlet.getI18n("nonstand_el"), 2, stringArray2, imageArray);
            this.append((Item)this.prohib_elements_choice);
            this.prohib_elements_choice.setSelectedFlags(blArray);
            stringArray[0] = this.midlet.getI18n("always");
            stringArray[1] = this.midlet.getI18n("on_nextlevel");
            this.usenonstd_elements_choice = new ChoiceGroup(this.midlet.getI18n("usenonstand_el"), 1, stringArray, null);
            if (!this.midlet.getTetris().isUsenonstdel_on_nextlvl()) {
                this.usenonstd_elements_choice.setSelectedIndex(0, true);
            } else {
                this.usenonstd_elements_choice.setSelectedIndex(1, true);
            }
            this.append((Item)this.usenonstd_elements_choice);
            this.initial_rate_field = new TextField(this.midlet.getI18n("initial_rate"), String.valueOf(this.midlet.getTetris().getInitial_rate()), 5, 2);
            this.append((Item)this.initial_rate_field);
            this.minimum_rate_field = new TextField(this.midlet.getI18n("minimum_rate"), String.valueOf(this.midlet.getTetris().getMinimum_rate()), 5, 2);
            this.append((Item)this.minimum_rate_field);
            this.next_level_delta_field = new TextField(this.midlet.getI18n("next_level_delta"), String.valueOf(this.midlet.getTetris().getNext_level_delta()), 5, 2);
            this.append((Item)this.next_level_delta_field);
            this.next_level_devider_field = new TextField(this.midlet.getI18n("next_level_devider"), String.valueOf(this.midlet.getTetris().getNext_level_devider()), 5, 2);
            this.append((Item)this.next_level_devider_field);
            stringArray[0] = this.midlet.getI18n("enable");
            stringArray[1] = this.midlet.getI18n("disable");
            this.siemens_bug_choiche = new ChoiceGroup(this.midlet.getI18n("siemens_bug_fix"), 1, stringArray, null);
            if (this.midlet.isSiemens_bug_fix()) {
                this.siemens_bug_choiche.setSelectedIndex(0, true);
            } else {
                this.siemens_bug_choiche.setSelectedIndex(1, true);
            }
            this.append((Item)this.siemens_bug_choiche);
            this.addCommand(this.save_cmd);
            this.addCommand(this.help_cmd);
            this.addCommand(this.cancel_cmd);
        }
        catch (Exception exception) {}
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.cancel_cmd) {
            this.midlet.showMenu();
        } else if (command == this.help_cmd) {
            this.midlet.showHelp();
        } else if (command == this.default_cmd) {
            this.midlet.setDefaultOptions();
            this.midlet.saveOptions();
            this.midlet.showMenu();
        } else if (command == this.save_cmd) {
            int n = Integer.parseInt(this.next_level_devider_field.getString());
            int n2 = Integer.parseInt(this.initial_rate_field.getString());
            int n3 = Integer.parseInt(this.minimum_rate_field.getString());
            int n4 = Integer.parseInt(this.next_level_delta_field.getString());
            if (n < 10) {
                PreferencesForm.showAlert(this.midlet.getI18n("incorrect_value"), this.midlet.getI18n("iv_next_level_devider"), this.midlet.getDisplay());
            } else if (n2 < 100 || n3 < 50 || n4 < 0 || n4 > n2 / 2 || n3 > n2) {
                PreferencesForm.showAlert(this.midlet.getI18n("incorrect_value"), this.midlet.getI18n("incorrect_value_text"), this.midlet.getDisplay());
            } else {
                TetrisView tetrisView = this.midlet.getTetris();
                tetrisView.setNext_level_devider(n);
                tetrisView.setNext_level_delta(n4);
                tetrisView.setInitial_rate(n2);
                tetrisView.setMinimum_rate(n3);
                if (this.lng_choice.getSelectedIndex() == 0) {
                    this.midlet.setLng("en");
                } else {
                    this.midlet.setLng("ru");
                }
                if (this.orientation_choice.getSelectedIndex() == 0) {
                    tetrisView.setOrientation((byte)1);
                } else {
                    tetrisView.setOrientation((byte)2);
                }
                tetrisView.setShow_grid(this.show_grid_choice.getSelectedIndex() == 0);
                tetrisView.setShow_animation_on_removing_line(this.show_anim_ondel.getSelectedIndex() == 0);
                if (!tetrisView.isKeys_settings_changed()) {
                    tetrisView.setDefaultKeyPreferences();
                }
                boolean[] blArray = new boolean[this.prohib_elements_choice.size()];
                this.prohib_elements_choice.getSelectedFlags(blArray);
                int n5 = 0;
                int n6 = 0;
                while (n6 < blArray.length) {
                    if (blArray[n6]) {
                        int n7 = 1;
                        n5 |= (n7 <<= n6 + 7);
                    }
                    ++n6;
                }
                tetrisView.setProhibition_elements(n5);
                if (this.usenonstd_elements_choice.getSelectedIndex() == 0) {
                    tetrisView.setUsenonstdel_on_nextlvl(false);
                } else {
                    tetrisView.setUsenonstdel_on_nextlvl(true);
                }
                if (this.siemens_bug_choiche.getSelectedIndex() == 0) {
                    this.midlet.setSiemens_bug_fix(true);
                } else {
                    this.midlet.setSiemens_bug_fix(false);
                }
                this.midlet.saveOptions();
                this.midlet.showMenu();
            }
        }
    }

    public void show() {
        this.midlet.getDisplay().setCurrent((Displayable)this);
    }

    public static void showAlert(String string, String string2, Display display) {
        Alert alert = new Alert(string, string2, null, AlertType.ERROR);
        alert.setTimeout(-2);
        display.setCurrent((Displayable)alert);
    }
}

