/*
 * Decompiled with CFR 0.152.
 */
package nbs_tetris;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import nbs_tetris.HelpBox;
import nbs_tetris.HighScores;
import nbs_tetris.Menu;
import nbs_tetris.PreferencesForm;
import nbs_tetris.Presentation;
import nbs_tetris.PropertyBundle;
import nbs_tetris.RedefineKeysMenu;
import nbs_tetris.SavedGames;
import nbs_tetris.TetrisView;

public class tetrisMIDlet
extends MIDlet {
    private static final String I18N_FILE = "/i18n.data";
    private static final String RMS_OPTIONS = "opt";
    private boolean color_phone;
    private Display display = Display.getDisplay((MIDlet)this);
    private PropertyBundle i18n;
    private static tetrisMIDlet instance;
    private String lng = null;
    private boolean siemens_bug_fix = true;
    private boolean started = false;
    private TetrisView tetris;

    public tetrisMIDlet() {
        instance = this;
        this.color_phone = this.display.isColor();
    }

    public void destroyApp(boolean bl) {
        this.notifyDestroyed();
    }

    public Display getDisplay() {
        return this.display;
    }

    public String getI18n(String string) {
        return this.i18n.getString(string);
    }

    public static tetrisMIDlet getInstance() {
        return instance;
    }

    public String getLng() {
        if (this.lng == null) {
            String string = System.getProperty("microedition.locale");
            this.lng = string.indexOf("ru") == 0 ? "ru" : "en";
        }
        return this.lng;
    }

    public TetrisView getTetris() {
        return this.tetris;
    }

    public boolean isColor_phone() {
        return this.color_phone;
    }

    public boolean isSiemens_bug_fix() {
        return this.siemens_bug_fix;
    }

    public void loadGame() {
        this.display.setCurrent((Displayable)new SavedGames());
    }

    public static String mkPath() {
        String string = "/res/" + (tetrisMIDlet.getInstance().isColor_phone() ? "" : "bw/");
        return string;
    }

    public void newGame() {
        this.display.setCurrent((Displayable)this.tetris);
        this.tetris.newGame(true);
    }

    public void pauseApp() {
        this.tetris.pauseGame();
    }

    public void preferencesForm() {
        new PreferencesForm().show();
    }

    public static void quitApp() {
        instance.destroyApp(true);
        instance.notifyDestroyed();
        instance = null;
    }

    public void readOptions() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)RMS_OPTIONS, (boolean)false);
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
            if (recordEnumeration.hasNextElement()) {
                byte[] byArray = recordEnumeration.nextRecord();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                this.setLng(dataInputStream.readUTF());
                this.tetris.setOrientation(dataInputStream.readByte());
                this.tetris.setInitial_rate(dataInputStream.readInt());
                this.tetris.setMinimum_rate(dataInputStream.readInt());
                this.tetris.setNext_level_delta(dataInputStream.readInt());
                this.tetris.setNext_level_devider(dataInputStream.readInt());
                this.tetris.setProhibition_elements(dataInputStream.readInt());
                this.tetris.setUsenonstdel_on_nextlvl(dataInputStream.readBoolean());
                this.siemens_bug_fix = dataInputStream.readBoolean();
                this.tetris.setShow_grid(dataInputStream.readBoolean());
                this.tetris.setShow_animation_on_removing_line(dataInputStream.readBoolean());
                recordStore.closeRecordStore();
            }
        }
        catch (Exception exception) {}
    }

    public void redefineKeys() {
        new RedefineKeysMenu().show();
    }

    public void saveOptions() {
        try {
            RecordStore.deleteRecordStore((String)RMS_OPTIONS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)RMS_OPTIONS, (boolean)true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeUTF(this.lng);
            dataOutputStream.writeByte(this.tetris.getOrientation());
            dataOutputStream.writeInt(this.tetris.getInitial_rate());
            dataOutputStream.writeInt(this.tetris.getMinimum_rate());
            dataOutputStream.writeInt(this.tetris.getNext_level_delta());
            dataOutputStream.writeInt(this.tetris.getNext_level_devider());
            dataOutputStream.writeInt(this.tetris.getProhibition_elements());
            dataOutputStream.writeBoolean(this.tetris.isUsenonstdel_on_nextlvl());
            dataOutputStream.writeBoolean(this.siemens_bug_fix);
            dataOutputStream.writeBoolean(this.tetris.isShow_grid());
            dataOutputStream.writeBoolean(this.tetris.isShow_animation_on_removing_line());
            byte[] byArray = byteArrayOutputStream.toByteArray();
            recordStore.addRecord(byArray, 0, byArray.length);
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {}
    }

    public void setColor_phone(boolean bl) {
        this.color_phone = bl;
    }

    public void setDefaultOptions() {
        this.lng = null;
        this.tetris.setDefaultOptions();
    }

    public void setLng(String string) {
        if (this.lng == null || !this.lng.equals(string)) {
            this.lng = string;
            String string2 = "/res/" + this.getLng() + I18N_FILE;
            this.i18n.loadFromFile(string2);
        }
    }

    public void setSiemens_bug_fix(boolean bl) {
        this.siemens_bug_fix = bl;
    }

    public void showHelp() {
        new HelpBox().show();
    }

    public void showHightScores() {
        new HighScores().show();
    }

    public void showMenu() {
        this.display.setCurrent((Displayable)new Menu());
    }

    public void startApp() {
        if (!this.started) {
            instance = this;
            this.started = true;
            String string = "/res/" + this.getLng() + I18N_FILE;
            this.i18n = new PropertyBundle(string);
            this.tetris = new TetrisView();
            this.setDefaultOptions();
            this.readOptions();
            this.tetris.makeCommands();
            this.display.setCurrent((Displayable)new Presentation(0));
        } else {
            this.tetris.continueGame();
        }
    }
}

