/*
 * Decompiled with CFR 0.152.
 */
public abstract class MathFP {
    private static int _fbits = 24;
    private static int _digits = 8;
    private static long _one;
    private static long _fmask;
    private static long _dmul;
    private static long _flt;
    private static long _pi;
    private static long[] e;
    public static long PI;
    public static long E;
    public static final long MAX_VALUE = Long.MAX_VALUE;
    public static final long MIN_VALUE = -9223372036854775807L;

    public static long toLong(long l) {
        l = MathFP.round(l, 0);
        return l >> _fbits;
    }

    public static long toFP(long l) {
        return l << _fbits;
    }

    public static long max(long l, long l2) {
        return l >= l2 ? l : l2;
    }

    public static long round(long l, int n) {
        long l2 = 10L;
        for (int i = 0; i < n; ++i) {
            l2 *= 10L;
        }
        l2 = MathFP.div(MathFP.toFP(5L), MathFP.toFP(l2));
        if (l < 0L) {
            l2 = -l2;
        }
        return l + l2;
    }

    public static long mul(long l, long l2) {
        boolean bl = false;
        int n = _fbits;
        long l3 = _fmask;
        if ((l & l3) == 0L) {
            return (l >> n) * l2;
        }
        if ((l2 & l3) == 0L) {
            return l * (l2 >> n);
        }
        if (l < 0L && l2 > 0L || l > 0L && l2 < 0L) {
            bl = true;
        }
        if (l < 0L) {
            l = -l;
        }
        if (l2 < 0L) {
            l2 = -l2;
        }
        while (MathFP.max(l, l2) >= 1L << 63 - n) {
            l >>= 1;
            l2 >>= 1;
            l3 >>= 1;
            --n;
        }
        long l4 = (l >> n) * (l2 >> n) << n;
        long l5 = (l & l3) * (l2 & l3) >> n;
        if ((l4 = l4 + (l5 += (l & (l3 ^ 0L - 1L)) * (l2 & l3) >> n) + ((l & l3) * (l2 & (l3 ^ 0L - 1L)) >> n) << _fbits - n) < 0L) {
            throw new ArithmeticException();
        }
        return bl ? -l4 : l4;
    }

    public static long div(long l, long l2) {
        boolean bl = false;
        int n = _fbits;
        if (l2 == _one) {
            return l;
        }
        if ((l2 & _fmask) == 0L) {
            return l / (l2 >> n);
        }
        if (l < 0L && l2 > 0L || l > 0L && l2 < 0L) {
            bl = true;
        }
        if (l < 0L) {
            l = -l;
        }
        if (l2 < 0L) {
            l2 = -l2;
        }
        while (MathFP.max(l, l2) >= 1L << 63 - n) {
            l >>= 1;
            l2 >>= 1;
            --n;
        }
        long l3 = (l << n) / l2 << _fbits - n;
        return bl ? -l3 : l3;
    }

    public static long abs(long l) {
        if (l < 0L) {
            return -l;
        }
        return l;
    }

    public static long sqrt(long l, int n) {
        if (l < 0L) {
            throw new ArithmeticException();
        }
        if (l == 0L) {
            return 0L;
        }
        long l2 = l + _one >> 1;
        for (int i = 0; i < n; ++i) {
            l2 = l2 + MathFP.div(l, l2) >> 1;
        }
        if (l2 < 0L) {
            throw new ArithmeticException();
        }
        return l2;
    }

    public static long sqrt(long l) {
        return MathFP.sqrt(l, 24);
    }

    public static long sin(long l) {
        long l2 = MathFP.mul(l, MathFP.div(MathFP.toFP(180L), PI));
        if ((l2 %= MathFP.toFP(360L)) < 0L) {
            l2 = MathFP.toFP(360L) + l2;
        }
        long l3 = l2;
        if (l2 >= MathFP.toFP(90L) && l2 < MathFP.toFP(270L)) {
            l3 = MathFP.toFP(180L) - l2;
        } else if (l2 >= MathFP.toFP(270L) && l2 < MathFP.toFP(360L)) {
            l3 = -(MathFP.toFP(360L) - l2);
        }
        long l4 = l3 / 90L;
        long l5 = MathFP.mul(l4, l4);
        long l6 = MathFP.mul(MathFP.mul(MathFP.mul(MathFP.mul(-73190L >> (int)_flt, l5) + (1333581L >> (int)_flt), l5) - (10836755L >> (int)_flt), l5) + (long)(26353564 >> (int)_flt), l4);
        return l6;
    }

    public static long cos(long l) {
        return MathFP.sin(PI / 2L - l);
    }

    static {
        _fmask = 0xFFFFFFL;
        _dmul = 100000000L;
        _flt = 0L;
        _one = 0x1000000L;
        _pi = 52707178L;
        e = new long[]{_one, 45605201L, 123967790L, 336979391L, 916004956L};
        PI = _pi;
        E = e[1];
    }
}

