/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class BayCanvas
extends Canvas {
    private static final int MAX_SHIPS = 9;
    private static final int MAX_BULLETS = 3;
    private Image offImage;
    private Graphics offGraphics;
    private Background back;
    private Ship[] ship;
    private Gun gun;
    private Rocket rocket;
    private Bullet[] bullet;
    protected Timer animTimer;
    private int animPeriod = 1;
    private int fps = 10;
    private Random rand = new Random(System.currentTimeMillis());
    public static boolean isFire;
    public static boolean isBullet;
    public static boolean isGameOver;
    public static boolean isShipSink;
    private int nBullet;
    private int startBulletX;
    private int endBulletX;
    private int bulletTrigger;
    private int bulletSpeed;
    private int score;
    private int best = 0;
    private int ships;
    private int level;
    private String strMessage = "BAY DEFENDER by Srdjan Susnic, E-MAIL: srdjan.susnic@zg.hinet.hr, WWW: http://www.geocities.com/srdjan_susnic";
    private int xMessage = 90;
    private boolean painting = false;
    private long time = System.currentTimeMillis();
    private long delay = 100L;
    private int updateFrame;
    private int secs = 50;

    public BayCanvas() {
        this.back = new Background(this.getWidth(), this.getHeight());
        try {
            Background.initResources();
            Ship.initResources();
            Rocket.initResources();
            Gun.initResources();
            Bullet.initResources();
        }
        catch (IOException iOException) {
            System.err.println("Failed loading images!");
        }
        this.ship = new Ship[9];
        int n = 0;
        while (n < 9) {
            this.ship[n] = new Ship(n, Math.abs(this.rand.nextInt() % 2), Math.abs(this.rand.nextInt() % 16) * 5 + this.back.getFieldPositionX(), this.back.getFieldPositionX(), this.back.getFieldWidth());
            ++n;
        }
        this.gun = new Gun(this.back.getFieldWidth() / 2 + this.back.getFieldPositionX(), 61, this.back.getFieldPositionX() + 7, this.back.getFieldWidth() - 14);
        this.rocket = new Rocket(this.gun.getPositionX() + 2, this.gun.getPositionY() - 3);
        this.bullet = new Bullet[3];
        int n2 = 0;
        while (n2 < 3) {
            this.bullet[n2] = new Bullet(n2);
            ++n2;
        }
        this.newGame();
        this.animTimer = new Timer();
        this.animTimer.schedule((TimerTask)new BayCanvas$AnimationTask(this), this.animPeriod, (long)this.animPeriod);
    }

    static int access$0(BayCanvas bayCanvas) {
        return bayCanvas.ships;
    }

    static void access$1(BayCanvas bayCanvas, int n) {
        bayCanvas.ships = n;
    }

    static Rocket access$10(BayCanvas bayCanvas) {
        return bayCanvas.rocket;
    }

    static Bullet[] access$11(BayCanvas bayCanvas) {
        return bayCanvas.bullet;
    }

    static int access$12(BayCanvas bayCanvas) {
        return bayCanvas.secs;
    }

    static int access$13(BayCanvas bayCanvas) {
        return bayCanvas.bulletTrigger;
    }

    static int access$14(BayCanvas bayCanvas) {
        return bayCanvas.nBullet;
    }

    static void access$15(BayCanvas bayCanvas, int n) {
        bayCanvas.nBullet = n;
    }

    static Background access$16(BayCanvas bayCanvas) {
        return bayCanvas.back;
    }

    static Random access$17(BayCanvas bayCanvas) {
        return bayCanvas.rand;
    }

    static int access$18(BayCanvas bayCanvas) {
        return bayCanvas.startBulletX;
    }

    static void access$19(BayCanvas bayCanvas, int n) {
        bayCanvas.startBulletX = n;
    }

    static int access$2(BayCanvas bayCanvas) {
        return bayCanvas.score;
    }

    static int access$20(BayCanvas bayCanvas) {
        return bayCanvas.endBulletX;
    }

    static void access$21(BayCanvas bayCanvas, int n) {
        bayCanvas.endBulletX = n;
    }

    static int access$22(BayCanvas bayCanvas) {
        return bayCanvas.bulletSpeed;
    }

    static int access$23(BayCanvas bayCanvas) {
        return bayCanvas.updateFrame;
    }

    static void access$24(BayCanvas bayCanvas, int n) {
        bayCanvas.updateFrame = n;
    }

    static int access$25(BayCanvas bayCanvas) {
        return bayCanvas.fps;
    }

    static void access$26(BayCanvas bayCanvas, int n) {
        bayCanvas.secs = n;
    }

    static long access$27(BayCanvas bayCanvas) {
        return bayCanvas.delay;
    }

    static void access$3(BayCanvas bayCanvas, int n) {
        bayCanvas.score = n;
    }

    static Gun access$4(BayCanvas bayCanvas) {
        return bayCanvas.gun;
    }

    static boolean access$5(BayCanvas bayCanvas) {
        return bayCanvas.painting;
    }

    static void access$6(BayCanvas bayCanvas, boolean bl) {
        bayCanvas.painting = bl;
    }

    static long access$7(BayCanvas bayCanvas) {
        return bayCanvas.time;
    }

    static void access$8(BayCanvas bayCanvas, long l) {
        bayCanvas.time = l;
    }

    static Ship[] access$9(BayCanvas bayCanvas) {
        return bayCanvas.ship;
    }

    public void destroy() {
        this.animTimer.cancel();
        int n = 0;
        while (n < 9) {
            this.ship[n] = null;
            ++n;
        }
        this.gun = null;
        this.rocket = null;
        int n2 = 0;
        while (n2 < 3) {
            this.bullet[n2] = null;
            ++n2;
        }
    }

    public void keyPressed(int n) {
        int n2 = this.getGameAction(n);
        switch (n2) {
            case 2: {
                this.gun.setVelocity(-3, 0);
                break;
            }
            case 5: {
                this.gun.setVelocity(3, 0);
                break;
            }
            case 1: {
                if (isFire || this.gun.GetState() != 0 || this.secs <= -1 || this.ships <= 0) break;
                this.rocket.setPosition(this.gun.getPositionX() + 2, this.gun.getPositionY() - 3);
                this.rocket.SetState(0);
                --this.score;
                isFire = true;
            }
        }
    }

    public void keyReleased(int n) {
        int n2 = this.getGameAction(n);
        switch (n2) {
            case 2: 
            case 5: {
                this.gun.setVelocity(0, 0);
            }
        }
    }

    public void newGame() {
        this.updateFrame = this.fps;
        this.secs = 50;
        if (this.score > this.best) {
            this.best = this.score;
        }
        this.score = 0;
        this.level = 0;
        this.bulletTrigger = 100;
        this.bulletSpeed = 1;
        this.newLevel();
    }

    public void newLevel() {
        isGameOver = false;
        isShipSink = false;
        isFire = false;
        isBullet = false;
        this.nBullet = 0;
        ++this.level;
        if (this.level > 1) {
            this.score += this.secs;
            this.updateFrame = this.fps;
            this.secs = 50;
            if (this.level == 2) {
                this.bulletTrigger = 10;
                this.bulletSpeed = 1;
            } else {
                --this.bulletTrigger;
                ++this.bulletSpeed;
                if (this.bulletTrigger < 1) {
                    this.bulletTrigger = 1;
                }
                if (this.bulletSpeed > 4) {
                    this.bulletSpeed = 4;
                }
            }
        }
        this.ships = 9;
        this.gun.SetState(0);
        this.gun.setPosition(this.back.getFieldWidth() / 2 + this.back.getFieldPositionX(), 61);
        int n = 0;
        while (n < 9) {
            this.ship[n].Initialization(Math.abs(this.rand.nextInt() % 2), Math.abs(this.rand.nextInt() % 16) * 5 + this.back.getFieldPositionX());
            ++n;
        }
        int n2 = 0;
        while (n2 < 3) {
            this.bullet[n2].SetState(2);
            this.bullet[n2].setPosition(0, 0);
            ++n2;
        }
        this.rocket.SetState(2);
        this.rocket.setPosition(this.gun.getPositionX() + 2, this.gun.getPositionY() - 3);
    }

    public void paint(Graphics graphics) {
        if (this.offGraphics == null) {
            this.offImage = Image.createImage((int)this.getWidth(), (int)this.getHeight());
            this.offGraphics = this.offImage.getGraphics();
        }
        this.back.draw(this.offGraphics);
        int n = 0;
        while (n < 9) {
            this.ship[n].draw(this.offGraphics);
            ++n;
        }
        this.rocket.draw(this.offGraphics);
        this.gun.draw(this.offGraphics);
        int n2 = 0;
        while (n2 < 3) {
            this.bullet[n2].draw(this.offGraphics);
            ++n2;
        }
        this.offGraphics.setFont(Font.getFont((int)0, (int)0, (int)8));
        this.offGraphics.setColor(0, 0, 0);
        this.offGraphics.drawString(String.valueOf(this.ships), 25, -1, 20);
        this.offGraphics.drawString(String.valueOf(this.secs), 75, -1, 20);
        this.offGraphics.drawString("Sc:" + String.valueOf(this.score) + " Best:" + String.valueOf(this.best), this.back.getFieldPositionX(), 70, 20);
        if (isGameOver) {
            this.offGraphics.setFont(Font.getFont((int)0, (int)1, (int)0));
            this.offGraphics.setColor(0, 0, 0);
            this.offGraphics.drawString("Game Over", this.getWidth() / 2 + 1, this.back.getFieldHeight() / 2 + 1, 65);
            this.offGraphics.drawString(this.strMessage, this.xMessage + 1, this.back.getFieldHeight() / 2 + 3, 20);
            this.offGraphics.setColor(255, 255, 255);
            this.offGraphics.drawString("Game Over", this.getWidth() / 2, this.back.getFieldHeight() / 2, 65);
            this.offGraphics.setColor(255, 255, 0);
            this.offGraphics.drawString(this.strMessage, this.xMessage, this.back.getFieldHeight() / 2 + 2, 20);
            this.xMessage -= 3;
            if (this.xMessage <= -this.strMessage.length() * 6) {
                this.xMessage = 90;
            }
        }
        this.back.drawBorders(this.offGraphics);
        graphics.drawImage(this.offImage, 0, 0, 20);
    }
}

