/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Bullet {
    public static final int STATE_LIVE = 0;
    public static final int STATE_EXPLOSION = 1;
    public static final int STATE_KILL = 2;
    private int dx;
    private int dy;
    private int dx2;
    private int dy2;
    private int x_inc;
    private int y_inc;
    private int error;
    private int index;
    private int shot;
    private int positionX = 0;
    private int positionY = 0;
    private int state = 2;
    private int frame = 0;
    private int idBullet;
    public static Image[] image;

    public Bullet(int n) {
        this.idBullet = n;
    }

    protected boolean CheckCollision(Gun gun) {
        int n = gun.getPositionX();
        int n2 = gun.getPositionY();
        int n3 = gun.getWidth();
        int n4 = gun.getHeight();
        return (n > this.positionX && n < this.positionX + 7 || this.positionX > n && this.positionX < n + n3) && (n2 > this.positionY && n2 < this.positionY + 7 || this.positionY > n2 && this.positionY < n2 + n4);
    }

    public int GetState() {
        return this.state;
    }

    public void Initialize(int n, int n2, int n3, int n4, int n5) {
        this.positionX = n;
        this.positionY = n2;
        this.dx = n3 - n;
        this.dy = n4 - n2;
        this.state = 0;
        if (this.dx >= 0) {
            this.x_inc = n5;
        } else {
            this.x_inc = -n5;
            this.dx = -this.dx;
        }
        if (this.dy >= 0) {
            this.y_inc = n5;
        } else {
            this.y_inc = -n5;
            this.dy = -this.dy;
        }
        this.dx2 = this.dx << 1;
        this.dy2 = this.dy << 1;
        this.index = 0;
        if (this.dx > this.dy) {
            this.shot = 1;
            this.error = this.dy2 - this.dx;
        } else {
            this.shot = 2;
            this.error = this.dx2 - this.dy;
        }
    }

    public void SetState(int n) {
        this.state = n;
    }

    public void draw(Graphics graphics) {
        if (this.state == 0) {
            graphics.setColor(255, 255, 0);
            graphics.fillRect(this.positionX, this.positionY, 2, 2);
        } else if (this.state == 1) {
            if (this.frame == 0) {
                this.positionX -= 3;
                this.positionY -= 3;
            }
            graphics.drawImage(image[this.frame], this.positionX, this.positionY, 20);
            ++this.frame;
            if (this.frame == 3) {
                this.state = 2;
                this.frame = 0;
            }
        }
    }

    public int getPositionX() {
        return this.positionX;
    }

    public int getPositionY() {
        return this.positionY;
    }

    public static void initResources() throws IOException {
        image = new Image[3];
        int n = 0;
        while (n < 3) {
            Bullet.image[n] = Image.createImage((String)("/expl" + n + ".png"));
            ++n;
        }
    }

    public void setPosition(int n, int n2) {
        this.positionX = n;
        this.positionY = n2;
    }

    public void update() {
        if (this.state == 0) {
            if (this.shot == 1) {
                if (this.error >= 0) {
                    this.error = -this.dx2;
                    this.positionY += this.y_inc;
                }
                this.error += this.dy2;
                this.positionX += this.x_inc;
                this.index += Math.abs(this.x_inc);
                if (this.index > this.dx) {
                    this.state = 1;
                }
            } else {
                if (this.error >= 0) {
                    this.error = -this.dy2;
                    this.positionX += this.x_inc;
                }
                this.error += this.dx2;
                this.positionY += this.y_inc;
                this.index += Math.abs(this.y_inc);
                if (this.index > this.dy) {
                    this.state = 1;
                }
            }
        }
    }
}

