/*
 * Decompiled with CFR 0.152.
 */
import com.bsg.siemens.BSCanvas;
import com.siemens.mp.game.Melody;
import com.siemens.mp.game.MelodyComposer;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BigTreeCanvas
extends BSCanvas {
    private MovementThread GameThread;
    private int SESequence;
    private int DeadSequence;
    private boolean FirstMove;
    private int[][] exitCoords = new int[][]{{9, 1}, {17, 9}, {9, 17}, {1, 9}};
    private int[][] testCoords = new int[][]{{-1, -1}, {-1, 0}, {-1, 1}, {0, -1}, {0, 1}, {1, -1}, {1, 0}, {1, 1}};
    private byte[] Memory;
    private byte[][] LevelData;
    private byte[] LevelFlags;
    private byte[] GemData;
    private int[] exitCodes;
    private byte[][] map;
    private int GemX;
    private int GemY;
    private int Level;
    private int Zone;
    private int userx;
    private int usery;
    private int PlayerLives;
    private int NewLife;
    private int PlayerFrame;
    private int PlayerDirection;
    private Vector Monsters;
    private Vector Doors;
    private Vector Switches;
    private Image backBuffer;
    private Image secondaryBuffer;
    private Graphics backCanvas;
    private Graphics secondaryCanvas;
    private Image[][] TileSet;
    private int UnWi;
    private int Mag;
    private int HalfUnWi;
    private int FithUnWi;
    private int halfWidth;
    private int halfHeight;
    private Melody[] sounds = new Melody[2];

    public BigTreeCanvas() {
        try {
            int n;
            MelodyComposer melodyComposer = new MelodyComposer();
            melodyComposer.setBPM(120);
            melodyComposer.appendNote(24, 4);
            melodyComposer.appendNote(26, 4);
            melodyComposer.appendNote(28, 4);
            melodyComposer.appendNote(29, 4);
            melodyComposer.appendNote(31, 4);
            this.sounds[0] = melodyComposer.getMelody();
            melodyComposer.resetMelody();
            melodyComposer.setBPM(120);
            melodyComposer.appendNote(24, 3);
            melodyComposer.appendNote(28, 4);
            melodyComposer.appendNote(29, 4);
            melodyComposer.appendNote(31, 4);
            melodyComposer.appendNote(36, 3);
            melodyComposer.appendNote(12, 3);
            this.sounds[1] = melodyComposer.getMelody();
            this.Memory = new byte[48];
            this.LevelData = new byte[9][];
            this.GemData = new byte[9];
            this.LevelFlags = new byte[32];
            this.map = new byte[19][19];
            this.Monsters = new Vector();
            this.Doors = new Vector();
            this.Switches = new Vector();
            Image image = Image.createImage((String)"/Tileset.png");
            this.TileSet = new Image[3][];
            this.TileSet[1] = new Image[4];
            this.TileSet[0] = new Image[7];
            this.TileSet[2] = new Image[6];
            this.Mag = image.getWidth() / 100;
            this.UnWi = 10 * this.Mag;
            this.HalfUnWi = this.UnWi / 2;
            this.FithUnWi = this.UnWi / 5;
            this.exitCodes = new int[4];
            this.halfWidth = this.getWidth() / 2;
            this.halfHeight = this.getHeight() / 2;
            for (n = 0; n < 7; ++n) {
                this.TileSet[0][n] = this.getTile(image, n);
            }
            for (n = 0; n < 4; ++n) {
                this.TileSet[1][n] = this.getTile(image, 7 + n);
            }
            this.TileSet[2][0] = this.getTile(image, 11);
            this.TileSet[2][1] = this.getTile(image, 12);
            this.TileSet[2][2] = Image.createImage((int)5, (int)5);
            Graphics graphics = this.TileSet[2][2].getGraphics();
            graphics.drawImage(image, -55, -12, 0x10 | 4);
            this.TileSet[2][4] = this.getTile(image, 13);
            this.TileSet[2][5] = this.getTile(image, 14);
            this.TileSet[2][3] = Image.createImage((int)32, (int)8);
            graphics = this.TileSet[2][3].getGraphics();
            graphics.drawImage(image, 32, 8, 0x20 | 8);
            this.backBuffer = Image.createImage((int)(19 * this.UnWi), (int)(19 * this.UnWi));
            this.secondaryBuffer = Image.createImage((int)(19 * this.UnWi), (int)(19 * this.UnWi));
            this.backCanvas = this.backBuffer.getGraphics();
            this.secondaryCanvas = this.secondaryBuffer.getGraphics();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.gc();
    }

    public Image getTile(Image image, int n) {
        int n2 = -(n % 10 * this.UnWi);
        int n3 = -(n / 10 * this.UnWi);
        Image image2 = Image.createImage((int)this.UnWi, (int)this.UnWi);
        Graphics graphics = image2.getGraphics();
        graphics.drawImage(image, n2, n3, 20);
        return image2;
    }

    public void buildBackBuffer() {
        for (int i = 0; i < 19; ++i) {
            for (int j = 0; j < 19; ++j) {
                if (this.map[i][j] > 24) {
                    this.backCanvas.drawImage(this.TileSet[1][this.map[i][j] - 25], j * this.UnWi, i * this.UnWi, 0x10 | 4);
                    continue;
                }
                this.backCanvas.drawImage(this.TileSet[0][this.map[i][j]], j * this.UnWi, i * this.UnWi, 0x10 | 4);
            }
        }
    }

    public void workOutDoorsAndSwitches() {
        byte[] byArray;
        int n;
        for (n = 0; n < this.Doors.size(); ++n) {
            byArray = (byte[])this.Doors.elementAt(n);
            if (this.LevelFlags[byArray[2]] == 0) {
                this.map[byArray[1]][byArray[0]] = 26;
                this.backCanvas.drawImage(this.TileSet[1][1], byArray[0] * this.UnWi, byArray[1] * this.UnWi, 0x10 | 4);
                continue;
            }
            this.map[byArray[1]][byArray[0]] = 6;
            this.backCanvas.drawImage(this.TileSet[0][6], byArray[0] * this.UnWi, byArray[1] * this.UnWi, 0x10 | 4);
        }
        for (n = 0; n < this.Switches.size(); ++n) {
            byArray = (byte[])this.Switches.elementAt(n);
            if (this.LevelFlags[byArray[2]] == 0) {
                this.map[byArray[1]][byArray[0]] = 27;
                this.backCanvas.drawImage(this.TileSet[1][2], byArray[0] * this.UnWi, byArray[1] * this.UnWi, 0x10 | 4);
                continue;
            }
            this.map[byArray[1]][byArray[0]] = 28;
            this.backCanvas.drawImage(this.TileSet[1][3], byArray[0] * this.UnWi, byArray[1] * this.UnWi, 0x10 | 4);
        }
    }

    private void LoadLevel(Gauge gauge) {
        int n;
        for (n = 0; n < 32; ++n) {
            this.LevelFlags[n] = 0;
        }
        for (n = 0; n < 9; ++n) {
            this.GemData[n] = 1;
            try {
                InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(String.valueOf(String.valueOf(new StringBuffer("/").append(this.Level).append("/").append(n + 2))));
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n2 = inputStream.read();
                while (n2 != -1) {
                    byteArrayOutputStream.write(n2);
                    n2 = inputStream.read();
                }
                inputStream.close();
                byteArrayOutputStream.close();
                this.LevelData[n] = byteArrayOutputStream.toByteArray();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.gc();
            gauge.setValue(n * 10);
        }
    }

    private void LoadZone(int n) {
        try {
            int n2;
            int n3;
            int n4;
            int n5;
            this.Monsters.removeAllElements();
            this.Doors.removeAllElements();
            this.Switches.removeAllElements();
            byte[] byArray = this.LevelData[n - 2];
            int n6 = 0;
            for (n5 = 0; n5 < 19; ++n5) {
                for (n4 = 0; n4 < 19; ++n4) {
                    if (n5 >= 1 && n5 < 18 && n4 >= 1 && n4 < 18) {
                        this.map[n5][n4] = byArray[n6];
                        ++n6;
                        continue;
                    }
                    this.map[n5][n4] = 25;
                }
            }
            try {
                for (n5 = 0; n5 < 4; ++n5) {
                    this.exitCodes[n5] = Integer.parseInt(new String(new byte[]{byArray[n6], byArray[n6 + 1], byArray[n6 + 2], byArray[n6 + 3]}), 16);
                    n6 += 4;
                    if (this.exitCodes[n5] <= 0) continue;
                    this.map[this.exitCoords[n5][1]][this.exitCoords[n5][0]] = (byte)(n5 + 2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.GemX = byArray[n6];
            this.GemY = byArray[n6 + 1];
            if (this.GemData[n - 2] == 1) {
                this.map[this.GemY + 1][this.GemX + 1] = 1;
            }
            int n7 = byArray[n6 += 2];
            ++n6;
            for (n4 = 0; n4 < n7; ++n4) {
                byte[] byArray2 = new byte[]{(byte)(byArray[n6] + 1), (byte)(byArray[n6 + 1] + 1), byArray[n6 + 2]};
                this.Doors.addElement(byArray2);
                n6 += 3;
            }
            n4 = byArray[n6];
            ++n6;
            for (n3 = 0; n3 < n4; ++n3) {
                byte[] byArray3 = new byte[]{(byte)(byArray[n6] + 1), (byte)(byArray[n6 + 1] + 1), byArray[n6 + 2]};
                this.Switches.addElement(byArray3);
                n6 += 3;
            }
            this.workOutDoorsAndSwitches();
            this.buildBackBuffer();
            n3 = byArray[n6];
            ++n6;
            for (n2 = 0; n2 < n3; ++n2) {
                int n8;
                Vector<Integer> vector = new Vector<Integer>();
                for (n8 = 0; n8 < 6; ++n8) {
                    vector.addElement(new Integer(0));
                }
                for (n8 = 0; n8 < 3; ++n8) {
                    if (n8 != 2) {
                        vector.addElement(new Integer(byArray[n6 + n8] + 1));
                        continue;
                    }
                    vector.addElement(new Integer(byArray[n6 + n8]));
                }
                n6 += 3;
                while (byArray[n6] != 5) {
                    vector.addElement(new Integer(byArray[n6]));
                    vector.addElement(new Integer(Integer.parseInt(new String(new byte[]{byArray[n6 + 1], byArray[n6 + 2]}), 16)));
                    n6 += 3;
                }
                vector.addElement(new Integer(5));
                ++n6;
                int[] nArray = new int[vector.size()];
                for (int i = 0; i < vector.size(); ++i) {
                    nArray[i] = (Integer)vector.elementAt(i);
                }
                vector = null;
                System.gc();
                nArray[3] = nArray[6] * this.UnWi;
                nArray[4] = nArray[7] * this.UnWi;
                this.Monsters.addElement(nArray);
            }
            if (this.Zone == 0) {
                this.userx = 9 * this.UnWi;
                this.usery = 2 * this.UnWi;
                this.PlayerDirection = 0;
            } else {
                n2 = 5;
                for (int i = 0; i < 4; ++i) {
                    if (this.exitCodes[i] <= 1 || this.Zone != this.exitCodes[i]) continue;
                    n2 = i;
                    i = 5;
                }
                if (n2 != 5) {
                    switch (n2) {
                        case 0: {
                            this.PlayerDirection = 2;
                            this.userx = 9 * this.UnWi;
                            this.usery = 2 * this.UnWi;
                            break;
                        }
                        case 1: {
                            this.PlayerDirection = 3;
                            this.userx = 16 * this.UnWi;
                            this.usery = 9 * this.UnWi;
                            break;
                        }
                        case 2: {
                            this.PlayerDirection = 0;
                            this.userx = 9 * this.UnWi;
                            this.usery = 16 * this.UnWi;
                            break;
                        }
                        default: {
                            this.PlayerDirection = 1;
                            this.userx = 2 * this.UnWi;
                            this.usery = 9 * this.UnWi;
                        }
                    }
                }
            }
            this.Memory[0] = (byte)this.Level;
            this.Memory[1] = (byte)this.Zone;
            this.Memory[2] = (byte)n;
            this.Memory[3] = (byte)this.score;
            this.Memory[4] = (byte)this.NewLife;
            this.Memory[5] = (byte)this.PlayerLives;
            for (n6 = 0; n6 < 32; ++n6) {
                this.Memory[n6 + 6] = this.LevelFlags[n6];
            }
            for (n6 = 0; n6 < 9; ++n6) {
                this.Memory[n6 + 38] = this.GemData[n6];
            }
            this.Zone = n;
            System.gc();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void keyPressed(int n) {
        if (this.DeadSequence == 0 && this.SESequence == 0) {
            if (n == -4) {
                this.commandListener.commandAction(BSCanvas.DISPLAY_MENU, (Displayable)this);
                return;
            }
            this.FirstMove = true;
            int n2 = this.getGameAction(n);
            if (n2 == 2 || n == 52) {
                this.PlayerDirection = 3;
            }
            if (n2 == 1 || n == 50) {
                this.PlayerDirection = 0;
            }
            if (n2 == 5 || n == 54) {
                this.PlayerDirection = 1;
            }
            if (n2 == 6 || n == 56) {
                this.PlayerDirection = 2;
            }
            if (n2 == 8 || n == 53) {
                int n3 = this.userx / this.UnWi;
                int n4 = this.usery / this.UnWi;
                for (int i = 0; i < 8; ++i) {
                    int n5 = n4 + this.testCoords[i][0];
                    int n6 = n3 + this.testCoords[i][1];
                    byte by = this.map[n5][n6];
                    if (by != 27 && by != 28) continue;
                    for (int j = 0; j < this.Switches.size(); ++j) {
                        byte[] byArray = (byte[])this.Switches.elementAt(j);
                        if (byArray[0] != n6 || byArray[1] != n5) continue;
                        this.LevelFlags[byArray[2]] = this.LevelFlags[byArray[2]] == 0 ? (byte)1 : 0;
                        j = this.Switches.size();
                    }
                    BSCanvas.vibrate(50, 1000);
                    this.workOutDoorsAndSwitches();
                    i = 9;
                }
            }
        }
    }

    public void loadGame(byte[] byArray, Gauge gauge) {
        int n;
        this.Level = byArray[0];
        this.LoadLevel(gauge);
        this.Zone = byArray[1];
        this.score = byArray[3];
        this.NewLife = byArray[4];
        this.PlayerLives = byArray[5];
        for (n = 0; n < 32; ++n) {
            this.LevelFlags[n] = byArray[n + 6];
        }
        for (n = 0; n < 9; ++n) {
            this.GemData[n] = byArray[n + 38];
        }
        this.LoadZone(byArray[2]);
        this.FirstMove = false;
        this.commandListener.commandAction(BSCanvas.DISPLAY_CANVAS, (Displayable)this);
    }

    public byte[] saveGame(Gauge gauge) {
        return this.Memory;
    }

    protected void showNotify() {
        this.FirstMove = false;
        if (this.GameThread == null || this.GameThread.DieNow) {
            this.GameThread = new MovementThread();
        }
    }

    protected void hideNotify() {
        if (this.GameThread != null) {
            this.GameThread.DieNow = true;
        }
    }

    public void startGame(int n, Gauge gauge) {
        byte[] byArray = new byte[]{4, 9, -2};
        this.NewLife = byArray[n];
        this.SESequence = 35;
        this.score = 0;
        this.Level = 0;
        this.Zone = 0;
        this.PlayerLives = 3;
        this.LoadLevel(gauge);
        this.LoadZone(2);
        this.commandListener.commandAction(BSCanvas.DISPLAY_CANVAS, (Displayable)this);
    }

    public void nextLevel(Gauge gauge) {
        this.SESequence = 35;
        ++this.Level;
        this.Zone = 0;
        this.LoadLevel(gauge);
        this.LoadZone(2);
        this.commandListener.commandAction(BSCanvas.DISPLAY_CANVAS, (Displayable)this);
    }

    public synchronized void UnifiedMethod(int n) {
        if (n == -1) {
            this.repaint();
        }
        if (n == 0) {
            BSCanvas.vibrate(50, 1000);
            --this.PlayerLives;
            this.DeadSequence = 35;
            this.GameThread = new MovementThread();
        }
        if (n == 1) {
            int n2;
            if (this.PlayerLives < 1) {
                this.score = 0;
                this.commandListener.commandAction(BSCanvas.GAME_ENDED, (Displayable)this);
                return;
            }
            this.Zone = this.Memory[1];
            this.score = this.Memory[3];
            for (n2 = 0; n2 < 32; ++n2) {
                this.LevelFlags[n2] = this.Memory[n2 + 6];
            }
            for (n2 = 0; n2 < 9; ++n2) {
                this.GemData[n2] = this.Memory[n2 + 38];
            }
            this.LoadZone(this.Memory[2]);
            this.repaint();
            this.FirstMove = false;
            this.GameThread = new MovementThread();
        }
        if (n == 2) {
            BSCanvas.playSound(this.sounds[0]);
            if (this.Level == 4) {
                this.score = 0;
                this.commandListener.commandAction(BSCanvas.GAME_ENDED, (Displayable)this);
            } else {
                this.commandListener.commandAction(BSCanvas.LEVEL_ENDED, (Displayable)this);
            }
        }
        if (n == 3) {
            this.SESequence = -35;
            this.GameThread = new MovementThread();
        }
    }

    public void paint(Graphics graphics) {
        int n;
        graphics.setColor(0);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        int n2 = -this.userx;
        int n3 = -this.usery;
        this.secondaryCanvas.drawImage(this.backBuffer, 0, 0, 0x10 | 4);
        for (n = 0; n < this.Monsters.size(); ++n) {
            int[] nArray = (int[])this.Monsters.elementAt(n);
            this.secondaryCanvas.drawImage(this.TileSet[2][nArray[5] + 4], nArray[3], nArray[4], 0x10 | 4);
        }
        graphics.drawImage(this.secondaryBuffer, this.halfWidth + n2 - this.HalfUnWi, this.halfHeight + n3 - this.HalfUnWi, 0x10 | 4);
        graphics.drawImage(this.TileSet[2][this.PlayerFrame], this.halfWidth, this.halfHeight, 1 | 2);
        graphics.drawImage(this.TileSet[2][3], this.getWidth(), this.getHeight(), 0x20 | 8);
        for (n = 0; n < this.PlayerLives - 1; ++n) {
            graphics.drawImage(this.TileSet[2][2], n * (this.TileSet[2][2].getWidth() + 1), 0, 0x10 | 4);
        }
        graphics.setFont(Font.getFont((int)64, (int)1, (int)8));
        if (this.paused) {
            this.drawText(graphics, this.langT[7], this.halfWidth, this.halfHeight);
        }
        if (this.DeadSequence > 0) {
            this.drawText(graphics, this.langT[6], this.halfWidth, this.getHeight() / 3);
            if (this.PlayerLives == 1) {
                this.drawText(graphics, this.langT[0], this.halfWidth, this.getHeight() / 3 * 2);
            } else {
                this.drawText(graphics, String.valueOf(String.valueOf(this.PlayerLives)).concat(String.valueOf(String.valueOf(this.langT[1]))), this.halfWidth, this.getHeight() / 3 * 2);
            }
        }
        if (this.DeadSequence < 0) {
            this.drawText(graphics, this.langT[2], this.halfWidth, this.halfHeight);
        }
        if (this.SESequence > 0) {
            this.drawText(graphics, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.langT[3]))).append(this.Level + 1))), this.halfWidth, this.halfHeight);
        }
        if (this.SESequence < 0) {
            if (this.Level == 4) {
                this.drawText(graphics, this.langT[4], this.halfWidth, this.halfHeight);
            } else {
                this.drawText(graphics, this.langT[5], this.halfWidth, this.halfHeight);
            }
        }
    }

    public void drawText(Graphics graphics, String string, int n, int n2) {
        Font font = graphics.getFont();
        int n3 = font.stringWidth(string);
        int n4 = font.getHeight();
        graphics.setColor(0);
        graphics.fillRect(n - n3 / 2 - 1, n2 - 2, n3 + 3, n4 + 2);
        graphics.setColor(0xFFFFFF);
        graphics.drawString(string, n, n2, 0x10 | 1);
    }

    private class MovementThread
    extends Thread {
        public boolean DieNow = false;

        public MovementThread() {
            this.start();
        }

        public void run() {
            int n = 66;
            int n2 = BigTreeCanvas.this.FithUnWi * 4;
            if (BigTreeCanvas.this.DeadSequence != 0) {
                while (BigTreeCanvas.this.DeadSequence != 0) {
                    if (BigTreeCanvas.this.DeadSequence > 0) {
                        --BigTreeCanvas.this.DeadSequence;
                    } else {
                        ++BigTreeCanvas.this.DeadSequence;
                    }
                    if (BigTreeCanvas.this.DeadSequence == 0 && BigTreeCanvas.this.PlayerLives == 0) {
                        --BigTreeCanvas.this.PlayerLives;
                        BigTreeCanvas.this.DeadSequence = -35;
                    }
                    BigTreeCanvas.this.UnifiedMethod(-1);
                    try {
                        Thread.sleep(n);
                    }
                    catch (Exception exception) {}
                }
                BigTreeCanvas.this.UnifiedMethod(1);
                this.DieNow = true;
            } else if (BigTreeCanvas.this.SESequence != 0) {
                boolean bl = true;
                if (BigTreeCanvas.this.SESequence > 0) {
                    bl = false;
                }
                while (BigTreeCanvas.this.SESequence != 0) {
                    if (BigTreeCanvas.this.SESequence > 0) {
                        --BigTreeCanvas.this.SESequence;
                    } else {
                        ++BigTreeCanvas.this.SESequence;
                    }
                    BigTreeCanvas.this.UnifiedMethod(-1);
                    try {
                        Thread.sleep(n);
                    }
                    catch (Exception exception) {}
                }
                if (bl) {
                    BigTreeCanvas.this.UnifiedMethod(2);
                    this.DieNow = true;
                }
            }
            while (true) {
                int n3;
                int n4;
                int n5;
                if (BigTreeCanvas.this.paused) {
                    this.DieNow = true;
                }
                if (this.DieNow) {
                    return;
                }
                if (!BigTreeCanvas.this.FirstMove) continue;
                if (BigTreeCanvas.this.PlayerDirection == 3) {
                    BigTreeCanvas.this.userx -= BigTreeCanvas.this.FithUnWi;
                    if (!this.UserValidLocation()) {
                        n5 = BigTreeCanvas.this.userx / BigTreeCanvas.this.UnWi;
                        int n6 = BigTreeCanvas.this.usery / BigTreeCanvas.this.UnWi;
                        n4 = BigTreeCanvas.this.userx % BigTreeCanvas.this.UnWi;
                        n3 = BigTreeCanvas.this.usery % BigTreeCanvas.this.UnWi;
                        if (n3 == BigTreeCanvas.this.FithUnWi) {
                            if (BigTreeCanvas.this.map[n6][n5] < 24 && BigTreeCanvas.this.map[n6 + 1][n5] > 24) {
                                BigTreeCanvas.this.usery -= BigTreeCanvas.this.FithUnWi;
                            } else {
                                BigTreeCanvas.this.userx += BigTreeCanvas.this.FithUnWi;
                            }
                        } else if (n3 == n2) {
                            if (BigTreeCanvas.this.map[n6][n5] > 24 && BigTreeCanvas.this.map[n6 + 1][n5] < 24) {
                                BigTreeCanvas.this.usery += BigTreeCanvas.this.FithUnWi;
                            } else {
                                BigTreeCanvas.this.userx += BigTreeCanvas.this.FithUnWi;
                            }
                        } else {
                            BigTreeCanvas.this.userx += BigTreeCanvas.this.FithUnWi;
                        }
                    }
                } else if (BigTreeCanvas.this.PlayerDirection == 1) {
                    BigTreeCanvas.this.userx += BigTreeCanvas.this.FithUnWi;
                    if (!this.UserValidLocation()) {
                        n5 = BigTreeCanvas.this.userx / BigTreeCanvas.this.UnWi;
                        int n7 = BigTreeCanvas.this.usery / BigTreeCanvas.this.UnWi;
                        n4 = BigTreeCanvas.this.userx % BigTreeCanvas.this.UnWi;
                        n3 = BigTreeCanvas.this.usery % BigTreeCanvas.this.UnWi;
                        if (n3 == BigTreeCanvas.this.FithUnWi) {
                            if (BigTreeCanvas.this.map[n7][n5 + 1] < 24 && BigTreeCanvas.this.map[n7 + 1][n5 + 1] > 24) {
                                BigTreeCanvas.this.usery -= BigTreeCanvas.this.FithUnWi;
                            } else {
                                BigTreeCanvas.this.userx -= BigTreeCanvas.this.FithUnWi;
                            }
                        } else if (n3 == n2) {
                            if (BigTreeCanvas.this.map[n7][n5 + 1] > 24 && BigTreeCanvas.this.map[n7 + 1][n5 + 1] < 24) {
                                BigTreeCanvas.this.usery += BigTreeCanvas.this.FithUnWi;
                            } else {
                                BigTreeCanvas.this.userx -= BigTreeCanvas.this.FithUnWi;
                            }
                        } else {
                            BigTreeCanvas.this.userx -= BigTreeCanvas.this.FithUnWi;
                        }
                    }
                } else if (BigTreeCanvas.this.PlayerDirection == 0) {
                    BigTreeCanvas.this.usery -= BigTreeCanvas.this.FithUnWi;
                    if (!this.UserValidLocation()) {
                        n5 = BigTreeCanvas.this.userx / BigTreeCanvas.this.UnWi;
                        int n8 = BigTreeCanvas.this.usery / BigTreeCanvas.this.UnWi;
                        n4 = BigTreeCanvas.this.userx % BigTreeCanvas.this.UnWi;
                        n3 = BigTreeCanvas.this.usery % BigTreeCanvas.this.UnWi;
                        if (n4 == BigTreeCanvas.this.FithUnWi) {
                            if (BigTreeCanvas.this.map[n8][n5] < 24 && BigTreeCanvas.this.map[n8][n5 + 1] > 24) {
                                BigTreeCanvas.this.userx -= BigTreeCanvas.this.FithUnWi;
                            } else {
                                BigTreeCanvas.this.usery += BigTreeCanvas.this.FithUnWi;
                            }
                        } else if (n4 == n2) {
                            if (BigTreeCanvas.this.map[n8][n5 + 1] < 24 && BigTreeCanvas.this.map[n8][n5] > 24) {
                                BigTreeCanvas.this.userx += BigTreeCanvas.this.FithUnWi;
                            } else {
                                BigTreeCanvas.this.usery += BigTreeCanvas.this.FithUnWi;
                            }
                        } else {
                            BigTreeCanvas.this.usery += BigTreeCanvas.this.FithUnWi;
                        }
                    }
                } else if (BigTreeCanvas.this.PlayerDirection == 2) {
                    BigTreeCanvas.this.usery += BigTreeCanvas.this.FithUnWi;
                    if (!this.UserValidLocation()) {
                        n5 = BigTreeCanvas.this.userx / BigTreeCanvas.this.UnWi;
                        int n9 = BigTreeCanvas.this.usery / BigTreeCanvas.this.UnWi;
                        n4 = BigTreeCanvas.this.userx % BigTreeCanvas.this.UnWi;
                        n3 = BigTreeCanvas.this.usery % BigTreeCanvas.this.UnWi;
                        if (n4 == BigTreeCanvas.this.FithUnWi) {
                            if (BigTreeCanvas.this.map[n9 + 1][n5] < 24 && BigTreeCanvas.this.map[n9 + 1][n5 + 1] > 24) {
                                BigTreeCanvas.this.userx -= BigTreeCanvas.this.FithUnWi;
                            } else {
                                BigTreeCanvas.this.usery -= BigTreeCanvas.this.FithUnWi;
                            }
                        } else if (n4 == n2) {
                            if (BigTreeCanvas.this.map[n9 + 1][n5] > 24 && BigTreeCanvas.this.map[n9 + 1][n5 + 1] < 24) {
                                BigTreeCanvas.this.userx += BigTreeCanvas.this.FithUnWi;
                            } else {
                                BigTreeCanvas.this.usery -= BigTreeCanvas.this.FithUnWi;
                            }
                        } else {
                            BigTreeCanvas.this.usery -= BigTreeCanvas.this.FithUnWi;
                        }
                    }
                }
                if (BigTreeCanvas.this.PlayerFrame == 0) {
                    BigTreeCanvas.this.PlayerFrame = 1;
                } else {
                    BigTreeCanvas.this.PlayerFrame = 0;
                }
                for (n5 = 0; n5 < BigTreeCanvas.this.Monsters.size(); ++n5) {
                    int[] nArray = (int[])BigTreeCanvas.this.Monsters.elementAt(n5);
                    if (nArray[1] == 0) {
                        n4 = 9 + nArray[0] * 2;
                        if (nArray[n4] == 5) {
                            nArray[0] = 1;
                            nArray[1] = nArray[10];
                            nArray[2] = nArray[9];
                            nArray[3] = nArray[6] * BigTreeCanvas.this.UnWi;
                            nArray[4] = nArray[7] * BigTreeCanvas.this.UnWi;
                        } else {
                            nArray[2] = nArray[n4];
                            nArray[1] = nArray[n4 + 1];
                            nArray[0] = nArray[0] + 1;
                        }
                    }
                    if (nArray[2] == 0) {
                        nArray[4] = nArray[4] - nArray[8] * BigTreeCanvas.this.Mag;
                    } else if (nArray[2] == 1) {
                        nArray[3] = nArray[3] + nArray[8] * BigTreeCanvas.this.Mag;
                    } else if (nArray[2] == 2) {
                        nArray[4] = nArray[4] + nArray[8] * BigTreeCanvas.this.Mag;
                    } else if (nArray[2] == 3) {
                        nArray[3] = nArray[3] - nArray[8] * BigTreeCanvas.this.Mag;
                    }
                    n4 = BigTreeCanvas.this.UnWi - 1;
                    if (nArray[3] >= BigTreeCanvas.this.userx - n4 && nArray[3] <= BigTreeCanvas.this.userx + n4 && nArray[4] >= BigTreeCanvas.this.usery - n4 && nArray[4] <= BigTreeCanvas.this.usery + n4) {
                        BigTreeCanvas.this.UnifiedMethod(0);
                        this.DieNow = true;
                        return;
                    }
                    nArray[1] = nArray[1] - 1;
                    nArray[5] = nArray[5] == 0 ? 1 : 0;
                }
                n5 = BigTreeCanvas.this.map[BigTreeCanvas.this.usery / BigTreeCanvas.this.UnWi][BigTreeCanvas.this.userx / BigTreeCanvas.this.UnWi];
                if (n5 > 1 && n5 < 6 && BigTreeCanvas.this.usery % 10 == 0 && BigTreeCanvas.this.userx % 10 == 0) {
                    if (BigTreeCanvas.this.exitCodes[n5 - 2] == 1) {
                        BigTreeCanvas.this.UnifiedMethod(3);
                        this.DieNow = true;
                        return;
                    }
                    BigTreeCanvas.this.LoadZone(BigTreeCanvas.this.exitCodes[n5 - 2]);
                }
                BigTreeCanvas.this.UnifiedMethod(-1);
                try {
                    Thread.sleep(n);
                }
                catch (Exception exception) {
                }
            }
        }

        public void getGem(int n, int n2) {
            BSCanvas.playSound(BigTreeCanvas.this.sounds[1]);
            ((BigTreeCanvas)BigTreeCanvas.this).map[n2][n] = 0;
            Graphics graphics = BigTreeCanvas.this.backCanvas;
            Image image = BigTreeCanvas.this.TileSet[0][0];
            int n3 = n * BigTreeCanvas.this.UnWi;
            int n4 = n2 * BigTreeCanvas.this.UnWi;
            BigTreeCanvas.this.backCanvas;
            BigTreeCanvas.this.backCanvas;
            graphics.drawImage(image, n3, n4, 0x10 | 4);
            ((BigTreeCanvas)BigTreeCanvas.this).GemData[((BigTreeCanvas)BigTreeCanvas.this).Zone - 2] = 0;
            ++BigTreeCanvas.this.score;
            if (BigTreeCanvas.this.NewLife != -2 && BigTreeCanvas.this.score >= BigTreeCanvas.this.NewLife) {
                ++BigTreeCanvas.this.PlayerLives;
                BigTreeCanvas.this.score = 0;
            }
        }

        public boolean UserValidLocation() {
            int n = BigTreeCanvas.this.userx / BigTreeCanvas.this.UnWi;
            int n2 = BigTreeCanvas.this.usery / BigTreeCanvas.this.UnWi;
            if (BigTreeCanvas.this.map[n2][n] == 1) {
                this.getGem(n, n2);
            }
            if (BigTreeCanvas.this.map[n2][n] > 24) {
                return false;
            }
            int n3 = BigTreeCanvas.this.userx % BigTreeCanvas.this.UnWi;
            int n4 = BigTreeCanvas.this.usery % BigTreeCanvas.this.UnWi;
            if (n3 == 0 && n4 == 0) {
                return true;
            }
            if (n3 != 0 && n4 != 0) {
                if (BigTreeCanvas.this.map[n2 + 1][n] == 1) {
                    this.getGem(n, n2 + 1);
                } else if (BigTreeCanvas.this.map[n2][n + 1] == 1) {
                    this.getGem(n + 1, n2);
                } else if (BigTreeCanvas.this.map[n2 + 1][n + 1] == 1) {
                    this.getGem(n + 1, n2 + 1);
                }
                if (BigTreeCanvas.this.map[n2 + 1][n] < 25 && BigTreeCanvas.this.map[n2][n + 1] < 25 && BigTreeCanvas.this.map[n2 + 1][n + 1] < 25) {
                    return true;
                }
            } else if (n3 == 0) {
                if (BigTreeCanvas.this.map[n2 + 1][n] == 1) {
                    this.getGem(n, n2 + 1);
                }
                if (BigTreeCanvas.this.map[n2 + 1][n] < 25) {
                    return true;
                }
            } else if (n4 == 0) {
                if (BigTreeCanvas.this.map[n2][n + 1] == 1) {
                    this.getGem(n + 1, n2);
                }
                if (BigTreeCanvas.this.map[n2][n + 1] < 25) {
                    return true;
                }
            }
            return false;
        }
    }
}

