/*
 * Decompiled with CFR 0.152.
 */
package example.MyGame01;

import example.MyGame01.CImgLib;
import example.MyGame01.CSprite;
import example.MyGame01.GameCanvas;
import example.MyGame01.MainUI;
import example.MyGame01.Player;
import example.MyGame01.Scene;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class CMainLoop
implements Runnable {
    private final int RUNSTATE_PLAY;
    private final int RUNSTATE_VICTROY;
    private final int RUNSTATE_OVER;
    public int m_nClipX = 0;
    public int m_nClipY = 0;
    public int m_nClipWidth = 0;
    public int m_nClipHeight = 0;
    public CImgLib m_ImgLib;
    public int m_nScrWidth = 0;
    public int m_nScrHeight = 0;
    public boolean m_bQuit = false;
    public boolean m_bPause = false;
    public boolean m_bPauseNpc = false;
    public boolean m_bCanInput = true;
    static int m_nDelay = 10;
    public MainUI m_UI;
    public GameCanvas m_Canvas;
    private int m_nRunState = 0;
    private int m_nLevel = 0;
    private long m_lNpcTime = 0L;
    private Player m_Player = null;
    private CSprite[] m_Sprite = null;
    public Scene m_Scene;
    private boolean m_bMustRepaint = true;
    private int m_nNpcCount = 1;
    public int m_nNpcTotal = 0;
    public int m_nNpcAliveCount = 0;
    static final int LEVELCOUNT = 2;
    private String m_Msg;
    private long m_lTimer = 0L;
    int m_nScore = 0;
    private int m_nDisX = 0;
    private int m_nDisY = 0;
    private AlertType m_AlertType = null;
    private long m_lRunTimer = 0L;

    public CMainLoop(GameCanvas gameCanvas) {
        this.RUNSTATE_PLAY = 0;
        this.RUNSTATE_VICTROY = 2;
        this.RUNSTATE_OVER = 3;
        this.m_Canvas = gameCanvas;
        this.m_ImgLib = new CImgLib();
        this.m_Scene = new Scene(this);
        this.m_UI = new MainUI(this);
    }

    void restart(int n) {
        this.m_nScore = 0;
        this.m_Player.m_nLife = 3;
        this.start(n);
        this.m_nRunState = 0;
        this.m_bCanInput = true;
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start(int n) {
        InputStream inputStream = null;
        this.m_bMustRepaint = true;
        this.m_bCanInput = true;
        CMainLoop cMainLoop = this;
        synchronized (cMainLoop) {
            this.m_Player = new Player(this, this.m_Scene, 1);
            this.m_nLevel = n;
            this.m_Scene.SetMapRect(this.m_nScrWidth, this.m_nScrHeight);
            try {
                inputStream = this.getClass().getResourceAsStream("/data/scene." + (n % 2 + 1));
                if (inputStream != null) {
                    if (!this.m_Scene.readData(inputStream)) {
                        return;
                    }
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                return;
            }
            if (!this.m_Canvas.m_bColor) {
                this.m_Scene.m_nBkColor = 0xFFFFFF;
            }
            this.m_Scene.SetMapWndPos(0, 0);
            int n2 = 0;
            while (n2 < this.m_nNpcCount) {
                this.m_Sprite[n2].start(this.m_nScrWidth, this.m_nScrHeight, n);
                ++n2;
            }
            this.m_Scene.start();
            this.m_Player.start(this.m_nScrWidth, this.m_nScrHeight);
            this.m_Player.SetPos(1, 1);
            this.m_nRunState = 0;
            this.m_UI.loadImage();
            this.m_lRunTimer = System.currentTimeMillis();
        }
    }

    void SetFullRepaint() {
        this.m_bMustRepaint = true;
    }

    void destroy() {
        this.m_bQuit = true;
    }

    void SetGameDelay(int n) {
        m_nDelay = n;
    }

    int GetWalkSpeed() {
        return CSprite.getWalkSpeed();
    }

    void SetWalkSpeed(int n) {
        this.m_Player.setWalkSpeed(n);
    }

    public void SetScreenRect(int n, int n2) {
        this.m_nScrWidth = n;
        this.m_nScrHeight = n2;
    }

    public void SetNpcCount(int n) {
        this.m_nNpcAliveCount = this.m_nNpcCount = n;
        this.m_Sprite = new CSprite[this.m_nNpcCount];
        int n2 = 0;
        while (n2 < this.m_nNpcCount) {
            this.m_Sprite[n2] = new CSprite(this, this.m_Scene, 1);
            ++n2;
        }
    }

    public void SetNpcPos(int n, int n2, int n3) {
        if (n >= this.m_nNpcCount) {
            return;
        }
        if (this.m_Sprite[n] == null) {
            return;
        }
        this.m_Sprite[n].SetPos(n2, n3);
        this.m_Sprite[n].m_nMapXBak = n2;
        this.m_Sprite[n].m_nMapYBak = n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.m_bQuit) {
            long l = System.currentTimeMillis();
            if (l - this.m_lRunTimer > 300000L) {
                this.Fail("Sorry ,This is a Demo!");
                continue;
            }
            if (!this.m_bPause && this.m_nRunState == 0) {
                CMainLoop cMainLoop = this;
                synchronized (cMainLoop) {
                    if (l - this.m_lNpcTime > 10000L) {
                        this.m_lNpcTime = l;
                        if (this.m_nNpcAliveCount < this.m_nNpcCount && this.m_nNpcAliveCount + 1 <= this.m_nNpcTotal) {
                            this.AddNpc();
                        }
                    }
                    if (!this.m_bPauseNpc) {
                        int n = 0;
                        while (n < this.m_nNpcCount) {
                            if (this.m_Sprite[n].m_bAlive) {
                                this.m_Sprite[n].ProcAction();
                            }
                            ++n;
                        }
                    }
                    this.m_Player.ProcAction();
                    if (this.m_AlertType != null) {
                        Display display = this.m_Canvas.getDisplay();
                        this.m_AlertType.playSound(display);
                        this.m_AlertType = null;
                    }
                }
                try {
                    Thread.sleep(m_nDelay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.repaint();
                continue;
            }
            if (2 != this.m_nRunState) continue;
            if (l - this.m_lTimer > 3000L) {
                this.m_nRunState = 0;
                ++this.m_nLevel;
                this.start(this.m_nLevel);
            }
            this.repaint();
        }
    }

    void ShowAlert(AlertType alertType) {
        this.m_AlertType = alertType;
    }

    void Fail(String string) {
        this.m_nRunState = 3;
        this.m_Canvas.setState(4);
        this.m_Msg = string;
        this.repaint();
    }

    void Victroy() {
        this.m_lTimer = System.currentTimeMillis();
        this.m_nRunState = 2;
        this.m_Msg = "Victroy!";
        this.ShowAlert(AlertType.ERROR);
        this.repaint();
    }

    void AllDie() {
        int n = 0;
        int n2 = 0;
        this.m_nNpcAliveCount = 0;
        int n3 = 0;
        while (n3 < this.m_nNpcCount) {
            if (this.m_Sprite[n3].m_bAlive) {
                this.m_Sprite[n3].toBeDie();
                n2 += this.m_Sprite[n3].m_nExp;
                --this.m_nNpcTotal;
                ++n;
            }
            ++n3;
        }
        this.m_nNpcAliveCount = 0;
        if (this.m_nNpcTotal <= 0) {
            this.Victroy();
        }
        this.m_nScore += n2 * n * 2;
        this.m_UI.m_bRepaint = true;
    }

    void CheckPushNpcDie(int n, int n2) {
        int n3 = 0;
        this.m_nNpcAliveCount = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.m_nNpcCount) {
            if (this.m_Sprite[n5].m_bAlive) {
                if (this.m_Sprite[n5].m_bBePush) {
                    this.m_Sprite[n5].toBeDie();
                    n4 += this.m_Sprite[n5].m_nExp;
                    ++n3;
                    --this.m_nNpcTotal;
                } else if (this.m_Sprite[n5].m_nMapX == n && this.m_Sprite[n5].m_nMapY == n2) {
                    this.m_Sprite[n5].toBeDie();
                    n4 += this.m_Sprite[n5].m_nExp;
                    ++n3;
                    --this.m_nNpcTotal;
                } else {
                    ++this.m_nNpcAliveCount;
                }
            }
            ++n5;
        }
        if (this.m_nNpcTotal <= 0) {
            this.Victroy();
        } else if (this.m_nNpcAliveCount < 2 && this.m_nNpcAliveCount + 1 <= this.m_nNpcTotal) {
            this.AddNpc();
        }
        this.m_nScore += n4 * n3 * n3;
        this.m_UI.m_bRepaint = true;
    }

    void AddNpc() {
        int n = 0;
        while (n < this.m_nNpcCount) {
            if (!this.m_Sprite[n].m_bAlive) {
                this.m_Sprite[n].restore();
                ++this.m_nNpcAliveCount;
                break;
            }
            ++n;
        }
    }

    void PushNpc(int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < this.m_nNpcCount) {
            if (this.m_Sprite[n4].m_bAlive && !this.m_Sprite[n4].m_bBePush && this.m_Sprite[n4].m_nMapX == n && this.m_Sprite[n4].m_nMapY == n2) {
                this.m_Sprite[n4].m_bBePush = true;
                this.m_Sprite[n4].m_nDir = n3;
            }
            ++n4;
        }
    }

    void PushNpcLoop() {
        int n = 0;
        while (n < this.m_nNpcCount) {
            if (this.m_Sprite[n].m_bAlive && this.m_Sprite[n].m_bBePush) {
                this.m_Sprite[n].bePushWalk();
            }
            ++n;
        }
    }

    int GetPlayerX() {
        int n = this.m_Player.m_nMapX;
        this.m_Scene.getClass();
        int n2 = n * 16;
        this.m_Scene.getClass();
        return n2 + 16 / 2;
    }

    int GetPlayerY() {
        int n = this.m_Player.m_nMapY;
        this.m_Scene.getClass();
        int n2 = n * 16;
        this.m_Scene.getClass();
        return n2 + 16 / 2;
    }

    boolean CheckPlayerDie(int n, int n2) {
        return this.m_Player.CheckDie(n, n2);
    }

    int CheckPlayer(int n, int n2, int n3) {
        int n4 = n - this.m_Player.m_nMapX;
        int n5 = n2 - this.m_Player.m_nMapY;
        if (n4 < 0) {
            n4 = -n4;
        }
        if (n5 < 0) {
            n5 = -n5;
        }
        if (n4 == 0) {
            if (n5 < n3) {
                return 2;
            }
        } else if (n5 == 0 && n4 < n3) {
            return 1;
        }
        return 0;
    }

    void pauseNpc() {
        this.m_bPauseNpc = true;
    }

    void resumeNpc() {
        this.m_bPauseNpc = false;
    }

    void pause() {
        this.m_bPause = true;
    }

    void resume() {
        this.m_bPause = false;
        this.m_bMustRepaint = true;
        this.repaint();
    }

    public void repaint(int n, int n2, int n3, int n4) {
        if (n < 0 || n2 < 0 || n > this.m_nScrWidth || n2 > this.m_nScrHeight) {
            return;
        }
        this.m_Canvas.repaint(n, n2, n3, n4);
    }

    public void repaint() {
        this.m_Canvas.repaint();
    }

    void PaintMsg(Graphics graphics) {
        Font font = graphics.getFont();
        int n = font.getHeight();
        int n2 = font.stringWidth(this.m_Msg);
        graphics.setColor(0xFFFFFF);
        graphics.fillRect((this.m_nClipWidth - n2) / 2 - 1, (this.m_nClipHeight - n) / 2, n2 + 2, n);
        graphics.setColor(0xFF0000);
        graphics.setFont(font);
        graphics.drawString(this.m_Msg, (this.m_nClipWidth - n2) / 2, (this.m_nClipHeight - n) / 2, 0x10 | 4);
    }

    public void paint(Graphics graphics) {
        long l = System.currentTimeMillis();
        if (this.m_bMustRepaint) {
            this.m_nClipX = graphics.getClipX();
            this.m_nClipY = graphics.getClipY();
            this.m_nClipWidth = graphics.getClipWidth();
            this.m_nClipHeight = graphics.getClipHeight();
            graphics.setColor(this.m_Scene.m_nBkColor);
            graphics.fillRect(this.m_nClipX, this.m_nClipY, this.m_nClipWidth, this.m_nClipHeight);
            this.m_Scene.paint(graphics);
        } else {
            this.m_Scene.paintPushBox(graphics);
        }
        int n = 0;
        while (n < this.m_nNpcCount) {
            if (this.m_Sprite[n] != null && this.m_Sprite[n].m_bAlive) {
                this.m_Sprite[n].paint(graphics, this.m_bMustRepaint);
            }
            ++n;
        }
        if (this.m_nRunState == 0) {
            if (this.m_Player != null) {
                this.m_Player.paint(graphics, this.m_bMustRepaint);
            }
        } else if (this.m_nRunState == 2) {
            this.PaintMsg(graphics);
        } else if (this.m_nRunState == 3) {
            this.PaintMsg(graphics);
        }
        this.m_UI.paint(graphics, 0, 0, this.m_bMustRepaint);
        if (this.m_bMustRepaint) {
            this.m_bMustRepaint = false;
        }
    }

    int getPlayerLife() {
        return this.m_Player.m_nLife;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void left() {
        CMainLoop cMainLoop = this;
        synchronized (cMainLoop) {
            if (this.m_bCanInput) {
                this.m_Player.Left();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void right() {
        CMainLoop cMainLoop = this;
        synchronized (cMainLoop) {
            if (this.m_bCanInput) {
                this.m_Player.Right();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void up() {
        CMainLoop cMainLoop = this;
        synchronized (cMainLoop) {
            if (this.m_bCanInput) {
                this.m_Player.Up();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void down() {
        CMainLoop cMainLoop = this;
        synchronized (cMainLoop) {
            if (this.m_bCanInput) {
                this.m_Player.Down();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fire() {
        CMainLoop cMainLoop = this;
        synchronized (cMainLoop) {
            if (this.m_bCanInput) {
                this.m_Player.PushBox();
            }
        }
    }
}

