/*
 * Decompiled with CFR 0.152.
 */
package example.MyGame01;

import example.MyGame01.CMainLoop;
import example.MyGame01.COption;
import example.MyGame01.Producer;
import example.MyGame01.logo;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

public class GameCanvas
extends Canvas
implements CommandListener {
    private MIDlet m_MIDlet = null;
    private Producer m_Producer = null;
    public CMainLoop m_MainLoop = null;
    private Command[] m_Command;
    private Display m_Display;
    private COption Option = null;
    public boolean m_bColor = true;
    private logo m_Logo = null;
    private long m_lDisplayTime = 0L;
    static final int STATE_INIT = 0;
    static final int STATE_PLAY = 1;
    static final int STATE_PAUSE = 2;
    static final int STATE_MENU = 3;
    static final int STATE_OVER = 4;
    static final int CMD_EXIT = 0;
    static final int CMD_OPTION = 1;
    static final int CMD_RESUME = 2;
    static final int CMD_PAUSE = 3;
    static final int CMD_QUITGAME = 4;
    static final int CMD_STARTGAME = 5;
    static final int CMD_PRODUCER = 6;

    public GameCanvas(MIDlet mIDlet, Display display) {
        this.m_MIDlet = mIDlet;
        this.m_Display = display;
        this.m_MainLoop = new CMainLoop(this);
        this.m_Producer = new Producer(this, display);
        this.m_Command = new Command[7];
        this.m_Command[0] = new Command("Exit", 1, 1);
        this.m_Command[1] = new Command("Option", 1, 3);
        this.m_Command[2] = new Command("Resume", 1, 2);
        this.m_Command[3] = new Command("Pause", 1, 2);
        this.m_Command[4] = new Command("Quit Game", 1, 4);
        this.m_Command[5] = new Command("Start Game", 1, 5);
        this.m_Command[6] = new Command("Producer", 1, 6);
        this.Option = new COption(display, this);
        this.m_bColor = display.isColor();
    }

    public void setState(int n) {
        switch (n) {
            case 0: {
                this.removeCommand(this.m_Command[3]);
                this.removeCommand(this.m_Command[4]);
                this.addCommand(this.m_Command[2]);
                break;
            }
            case 1: {
                this.removeCommand(this.m_Command[2]);
                this.removeCommand(this.m_Command[5]);
                this.addCommand(this.m_Command[3]);
                this.addCommand(this.m_Command[4]);
                this.addCommand(this.m_Command[6]);
                break;
            }
            case 2: {
                this.removeCommand(this.m_Command[3]);
                this.addCommand(this.m_Command[2]);
                break;
            }
            case 4: {
                this.removeCommand(this.m_Command[3]);
                this.removeCommand(this.m_Command[2]);
                this.addCommand(this.m_Command[5]);
            }
        }
    }

    Display getDisplay() {
        return this.m_Display;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.m_Command[0]) {
            this.m_MIDlet.notifyDestroyed();
        } else if (command == this.m_Command[6]) {
            this.m_Producer.start();
            Thread thread = new Thread(this.m_Producer);
            thread.start();
            this.repaint();
        } else if (command == this.m_Command[2]) {
            this.resume();
            this.setState(1);
            this.m_MainLoop.SetFullRepaint();
            this.repaint();
        } else if (command == this.m_Command[3]) {
            this.pause();
            this.setState(2);
            this.m_MainLoop.SetFullRepaint();
            this.repaint();
        } else if (command == this.m_Command[1]) {
            this.m_Display.setCurrent((Displayable)this.Option);
        } else if (command == this.m_Command[5]) {
            this.m_MainLoop.restart(0);
            this.setState(1);
            this.m_MainLoop.SetFullRepaint();
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paint(Graphics graphics) {
        long l = System.currentTimeMillis();
        if (l - this.m_lDisplayTime > 40L) {
            this.m_lDisplayTime = l;
            CMainLoop cMainLoop = this.m_MainLoop;
            synchronized (cMainLoop) {
                this.m_MainLoop.paint(graphics);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyPressed(int n) {
        CMainLoop cMainLoop = this.m_MainLoop;
        synchronized (cMainLoop) {
            int n2 = this.getGameAction(n);
            boolean bl = false;
            if (n2 == 0) {
                switch (n) {
                    case 52: {
                        this.m_MainLoop.left();
                        break;
                    }
                    case 54: {
                        this.m_MainLoop.right();
                        break;
                    }
                    case 56: {
                        this.m_MainLoop.down();
                        break;
                    }
                    case 50: {
                        this.m_MainLoop.up();
                        break;
                    }
                    case 53: {
                        this.m_MainLoop.fire();
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            switch (n2) {
                case 2: 
                case 52: {
                    this.m_MainLoop.left();
                    break;
                }
                case 5: 
                case 54: {
                    this.m_MainLoop.right();
                    break;
                }
                case 6: 
                case 56: {
                    this.m_MainLoop.down();
                    break;
                }
                case 1: 
                case 50: {
                    this.m_MainLoop.up();
                    break;
                }
                case 8: 
                case 12: 
                case 53: {
                    this.m_MainLoop.fire();
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    protected void keyRepeated(int n) {
        int n2 = this.getGameAction(n);
        switch (n2) {
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                this.keyPressed(n);
                break;
            }
        }
    }

    void destroy() {
        this.m_Logo.m_bQuit = true;
        this.m_MainLoop.destroy();
    }

    void resume() {
        this.m_MainLoop.resume();
    }

    void resumeNpc() {
        this.m_MainLoop.resumeNpc();
    }

    void pauseNpc() {
        this.m_MainLoop.pauseNpc();
    }

    void pause() {
        this.m_MainLoop.pause();
    }

    void SetGameDelay(int n) {
        this.m_MainLoop.SetGameDelay(n);
    }

    void setWlakSpeed(int n) {
        this.m_MainLoop.SetWalkSpeed(n);
    }

    void startGame() {
        this.addCommand(this.m_Command[0]);
        this.addCommand(this.m_Command[1]);
        this.addCommand(this.m_Command[3]);
        this.addCommand(this.m_Command[6]);
        this.setCommandListener(this);
        this.m_Display.setCurrent((Displayable)this);
        this.m_Producer.SetScreenHeight(this.getHeight());
        this.m_MainLoop.SetScreenRect(this.getWidth(), this.getHeight());
        this.m_MainLoop.start(0);
        Thread thread = new Thread(this.m_MainLoop);
        thread.start();
        this.repaint();
    }

    void start() {
        this.m_Logo = new logo(this.m_Display, this);
        this.m_Logo.start();
        Thread thread = new Thread(this.m_Logo);
        thread.start();
        this.m_Display.setCurrent((Displayable)this.m_Logo);
    }
}

