/*
 * Decompiled with CFR 0.152.
 */
package example.MyGame01;

import example.MyGame01.CMainLoop;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;

public class Scene {
    private byte[] m_SceneData;
    private int[] m_Image;
    private CMainLoop m_MainLoop = null;
    public int m_nWidth;
    public int m_nHeight;
    public final int m_nTileWidth;
    public final int m_nTileHeight;
    public int m_nScrHeight = 0;
    public int m_nScrWidth = 0;
    public int m_nMpsX;
    public int m_nMpsY;
    public int m_nMapX;
    public int m_nMapY;
    public static final byte GROUND = 0;
    public static final byte WALL = 1;
    public static final byte NPCRESTORE = 2;
    public static final byte WALL1 = 5;
    public static final byte WALL2 = 9;
    public static final byte WALL3 = 13;
    public static final byte WALL4 = 17;
    public static final byte WALL5 = 33;
    public static final byte OBJ01 = 64;
    public static final byte OBJ02 = 96;
    public static final byte OBJ03 = -128;
    public static final byte OBJ04 = -96;
    public static final byte OBJ05 = -64;
    public static final byte WALLMASK = 29;
    public static final byte OBJMASK = -32;
    public int m_nBkColor = 0xFFFFFF;
    protected boolean m_bPushBoxRepaint = false;
    protected int m_nPushBox = -1;
    protected int m_nPushDir = 0;
    protected int m_nPushX = 0;
    protected int m_nPushY = 0;
    protected int m_nPushMpsX = 0;
    protected int m_nPushMpsY = 0;

    public Scene(CMainLoop cMainLoop) {
        this.m_nTileWidth = 16;
        this.m_nTileHeight = 16;
        this.m_MainLoop = cMainLoop;
        this.m_Image = new int[10];
    }

    void start() {
        String string = new String("box");
        int n = 0;
        while (n < 10) {
            string = "box" + n;
            this.m_Image[n] = this.m_MainLoop.m_ImgLib.load(string, 1, 1);
            ++n;
        }
    }

    public boolean readData(InputStream inputStream) {
        int n = 0;
        try {
            this.m_nWidth = inputStream.read();
            this.m_nHeight = inputStream.read();
            n = inputStream.read();
            int n2 = inputStream.read();
            int n3 = inputStream.read();
            int n4 = n2 << 16 | n3 << 8;
            n2 = inputStream.read();
            this.m_nBkColor = n4 | n2;
            this.m_MainLoop.m_nNpcTotal = inputStream.read();
            this.m_MainLoop.SetNpcCount(n);
            n = 0;
            n4 = inputStream.read();
            this.m_SceneData = new byte[this.m_nWidth * this.m_nHeight];
            n2 = 0;
            n3 = 0;
            while ((n4 = inputStream.read()) != -1) {
                switch (n4) {
                    case 10: {
                        n2 = 0;
                        ++n3;
                        break;
                    }
                    case 35: {
                        this.m_SceneData[n2 + n3 * this.m_nWidth] = 1;
                        ++n2;
                        break;
                    }
                    case 49: {
                        this.m_SceneData[n2 + n3 * this.m_nWidth] = 5;
                        ++n2;
                        break;
                    }
                    case 50: {
                        this.m_SceneData[n2 + n3 * this.m_nWidth] = 9;
                        ++n2;
                        break;
                    }
                    case 51: {
                        this.m_SceneData[n2 + n3 * this.m_nWidth] = 13;
                        ++n2;
                        break;
                    }
                    case 52: {
                        this.m_SceneData[n2 + n3 * this.m_nWidth] = 17;
                        ++n2;
                        break;
                    }
                    case 37: {
                        this.m_SceneData[n2 + n3 * this.m_nWidth] = 2;
                        this.m_MainLoop.SetNpcPos(n, n2, n3);
                        ++n;
                        ++n2;
                        break;
                    }
                    default: {
                        ++n2;
                    }
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return true;
    }

    public void ScrollScene(int n, int n2) {
        int n3 = this.m_nWidth * 16;
        int n4 = this.m_nHeight * 16;
        int n5 = this.m_nMpsX;
        int n6 = this.m_nMpsY;
        this.m_nMpsX = n - this.m_MainLoop.m_nScrWidth / 2;
        this.m_nMpsY = n2 - this.m_MainLoop.m_nScrHeight / 2;
        if (this.m_nMpsX + this.m_MainLoop.m_nScrWidth >= n3) {
            this.m_nMpsX = n3 - this.m_MainLoop.m_nScrWidth;
        }
        if (this.m_nMpsX < 0) {
            this.m_nMpsX = 0;
        }
        if (this.m_nMpsY + this.m_MainLoop.m_nScrHeight >= n4) {
            this.m_nMpsY = n4 - this.m_MainLoop.m_nScrHeight;
        }
        if (this.m_nMpsY < 0) {
            this.m_nMpsY = 0;
        }
        this.m_nMapX = this.m_nMpsX / 16;
        this.m_nMapY = this.m_nMpsY / 16;
        if (this.m_nMpsX != n5 || this.m_nMpsY != n6) {
            this.m_MainLoop.SetFullRepaint();
        }
    }

    public void SetMapRect(int n, int n2) {
        this.m_nScrHeight = n / 16;
        this.m_nScrWidth = n2 / 16;
    }

    public int isBarriarLineX(int n, int n2, int n3) {
        return this.isBarriarLineXMap(n /= 16, n2 /= 16, n3 /= 16);
    }

    public int isBarriarLineXMap(int n, int n2, int n3) {
        boolean bl = false;
        if (n3 >= this.m_nHeight) {
            return this.m_nHeight - 1;
        }
        if (n < 0) {
            n = 0;
        } else if (n >= this.m_nWidth) {
            n = this.m_nWidth - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= this.m_nWidth) {
            n2 = this.m_nWidth - 1;
        }
        if (n < n2) {
            int n4 = n2 - n;
            if (n4 == 0) {
                if (this.isBarriarMap(n2, n3)) {
                    return n;
                }
                return -1;
            }
            int n5 = n + n3 * this.m_nWidth;
            int n6 = 0;
            while (n6 < n4) {
                if ((this.m_SceneData[++n5] & 1) == 1) {
                    bl = true;
                    break;
                }
                ++n6;
            }
            if (bl) {
                return n + n6;
            }
        } else if (n > n2) {
            int n7 = n - n2;
            if (n7 == 0) {
                if (this.isBarriarMap(n2, n3)) {
                    return n;
                }
                return -1;
            }
            int n8 = n + n3 * this.m_nWidth;
            int n9 = 0;
            while (n9 < n7) {
                if ((this.m_SceneData[--n8] & 1) == 1) {
                    bl = true;
                    break;
                }
                ++n9;
            }
            if (bl) {
                return n - n9;
            }
        } else {
            return n;
        }
        return -1;
    }

    public boolean isBarriarMap(int n, int n2) {
        if (n >= this.m_nWidth) {
            return true;
        }
        if (n < 0) {
            return true;
        }
        if (n2 < 0) {
            return true;
        }
        if (n2 >= this.m_nHeight) {
            return true;
        }
        return (this.m_SceneData[n + n2 * this.m_nWidth] & 1) == 1;
    }

    public int isBarriarLineY(int n, int n2, int n3) {
        return this.isBarriarLineYMap(n /= 16, n2 /= 16, n3 /= 16);
    }

    public int isBarriarLineYMap(int n, int n2, int n3) {
        boolean bl = false;
        if (n3 >= this.m_nWidth) {
            return this.m_nWidth - 1;
        }
        if (n < 0) {
            n = 0;
        } else if (n >= this.m_nHeight) {
            n = this.m_nHeight - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= this.m_nHeight) {
            n2 = this.m_nHeight - 1;
        }
        if (n < n2) {
            int n4 = n2 - n;
            if (n4 == 0) {
                if (this.isBarriarMap(n3, n2)) {
                    return n;
                }
                return -1;
            }
            int n5 = n3 + n * this.m_nWidth;
            int n6 = 0;
            while (n6 < n4) {
                if ((this.m_SceneData[n5 += this.m_nWidth] & 1) == 1) {
                    bl = true;
                    break;
                }
                ++n6;
            }
            if (bl) {
                return n + n6;
            }
        } else if (n > n2) {
            int n7 = n - n2;
            if (n7 == 0) {
                if (this.isBarriarMap(n3, n2)) {
                    return n;
                }
                return -1;
            }
            int n8 = n3 + n * this.m_nWidth;
            int n9 = 0;
            while (n9 < n7) {
                if ((this.m_SceneData[n8 -= this.m_nWidth] & 1) == 1) {
                    bl = true;
                    break;
                }
                ++n9;
            }
            if (bl) {
                return n - n9;
            }
        } else {
            return n;
        }
        return -1;
    }

    public boolean isVisible(int n, int n2, int n3, int n4) {
        return n + n3 > this.m_nMpsX && n < this.m_nMpsX + this.m_MainLoop.m_nScrWidth && n2 + n4 > this.m_nMpsY && n2 < this.m_nMpsY + this.m_MainLoop.m_nScrHeight - 12;
    }

    public void SetMapWndPos(int n, int n2) {
        this.m_nMapX = n / 16;
        this.m_nMapY = n2 / 16;
        this.m_nMpsX = n;
        this.m_nMpsY = n2;
    }

    public boolean pushBox(int n, int n2, int n3) {
        int n4;
        int n5;
        this.m_nPushX = n / 16;
        this.m_nPushY = n2 / 16;
        switch (n3) {
            case 1: {
                --this.m_nPushX;
                if (this.m_nPushX < 0) {
                    return false;
                }
                n5 = this.m_nPushX - 1;
                n4 = this.m_nPushY;
                break;
            }
            case 3: {
                ++this.m_nPushX;
                if (this.m_nPushX >= this.m_nWidth) {
                    return false;
                }
                n5 = this.m_nPushX + 1;
                n4 = this.m_nPushY;
                break;
            }
            case 0: {
                --this.m_nPushY;
                if (this.m_nPushY < 0) {
                    return false;
                }
                n5 = this.m_nPushX;
                n4 = this.m_nPushY - 1;
                break;
            }
            case 2: {
                ++this.m_nPushY;
                if (this.m_nPushY >= this.m_nHeight) {
                    return false;
                }
                n5 = this.m_nPushX;
                n4 = this.m_nPushY + 1;
                break;
            }
            default: {
                return false;
            }
        }
        int n6 = this.m_nPushX + this.m_nPushY * this.m_nWidth;
        byte by = (byte)(this.m_SceneData[n6] & 0x1D);
        if (by == 0) {
            return false;
        }
        if (n5 < 0 || n5 >= this.m_nWidth || n4 < 0 || n4 >= this.m_nHeight) {
            if (by == 1) {
                this.m_bPushBoxRepaint = true;
                int n7 = n6;
                this.m_SceneData[n7] = (byte)(this.m_SceneData[n7] & 0xE2);
                this.m_nPushMpsX = this.m_nPushX * 16;
                this.m_nPushMpsY = this.m_nPushY * 16;
            }
            return false;
        }
        byte by2 = this.m_SceneData[n5 + n4 * this.m_nWidth];
        if ((by2 & 1) == 1) {
            if (by == 1) {
                this.m_bPushBoxRepaint = true;
                int n8 = n6;
                this.m_SceneData[n8] = (byte)(this.m_SceneData[n8] & 0xE2);
                this.m_nPushMpsX = this.m_nPushX * 16;
                this.m_nPushMpsY = this.m_nPushY * 16;
            } else if ((by2 = (byte)(by2 & 0x1D)) == by) {
                this.m_MainLoop.SetFullRepaint();
                int n9 = n6;
                this.m_SceneData[n9] = (byte)(this.m_SceneData[n9] & 0xE2);
                if (by == 5) {
                    this.m_SceneData[n5 + n4 * this.m_nWidth] = 64;
                } else if (by == 9) {
                    this.m_SceneData[n5 + n4 * this.m_nWidth] = 96;
                } else if (by == 13) {
                    this.m_SceneData[n5 + n4 * this.m_nWidth] = -128;
                } else if (by == 17) {
                    this.m_SceneData[n5 + n4 * this.m_nWidth] = -96;
                } else if (by == 33) {
                    this.m_SceneData[n5 + n4 * this.m_nWidth] = -64;
                }
            }
            return false;
        }
        this.m_nPushMpsX = this.m_nPushX * 16;
        this.m_nPushMpsY = this.m_nPushY * 16;
        this.m_nPushDir = n3;
        this.m_nPushBox = n6;
        return true;
    }

    byte GetMapGoods(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= this.m_nWidth || n2 >= this.m_nHeight) {
            return 0;
        }
        return (byte)(this.m_SceneData[n + n2 * this.m_nWidth] & 0xFFFFFFE0);
    }

    void DestoryGoods(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= this.m_nWidth || n2 >= this.m_nHeight) {
            return;
        }
        int n3 = n + n2 * this.m_nWidth;
        this.m_SceneData[n3] = (byte)(this.m_SceneData[n3] & 0x1F);
    }

    public boolean pushLoop() {
        int n = this.m_nPushX;
        int n2 = this.m_nPushY;
        int n3 = this.m_nPushBox;
        int n4 = this.m_nPushMpsX;
        int n5 = this.m_nPushMpsY;
        boolean bl = false;
        int n6 = this.m_MainLoop.GetWalkSpeed();
        switch (this.m_nPushDir) {
            case 0: {
                n5 = this.m_nPushMpsY - n6;
                if (n5 < 0) {
                    this.m_MainLoop.CheckPushNpcDie(this.m_nPushX, this.m_nPushY);
                    this.m_nPushBox = -1;
                    return false;
                }
                n2 = n5 / 16;
                if (n2 == this.m_nPushY) break;
                n3 = this.m_nPushBox - this.m_nWidth;
                if (n2 < 0 || n3 < 0) {
                    this.m_nPushBox = -1;
                    this.m_MainLoop.CheckPushNpcDie(this.m_nPushX, this.m_nPushY);
                    return false;
                }
                byte by = (byte)(this.m_SceneData[n3] & 0x1D);
                if (by == 1) {
                    this.m_nPushBox = -1;
                    this.m_MainLoop.CheckPushNpcDie(this.m_nPushX, this.m_nPushY);
                    return false;
                }
                if (by != 0) {
                    byte by2 = (byte)(this.m_SceneData[this.m_nPushBox] & 0x1D);
                    if (by == by2) {
                        int n7 = this.m_nPushBox;
                        this.m_SceneData[n7] = (byte)(this.m_SceneData[n7] & 0xE2);
                        int n8 = n3;
                        this.m_SceneData[n8] = (byte)(this.m_SceneData[n8] & 0xE2);
                        if (by2 == 5) {
                            int n9 = n3;
                            this.m_SceneData[n9] = (byte)(this.m_SceneData[n9] | 0x40);
                        } else if (by2 == 9) {
                            int n10 = n3;
                            this.m_SceneData[n10] = (byte)(this.m_SceneData[n10] | 0x60);
                        } else if (by2 == 13) {
                            int n11 = n3;
                            this.m_SceneData[n11] = (byte)(this.m_SceneData[n11] | 0xFFFFFF80);
                        } else if (by2 == 17) {
                            int n12 = n3;
                            this.m_SceneData[n12] = (byte)(this.m_SceneData[n12] | 0xFFFFFFA0);
                        } else if (by2 == 33) {
                            int n13 = n3;
                            this.m_SceneData[n13] = (byte)(this.m_SceneData[n13] | 0xFFFFFFC0);
                        }
                    }
                    this.m_nPushBox = -1;
                    this.m_MainLoop.CheckPushNpcDie(this.m_nPushX, this.m_nPushY);
                    return false;
                }
                bl = true;
                break;
            }
            case 1: {
                n4 = this.m_nPushMpsX - n6;
                if (n4 < 0) {
                    this.m_MainLoop.CheckPushNpcDie(this.m_nPushX, this.m_nPushY);
                    this.m_nPushBox = -1;
                    return false;
                }
                n = n4 / 16;
                if (n == this.m_nPushX) break;
                if (n < 0) {
                    this.m_nPushBox = -1;
                    this.m_MainLoop.CheckPushNpcDie(this.m_nPushX, this.m_nPushY);
                    return false;
                }
                n3 = this.m_nPushBox - 1;
                byte by = (byte)(this.m_SceneData[n3] & 0x1D);
                if (by == 1) {
                    this.m_nPushBox = -1;
                    this.m_MainLoop.CheckPushNpcDie(this.m_nPushX, this.m_nPushY);
                    return false;
                }
                if (by != 0) {
                    byte by3 = (byte)(this.m_SceneData[this.m_nPushBox] & 0x1D);
                    if (by == by3) {
                        int n14 = this.m_nPushBox;
                        this.m_SceneData[n14] = (byte)(this.m_SceneData[n14] & 0xE2);
                        int n15 = n3;
                        this.m_SceneData[n15] = (byte)(this.m_SceneData[n15] & 0xE2);
                        if (by3 == 5) {
                            int n16 = n3;
                            this.m_SceneData[n16] = (byte)(this.m_SceneData[n16] | 0x40);
                        } else if (by3 == 9) {
                            int n17 = n3;
                            this.m_SceneData[n17] = (byte)(this.m_SceneData[n17] | 0x60);
                        } else if (by3 == 13) {
                            int n18 = n3;
                            this.m_SceneData[n18] = (byte)(this.m_SceneData[n18] | 0xFFFFFF80);
                        } else if (by3 == 17) {
                            int n19 = n3;
                            this.m_SceneData[n19] = (byte)(this.m_SceneData[n19] | 0xFFFFFFA0);
                        } else if (by3 == 33) {
                            int n20 = n3;
                            this.m_SceneData[n20] = (byte)(this.m_SceneData[n20] | 0xFFFFFFC0);
                        }
                    }
                    this.m_nPushBox = -1;
                    this.m_MainLoop.CheckPushNpcDie(this.m_nPushX, this.m_nPushY);
                    return false;
                }
                bl = true;
                break;
            }
            case 2: {
                n5 = this.m_nPushMpsY + n6;
                n2 = n5 / 16;
                if (n2 == this.m_nPushY) break;
                n3 = this.m_nPushBox + this.m_nWidth;
                if (n2 + 1 >= this.m_nHeight) {
                    byte by = (byte)(this.m_SceneData[this.m_nPushBox] & 0x1D);
                    int n21 = this.m_nPushBox;
                    this.m_SceneData[n21] = (byte)(this.m_SceneData[n21] & 0xE2);
                    int n22 = n3;
                    this.m_SceneData[n22] = (byte)(this.m_SceneData[n22] | by);
                    this.m_nPushBox = -1;
                    this.m_MainLoop.CheckPushNpcDie(this.m_nPushX, this.m_nPushY + 1);
                    return false;
                }
                byte by = (byte)(this.m_SceneData[n3 + this.m_nWidth] & 0x1D);
                if (by == 1) {
                    byte by4 = (byte)(this.m_SceneData[this.m_nPushBox] & 0x1D);
                    int n23 = this.m_nPushBox;
                    this.m_SceneData[n23] = (byte)(this.m_SceneData[n23] & 0xE2);
                    int n24 = n3;
                    this.m_SceneData[n24] = (byte)(this.m_SceneData[n24] | by4);
                    this.m_nPushBox = -1;
                    this.m_MainLoop.CheckPushNpcDie(this.m_nPushX, this.m_nPushY + 1);
                    return false;
                }
                if (by != 0) {
                    byte by5 = (byte)(this.m_SceneData[this.m_nPushBox] & 0x1D);
                    int n25 = this.m_nPushBox;
                    this.m_SceneData[n25] = (byte)(this.m_SceneData[n25] & 0xE2);
                    if (by == by5) {
                        int n26 = this.m_nPushBox = n3 + this.m_nWidth;
                        this.m_SceneData[n26] = (byte)(this.m_SceneData[n26] & 0xE2);
                        switch (by5) {
                            case 5: {
                                int n27 = this.m_nPushBox;
                                this.m_SceneData[n27] = (byte)(this.m_SceneData[n27] | 0x40);
                                break;
                            }
                            case 9: {
                                int n28 = this.m_nPushBox;
                                this.m_SceneData[n28] = (byte)(this.m_SceneData[n28] | 0x60);
                                break;
                            }
                            case 13: {
                                int n29 = this.m_nPushBox;
                                this.m_SceneData[n29] = (byte)(this.m_SceneData[n29] | 0xFFFFFF80);
                                break;
                            }
                            case 17: {
                                int n30 = this.m_nPushBox;
                                this.m_SceneData[n30] = (byte)(this.m_SceneData[n30] | 0xFFFFFFA0);
                                break;
                            }
                            case 33: {
                                int n31 = this.m_nPushBox;
                                this.m_SceneData[n31] = (byte)(this.m_SceneData[n31] | 0xFFFFFFC0);
                            }
                        }
                    } else {
                        int n32 = n3;
                        this.m_SceneData[n32] = (byte)(this.m_SceneData[n32] | by5);
                    }
                    this.m_nPushBox = -1;
                    this.m_MainLoop.CheckPushNpcDie(this.m_nPushX, this.m_nPushY + 1);
                    return false;
                }
                bl = true;
                break;
            }
            case 3: {
                n4 = this.m_nPushMpsX + n6;
                n = n4 / 16;
                if (n == this.m_nPushX) break;
                n3 = this.m_nPushBox + 1;
                if (n + 1 >= this.m_nWidth) {
                    byte by = (byte)(this.m_SceneData[this.m_nPushBox] & 0x1D);
                    int n33 = this.m_nPushBox;
                    this.m_SceneData[n33] = (byte)(this.m_SceneData[n33] & 0xE2);
                    int n34 = n3;
                    this.m_SceneData[n34] = (byte)(this.m_SceneData[n34] | by);
                    this.m_nPushBox = -1;
                    this.m_MainLoop.CheckPushNpcDie(this.m_nPushX + 1, this.m_nPushY);
                    return false;
                }
                byte by = (byte)(this.m_SceneData[n3 + 1] & 0x1D);
                if (by == 1) {
                    byte by6 = (byte)(this.m_SceneData[this.m_nPushBox] & 0x1D);
                    int n35 = this.m_nPushBox;
                    this.m_SceneData[n35] = (byte)(this.m_SceneData[n35] & 0xE2);
                    int n36 = n3;
                    this.m_SceneData[n36] = (byte)(this.m_SceneData[n36] | by6);
                    this.m_nPushBox = -1;
                    this.m_MainLoop.CheckPushNpcDie(this.m_nPushX + 1, this.m_nPushY);
                    return false;
                }
                if (by != 0) {
                    byte by7 = (byte)(this.m_SceneData[this.m_nPushBox] & 0x1D);
                    int n37 = this.m_nPushBox;
                    this.m_SceneData[n37] = (byte)(this.m_SceneData[n37] & 0xE2);
                    this.m_nPushBox = -1;
                    if (by == by7) {
                        int n38 = n3 + 1;
                        this.m_SceneData[n38] = (byte)(this.m_SceneData[n38] & 0xE2);
                        if (by7 == 5) {
                            int n39 = n3 + 1;
                            this.m_SceneData[n39] = (byte)(this.m_SceneData[n39] | 0x40);
                        } else if (by7 == 9) {
                            int n40 = n3 + 1;
                            this.m_SceneData[n40] = (byte)(this.m_SceneData[n40] | 0x60);
                        } else if (by7 == 13) {
                            int n41 = n3 + 1;
                            this.m_SceneData[n41] = (byte)(this.m_SceneData[n41] | 0xFFFFFF80);
                        } else if (by7 == 17) {
                            int n42 = n3 + 1;
                            this.m_SceneData[n42] = (byte)(this.m_SceneData[n42] | 0xFFFFFFA0);
                        } else if (by7 == 33) {
                            int n43 = n3 + 1;
                            this.m_SceneData[n43] = (byte)(this.m_SceneData[n43] | 0xFFFFFFC0);
                        }
                    } else {
                        int n44 = n3;
                        this.m_SceneData[n44] = (byte)(this.m_SceneData[n44] | by7);
                    }
                    this.m_MainLoop.CheckPushNpcDie(this.m_nPushX + 1, this.m_nPushY);
                    return false;
                }
                bl = true;
                break;
            }
            default: {
                return false;
            }
        }
        if (bl && this.m_nPushBox >= 0) {
            this.m_nPushX = n;
            this.m_nPushY = n2;
            byte by = (byte)(this.m_SceneData[this.m_nPushBox] & 0x1D);
            int n45 = this.m_nPushBox;
            this.m_SceneData[n45] = (byte)(this.m_SceneData[n45] & 0xE2);
            int n46 = this.m_nPushBox = n3;
            this.m_SceneData[n46] = (byte)(this.m_SceneData[n46] | by);
            this.m_MainLoop.PushNpc(this.m_nPushX, this.m_nPushY, this.m_nPushDir);
        }
        this.m_nPushMpsX = n4;
        this.m_nPushMpsY = n5;
        this.m_MainLoop.PushNpcLoop();
        this.ScrollScene(this.m_nPushMpsX, this.m_nPushMpsY);
        return this.m_nPushBox != -1;
    }

    void paintPushBox(Graphics graphics) {
        int n;
        if (this.m_nPushBox == -1) {
            if (this.m_bPushBoxRepaint) {
                graphics.setColor(this.m_nBkColor);
                graphics.fillRect(this.m_nPushMpsX - this.m_nMpsX, this.m_nPushMpsY - this.m_nMpsY, 16, 16);
                this.m_bPushBoxRepaint = false;
            }
            return;
        }
        byte by = this.m_SceneData[this.m_nPushBox];
        if ((by & 1) == 1 && this.m_Image[n = (by & 0x1D) == 5 ? 1 : ((by & 0x1D) == 9 ? 2 : ((by & 0x1D) == 13 ? 3 : ((by & 0x1D) == 17 ? 4 : ((by & 0x1D) == 33 ? 5 : 0))))] != -1) {
            this.m_MainLoop.m_ImgLib.paint(graphics, this.m_Image[n], this.m_nPushMpsX - this.m_nMpsX, this.m_nPushMpsY - this.m_nMpsY, 0, 0);
        }
        if ((by = (byte)(by & 0xFFFFFFE0)) != 0 && this.m_Image[n = by == 64 ? 6 : (by == 96 ? 7 : (by == -128 ? 8 : (by == -96 ? 9 : (by == -64 ? 10 : 0))))] != -1) {
            this.m_MainLoop.m_ImgLib.paint(graphics, this.m_Image[n], this.m_nPushMpsX - this.m_nMpsX, this.m_nPushMpsY - this.m_nMpsY, 0, 0);
        }
    }

    public void paintMap(Graphics graphics, int n, int n2) {
        if (n < 0 || n2 < 0 || n >= this.m_nWidth * 16 || n2 >= this.m_nHeight * 16) {
            return;
        }
        int n3 = n / 16;
        int n4 = n2 / 16;
        int n5 = n3 + n4 * this.m_nWidth;
        byte by = this.m_SceneData[n5];
        if ((by & 1) == 1 && this.m_Image[n5 = (by & 0x1D) == 5 ? 1 : ((by & 0x1D) == 9 ? 2 : ((by & 0x1D) == 13 ? 3 : ((by & 0x1D) == 17 ? 4 : ((by & 0x1D) == 33 ? 5 : 0))))] != -1) {
            int n6 = n3 * 16 - this.m_nMpsX;
            int n7 = n4 * 16 - this.m_nMpsY;
            this.m_MainLoop.m_ImgLib.paint(graphics, this.m_Image[n5], n6, n7, 0, 0);
            return;
        }
        if ((by = (byte)(by & 0xFFFFFFE0)) != 0) {
            n5 = by == 64 ? 6 : (by == 96 ? 7 : (by == -128 ? 8 : (by == -96 ? 9 : (by == -64 ? 10 : 0))));
            int n8 = n - this.m_nMpsX;
            int n9 = n2 - this.m_nMpsY;
            graphics.setColor(this.m_nBkColor);
            graphics.fillRect(n8, n9, 16, 16);
            if (this.m_Image[n5] != -1) {
                n8 = n3 * 16 - this.m_nMpsX;
                n9 = n4 * 16 - this.m_nMpsY;
                this.m_MainLoop.m_ImgLib.paint(graphics, this.m_Image[n5], n8, n9, 0, 0);
            }
        } else {
            int n10 = n - this.m_nMpsX;
            int n11 = n2 - this.m_nMpsY;
            graphics.setColor(this.m_nBkColor);
            graphics.fillRect(n10, n11, 16, 16);
        }
    }

    public void paint(Graphics graphics) {
        int n = this.m_nScrWidth + 2;
        int n2 = this.m_nScrHeight + 2;
        if (this.m_nMapX + n >= this.m_nWidth) {
            n = this.m_nWidth - this.m_nMapX;
        }
        if (this.m_nMapY + n2 >= this.m_nHeight) {
            n2 = this.m_nHeight - this.m_nMapY;
        }
        int n3 = this.m_nMapX * 16 - this.m_nMpsX;
        int n4 = this.m_nMapY * 16 - this.m_nMpsY;
        int n5 = 0;
        while (n5 < n2) {
            int n6 = 0;
            while (n6 < n) {
                int n7;
                int n8;
                int n9 = n6 + this.m_nMapX + (n5 + this.m_nMapY) * this.m_nWidth;
                byte by = this.m_SceneData[n9];
                if ((by & 1) == 1 && this.m_Image[n9 = (by & 0x1D) == 5 ? 1 : ((by & 0x1D) == 9 ? 2 : ((by & 0x1D) == 13 ? 3 : ((by & 0x1D) == 17 ? 4 : ((by & 0x1D) == 33 ? 5 : 0))))] != -1) {
                    if (n9 == this.m_nPushBox) {
                        this.m_MainLoop.m_ImgLib.paint(graphics, this.m_Image[n9], this.m_nPushMpsX - this.m_nMpsX, this.m_nPushMpsY - this.m_nMpsY, 0, 0);
                    } else {
                        n8 = n3 + n6 * 16;
                        n7 = n4 + n5 * 16;
                        this.m_MainLoop.m_ImgLib.paint(graphics, this.m_Image[n9], n8, n7, 0, 0);
                    }
                }
                if ((by = (byte)(by & 0xFFFFFFE0)) != 0) {
                    n9 = by == 64 ? 6 : (by == 96 ? 7 : (by == -128 ? 8 : (by == -96 ? 9 : (by == -64 ? 10 : 0))));
                    n8 = n3 + n6 * 16;
                    n7 = n4 + n5 * 16;
                    this.m_MainLoop.m_ImgLib.paint(graphics, this.m_Image[n9], n8, n7, 0, 0);
                }
                ++n6;
            }
            ++n5;
        }
    }
}

