/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class HighScores {
    static final int NUMOFSCORES = 3;
    private static RecordStore store;
    private static short[] highScore;
    private static String[] highScoreName;
    private static boolean highScoresHaveBeenInit;

    private HighScores() {
    }

    private static void initializeScores() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            byte[] byArray;
            try {
                dataOutputStream.writeShort(0);
                dataOutputStream.writeUTF("x");
                byArray = byteArrayOutputStream.toByteArray();
                dataOutputStream.close();
            }
            catch (IOException iOException) {
                throw new RecordStoreException();
            }
            int n = 0;
            while (n < 3) {
                store.addRecord(byArray, 0, byArray.length);
                ++n;
            }
        }
        catch (RecordStoreException recordStoreException) {
            HighScores.closeHighScores();
        }
    }

    static void setHighScore(int n, int n2, String string) {
        if (n2 <= highScore[n]) {
            return;
        }
        try {
            byte[] byArray;
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream.writeShort((short)n2);
                dataOutputStream.writeUTF(string);
                byArray = byteArrayOutputStream.toByteArray();
                dataOutputStream.close();
            }
            catch (IOException iOException) {
                throw new RecordStoreException();
            }
            if (store == null) {
                HighScores.openHighScores();
                store.setRecord(n + 1, byArray, 0, byArray.length);
                HighScores.closeHighScores();
            } else {
                store.setRecord(n + 1, byArray, 0, byArray.length);
            }
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        HighScores.highScore[n] = (short)n2;
        HighScores.highScoreName[n] = string;
    }

    static void addScore(short s, String string) {
        if (string == null) {
            string = new String("abc");
        }
        if (string.length() < 1) {
            string = new String("y");
        }
        int n = 0;
        while (n < 3) {
            if (s > highScore[n]) {
                short s2 = highScore[n];
                String string2 = highScoreName[n];
                HighScores.setHighScore(n, s, string);
                HighScores.addScore(s2, string2);
                break;
            }
            ++n;
        }
    }

    static void openHighScores() {
        try {
            store = RecordStore.openRecordStore((String)"HighScores", (boolean)true);
            if (highScoresHaveBeenInit) {
                return;
            }
            if (store.getNumRecords() == 0) {
                HighScores.initializeScores();
            } else {
                int n = 0;
                while (n < 3) {
                    byte[] byArray = store.getRecord(n + 1);
                    if (byArray != null) {
                        try {
                            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                            HighScores.highScore[n] = dataInputStream.readShort();
                            HighScores.highScoreName[n] = dataInputStream.readUTF();
                            dataInputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    ++n;
                }
            }
            highScoresHaveBeenInit = true;
        }
        catch (RecordStoreException recordStoreException) {}
    }

    static void closeHighScores() {
        if (store != null) {
            try {
                store.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
            store = null;
        }
    }

    static boolean isHighScore(short s) {
        if (!highScoresHaveBeenInit) {
            HighScores.openHighScores();
            HighScores.closeHighScores();
        }
        return s > highScore[2];
    }

    static String getName(int n) {
        if (!highScoresHaveBeenInit) {
            HighScores.openHighScores();
            HighScores.closeHighScores();
        }
        return highScoreName[n + 1];
    }

    static short getScore(int n) {
        if (!highScoresHaveBeenInit) {
            HighScores.openHighScores();
            HighScores.closeHighScores();
        }
        return highScore[n + 1];
    }

    static void paint(Graphics graphics, int n) {
        graphics.setColor(0);
        int n2 = 0;
        while (n2 < 3) {
            graphics.drawString(highScore[n2] + " - " + highScoreName[n2], graphics.getClipWidth() / 2, n + n2 * 8, 17);
            ++n2;
        }
    }

    static {
        highScore = new short[3];
        highScoreName = new String[3];
        highScoresHaveBeenInit = false;
    }
}

