/*
 * Decompiled with CFR 0.152.
 */
import com.bsg.siemens.BSCanvas;
import com.siemens.mp.color_game.Sprite;
import com.siemens.mp.color_game.TiledLayer;
import com.siemens.mp.game.Melody;
import com.siemens.mp.game.MelodyComposer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DiamondMineCanvas
extends BSCanvas
implements Runnable {
    private Image statusImage;
    private Image tiles;
    private Image livesImage;
    private Image crossImage;
    private Image tickImage;
    private Image optionsImage;
    private Image[] digits;
    private Graphics statusGraphics;
    private TiledLayer backGround;
    private Sprite playerSprite;
    private Sprite enemySprite;
    private Sprite objectsSprite;
    private Thread instance;
    private boolean running;
    private int screenWidth;
    private int halfScreenWidth;
    private int screenHeight;
    private int halfScreenHeight;
    private int statusHeight = 7;
    private int levelWidth;
    private int levelHeight;
    private int levelDiamonds;
    private int xOffSet;
    private int yOffSet;
    private int tileWidth = 11;
    private int halfTileWidth;
    private int tileHeight = 11;
    private int halfTileHeight;
    private int[][][] level;
    private int[][] spiders;
    private int currentLevel;
    private int exitX;
    private int exitY;
    private int pXPos;
    private int pOldXPos;
    private int pYPos;
    private int pOldYPos;
    private int pDiamonds;
    private int pLives;
    private int pMove;
    private int pFrame;
    private Vector fallingObjects;
    private Vector keyPresses;
    private final int[] P_FRAMES = new int[]{2, 1};
    private final int P_UP;
    private final int P_DOWN;
    private final int P_LEFT;
    private final int P_RIGHT;
    private final int P_DEAD;
    private final int[] M_FRAMES = new int[]{2, 2, 2, 2};
    private final int M_UP;
    private final int M_DOWN;
    private final int M_LEFT;
    private final int M_RIGHT;
    private final int M_X;
    private final int M_Y;
    private final int M_DX;
    private final int M_DY;
    private final int M_MOVE_COUNTER;
    private final int M_MOVE;
    private final int M_FRAME;
    private boolean updateStatus;
    private boolean keyPressed;
    private boolean start;
    private boolean levelClear;
    private boolean won;
    private boolean dead;
    private boolean gameover;
    private boolean gamecomplete;
    private Melody wonMelody;
    private Melody deadMelody;
    private Melody beepMed;

    public DiamondMineCanvas() {
        MelodyComposer melodyComposer;
        this.P_UP = 0;
        this.P_DOWN = 0;
        this.P_LEFT = 0;
        this.P_RIGHT = 0;
        this.P_DEAD = 1;
        this.M_UP = 0;
        this.M_DOWN = 1;
        this.M_LEFT = 2;
        this.M_RIGHT = 3;
        this.M_X = 0;
        this.M_Y = 1;
        this.M_DX = 2;
        this.M_DY = 3;
        this.M_MOVE_COUNTER = 4;
        this.M_MOVE = 5;
        this.M_FRAME = 6;
        this.screenWidth = this.getWidth();
        this.halfScreenWidth = this.screenWidth / 2;
        this.screenHeight = this.getHeight() - this.statusHeight;
        this.halfScreenHeight = this.screenHeight / 2;
        this.halfTileWidth = this.tileWidth / 2;
        this.halfTileHeight = this.tileHeight / 2;
        this.statusImage = Image.createImage((int)this.screenWidth, (int)this.statusHeight);
        this.statusGraphics = this.statusImage.getGraphics();
        try {
            melodyComposer = new MelodyComposer();
            melodyComposer.setBPM(160);
            melodyComposer.appendNote(33, 2);
            melodyComposer.appendNote(28, 3);
            melodyComposer.appendNote(31, 4);
            melodyComposer.appendNote(35, 3);
            melodyComposer.appendNote(36, 4);
            melodyComposer.appendNote(35, 4);
            melodyComposer.appendNote(33, 3);
            melodyComposer.appendNote(58, 4);
            melodyComposer.appendNote(33, 2);
            melodyComposer.appendNote(28, 3);
            melodyComposer.appendNote(31, 4);
            melodyComposer.appendNote(38, 3);
            melodyComposer.appendNote(36, 4);
            melodyComposer.appendNote(36, 3);
            melodyComposer.appendNote(35, 4);
            melodyComposer.appendNote(36, 3);
            this.wonMelody = melodyComposer.getMelody();
            melodyComposer.resetMelody();
            melodyComposer.setBPM(120);
            melodyComposer.appendNote(26, 2);
            melodyComposer.appendNote(28, 2);
            melodyComposer.appendNote(31, 2);
            melodyComposer.appendNote(29, 2);
            this.deadMelody = melodyComposer.getMelody();
            melodyComposer.resetMelody();
            melodyComposer.setBPM(120);
            melodyComposer.appendNote(24, 4);
            this.beepMed = melodyComposer.getMelody();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.tiles = com.siemens.mp.ui.Image.createImageWithoutScaling((String)"/Tiles.png");
            this.playerSprite = new Sprite(Image.createImage((String)"/PlayerImages.png"), 11, 11);
            this.enemySprite = new Sprite(Image.createImage((String)"/EnemyImages.png"), 11, 11);
            this.objectsSprite = new Sprite(this.tiles, 11, 11);
            melodyComposer = Image.createImage((String)"/Status.png");
            this.livesImage = this.getImage((Image)melodyComposer, 13, 7, -30, 0);
            this.crossImage = this.getImage((Image)melodyComposer, 7, 7, -43, 0);
            this.tickImage = this.getImage((Image)melodyComposer, 8, 7, -50, 0);
            this.optionsImage = this.getImage((Image)melodyComposer, melodyComposer.getWidth() - 58, 7, -58, 0);
            this.digits = new Image[10];
            for (int i = 0; i < this.digits.length; ++i) {
                this.digits[i] = this.getImage((Image)melodyComposer, 3, 5, -3 * i, 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Image getImage(Image image, int n, int n2, int n3, int n4) {
        Image image2 = Image.createImage((int)n, (int)n2);
        Graphics graphics = image2.getGraphics();
        graphics.drawImage(image, n3, n4, 20);
        return image2;
    }

    public void startGame(int n, Gauge gauge) {
        this.currentLevel = 0;
        try {
            this.loadLevel(gauge);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pLives = 5;
        gauge.setValue(100);
        this.commandListener.commandAction(BSCanvas.DISPLAY_CANVAS, (Displayable)this);
    }

    public void nextLevel(Gauge gauge) {
        if (!this.dead) {
            ++this.currentLevel;
        }
        try {
            this.loadLevel(gauge);
        }
        catch (Exception exception) {
            // empty catch block
        }
        gauge.setValue(100);
        this.commandListener.commandAction(BSCanvas.DISPLAY_CANVAS, (Displayable)this);
    }

    public void loadLevel(Gauge gauge) throws Exception {
        int n;
        InputStream inputStream = this.getClass().getResourceAsStream(String.valueOf(String.valueOf(new StringBuffer("/Levels/level").append(this.currentLevel).append(".txt"))));
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        gauge.setValue(10);
        this.pXPos = dataInputStream.readInt() * this.tileWidth;
        this.pYPos = dataInputStream.readInt() * this.tileHeight;
        int n2 = dataInputStream.readInt();
        int n3 = dataInputStream.readInt();
        this.level = new int[n3][n2][1];
        this.levelWidth = n2 * this.tileWidth;
        this.levelHeight = n3 * this.tileHeight;
        this.backGround = new TiledLayer(n2, n3, this.tiles, 11, 11);
        this.levelDiamonds = 0;
        this.fallingObjects = new Vector(10);
        Vector<int[]> vector = new Vector<int[]>(10);
        gauge.setValue(30);
        for (n = 0; n < this.level[0].length; ++n) {
            for (int i = 0; i < this.level.length; ++i) {
                this.level[i][n][0] = dataInputStream.readByte();
                if (this.level[i][n][0] == 0) continue;
                if (this.level[i][n][0] >= 30 && this.level[i][n][0] < 45) {
                    this.level[i][n] = new int[]{this.level[i][n][0], n, i, 0};
                }
                if (this.level[i][n][0] == 40) {
                    ++this.levelDiamonds;
                }
                if (this.level[i][n][0] == 21) {
                    this.exitX = n;
                    this.exitY = i;
                }
                if (this.level[i][n][0] < 50 || this.level[i][n][0] >= 60) continue;
                vector.addElement(new int[]{n, i, 0, -1, 0, 0, 0});
                this.level[i][n] = new int[]{0};
            }
        }
        gauge.setValue(50);
        this.spiders = new int[vector.size()][];
        for (n = 0; n < this.spiders.length; ++n) {
            this.spiders[n] = (int[])vector.elementAt(n);
        }
        dataInputStream.close();
        gauge.setValue(70);
        this.pDiamonds = 0;
        this.pMove = 0;
        this.pFrame = 0;
        this.xOffSet = this.levelWidth < this.screenWidth ? (this.screenWidth - this.levelWidth) / 2 : 0;
        this.yOffSet = this.levelHeight < this.screenHeight ? (this.screenHeight - this.levelHeight) / 2 : 0;
        this.updateStatus = true;
        this.won = false;
        this.levelClear = false;
        this.dead = false;
        this.gameover = false;
        this.gamecomplete = false;
        this.start = true;
    }

    public void loadGame(byte[] byArray, Gauge gauge) throws Exception {
        int n;
        int n2;
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        this.currentLevel = dataInputStream.readByte();
        this.loadLevel(gauge);
        this.pXPos = dataInputStream.readInt();
        this.pYPos = dataInputStream.readInt();
        this.pMove = dataInputStream.readByte();
        this.pFrame = dataInputStream.readByte();
        this.pDiamonds = dataInputStream.readByte();
        this.pLives = dataInputStream.readByte();
        gauge.setValue(80);
        for (n2 = 0; n2 < this.level[0].length; ++n2) {
            for (n = 0; n < this.level.length; ++n) {
                byte by = dataInputStream.readByte();
                this.level[n][n2] = by >= 30 && by < 45 ? new int[]{by, dataInputStream.readByte(), dataInputStream.readByte(), dataInputStream.readByte()} : new int[]{by};
            }
        }
        gauge.setValue(90);
        n2 = dataInputStream.readByte();
        this.fallingObjects = new Vector(n2);
        for (n = 0; n < n2; ++n) {
            this.fallingObjects.addElement(this.level[dataInputStream.readByte()][dataInputStream.readByte()]);
        }
        this.spiders = new int[dataInputStream.readByte()][7];
        for (n = 0; n < this.spiders.length; ++n) {
            if (dataInputStream.readByte() == -1) {
                this.spiders[n] = null;
                continue;
            }
            this.spiders[n][0] = dataInputStream.readByte();
            this.spiders[n][1] = dataInputStream.readByte();
            this.spiders[n][2] = dataInputStream.readByte();
            this.spiders[n][3] = dataInputStream.readByte();
            this.spiders[n][4] = dataInputStream.readByte();
            this.spiders[n][5] = dataInputStream.readByte();
            this.spiders[n][6] = dataInputStream.readByte();
        }
        dataInputStream.close();
        gauge.setValue(100);
    }

    public byte[] saveGame(Gauge gauge) {
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            gauge.setValue(10);
            dataOutputStream.writeByte(this.currentLevel);
            dataOutputStream.writeInt(this.pXPos);
            dataOutputStream.writeInt(this.pYPos);
            dataOutputStream.writeByte(this.pMove);
            dataOutputStream.writeByte(this.pFrame);
            dataOutputStream.writeByte(this.pDiamonds);
            dataOutputStream.writeByte(this.pLives);
            gauge.setValue(20);
            for (n = 0; n < this.level[0].length; ++n) {
                for (int i = 0; i < this.level.length; ++i) {
                    dataOutputStream.writeByte(this.level[i][n][0]);
                    if (this.level[i][n][0] < 30 || this.level[i][n][0] >= 45) continue;
                    dataOutputStream.writeByte(this.level[i][n][1]);
                    dataOutputStream.writeByte(this.level[i][n][2]);
                    dataOutputStream.writeByte(this.level[i][n][3]);
                }
            }
            gauge.setValue(50);
            dataOutputStream.writeByte(this.fallingObjects.size());
            for (n = 0; n < this.fallingObjects.size(); ++n) {
                int[] nArray = (int[])this.fallingObjects.elementAt(n);
                dataOutputStream.writeByte(nArray[2]);
                dataOutputStream.writeByte(nArray[1]);
            }
            gauge.setValue(70);
            dataOutputStream.writeByte(this.spiders.length);
            for (n = 0; n < this.spiders.length; ++n) {
                if (this.spiders[n] == null) {
                    dataOutputStream.writeByte(-1);
                    continue;
                }
                dataOutputStream.writeByte(0);
                dataOutputStream.writeByte(this.spiders[n][0]);
                dataOutputStream.writeByte(this.spiders[n][1]);
                dataOutputStream.writeByte(this.spiders[n][2]);
                dataOutputStream.writeByte(this.spiders[n][3]);
                dataOutputStream.writeByte(this.spiders[n][4]);
                dataOutputStream.writeByte(this.spiders[n][5]);
                dataOutputStream.writeByte(this.spiders[n][6]);
            }
            gauge.setValue(80);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception exception) {
            byte[] byArray = null;
            return byArray;
        }
    }

    protected void paint(Graphics graphics) {
        if (!this.gamecomplete) {
            int n;
            if (this.updateStatus) {
                this.statusGraphics.setColor(0xFFFFFF);
                this.statusGraphics.fillRect(0, 0, this.screenWidth, this.statusHeight);
                this.statusGraphics.drawImage(this.optionsImage, this.screenWidth - this.optionsImage.getWidth(), 0, 20);
                n = 0;
                this.statusGraphics.drawImage(this.livesImage, n, 0, 20);
                this.statusGraphics.drawImage(this.digits[this.pLives / 10 % 10], n += this.livesImage.getWidth() + 1, 1, 20);
                this.statusGraphics.drawImage(this.digits[this.pLives % 10], n += this.digits[0].getWidth() + 1, 1, 20);
                if (this.pDiamonds == this.levelDiamonds) {
                    this.statusGraphics.drawImage(this.tickImage, n += this.digits[0].getWidth() + 20, 0, 20);
                } else {
                    this.statusGraphics.drawImage(this.crossImage, n += this.digits[0].getWidth() + 20, 0, 20);
                }
                this.updateStatus = false;
            }
            if (this.pXPos + this.halfTileWidth > this.halfScreenWidth && this.levelWidth + this.xOffSet > this.screenWidth || this.pXPos + this.halfTileWidth < this.halfScreenWidth - this.xOffSet && this.xOffSet < 0) {
                this.xOffSet = this.halfScreenWidth - this.pXPos - this.halfTileWidth;
                if (this.levelWidth + this.xOffSet < this.screenWidth) {
                    this.xOffSet = -(this.levelWidth - this.screenWidth);
                } else if (this.xOffSet > 0) {
                    this.xOffSet = 0;
                }
            }
            if (this.pYPos + this.halfTileHeight > this.halfScreenHeight && this.levelHeight + this.yOffSet > this.screenHeight || this.pYPos + this.halfTileHeight < this.halfScreenHeight - this.yOffSet && this.yOffSet < 0) {
                this.yOffSet = this.halfScreenHeight - this.pYPos - this.halfTileHeight;
                if (this.levelHeight + this.yOffSet < this.screenHeight) {
                    this.yOffSet = -(this.levelHeight - this.screenHeight);
                } else if (this.yOffSet > 0) {
                    this.yOffSet = 0;
                }
            }
            for (n = 0; n < this.level[0].length; ++n) {
                for (int i = 0; i < this.level.length; ++i) {
                    this.backGround.setCell(n, i, this.level[i][n][0] + 1);
                }
            }
            this.backGround.setPosition(this.xOffSet, this.yOffSet);
            this.backGround.paint(graphics);
            this.playerSprite.setFrame(this.pMove * 2 + this.pFrame);
            this.playerSprite.setPosition(this.xOffSet + this.pXPos, this.yOffSet + this.pYPos);
            this.playerSprite.paint(graphics);
            for (n = 0; n < this.spiders.length; ++n) {
                if (this.spiders[n] == null) continue;
                this.enemySprite.setFrame(this.spiders[n][5] * 2 + this.spiders[n][6]);
                this.enemySprite.setPosition(this.xOffSet + this.spiders[n][0] * this.tileWidth, this.yOffSet + this.spiders[n][1] * this.tileHeight);
                this.enemySprite.paint(graphics);
            }
            for (n = 0; n < this.fallingObjects.size(); ++n) {
                int[] nArray = (int[])this.fallingObjects.elementAt(n);
                this.objectsSprite.setFrame(nArray[0]);
                this.objectsSprite.setPosition(this.xOffSet + nArray[1] * this.tileWidth, this.yOffSet + nArray[2] * this.tileHeight);
                this.objectsSprite.paint(graphics);
            }
            graphics.drawImage(this.statusImage, 0, this.screenHeight, 20);
            if (this.levelClear) {
                this.drawText(graphics, this.parseString(this.langT[0]), this.getFont(this.langA[0]), true, this.halfScreenWidth, this.halfScreenHeight);
            } else if (this.gameover) {
                this.drawText(graphics, this.parseString(this.langT[1]), this.getFont(this.langA[1]), true, this.halfScreenWidth, this.halfScreenHeight);
            }
            if (this.start) {
                this.drawText(graphics, this.parseString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.langT[6]))).append(this.currentLevel + 1)))), this.getFont(this.langA[6]), true, this.halfScreenWidth, this.halfScreenHeight);
            }
            if (this.paused) {
                this.drawText(graphics, this.parseString(this.langT[5]), this.getFont(this.langA[5]), true, this.halfScreenWidth, this.halfScreenHeight);
            }
        } else {
            graphics.setColor(0xEEAA66);
            graphics.fillRect(0, 0, this.screenWidth, this.screenHeight + this.statusHeight);
            this.objectsSprite.setFrame(40);
            this.objectsSprite.setPosition(0, 0);
            this.objectsSprite.paint(graphics);
            this.objectsSprite.setFrame(40);
            this.objectsSprite.setPosition(this.screenWidth - this.tileWidth, 0);
            this.objectsSprite.paint(graphics);
            this.objectsSprite.setFrame(40);
            this.objectsSprite.setPosition(0, this.screenHeight + this.statusHeight - this.tileHeight);
            this.objectsSprite.paint(graphics);
            this.objectsSprite.setFrame(40);
            this.objectsSprite.setPosition(this.screenWidth - this.tileWidth, this.screenHeight + this.statusHeight - this.tileHeight);
            this.objectsSprite.paint(graphics);
            this.drawText(graphics, this.parseString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.langT[2]))).append(",").append(this.langT[3])))), new Font[]{this.getFont(this.langA[2]), this.getFont(this.langA[3])}, true, this.halfScreenWidth, this.halfScreenHeight - this.getFont(this.langA[2]).getHeight());
        }
    }

    public void start() {
        if (this.instance == null || !this.running && !this.paused && !this.instance.isAlive()) {
            this.instance = new Thread(this);
            this.running = true;
            this.instance.start();
        } else if (this.instance.isAlive()) {
            this.running = true;
        }
    }

    public void stop() {
        this.running = false;
        this.keyPressed = false;
    }

    public void hideNotify() {
        this.stop();
    }

    public void showNotify() {
        this.start();
        this.keyPresses = new Vector();
    }

    public void restartLevel() {
        BSCanvas.playSound(this.deadMelody);
        BSCanvas.vibrate(50, 500);
        this.pMove = 1;
        this.pFrame = 0;
        this.dead = true;
        this.keyPressed = true;
    }

    private void moveSpiders() {
        for (int i = 0; i < this.spiders.length; ++i) {
            if (this.spiders[i] == null) continue;
            int[] nArray = this.spiders[i];
            nArray[4] = nArray[4] + 1;
            if (this.spiders[i][4] == 4) {
                this.spiders[i][4] = 0;
                int n = this.spiders[i][0] + this.spiders[i][2];
                int n2 = this.spiders[i][1] + this.spiders[i][3];
                boolean bl = false;
                for (int j = 0; j < this.spiders.length; ++j) {
                    if (this.spiders[j] == null || this.spiders[j][0] != n || this.spiders[j][1] != n2) continue;
                    bl = true;
                }
                if (!bl && this.level[n2][n][0] < 10) {
                    this.spiders[i][0] = n;
                    this.spiders[i][1] = n2;
                } else {
                    this.spiders[i][5] = BSCanvas.getRandom(4);
                    switch (this.spiders[i][5]) {
                        case 0: {
                            this.spiders[i][2] = 0;
                            this.spiders[i][3] = -1;
                            break;
                        }
                        case 1: {
                            this.spiders[i][2] = 0;
                            this.spiders[i][3] = 1;
                            break;
                        }
                        case 2: {
                            this.spiders[i][2] = -1;
                            this.spiders[i][3] = 0;
                            break;
                        }
                        case 3: {
                            this.spiders[i][2] = 1;
                            this.spiders[i][3] = 0;
                        }
                    }
                }
            }
            if (this.spiders[i][0] == this.pXPos / this.tileWidth && this.spiders[i][1] - 1 == this.pYPos / this.tileHeight) {
                this.restartLevel();
                continue;
            }
            if (this.spiders[i][0] == this.pXPos / this.tileWidth && this.spiders[i][1] + 1 == this.pYPos / this.tileHeight) {
                this.restartLevel();
                continue;
            }
            if (this.spiders[i][0] - 1 == this.pXPos / this.tileWidth && this.spiders[i][1] == this.pYPos / this.tileHeight) {
                this.restartLevel();
                continue;
            }
            if (this.spiders[i][0] + 1 != this.pXPos / this.tileWidth || this.spiders[i][1] != this.pYPos / this.tileHeight) continue;
            this.restartLevel();
        }
    }

    public void run() {
        while (this.running) {
            try {
                if (this.start) {
                    this.repaint();
                    Thread.sleep(2000L);
                    this.start = false;
                    this.repaint();
                }
                if (this.levelClear || this.gameover || !this.keyPressed) continue;
                if (this.keyPresses.size() > 0) {
                    int[] nArray = (int[])this.keyPresses.elementAt(0);
                    this.move(nArray[0], nArray[1]);
                    this.keyPresses.removeElementAt(0);
                }
                ++this.pFrame;
                if (this.pFrame == this.P_FRAMES[this.pMove]) {
                    this.pFrame = 0;
                }
                this.moveSpiders();
                for (int i = 0; i < this.spiders.length; ++i) {
                    if (this.spiders[i] == null) continue;
                    int[] nArray = this.spiders[i];
                    nArray[6] = nArray[6] + 1;
                    if (this.spiders[i][6] != this.M_FRAMES[this.spiders[i][5]]) continue;
                    this.spiders[i][6] = 0;
                }
                this.checkDrop();
                this.repaint();
                this.serviceRepaints();
                Thread.sleep(100L);
                if (this.won) {
                    this.stop();
                    BSCanvas.playSound(this.wonMelody);
                    this.repaint();
                    Thread.sleep(1000L);
                    this.levelClear = true;
                    this.repaint();
                    Thread.sleep(3000L);
                    if (this.currentLevel == 10) {
                        this.gamecomplete = true;
                        this.repaint();
                        Thread.sleep(3000L);
                        this.commandListener.commandAction(BSCanvas.GAME_ENDED, (Displayable)this);
                        continue;
                    }
                    this.commandListener.commandAction(BSCanvas.LEVEL_ENDED, (Displayable)this);
                    continue;
                }
                if (!this.dead) continue;
                this.stop();
                --this.pLives;
                this.updateStatus = true;
                this.repaint();
                Thread.sleep(1000L);
                if (this.pLives == 0) {
                    this.gameover = true;
                    this.repaint();
                    Thread.sleep(3000L);
                    this.commandListener.commandAction(BSCanvas.GAME_ENDED, (Displayable)this);
                    continue;
                }
                this.commandListener.commandAction(BSCanvas.LEVEL_ENDED, (Displayable)this);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void collect(int n, int n2, int n3) {
        this.level[n2][n] = new int[]{0};
        if (n3 == 40) {
            BSCanvas.playSound(this.beepMed);
            ++this.pDiamonds;
            if (this.pDiamonds >= this.levelDiamonds) {
                this.level[this.exitY][this.exitX] = new int[]{49};
                this.updateStatus = true;
            }
        } else if (n3 == 49) {
            this.won = true;
        }
    }

    private void checkDrop() {
        if (this.fallingObjects.size() > 0) {
            int n = this.pXPos / this.tileWidth;
            int n2 = this.pYPos / this.tileHeight;
            for (int i = 0; i < this.fallingObjects.size(); ++i) {
                int n3;
                int[] nArray = (int[])this.fallingObjects.elementAt(i);
                boolean bl = false;
                boolean bl2 = false;
                for (n3 = 0; n3 < this.spiders.length; ++n3) {
                    if (this.spiders[n3] == null) continue;
                    if (this.spiders[n3][0] == nArray[1] - 1 && this.spiders[n3][1] == nArray[2]) {
                        bl = true;
                        continue;
                    }
                    if (this.spiders[n3][0] != nArray[1] + 1 || this.spiders[n3][1] != nArray[2]) continue;
                    bl2 = true;
                }
                if (this.level[nArray[2] + 1][nArray[1]][0] < 10) {
                    if (nArray[1] == n && nArray[2] + 1 == n2) {
                        this.fallingObjects.removeElementAt(i--);
                        if (nArray[0] >= 40) {
                            this.collect(nArray[1], nArray[2], nArray[0]);
                            continue;
                        }
                        this.level[nArray[2]][nArray[1]][3] = 0;
                        this.restartLevel();
                        continue;
                    }
                    for (n3 = 0; n3 < this.spiders.length; ++n3) {
                        if (this.spiders[n3] == null || nArray[1] != this.spiders[n3][0] || nArray[2] + 1 != this.spiders[n3][1]) continue;
                        this.spiders[n3] = null;
                        break;
                    }
                    this.level[nArray[2] + 1][nArray[1]] = this.level[nArray[2]][nArray[1]];
                    this.level[nArray[2]][nArray[1]] = new int[]{0};
                    nArray[2] = nArray[2] + 1;
                    continue;
                }
                if (!(this.level[nArray[2] + 1][nArray[1]][0] < 30 || this.level[nArray[2] + 1][nArray[1]][0] >= 40 || this.level[nArray[2] + 1][nArray[1]][3] != 0 || this.pXPos / this.tileWidth == nArray[1] + 1 && this.pYPos / this.tileHeight == nArray[2] || this.level[nArray[2]][nArray[1] + 1][0] >= 10 || this.level[nArray[2] + 1][nArray[1] + 1][0] >= 10 || bl2)) {
                    this.level[nArray[2]][nArray[1] + 1] = this.level[nArray[2]][nArray[1]];
                    this.level[nArray[2]][nArray[1]] = new int[]{0};
                    nArray[1] = nArray[1] + 1;
                    continue;
                }
                if (!(this.level[nArray[2] + 1][nArray[1]][0] < 30 || this.level[nArray[2] + 1][nArray[1]][0] >= 40 || this.level[nArray[2] + 1][nArray[1]][3] != 0 || this.pXPos / this.tileWidth == nArray[1] - 1 && this.pYPos / this.tileHeight == nArray[2] || this.level[nArray[2]][nArray[1] - 1][0] >= 10 || this.level[nArray[2] + 1][nArray[1] - 1][0] >= 10 || bl)) {
                    this.level[nArray[2]][nArray[1] - 1] = this.level[nArray[2]][nArray[1]];
                    this.level[nArray[2]][nArray[1]] = new int[]{0};
                    nArray[1] = nArray[1] - 1;
                    continue;
                }
                if (this.level[nArray[2] + 1][nArray[1]][0] >= 30 && this.level[nArray[2] + 1][nArray[1]][0] < 45 && this.level[nArray[2] + 1][nArray[1]][3] != 0) continue;
                BSCanvas.vibrate(50, 100);
                this.fallingObjects.removeElementAt(i--);
                this.level[nArray[2]][nArray[1]][3] = 0;
            }
        }
    }

    private void move(int n, int n2) {
        int n3;
        int n4;
        this.pOldXPos = this.pXPos;
        this.pOldYPos = this.pYPos;
        int n5 = (this.pYPos + n2) / this.tileHeight;
        int n6 = (this.pXPos + n) / this.tileWidth;
        if (this.level[n5][n6][0] < 20) {
            this.pXPos += n;
            this.pYPos += n2;
            this.level[n5][n6] = new int[]{0};
        } else if (n != 0 && this.level[n5][n6][0] >= 30 && this.level[n5][n6][0] < 40) {
            n4 = n6;
            n4 = n > 0 ? ++n4 : --n4;
            if (this.level[n5][n4][0] < 10) {
                n3 = 0;
                for (int i = 0; i < this.spiders.length; ++i) {
                    if (this.spiders[i] == null || this.spiders[i][0] != n4 || this.spiders[i][1] != n5) continue;
                    n3 = 1;
                }
                if (n3 == 0) {
                    this.pXPos += n;
                    this.pYPos += n2;
                    this.level[n5][n4] = this.level[n5][n6];
                    this.level[n5][n6] = new int[]{0};
                    this.level[n5][n4][1] = n4;
                    if (this.level[n5 + 1][n4][0] < 10 || this.level[n5 + 1][n4][0] >= 30 && this.level[n5 + 1][n4][0] <= 45 && this.level[n5 + 1][n4][3] == 1) {
                        this.fallingObjects.addElement(this.level[n5][n4]);
                        this.level[n5][n4][3] = 1;
                    }
                }
            }
        } else if (this.level[n5][n6][0] >= 40 && this.level[n5][n6][0] < 50) {
            this.pXPos += n;
            this.pYPos += n2;
            if (this.level[n5][n6][0] < 45 && this.level[n5][n6][3] != 0) {
                this.fallingObjects.removeElement(this.level[n5][n6]);
            }
            this.collect(n6, n5, this.level[n5][n6][0]);
        }
        if (this.pOldXPos != this.pXPos || this.pOldYPos != this.pYPos) {
            if (n5 - 1 >= 0 && this.level[n5 - 1][n6][0] >= 40 && this.level[n5 - 1][n6][0] < 45) {
                if (this.level[n5 - 1][n6][3] != 0) {
                    this.fallingObjects.removeElement(this.level[n5 - 1][n6]);
                }
                this.collect(n6, n5 - 1, this.level[n5 - 1][n6][0]);
                for (n4 = n5 - 2; n4 > 0 && this.level[n4][n6][0] >= 30 && this.level[n4][n6][0] < 45 && this.level[n4][n6][3] == 0; --n4) {
                    this.fallingObjects.addElement(this.level[n4][n6]);
                    this.level[n4][n6][3] = 1;
                }
            }
            if (n2 >= 0) {
                n4 = n6;
                n3 = n5 - 1;
                if (n > 0) {
                    --n4;
                } else if (n < 0) {
                    ++n4;
                }
                if (n2 > 0) {
                    --n3;
                }
                while (n3 > 0 && this.level[n3][n4][0] >= 30 && this.level[n3][n4][0] < 45 && this.level[n3][n4][3] == 0) {
                    this.fallingObjects.addElement(this.level[n3][n4]);
                    this.level[n3][n4][3] = 1;
                    --n3;
                }
            }
        }
    }

    public void keyPressed(int n) {
        if (!(this.won || this.dead || this.start)) {
            this.keyPressed = true;
            int n2 = this.getGameAction(n);
            if (n == -4) {
                this.commandListener.commandAction(BSCanvas.DISPLAY_MENU, (Displayable)this);
            } else {
                block0 : switch (n2) {
                    case 1: {
                        this.keyPresses.addElement(new int[]{0, -this.tileHeight});
                        break;
                    }
                    case 6: {
                        this.keyPresses.addElement(new int[]{0, this.tileHeight});
                        break;
                    }
                    case 2: {
                        this.keyPresses.addElement(new int[]{-this.tileWidth, 0});
                        break;
                    }
                    case 5: {
                        this.keyPresses.addElement(new int[]{this.tileWidth, 0});
                        break;
                    }
                    default: {
                        switch (n) {
                            case 50: {
                                this.keyPresses.addElement(new int[]{0, -this.tileHeight});
                                break block0;
                            }
                            case 56: {
                                this.keyPresses.addElement(new int[]{0, this.tileHeight});
                                break block0;
                            }
                            case 52: {
                                this.keyPresses.addElement(new int[]{-this.tileWidth, 0});
                                break block0;
                            }
                            case 54: {
                                this.keyPresses.addElement(new int[]{this.tileWidth, 0});
                            }
                        }
                    }
                }
            }
        }
    }

    public String[] parseString(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != ',') continue;
            ++n;
        }
        String[] stringArray = new String[n + 1];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = string.substring(0, string.indexOf(44));
            string = string.substring(string.indexOf(44) + 1);
        }
        stringArray[n] = string;
        return stringArray;
    }

    public void drawText(Graphics graphics, String[] stringArray, Font font, boolean bl, int n, int n2) {
        Font[] fontArray = new Font[stringArray.length];
        for (int i = 0; i < fontArray.length; ++i) {
            fontArray[i] = font;
        }
        this.drawText(graphics, stringArray, fontArray, bl, n, n2);
    }

    public void drawText(Graphics graphics, String[] stringArray, Font[] fontArray, boolean bl, int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            graphics.setFont(fontArray[n3]);
            n5 = Math.max(fontArray[n3].stringWidth(stringArray[n3]), n5);
            n7 += fontArray[n3].getHeight();
        }
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(n - n5 / 2 - 1, n2 - 2, n5 + 2, n7 + 1);
        graphics.setColor(0);
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            n4 = fontArray[n3].stringWidth(stringArray[n3]);
            graphics.setFont(fontArray[n3]);
            graphics.drawString(stringArray[n3], n, n2 + n6, 17);
            n6 += fontArray[n3].getHeight();
        }
        if (bl) {
            graphics.drawRect(n - n5 / 2 - 1, n2 - 2, n5 + 2, n7 + 1);
        }
    }
}

