/*
 * Decompiled with CFR 0.152.
 */
package Space;

import Space.Ship;
import Space.Space;
import Space.Weapon;
import com.siemens.mp.color_game.GameCanvas;
import com.siemens.mp.color_game.Layer;
import com.siemens.mp.color_game.LayerManager;
import com.siemens.mp.color_game.Sprite;
import com.siemens.mp.game.Vibrator;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class SpaceCanvas
extends GameCanvas {
    Ship[] ship = new Ship[2];
    Weapon[][] weapon = new Weapon[2][2];
    private Timer timer;
    private Space space;
    private Display display;
    private CommandListener listener;
    public int width;
    public int height;
    public int fh;
    private Font font;
    private MyTimerTask myTimerTask;
    public final int maxcam;
    public final int mincam;
    public int cam;
    private LayerManager layMan;
    private int spaceColor = 0xFFFFFF;
    private int starColor = 0;
    private int frame_counter = 0;
    private int fps = 0;
    private long old_time = 0L;
    private long old_time2 = 0L;
    final int STAR_NUMBER;
    private int[][] star_pos = new int[15][2];
    private int[] star_dist = new int[15];
    private Sprite[] star = new Sprite[15];
    private boolean stars_inited = false;
    private boolean initialized = false;
    public Random random;
    private Sprite bg;
    private boolean bg_visible = true;
    private Image bg_im;
    private int[] bg_pos = new int[2];
    private Image logo;
    public Image explode_im;
    public Image[] explode_im32 = new Image[16];
    private boolean death_vibrator_triggered = false;
    private String ship_file0 = "";
    private String ship_file1 = "";
    private boolean ship0_reload = true;
    private boolean ship1_reload = true;
    private int info_time = 0;
    private long time;
    private int rect_around_ship_counter = 3;

    private void init_entities() {
        if (!this.initialized) {
            try {
                this.info_time = 15;
                this.out_text("Loading...");
                this.out_text("Load: explode.png");
                this.explode_im = Image.createImage((String)"/Space/explode.png");
                this.out_text("Load: explode32.png");
                for (int e = 6; e <= 15; ++e) {
                    this.explode_im32[e] = Image.createImage((String)String.valueOf(String.valueOf(new StringBuffer("/Space/explode32_").append(e).append(".png"))));
                }
                this.out_text("Load: background");
                int bcknum = Math.abs(this.random.nextInt()) % 3;
                this.bg_im = Image.createImage((String)String.valueOf(String.valueOf(new StringBuffer("/Space/bck").append(bcknum).append(".png"))));
                this.bg = new Sprite(this.bg_im, 101, 80);
                this.bg_pos[0] = 0;
                this.bg_pos[1] = 0;
            }
            catch (Exception bcknum) {
                // empty catch block
            }
            this.layMan = new LayerManager();
            if (this.ship0_reload) {
                this.ship[0] = new Ship();
            }
            if (this.ship1_reload) {
                this.ship[1] = new Ship();
            }
            int x = this.random.nextInt() % this.getWidth() * 500 / 2;
            int y = this.random.nextInt() % this.getHeight() * 500 / 2;
            if (this.ship0_reload) {
                this.weapon[0] = this.ship[0].init(this.ship_file0, this, x, y, this.layMan, this.ship[1], false);
            }
            if (this.ship1_reload) {
                this.weapon[1] = this.ship[1].init(this.ship_file1, this, -x, -y, this.layMan, this.ship[0], true);
            }
            this.init_stars();
            this.initialized = true;
            this.layMan.append((Layer)this.bg);
        }
    }

    public int get_scr_pos(int pos) {
        return pos / this.cam;
    }

    public SpaceCanvas(Space space) {
        super(false);
        this.maxcam = 500;
        this.mincam = 100;
        this.STAR_NUMBER = 15;
        this.random = new Random(System.currentTimeMillis());
        this.height = this.getHeight();
        this.width = this.getWidth();
        this.font = Font.getDefaultFont();
        this.fh = this.font.getHeight();
        this.space = space;
        this.display = Display.getDisplay((MIDlet)space);
        this.initColors();
    }

    private void init_stars() {
        int e;
        com.siemens.mp.ui.Image.mirrorImageHorizontally((Image)this.bg_im);
        com.siemens.mp.ui.Image.mirrorImageVertically((Image)this.bg_im);
        this.bg.setImage(this.bg_im, 101, 80);
        for (e = 0; e < 15; ++e) {
            this.star_pos[e][0] = this.random.nextInt() % (this.width * 50 * 500 / 100);
            this.star_pos[e][1] = this.random.nextInt() % (this.height * 50 * 500 / 100);
            this.star_dist[e] = this.random.nextInt() % 10 + 12;
        }
        if (this.bg_visible) {
            this.bg_pos[0] = this.bg_pos[0] * -1;
            this.bg_pos[1] = this.bg_pos[1] * -1;
        } else {
            this.bg_pos[0] = 0;
            this.bg_pos[1] = 0;
        }
        boolean bl = this.bg_visible = this.random.nextInt() % 50 + 50 < 30;
        if (!this.stars_inited) {
            this.bg_visible = true;
            this.stars_inited = true;
            byte[] buf0 = new byte[]{-1};
            byte[] buf1 = new byte[]{-64, 3, -64, 3, -1, 3, -64, 3, -64};
            this.star_dist[0] = 1;
            for (e = 0; e < 15; ++e) {
                try {
                    this.star[e] = this.star_dist[e] > 15 ? new Sprite(com.siemens.mp.ui.Image.createRGBImage((byte[])buf1, (int)3, (int)3, (int)5), 3, 3) : new Sprite(com.siemens.mp.ui.Image.createRGBImage((byte[])buf0, (int)1, (int)1, (int)5), 1, 1);
                    this.layMan.append((Layer)this.star[e]);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.bg.setVisible(this.bg_visible);
    }

    public void init(String ship_file0, boolean re0, String ship_file1, boolean re1) {
        this.ship_file0 = ship_file0;
        this.ship_file1 = ship_file1;
        this.ship0_reload = re0;
        this.ship1_reload = re1;
        this.cam = 500;
        this.timer = new Timer();
        this.myTimerTask = new MyTimerTask();
        this.timer.schedule((TimerTask)this.myTimerTask, 0L, 100L);
    }

    public void the_end() {
        this.myTimerTask.cancel();
        this.timer.cancel();
    }

    private void initColors() {
        block1: {
            int numColors;
            block0: {
                boolean isColor = this.display.isColor();
                numColors = this.display.numColors();
                if (!isColor) break block0;
                if (numColors <= 2) break block1;
                this.spaceColor = 0;
                this.starColor = 0xFFFFFF;
                break block1;
            }
            if (numColors <= 2) break block1;
            this.spaceColor = 0;
            this.starColor = 0xFFFFFF;
        }
    }

    private void setColors(int w, int g, int pa, int s, int pu) {
    }

    protected void keyRepeated(int keyCode) {
        int action = this.getGameAction(keyCode);
        switch (action) {
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                this.keyPressed(keyCode);
                break;
            }
        }
    }

    private void draw_rect_around_ship(Graphics g, int shi, int size) {
        int _x = this.get_scr_pos(this.ship[shi].posX) + this.width / 2;
        int _y = this.get_scr_pos(this.ship[shi].posY) + this.height / 2;
        int x0 = _x - size;
        int y0 = _y - size;
        int x1 = 2 * size;
        int y1 = 2 * size;
        g.drawRect(x0, y0, x1, y1);
    }

    public void paint() {
        Graphics g = this.getGraphics();
        g.setColor(this.spaceColor);
        g.fillRect(0, 0, this.width, this.height);
        this.ship[0].draw(g);
        this.ship[1].draw(g);
        this.weapon[0][0].draw(g);
        this.weapon[0][1].draw(g);
        this.weapon[1][0].draw(g);
        this.weapon[1][1].draw(g);
        for (int e = 0; e < 15; ++e) {
            int x = this.get_scr_pos(this.star_pos[e][0]);
            int y = this.get_scr_pos(this.star_pos[e][1]);
            this.star[e].setPosition(x + this.width / 2, y + this.height / 2);
        }
        this.bg.setPosition(this.bg_pos[0] / 100, this.bg_pos[1] / 100);
        this.layMan.paint(g, 0, 0);
        if (this.info_time > 0) {
            for (int shi = 0; shi < 2; ++shi) {
                if (shi == 0) {
                    g.setColor(255, 255, 255);
                } else {
                    g.setColor(255, 0, 0);
                }
                this.draw_rect_around_ship(g, shi, 5 * this.info_time);
            }
        }
        ++this.frame_counter;
        Date date = new Date();
        this.time = date.getTime();
        if (this.time - this.old_time > (long)1000) {
            this.old_time = this.time;
            this.fps = this.frame_counter;
            this.frame_counter = 0;
            g.setColor(255, 255, 255);
            g.drawString(String.valueOf(this.fps), 0, 0, 20);
            if (this.cam > 300) {
                --this.rect_around_ship_counter;
                if (this.rect_around_ship_counter == 0) {
                    this.draw_rect_around_ship(g, 0, 5);
                    this.rect_around_ship_counter = 3;
                }
            }
        }
        this.flushGraphics();
    }

    public byte[][] loadBMP(String filename, int shape_width, int shape_height) {
        this.out_text("Load: ".concat(String.valueOf(String.valueOf(filename))));
        InputStream is = null;
        byte[][] shape = new byte[shape_width][shape_height];
        try {
            is = ((Object)((Object)this)).getClass().getResourceAsStream(filename);
            if (is == null) {
                IOException exe = new IOException("hehe");
                throw exe;
            }
            is.skip(54L);
            int shape_width4 = (shape_width * 3 + 4) / 4 * 4 - shape_width * 3;
            for (int e = 0; e < shape_height; ++e) {
                for (int f = 0; f < shape_width; ++f) {
                    int blue = is.read();
                    int green = is.read();
                    int red = is.read();
                    shape[f][e] = (byte)(red / 32 * 32 + green / 32 * 4 + blue / 64);
                }
                for (int r = 0; r < shape_width4; ++r) {
                    is.read();
                }
            }
            is.close();
        }
        catch (IOException ex) {
            try {
                is.close();
            }
            catch (IOException r) {
                // empty catch block
            }
        }
        return shape;
    }

    public static int get_sin(int dir) {
        switch (dir) {
            case 0: {
                return 0;
            }
            case 1: {
                return 500;
            }
            case 2: {
                return 866;
            }
            case 3: {
                return 1000;
            }
            case 4: {
                return 866;
            }
            case 5: {
                return 500;
            }
            case 6: {
                return 0;
            }
            case 7: {
                return -500;
            }
            case 8: {
                return -866;
            }
            case 9: {
                return -1000;
            }
            case 10: {
                return -866;
            }
            case 11: {
                return -500;
            }
        }
        return 1;
    }

    public static int get_cos(int dir) {
        switch (dir) {
            case 0: {
                return 1000;
            }
            case 1: {
                return 866;
            }
            case 2: {
                return 500;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return -500;
            }
            case 5: {
                return -866;
            }
            case 6: {
                return -1000;
            }
            case 7: {
                return -866;
            }
            case 8: {
                return -500;
            }
            case 9: {
                return 0;
            }
            case 10: {
                return 500;
            }
            case 11: {
                return 866;
            }
        }
        return 1;
    }

    public Image[][] rotate_shapes(int NUM_SHAPE_SIZES, int[] shape_size, int shape_width, byte[][] shape) {
        Image[][] iShape = new Image[NUM_SHAPE_SIZES][12];
        for (int size = 0; size < NUM_SHAPE_SIZES; ++size) {
            int e;
            byte[] temp_shape_buffer = new byte[shape_size[size] * shape_size[size]];
            byte[] temp_shape_buffer2 = new byte[shape_size[size] * shape_size[size]];
            byte[] temp_shape_buffer3 = new byte[shape_size[size] * shape_size[size]];
            byte[] temp_shape_buffer4 = new byte[shape_size[size] * shape_size[size]];
            int[] resized = new int[shape_size[size]];
            for (e = 0; e < shape_size[size]; ++e) {
                resized[e] = (shape_width * 100 * e / shape_size[size] + 50) / 100;
            }
            for (int rotate = 0; rotate < 3; ++rotate) {
                int sin = SpaceCanvas.get_sin(rotate);
                int cos = SpaceCanvas.get_cos(rotate);
                for (e = 0; e < shape_size[size]; ++e) {
                    for (int f = 0; f < shape_size[size]; ++f) {
                        int e_rotated = ((resized[e] - shape_width / 2) * cos + (resized[f] - shape_width / 2) * sin) / 1000 + shape_width / 2;
                        int f_rotated = ((resized[e] - shape_width / 2) * sin - (resized[f] - shape_width / 2) * cos) / 1000 + shape_width / 2;
                        int col = e_rotated >= 0 && e_rotated < shape_width && f_rotated >= 0 && f_rotated < shape_width ? shape[e_rotated][f_rotated] : -64;
                        temp_shape_buffer[f * shape_size[size] + e] = col;
                        temp_shape_buffer2[e * shape_size[size] + shape_size[size] - 1 - f] = col;
                        temp_shape_buffer3[(shape_size[size] - 1 - f) * shape_size[size] + (shape_size[size] - 1 - e)] = col;
                        temp_shape_buffer4[(shape_size[size] - 1 - e) * shape_size[size] + f] = col;
                    }
                }
                try {
                    iShape[size][rotate] = com.siemens.mp.ui.Image.createRGBImage((byte[])temp_shape_buffer, (int)shape_size[size], (int)shape_size[size], (int)5);
                    iShape[size][rotate + 3] = com.siemens.mp.ui.Image.createRGBImage((byte[])temp_shape_buffer2, (int)shape_size[size], (int)shape_size[size], (int)5);
                    iShape[size][rotate + 6] = com.siemens.mp.ui.Image.createRGBImage((byte[])temp_shape_buffer3, (int)shape_size[size], (int)shape_size[size], (int)5);
                    iShape[size][rotate + 9] = com.siemens.mp.ui.Image.createRGBImage((byte[])temp_shape_buffer4, (int)shape_size[size], (int)shape_size[size], (int)5);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return iShape;
    }

    public static String readS(InputStream is) {
        byte[] buf = new byte[12];
        char[] bufc = new char[12];
        try {
            is.skip(18L);
            is.read(buf, 0, 12);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int e = 0; e < 12; ++e) {
            bufc[e] = (char)buf[e];
        }
        return String.valueOf(bufc).trim();
    }

    public static int read11(InputStream is) {
        return Integer.parseInt(SpaceCanvas.readS(is));
    }

    public void out_text(String text) {
        Graphics g = this.getGraphics();
        if (this.logo == null) {
            g.setColor(0, 0, 0);
            g.fillRect(0, 0, this.width, this.height);
        } else {
            g.drawImage(this.logo, 0, 0, 20);
        }
        g.setColor(255, 255, 255);
        g.drawString(text, 50, 80, 33);
        this.flushGraphics();
    }

    public void reinit() {
        int x = this.random.nextInt() % this.getWidth() * 500 / 2;
        int y = this.random.nextInt() % this.getHeight() * 500 / 2;
        this.ship[0].reinit(x, y);
        this.ship[1].reinit(-x, -y);
    }

    private void killed_cleanup() {
        int e;
        this.timer.cancel();
        this.space.show_select_canvas();
        this.initialized = false;
        this.stars_inited = false;
        this.bg = null;
        this.bg_im = null;
        this.explode_im = null;
        for (e = 0; e < this.explode_im32.length; ++e) {
            this.explode_im32[e] = null;
        }
        this.layMan = null;
        this.myTimerTask = null;
        this.ship[0] = null;
        this.ship[1] = null;
        for (e = 0; e < this.star.length; ++e) {
            this.star[e] = null;
        }
        this.timer = null;
        for (e = 0; e < 2; ++e) {
            for (int f = 0; f < 2; ++f) {
                this.weapon[e][f] = null;
            }
        }
    }

    private class MyTimerTask
    extends TimerTask {
        private void equalize_poss() {
            int translateX = (SpaceCanvas.this.ship[0].posX + SpaceCanvas.this.ship[1].posX) / 2;
            SpaceCanvas.this.ship[0].posX -= translateX;
            SpaceCanvas.this.ship[1].posX -= translateX;
            int translateY = (SpaceCanvas.this.ship[0].posY + SpaceCanvas.this.ship[1].posY) / 2;
            SpaceCanvas.this.ship[0].posY -= translateY;
            SpaceCanvas.this.ship[1].posY -= translateY;
            int[] nArray = SpaceCanvas.this.bg_pos;
            nArray[0] = nArray[0] - translateX / 10;
            int[] nArray2 = SpaceCanvas.this.bg_pos;
            nArray2[1] = nArray2[1] - translateY / 10;
            SpaceCanvas.this.weapon[0][0].translate(translateX, translateY);
            SpaceCanvas.this.weapon[0][1].translate(translateX, translateY);
            SpaceCanvas.this.weapon[1][0].translate(translateX, translateY);
            SpaceCanvas.this.weapon[1][1].translate(translateX, translateY);
            int wm2 = SpaceCanvas.this.width * 500 / 2;
            int hm2 = SpaceCanvas.this.height * 500 / 2;
            for (int e = 0; e < 15; ++e) {
                ((SpaceCanvas)SpaceCanvas.this).star_pos[e][0] = (SpaceCanvas.this.star_pos[e][0] + -translateX * SpaceCanvas.this.star_dist[e] / 10 + 3 * wm2) % (2 * wm2) - wm2;
                ((SpaceCanvas)SpaceCanvas.this).star_pos[e][1] = (SpaceCanvas.this.star_pos[e][1] + -translateY * SpaceCanvas.this.star_dist[e] / 10 + 3 * hm2) % (2 * hm2) - hm2;
            }
        }

        private void check_collisions() {
            if (SpaceCanvas.this.ship[0].sprite.collidesWith(SpaceCanvas.this.ship[1].sprite, false)) {
                int spdX0 = SpaceCanvas.this.ship[0].spdX;
                int spdY0 = SpaceCanvas.this.ship[0].spdY;
                SpaceCanvas.this.ship[0].spdX = SpaceCanvas.this.ship[1].spdX;
                SpaceCanvas.this.ship[0].spdY = SpaceCanvas.this.ship[1].spdY;
                SpaceCanvas.this.ship[1].spdX = spdX0;
                SpaceCanvas.this.ship[1].spdY = spdY0;
                SpaceCanvas.this.ship[0].posX = SpaceCanvas.this.ship[0].posX * 12 / 10;
                SpaceCanvas.this.ship[0].posY = SpaceCanvas.this.ship[0].posY * 12 / 10;
                SpaceCanvas.this.ship[1].posX = SpaceCanvas.this.ship[1].posX * 12 / 10;
                SpaceCanvas.this.ship[1].posY = SpaceCanvas.this.ship[1].posY * 12 / 10;
                Vibrator.triggerVibrator((int)100);
                SpaceCanvas.this.ship[0].hit(300);
                SpaceCanvas.this.ship[1].hit(300);
            }
            for (int now_ship = 0; now_ship <= 1; ++now_ship) {
                for (int which = 0; which <= 1; ++which) {
                    for (int e = 0; e < SpaceCanvas.this.weapon[now_ship][which].MAX_WEAPONS; ++e) {
                        if (SpaceCanvas.this.weapon[now_ship][which].life_time[e] <= 0 || !SpaceCanvas.this.weapon[now_ship][which].sprite[e].collidesWith(SpaceCanvas.this.ship[(now_ship + 1) % 2].sprite, false)) continue;
                        SpaceCanvas.this.weapon[now_ship][which].exploded(e);
                        SpaceCanvas.this.ship[(now_ship + 1) % 2].hit(SpaceCanvas.this.weapon[now_ship][which].damage);
                        if (now_ship != 1) continue;
                        Vibrator.triggerVibrator((int)30);
                    }
                }
            }
        }

        private void check_ship_out_of_screen() {
            if (Math.abs(SpaceCanvas.this.ship[0].posX) > SpaceCanvas.this.width * 500 / 2) {
                SpaceCanvas.this.ship[0].posX *= -1;
                SpaceCanvas.this.ship[1].posX *= -1;
                SpaceCanvas.this.weapon[0][0].translate(2 * SpaceCanvas.this.ship[0].posX, 0);
                SpaceCanvas.this.weapon[0][1].translate(2 * SpaceCanvas.this.ship[0].posX, 0);
                SpaceCanvas.this.weapon[1][0].translate(2 * SpaceCanvas.this.ship[1].posX, 0);
                SpaceCanvas.this.weapon[1][1].translate(2 * SpaceCanvas.this.ship[1].posX, 0);
                SpaceCanvas.this.init_stars();
                SpaceCanvas.this.info_time = 10;
            }
            if (Math.abs(SpaceCanvas.this.ship[0].posY) > SpaceCanvas.this.height * 500 / 2) {
                SpaceCanvas.this.ship[0].posY *= -1;
                SpaceCanvas.this.ship[1].posY *= -1;
                SpaceCanvas.this.ship[0].ships_swapped();
                SpaceCanvas.this.ship[1].ships_swapped();
                SpaceCanvas.this.init_stars();
                SpaceCanvas.this.weapon[0][0].translate(0, 2 * SpaceCanvas.this.ship[0].posY);
                SpaceCanvas.this.weapon[0][1].translate(0, 2 * SpaceCanvas.this.ship[0].posY);
                SpaceCanvas.this.weapon[1][0].translate(0, 2 * SpaceCanvas.this.ship[1].posY);
                SpaceCanvas.this.weapon[1][1].translate(0, 2 * SpaceCanvas.this.ship[1].posY);
                SpaceCanvas.this.info_time = 10;
            }
        }

        private void set_cam() {
            int difX = Math.abs(SpaceCanvas.this.ship[0].posX - SpaceCanvas.this.ship[1].posX);
            int difY = Math.abs(SpaceCanvas.this.ship[0].posY - SpaceCanvas.this.ship[1].posY);
            int camX = 2 * difX / SpaceCanvas.this.width;
            int camY = 2 * difY / SpaceCanvas.this.height;
            int camNEW = Math.max(camX, camY);
            SpaceCanvas.this.cam = (SpaceCanvas.this.cam * 9 + camNEW) / 10;
        }

        public void run() {
            SpaceCanvas.this.init_entities();
            if (SpaceCanvas.this.info_time != 0) {
                this.set_cam();
                this.equalize_poss();
                if (SpaceCanvas.this.info_time > 0) {
                    --SpaceCanvas.this.info_time;
                }
            } else {
                int keys = SpaceCanvas.this.getKeyStates();
                SpaceCanvas.this.ship[0].keyStates(keys);
                if ((keys & 0x1000) > 0) {
                    SpaceCanvas.this.bg_visible = !SpaceCanvas.this.bg_visible;
                    SpaceCanvas.this.bg.setVisible(SpaceCanvas.this.bg_visible);
                }
                if ((keys & 0x800) > 0) {
                    try {
                        if (((SpaceCanvas)SpaceCanvas.this).space.playa.getState() == 400) {
                            ((SpaceCanvas)SpaceCanvas.this).space.playa.stop();
                        } else {
                            ((SpaceCanvas)SpaceCanvas.this).space.playa.start();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (SpaceCanvas.this.time - SpaceCanvas.this.old_time > (long)500) {
                    SpaceCanvas.this.ship[1].think();
                    SpaceCanvas.this.old_time2 = SpaceCanvas.this.time;
                }
                if (SpaceCanvas.this.ship[0].lives == -2 || SpaceCanvas.this.ship[1].lives == -2) {
                    Vibrator.triggerVibrator((int)1000);
                }
                if (!SpaceCanvas.this.ship[0].live() || !SpaceCanvas.this.ship[1].live()) {
                    SpaceCanvas.this.killed_cleanup();
                    return;
                }
                SpaceCanvas.this.weapon[0][0].live();
                SpaceCanvas.this.weapon[0][1].live();
                SpaceCanvas.this.weapon[1][0].live();
                SpaceCanvas.this.weapon[1][1].live();
                this.check_collisions();
                this.equalize_poss();
                this.set_cam();
                this.check_ship_out_of_screen();
            }
            SpaceCanvas.this.paint();
            if (SpaceCanvas.this.cam > 500) {
                SpaceCanvas.this.cam = 500;
            }
            if (SpaceCanvas.this.cam < 100) {
                SpaceCanvas.this.cam = 100;
            }
        }
    }
}

