/*
 * Decompiled with CFR 0.152.
 */
import com.bsg.siemens.BSCanvas;
import com.siemens.mp.game.Melody;
import com.siemens.mp.game.MelodyComposer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Vector;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ForgeFortuneCanvas
extends BSCanvas
implements Runnable {
    private Thread instance;
    private boolean running;
    private Image backBuffer;
    private Image statusBarImage;
    private Image nuggetImages;
    private Image[] digits;
    private Image playerImage;
    private Image scoreImage;
    private Image optionsImage;
    private Image linkImage;
    private Image linksImage;
    private Graphics backSurface;
    private Graphics statusBarSurface;
    private Nugget[][] grid;
    private int[] coinXOff;
    private int[] coinYOff;
    private int[] scores;
    private int coinWidth;
    private int coinHeight;
    private int screenHeight = this.getHeight() - this.statusBarHeight;
    private int halfScreenHeight = this.screenHeight / 2;
    private int screenWidth = this.getWidth();
    private int halfScreenWidth = this.screenWidth / 2;
    private int statusBarHeight = 7;
    private int gridWidth;
    private int gridHeight;
    private int gridCutOff;
    private int pXPos;
    private int pYPos;
    private int newRowAt;
    private int newRowCounter;
    private int chains;
    private int difficulty;
    private Vector selectedCoins;
    private Vector dropCoins;
    private Vector disapCoins;
    private boolean chain;
    private boolean gameover;
    private boolean updateScreen;
    private boolean updateScore;
    private boolean keyPressed;
    private Melody reaction;
    private Melody gameoverMelody;
    private Melody beepMed;
    private final int P_UP;
    private final int P_DOWN;
    private final int P_LEFT;
    private final int P_RIGHT;
    private Vector keysPressed;

    public ForgeFortuneCanvas() {
        int n;
        MelodyComposer melodyComposer;
        this.P_UP = 0;
        this.P_DOWN = 1;
        this.P_LEFT = 2;
        this.P_RIGHT = 3;
        this.scores = new int[6];
        this.scores[0] = 1;
        this.scores[1] = 5;
        this.scores[2] = 10;
        this.scores[3] = 50;
        this.scores[4] = 100;
        this.scores[5] = 500;
        try {
            melodyComposer = new MelodyComposer();
            melodyComposer.setBPM(120);
            melodyComposer.appendNote(24, 4);
            melodyComposer.appendNote(26, 4);
            melodyComposer.appendNote(28, 4);
            melodyComposer.appendNote(29, 4);
            melodyComposer.appendNote(31, 4);
            this.reaction = melodyComposer.getMelody();
            melodyComposer.resetMelody();
            melodyComposer.setBPM(120);
            melodyComposer.appendNote(31, 4);
            melodyComposer.appendNote(29, 4);
            melodyComposer.appendNote(28, 4);
            melodyComposer.appendNote(26, 4);
            melodyComposer.appendNote(24, 4);
            this.gameoverMelody = melodyComposer.getMelody();
            melodyComposer.resetMelody();
            melodyComposer.setBPM(120);
            melodyComposer.appendNote(24, 4);
            this.beepMed = melodyComposer.getMelody();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.nuggetImages = Image.createImage((String)"/NuggetImages.png");
            this.playerImage = Image.createImage((String)"/NuggetCollector.png");
            melodyComposer = com.siemens.mp.ui.Image.createImageWithoutScaling((String)"/Status.png");
            this.scoreImage = this.getImage((Image)melodyComposer, 21, 5, -30, 0);
            this.linkImage = this.getImage((Image)melodyComposer, 18, 5, -51, 0);
            this.linksImage = this.getImage((Image)melodyComposer, 22, 5, -69, 0);
            this.optionsImage = this.getImage((Image)melodyComposer, melodyComposer.getWidth() - 91, 7, -91, 0);
            this.digits = new Image[10];
            for (int i = 0; i < this.digits.length; ++i) {
                this.digits[i] = this.getImage((Image)melodyComposer, 3, 5, -3 * i, 0);
            }
            this.statusBarImage = Image.createImage((int)this.screenWidth, (int)this.statusBarHeight);
            this.statusBarSurface = this.statusBarImage.getGraphics();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.coinWidth = 14;
        this.coinHeight = 7;
        this.gridWidth = 7;
        this.gridHeight = 20;
        this.gridCutOff = this.screenHeight / this.coinHeight - 1;
        if (this.gridCutOff > 10) {
            this.gridCutOff = 10;
        }
        this.backBuffer = Image.createImage((int)this.screenWidth, (int)this.screenHeight);
        this.backSurface = this.backBuffer.getGraphics();
        this.backSurface.setColor(0xFFFFFF);
        this.coinXOff = new int[this.gridWidth + 1];
        for (n = 0; n < this.gridWidth + 1; ++n) {
            this.coinXOff[n] = this.coinWidth * n + 1;
        }
        this.coinYOff = new int[this.gridHeight];
        for (n = 0; n < this.gridHeight; ++n) {
            this.coinYOff[n] = this.screenHeight - this.coinHeight * n;
        }
        this.pXPos = this.gridWidth / 2;
        this.pYPos = this.coinYOff[this.gridCutOff];
    }

    public Image getImage(Image image, int n, int n2, int n3, int n4) {
        Image image2 = Image.createImage((int)n, (int)n2);
        Graphics graphics = image2.getGraphics();
        graphics.drawImage(image, n3, n4, 20);
        return image2;
    }

    public void startGame(int n, Gauge gauge) {
        this.difficulty = n;
        this.gameover = false;
        this.keyPressed = false;
        this.chain = false;
        this.chains = 0;
        this.score = 0;
        this.newRowAt = 250 - 50 * this.difficulty;
        this.newRowCounter = 0;
        this.pXPos = this.gridWidth / 2;
        this.pYPos = this.coinYOff[this.gridCutOff];
        gauge.setValue(20);
        this.selectedCoins = new Vector(10);
        gauge.setValue(30);
        this.dropCoins = new Vector(10);
        gauge.setValue(40);
        this.disapCoins = new Vector(10);
        gauge.setValue(50);
        this.grid = new Nugget[this.gridWidth][this.gridHeight];
        gauge.setValue(60);
        for (int i = 0; i < this.grid.length; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.grid[i][j] = new Nugget(BSCanvas.getRandom(6), i, j);
            }
        }
        gauge.setValue(90);
        this.updateScreen = true;
        this.updateScore = true;
        gauge.setValue(100);
        this.commandListener.commandAction(BSCanvas.DISPLAY_CANVAS, (Displayable)this);
    }

    public void nextLevel(Gauge gauge) {
    }

    public void loadGame(byte[] byArray, Gauge gauge) {
        try {
            int n;
            int n2;
            int n3;
            int n4;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            this.pXPos = dataInputStream.readByte();
            this.pYPos = dataInputStream.readByte();
            this.difficulty = dataInputStream.readByte();
            gauge.setValue(30);
            this.grid = new Nugget[this.gridWidth][this.gridHeight];
            for (n4 = 0; n4 < this.gridWidth; ++n4) {
                for (n3 = 0; n3 < this.gridHeight && (n2 = dataInputStream.readByte()) != -1; ++n3) {
                    this.grid[n4][n3] = new Nugget(n2, n4, n3);
                }
            }
            gauge.setValue(50);
            this.dropCoins = new Vector(10);
            n4 = dataInputStream.readByte();
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = dataInputStream.readByte();
                n = dataInputStream.readByte();
                this.grid[n2][n].dropping = true;
                this.dropCoins.addElement(this.grid[n2][n]);
            }
            gauge.setValue(60);
            this.disapCoins = new Vector(10);
            n3 = dataInputStream.readByte();
            for (n2 = 0; n2 < n3; ++n2) {
                n = dataInputStream.readByte();
                byte by = dataInputStream.readByte();
                this.grid[n][by].dissapearing = true;
                this.disapCoins.addElement(this.grid[n][by]);
            }
            gauge.setValue(70);
            this.selectedCoins = new Vector(10);
            n2 = dataInputStream.readByte();
            for (n = 0; n < n2; ++n) {
                this.selectedCoins.addElement(new Nugget(dataInputStream.readByte(), this.pXPos, this.pYPos));
            }
            gauge.setValue(80);
            this.newRowAt = dataInputStream.readInt();
            this.newRowCounter = dataInputStream.readInt();
            this.score = dataInputStream.readInt();
            this.gameover = false;
            this.keyPressed = false;
            this.chain = false;
            this.chains = 0;
            this.updateScreen = true;
            this.updateScore = true;
            gauge.setValue(90);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte[] saveGame(Gauge gauge) {
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeByte(this.pXPos);
            dataOutputStream.writeByte(this.pYPos);
            dataOutputStream.writeByte(this.difficulty);
            block2: for (n = 0; n < this.gridWidth; ++n) {
                for (int i = 0; i < this.gridHeight; ++i) {
                    if (this.grid[n][i] == null) {
                        dataOutputStream.writeByte(-1);
                        continue block2;
                    }
                    dataOutputStream.writeByte(this.grid[n][i].type);
                }
            }
            dataOutputStream.writeByte(this.dropCoins.size());
            for (n = 0; n < this.dropCoins.size(); ++n) {
                Nugget nugget = (Nugget)this.dropCoins.elementAt(n);
                dataOutputStream.writeByte((byte)nugget.xPos);
                dataOutputStream.writeByte((byte)nugget.yPos);
            }
            dataOutputStream.writeByte(this.disapCoins.size());
            for (n = 0; n < this.disapCoins.size(); ++n) {
                Nugget nugget = (Nugget)this.disapCoins.elementAt(n);
                dataOutputStream.writeByte((byte)nugget.xPos);
                dataOutputStream.writeByte((byte)nugget.yPos);
            }
            dataOutputStream.writeByte(this.selectedCoins.size());
            for (n = 0; n < this.selectedCoins.size(); ++n) {
                Nugget nugget = (Nugget)this.selectedCoins.elementAt(n);
                dataOutputStream.writeByte((byte)nugget.type);
            }
            dataOutputStream.writeInt(this.newRowAt);
            dataOutputStream.writeInt(this.newRowCounter);
            dataOutputStream.writeInt(this.score);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception exception) {
            byte[] byArray = null;
            return byArray;
        }
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        if (this.updateScreen) {
            this.backSurface.setClip(0, 0, this.screenWidth, this.screenHeight);
            this.backSurface.fillRect(0, 0, this.screenWidth, this.screenHeight);
            for (n2 = 0; n2 < this.gridWidth; ++n2) {
                for (n = 0; n < this.gridCutOff + 1; ++n) {
                    if (this.grid[n2][n] == null || this.grid[n2][n].dropping || this.grid[n2][n].dissapearing) continue;
                    this.drawNugget(this.backSurface, this.coinXOff[n2], this.coinYOff[n] - this.coinHeight, this.grid[n2][n].type);
                }
            }
            this.updateScreen = false;
        }
        if (this.updateScore) {
            this.statusBarSurface.setColor(0xFFFFFF);
            this.statusBarSurface.fillRect(0, 0, this.screenWidth, this.statusBarHeight);
            this.statusBarSurface.drawImage(this.optionsImage, this.screenWidth - this.optionsImage.getWidth(), 0, 20);
            if (this.chains > 0) {
                this.statusBarSurface.drawImage(this.digits[this.chains % 10], 0, 1, 20);
                if (this.chains == 1) {
                    this.statusBarSurface.drawImage(this.linkImage, 4, 1, 20);
                } else {
                    this.statusBarSurface.drawImage(this.linksImage, 4, 1, 20);
                }
            } else {
                this.statusBarSurface.drawImage(this.scoreImage, 0, 1, 20);
                n2 = 10;
                n = this.scoreImage.getWidth() + 1;
                while (this.score >= (n2 *= 10) / 10) {
                }
                n2 /= 10;
                while (n2 >= 10) {
                    this.statusBarSurface.drawImage(this.digits[this.score % n2 / (n2 / 10)], n, 1, 20);
                    n2 /= 10;
                    n += 4;
                }
            }
            this.updateScore = false;
        }
        graphics.drawImage(this.backBuffer, 0, 0, 20);
        graphics.setColor(0);
        graphics.drawRect(0, this.coinYOff[this.gridCutOff], this.coinXOff[this.gridWidth] + 1, this.gridCutOff * this.coinHeight - 1);
        graphics.drawImage(this.playerImage, this.coinXOff[this.pXPos] - 4, this.pYPos, 36);
        if (this.selectedCoins.size() != 0) {
            this.drawNugget(graphics, this.coinXOff[this.pXPos], this.pYPos - this.coinHeight, ((Nugget)this.selectedCoins.elementAt((int)0)).type);
        }
        for (n2 = 0; n2 < this.dropCoins.size(); ++n2) {
            Nugget nugget = (Nugget)this.dropCoins.elementAt(n2);
            this.drawNugget(graphics, this.coinXOff[nugget.xPos], this.coinYOff[nugget.yPos] - this.coinHeight, nugget.type);
        }
        for (n2 = 0; n2 < this.disapCoins.size(); ++n2) {
            Nugget nugget = (Nugget)this.disapCoins.elementAt(n2);
            if ((nugget.animFrame & 1) != 1) continue;
            this.drawNugget(graphics, this.coinXOff[nugget.xPos], this.coinYOff[nugget.yPos] - this.coinHeight, nugget.type);
        }
        graphics.setClip(0, 0, this.screenWidth, this.screenHeight + this.statusBarHeight);
        if (this.gameover) {
            this.drawText(graphics, this.parseString(this.langT[0]), this.getFont(this.langA[0]), true, this.halfScreenWidth, this.halfScreenHeight);
        }
        if (this.paused) {
            this.drawText(graphics, this.parseString(this.langT[1]), this.getFont(this.langA[1]), true, this.halfScreenWidth, this.halfScreenHeight);
        }
        graphics.drawImage(this.statusBarImage, 0, this.screenHeight, 20);
    }

    public void start() {
        if (this.instance == null || !this.running && !this.paused && !this.instance.isAlive()) {
            this.instance = new Thread(this);
            this.running = true;
            this.instance.start();
        } else if (this.instance.isAlive()) {
            this.running = true;
        }
    }

    public void pause() {
        this.running = false;
        this.keyPressed = false;
    }

    public void destroy() {
        this.running = false;
        this.instance = null;
    }

    public void hideNotify() {
        this.pause();
    }

    public void showNotify() {
        this.start();
        this.keysPressed = new Vector();
    }

    public void run() {
        while (this.running) {
            if (!this.gameover && this.keyPressed) {
                if (this.keysPressed.size() > 0) {
                    int n = (Integer)this.keysPressed.elementAt(0);
                    this.keysPressed.removeElementAt(0);
                    switch (n) {
                        case 0: {
                            this.up();
                            break;
                        }
                        case 1: {
                            this.down();
                            break;
                        }
                        case 2: {
                            if (this.pXPos <= 0) break;
                            --this.pXPos;
                            break;
                        }
                        case 3: {
                            if (this.pXPos >= this.gridWidth - 1) break;
                            ++this.pXPos;
                        }
                    }
                }
                if (this.dropCoins.size() > 0) {
                    this.dropCoins();
                }
                if (this.disapCoins.size() > 0) {
                    this.animateCoins();
                }
                ++this.newRowCounter;
                if (this.newRowCounter == this.newRowAt) {
                    this.newRowCounter = 0;
                    if (this.newRowAt > 0) {
                        --this.newRowAt;
                    }
                    this.newRow();
                }
            } else if (this.gameover) {
                BSCanvas.playSound(this.gameoverMelody);
                BSCanvas.vibrate(50, 400);
                this.repaint();
                try {
                    Thread.sleep(2500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.commandListener.commandAction(BSCanvas.GAME_ENDED, (Displayable)this);
            }
            this.repaint();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void checkGameOver() {
        for (int i = 0; i < this.gridWidth; ++i) {
            if (this.grid[i][this.gridCutOff] == null) continue;
            this.gameover = true;
        }
    }

    private void newRow() {
        BSCanvas.playSound(this.beepMed);
        BSCanvas.vibrate(0, 200);
        for (int i = 0; i < this.gridWidth; ++i) {
            for (int j = this.gridHeight - 1; j >= 0; --j) {
                if (j == 0) {
                    this.grid[i][j] = new Nugget(BSCanvas.getRandom(6), i, j);
                    continue;
                }
                this.grid[i][j] = this.grid[i][j - 1];
                if (this.grid[i][j] == null) continue;
                this.grid[i][j].yPos = j;
            }
        }
        this.updateScreen = true;
        this.updateScore = true;
        if (this.dropCoins.size() == 0 && this.disapCoins.size() == 0) {
            this.checkGameOver();
        }
    }

    private void dropCoins() {
        for (int i = 0; i < this.dropCoins.size(); ++i) {
            Nugget nugget = (Nugget)this.dropCoins.elementAt(i);
            if (nugget.yPos == 0 || this.grid[nugget.xPos][nugget.yPos - 1] != null) {
                this.dropCoins.removeElementAt(i);
                this.grid[nugget.xPos][nugget.yPos].dropping = false;
                this.drawNugget(this.backSurface, this.coinXOff[nugget.xPos], this.coinYOff[nugget.yPos] - this.coinHeight, this.grid[nugget.xPos][nugget.yPos].type);
                Vector vector = new Vector(10);
                this.recurseCheck(vector, nugget.type, nugget.xPos, nugget.yPos);
                this.checkEnoughCoins(vector);
                --i;
                continue;
            }
            --nugget.yPos;
            this.grid[nugget.xPos][nugget.yPos] = nugget;
            this.grid[nugget.xPos][nugget.yPos + 1] = null;
        }
        if (this.dropCoins.size() == 0 && this.disapCoins.size() == 0) {
            this.chain = false;
            this.chains = 0;
            this.updateScore = true;
            this.checkGameOver();
        }
    }

    private void removeCoins(Vector vector) {
        if (this.chain) {
            ++this.chains;
        } else {
            this.chain = true;
        }
        BSCanvas.playSound(this.reaction);
        for (int i = 0; i < vector.size(); ++i) {
            Nugget nugget = (Nugget)vector.elementAt(i);
            this.score += (this.chains + 1) * (this.scores[nugget.type] * (this.difficulty + 1));
            if (this.grid[nugget.xPos][nugget.yPos].dropping) {
                this.dropCoins.removeElement(this.grid[nugget.xPos][nugget.yPos]);
                this.grid[nugget.xPos][nugget.yPos].dropping = false;
            }
            this.grid[nugget.xPos][nugget.yPos].dissapearing = true;
            this.blankCoin(nugget.xPos, nugget.yPos);
            this.disapCoins.addElement(nugget);
        }
        this.updateScore = true;
    }

    private void animateCoins() {
        Vector<Nugget> vector = new Vector<Nugget>(10);
        for (int i = 0; i < this.disapCoins.size(); ++i) {
            Nugget nugget = (Nugget)this.disapCoins.elementAt(i);
            ++nugget.animFrame;
            if (nugget.animFrame < 10) continue;
            vector.addElement(nugget);
            this.disapCoins.removeElement(nugget);
            --i;
        }
        if (vector.size() > 0) {
            this.replaceCoins(vector);
        }
    }

    private void replaceCoins(Vector vector) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            Nugget nugget = (Nugget)vector.elementAt(i);
            this.grid[nugget.xPos][nugget.yPos] = null;
            if (nugget.yPos <= n2 && (n2 != 0 || nugget.yPos != 0) && (nugget.yPos != n2 || nugget.xPos <= n)) continue;
            n = nugget.xPos;
            n2 = nugget.yPos;
        }
        n3 = ((Nugget)vector.elementAt((int)0)).type;
        vector.removeAllElements();
        if (n3 != 5) {
            this.grid[n][n2] = new Nugget(n3 + 1, n, n2);
            this.grid[n][n2].dropping = true;
            this.dropCoins.addElement(this.grid[n][n2]);
        }
        this.checkDrop();
        if (this.dropCoins.size() == 0 && this.disapCoins.size() == 0) {
            this.chain = false;
            this.chains = 0;
            this.updateScore = true;
        }
    }

    private void recurseCheck(Vector vector, int n, int n2, int n3) {
        if (!(vector.contains(this.grid[n2][n3]) || this.grid[n2][n3].type != n || this.grid[n2][n3].dissapearing || this.grid[n2][n3].dropping && (!this.grid[n2][n3].dropping || n3 != 0 && this.grid[n2][n3 - 1] == null))) {
            vector.addElement(this.grid[n2][n3]);
            if (n2 - 1 >= 0 && this.grid[n2 - 1][n3] != null) {
                this.recurseCheck(vector, n, n2 - 1, n3);
            }
            if (n3 + 1 < this.grid[n2].length && this.grid[n2][n3 + 1] != null) {
                this.recurseCheck(vector, n, n2, n3 + 1);
            }
            if (n2 + 1 < this.grid.length && this.grid[n2 + 1][n3] != null) {
                this.recurseCheck(vector, n, n2 + 1, n3);
            }
            if (n3 - 1 >= 0 && this.grid[n2][n3 - 1] != null) {
                this.recurseCheck(vector, n, n2, n3 - 1);
            }
        }
    }

    private void checkEnoughCoins(Vector vector) {
        switch (((Nugget)vector.elementAt((int)0)).type) {
            case 0: {
                if (vector.size() < 5) break;
                this.removeCoins(vector);
                break;
            }
            case 1: {
                if (vector.size() < 2) break;
                this.removeCoins(vector);
                break;
            }
            case 2: {
                if (vector.size() < 5) break;
                this.removeCoins(vector);
                break;
            }
            case 3: {
                if (vector.size() < 2) break;
                this.removeCoins(vector);
                break;
            }
            case 4: {
                if (vector.size() < 5) break;
                this.removeCoins(vector);
                break;
            }
            case 5: {
                if (vector.size() < 2) break;
                this.removeCoins(vector);
            }
        }
    }

    private void checkDrop() {
        for (int i = 0; i < this.grid.length; ++i) {
            for (int j = 1; j < this.grid[0].length; ++j) {
                if (this.grid[i][j - 1] != null && !this.grid[i][j - 1].dropping || this.grid[i][j] == null || this.dropCoins.contains(this.grid[i][j]) || this.grid[i][j].dissapearing) continue;
                this.grid[i][j].dropping = true;
                this.dropCoins.addElement(this.grid[i][j]);
                this.blankCoin(i, j);
            }
        }
        if (this.chain && this.dropCoins.size() == 0 && this.disapCoins.size() == 0) {
            this.chain = false;
            this.chains = 0;
        }
    }

    private void up() {
        for (int i = this.grid[this.pXPos].length - 1; i >= 0; --i) {
            if (this.grid[this.pXPos][i] == null) continue;
            if (!(this.grid[this.pXPos][i].dissapearing || this.grid[this.pXPos][i].dropping || this.selectedCoins.size() != 0 && ((Nugget)this.selectedCoins.elementAt((int)0)).type != this.grid[this.pXPos][i].type)) {
                this.selectedCoins.addElement(this.grid[this.pXPos][i]);
                this.grid[this.pXPos][i] = null;
                this.blankCoin(this.pXPos, i);
                continue;
            }
            i = 0;
        }
    }

    private void down() {
        if (this.selectedCoins.size() != 0) {
            for (int i = this.grid[this.pXPos].length - 1; i >= 0; --i) {
                int n;
                if (i != 0 && this.grid[this.pXPos][i - 1] == null) continue;
                for (n = 0; n < this.selectedCoins.size(); ++n) {
                    this.grid[this.pXPos][i + n] = (Nugget)this.selectedCoins.elementAt(n);
                    this.grid[this.pXPos][i + n].xPos = this.pXPos;
                    this.grid[this.pXPos][i + n].yPos = i + n;
                    if (i != 0 && this.grid[this.pXPos][i - 1].dropping) {
                        this.grid[this.pXPos][i + n].dropping = true;
                        this.dropCoins.addElement(this.grid[this.pXPos][i + n]);
                        continue;
                    }
                    this.drawNugget(this.backSurface, this.coinXOff[this.pXPos], this.coinYOff[i + n] - this.coinHeight, this.grid[this.pXPos][i + n].type);
                }
                this.selectedCoins.removeAllElements();
                this.checkDrop();
                if (!this.grid[this.pXPos][i + n - 1].dropping) {
                    Vector vector = new Vector(10);
                    this.recurseCheck(vector, this.grid[this.pXPos][i + n - 1].type, this.pXPos, i + n - 1);
                    this.checkEnoughCoins(vector);
                }
                i = 0;
            }
            BSCanvas.playSound(this.beepMed);
            if (this.dropCoins.size() == 0 && this.disapCoins.size() == 0) {
                this.checkGameOver();
            }
        }
    }

    public void keyPressed(int n) {
        this.keyPressed = true;
        if (!this.gameover) {
            int n2 = this.getGameAction(n);
            if (n == -4) {
                this.commandListener.commandAction(BSCanvas.DISPLAY_MENU, (Displayable)this);
            } else if (!this.paused) {
                block0 : switch (n2) {
                    case 1: {
                        this.keysPressed.addElement(new Integer(0));
                        break;
                    }
                    case 6: {
                        this.keysPressed.addElement(new Integer(1));
                        break;
                    }
                    case 2: {
                        this.keysPressed.addElement(new Integer(2));
                        break;
                    }
                    case 5: {
                        this.keysPressed.addElement(new Integer(3));
                        break;
                    }
                    default: {
                        switch (n) {
                            case 50: {
                                this.keysPressed.addElement(new Integer(0));
                                break block0;
                            }
                            case 56: {
                                this.keysPressed.addElement(new Integer(1));
                                break block0;
                            }
                            case 52: {
                                this.keysPressed.addElement(new Integer(2));
                                break block0;
                            }
                            case 54: {
                                this.keysPressed.addElement(new Integer(3));
                            }
                        }
                    }
                }
            }
        }
    }

    public void blankCoin(int n, int n2) {
        this.backSurface.setClip(0, 0, this.screenWidth, this.screenHeight);
        this.backSurface.clipRect(this.coinXOff[n], this.coinYOff[n2 + 1], this.coinWidth, this.coinHeight);
        this.backSurface.fillRect(this.coinXOff[n], this.coinYOff[n2 + 1], this.coinWidth, this.coinHeight);
    }

    public void drawNugget(Graphics graphics, int n, int n2, int n3) {
        if (n + this.coinWidth > 0 && n < this.screenWidth && n2 + this.coinHeight > 0 && n2 < this.screenHeight) {
            graphics.setClip(0, 0, this.screenWidth, this.screenHeight);
            graphics.clipRect(n, n2, this.coinWidth, this.coinHeight);
            graphics.drawImage(this.nuggetImages, n, n2 - n3 * this.coinHeight, 20);
        }
    }

    public String[] parseString(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != ',') continue;
            ++n;
        }
        String[] stringArray = new String[n + 1];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = string.substring(0, string.indexOf(44));
            string = string.substring(string.indexOf(44) + 1);
        }
        stringArray[n] = string;
        return stringArray;
    }

    public void drawText(Graphics graphics, String[] stringArray, Font font, boolean bl, int n, int n2) {
        Font[] fontArray = new Font[stringArray.length];
        for (int i = 0; i < fontArray.length; ++i) {
            fontArray[i] = font;
        }
        this.drawText(graphics, stringArray, fontArray, bl, n, n2);
    }

    public void drawText(Graphics graphics, String[] stringArray, Font[] fontArray, boolean bl, int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            graphics.setFont(fontArray[n3]);
            n5 = Math.max(fontArray[n3].stringWidth(stringArray[n3]), n5);
            n7 += fontArray[n3].getHeight();
        }
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(n - n5 / 2 - 1, n2 - 2, n5 + 2, n7 + 1);
        graphics.setColor(0);
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            n4 = fontArray[n3].stringWidth(stringArray[n3]);
            graphics.setFont(fontArray[n3]);
            graphics.drawString(stringArray[n3], n, n2 + n6, 17);
            n6 += fontArray[n3].getHeight();
        }
        if (bl) {
            graphics.drawRect(n - n5 / 2 - 1, n2 - 2, n5 + 2, n7 + 1);
        }
    }
}

