/*
 * Decompiled with CFR 0.152.
 */
package puzzle;

import java.io.IOException;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import puzzle.Config;
import puzzle.Element;
import puzzle.HelpDisplayable;
import puzzle.InterrupAnimation;
import puzzle.Menu;
import puzzle.MenuItem;
import puzzle.MenuListener;
import puzzle.MyCanvas;
import puzzle.Playfield;
import puzzle.Puzzle;

public class GameDisplayable
extends MyCanvas
implements MenuListener {
    InterrupAnimation iAnimation;
    private static int DELAY = 10;
    public Image large;
    private Image offscreen = null;
    private Graphics saved;
    Menu m = new Menu(Config.MENUOFFSET);
    MenuItem helpItem;
    MenuItem stopItem;
    private Playfield playfield;

    public GameDisplayable() {
        this.offscreen = Image.createImage((int)this.getWidth(), (int)this.getHeight());
        System.out.println("double buffered");
        try {
            Element.WIDTH = Config.SCREENWIDTH / 3;
            Element.HEIGHT = Config.SCREENHEIGHT / 3;
            this.iAnimation = new InterrupAnimation("Solved !", "press Fire..", this.getWidth() * 7 / 10, this.getHeight() * 5 / 20, this.getWidth() / 2, this.getHeight() / 2);
            this.createLarge();
            this.playfield = new Playfield(this.large);
            Image im0 = Image.createImage((String)String.valueOf(String.valueOf(Config.RESOURCE)).concat("help0.png"));
            Image im1 = Image.createImage((String)String.valueOf(String.valueOf(Config.RESOURCE)).concat("help1.png"));
            this.helpItem = new MenuItem(im1, im0, 1);
            im0 = Image.createImage((String)String.valueOf(String.valueOf(Config.RESOURCE)).concat("exit0.png"));
            im1 = Image.createImage((String)String.valueOf(String.valueOf(Config.RESOURCE)).concat("exit1.png"));
            this.stopItem = new MenuItem(im1, im0, 2);
            this.m.add(this.helpItem);
            this.m.add(this.stopItem);
            this.m.setListener(this);
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.startThread();
    }

    private void createLarge() {
        try {
            Image im = Image.createImage((String)String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Config.RESOURCE))).append(Config.getBg()[Puzzle.level]).append(".png"))));
            this.large = Image.createImage((int)Config.SCREENWIDTH, (int)Config.SCREENHEIGHT);
            Graphics g = this.large.getGraphics();
            g.setColor(255, 255, 255);
            g.fillRect(0, 0, Config.SCREENWIDTH, Config.SCREENHEIGHT);
            g.drawImage(im, Config.SCREENWIDTH / 2, Config.SCREENHEIGHT / 2, 3);
        }
        catch (IOException iox) {
            iox.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
    }

    public void run() {
        Thread thisThread = Thread.currentThread();
        while (this.runner == thisThread) {
            this.repaint();
            try {
                Thread.sleep(DELAY);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    protected void paint(Graphics g) {
        this.saved = g;
        if (this.offscreen != null) {
            g = this.offscreen.getGraphics();
        }
        g.setColor(128, 128, 128);
        g.fillRect(0, 0, Config.SCREENWIDTH, Config.SCREENHEIGHT);
        this.playfield.paint(g);
        if (this.m.isVisible()) {
            this.m.paint(g);
        }
        if (this.playfield.solved()) {
            this.iAnimation.paint(g);
        }
        if (g != this.saved) {
            this.saved.drawImage(this.offscreen, 0, 0, 20);
        }
    }

    public void keyPressed(int keyCode) {
        int action = this.getGameAction(keyCode);
        if (keyCode == -1 || keyCode == -4) {
            System.out.println("Menu Set Visible !");
            this.m.setVisible(!this.m.isVisible());
            this.repaint();
        } else {
            switch (action) {
                case 1: {
                    if (this.m.isVisible()) {
                        this.m.up();
                        break;
                    }
                    this.playfield.up();
                    break;
                }
                case 6: {
                    if (this.m.isVisible()) {
                        this.m.down();
                        break;
                    }
                    this.playfield.down();
                    break;
                }
                case 2: {
                    if (this.m.isVisible()) {
                        this.m.select();
                        break;
                    }
                    this.playfield.left();
                    break;
                }
                case 5: {
                    if (this.m.isVisible()) {
                        this.m.select();
                        break;
                    }
                    this.playfield.right();
                    break;
                }
                case 8: {
                    if (this.m.isVisible()) {
                        Config.ping();
                        this.m.select();
                        break;
                    }
                    if (!this.playfield.solved()) break;
                    ++Puzzle.levelCounter;
                    if (++Puzzle.level >= Config.getBg().length) {
                        Puzzle.level = 0;
                    }
                    if (Puzzle.levelCounter >= Config.getBg().length) {
                        Puzzle.levelCounter = 0;
                        Element.WIDTH = this.getWidth() / ++Puzzle.ElementsInX;
                        Element.HEIGHT = this.getHeight() / ++Puzzle.ElementsInY;
                    }
                    this.createLarge();
                    this.playfield = new Playfield(this.large);
                    this.iAnimation = new InterrupAnimation("Solved !", "press Fire..", this.getWidth() * 7 / 10, this.getHeight() * 5 / 20, this.getWidth() / 2, this.getHeight() / 2);
                }
            }
        }
    }

    public void select(MenuItem mi) {
        if (mi == this.helpItem) {
            this.stopThread();
            HelpDisplayable hd = new HelpDisplayable(this.large);
            Puzzle.display.setCurrent((Displayable)hd);
        } else if (mi == this.stopItem) {
            this.stopThread();
            Puzzle.display.setCurrent((Displayable)Puzzle.displayable);
        }
    }
}

