/*
 * Decompiled with CFR 0.152.
 */
package puzzle;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import puzzle.Config;
import puzzle.MenuListener;

public class MenuItem {
    private Image selectedImage;
    private Image unselectedImage;
    private int type;
    private boolean isSelected;
    private MenuListener listener;
    private String text;

    public MenuItem(Image selected, Image unselected, int comand) {
        this.selectedImage = selected;
        this.unselectedImage = unselected;
        this.type = comand;
    }

    public MenuItem(String t, int w, int h, int comand) {
        this.selectedImage = Image.createImage((int)w, (int)h);
        this.unselectedImage = Image.createImage((int)w, (int)h);
        this.type = comand;
        Graphics g = this.selectedImage.getGraphics();
        g.setColor(255, 255, 255);
        g.drawLine(0, 0, g.getClipWidth(), 0);
        g.drawLine(0, 0, 0, g.getClipHeight());
        g.setColor(0, 0, 0);
        g.drawLine(0, g.getClipHeight() - 1, g.getClipWidth(), g.getClipHeight() - 1);
        g.drawLine(g.getClipWidth() - 1, g.getClipHeight() - 1, g.getClipWidth() - 1, 0);
        g.setColor(255, 0, 0);
        g.setFont(Font.getFont((int)0, (int)1, (int)8));
        g.drawString(t, w / 2, h, 33);
        g = this.unselectedImage.getGraphics();
        g.setColor(100, 100, 100);
        g.drawRect(0, 0, g.getClipWidth() - 1, g.getClipHeight() - 1);
        g.setFont(Font.getFont((int)0, (int)0, (int)8));
        g.drawString(t, w / 2, h, 33);
        this.text = t;
    }

    public int getType() {
        return this.type;
    }

    public int getWidth() {
        return this.selectedImage.getWidth();
    }

    public int getHeight() {
        return this.selectedImage.getHeight();
    }

    public void setListener(MenuListener ml) {
        this.listener = ml;
    }

    public void setSelect(boolean state) {
        this.isSelected = state;
    }

    public void toggle() {
        this.isSelected = !this.isSelected;
    }

    public void perform() {
        this.listener.select(this);
    }

    public void paint(Graphics g, int y) {
        if (this.isSelected) {
            g.drawImage(this.selectedImage, Config.SCREENWIDTH / 2, y, 17);
        } else {
            g.drawImage(this.unselectedImage, Config.SCREENWIDTH / 2, y, 17);
        }
    }

    public void paint(Graphics g, int x, int y) {
        if (this.isSelected) {
            g.drawImage(this.selectedImage, x, y, 20);
        } else {
            g.drawImage(this.unselectedImage, x, y, 20);
        }
    }
}

