/*
 * Decompiled with CFR 0.152.
 */
package puzzle;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import puzzle.Config;
import puzzle.Playfield;
import puzzle.Puzzle;

public class Element {
    public static int WIDTH = 20;
    public static int HEIGHT = 20;
    public int xPos;
    public int yPos;
    private int sollIndex;
    public int istIndex;
    private Image image;
    private int moveXCounter = 0;
    private int moveYCounter = 0;
    private int stepX = 0;
    private int stepY = 0;

    public Element(Image i, int x, int y, int si, int ii) {
        if (i == null) {
            i = Image.createImage((int)WIDTH, (int)HEIGHT);
            Graphics g = i.getGraphics();
            g.setColor(0, 0, 0);
            g.drawRect(0, 0, g.getClipWidth() - 1, g.getClipHeight() - 1);
            g.drawString(Integer.toString(ii), 1, 1, 20);
        }
        this.image = i;
        this.xPos = x;
        this.yPos = y;
        this.sollIndex = si;
        this.istIndex = ii;
    }

    public void paint(Graphics g) {
        g.drawImage(this.image, this.xPos, this.yPos, 20);
        if (this.isMoving()) {
            g.setStrokeStyle(0);
            g.setColor(255, 255, 255);
            g.drawLine(this.xPos, this.yPos, this.xPos + WIDTH - 1, this.yPos);
            g.drawLine(this.xPos, this.yPos, this.xPos, HEIGHT - 1 + this.yPos);
            g.setColor(0, 0, 0);
            g.drawLine(this.xPos + WIDTH - 1, this.yPos, WIDTH - 1 + this.xPos, HEIGHT - 1 + this.yPos);
            g.drawLine(this.xPos, HEIGHT - 1 + this.yPos, WIDTH - 1 + this.xPos, HEIGHT - 1 + this.yPos);
        } else {
            g.setStrokeStyle(1);
            g.setColor(128, 128, 128);
            g.setStrokeStyle(1);
            g.drawRect(this.xPos, this.yPos, WIDTH - 1, HEIGHT - 1);
        }
        this.move();
    }

    public boolean correct() {
        return this.sollIndex == this.istIndex;
    }

    public void setMove(int xo, int yo) {
        Playfield.isMoving = true;
        this.stepX = xo;
        this.stepY = yo;
        if (xo != 0) {
            this.moveXCounter = WIDTH;
        }
        if (yo != 0) {
            this.moveYCounter = HEIGHT;
        }
    }

    public boolean isMoving() {
        return this.moveXCounter != 0 || this.moveYCounter != 0;
    }

    public void move() {
        if (this.moveXCounter > 0) {
            this.xPos += this.stepX;
            this.moveXCounter -= Math.abs(this.stepX);
            if (this.moveXCounter <= 0) {
                Playfield.elements[Playfield.actualXIndex][Playfield.actualYIndex] = null;
                Playfield.isMoving = false;
                this.moveXCounter = 0;
                this.moveYCounter = 0;
                Config.ping();
                if (this.stepX > 0) {
                    Playfield.elements[Playfield.actualXIndex + 1][Playfield.actualYIndex] = this;
                    this.xPos = (Playfield.actualXIndex + 1) * WIDTH;
                    ++this.istIndex;
                } else {
                    Playfield.elements[Playfield.actualXIndex - 1][Playfield.actualYIndex] = this;
                    this.xPos = (Playfield.actualXIndex - 1) * WIDTH;
                    --this.istIndex;
                }
            }
        }
        if (this.moveYCounter > 0) {
            this.yPos += this.stepY;
            this.moveYCounter -= Math.abs(this.stepY);
            if (this.moveYCounter <= 0) {
                Playfield.isMoving = false;
                Playfield.elements[Playfield.actualXIndex][Playfield.actualYIndex] = null;
                this.moveXCounter = 0;
                this.moveYCounter = 0;
                Config.ping();
                this.yPos -= this.stepY;
                if (this.stepY > 0) {
                    Playfield.elements[Playfield.actualXIndex][Playfield.actualYIndex + 1] = this;
                    this.yPos = (Playfield.actualYIndex + 1) * HEIGHT;
                    this.istIndex += Puzzle.ElementsInX;
                } else {
                    Playfield.elements[Playfield.actualXIndex][Playfield.actualYIndex - 1] = this;
                    this.istIndex -= Puzzle.ElementsInX;
                    this.yPos = (Playfield.actualYIndex - 1) * HEIGHT;
                }
            }
        }
    }
}

