/*
 * Decompiled with CFR 0.152.
 */
package puzzle;

import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import puzzle.Element;
import puzzle.Puzzle;

public class Playfield {
    private static final int OBEN = 0;
    private static final int UNTEN = 1;
    private static final int LINKS = 2;
    private static final int RECHTS = 3;
    private static final int STEP = 4;
    static Random random;
    public static boolean isMoving;
    public static Element[][] elements;
    public static int actualXIndex;
    public static int actualYIndex;
    private int moveX;
    private int moveY;
    private int ex;
    private int ey;
    private Element actualElement;
    private int[] istNumbers;

    public Playfield(Image im) {
        isMoving = false;
        this.ex = Puzzle.ElementsInX;
        this.ey = Puzzle.ElementsInY;
        elements = new Element[this.ex][this.ey];
        Image[] images = this.getImages(im, this.ex, this.ey);
        int x = 0;
        int y = 0;
        int sollnumber = 0;
        for (int j = 0; j < this.ey; ++j) {
            for (int i = 0; i < this.ex; ++i) {
                Playfield.elements[i][j] = new Element(images[++sollnumber - 1], x, y, sollnumber - 1, sollnumber - 1);
                x += Element.WIDTH;
            }
            x = 0;
            y += Element.HEIGHT;
        }
        Playfield.elements[0][0] = null;
        actualXIndex = 0;
        actualYIndex = 0;
        this.scrambel();
    }

    public Image[] getImages(Image largeImage, int nrImgsHorizontal, int nrImgsVertical) {
        Image[] smallImages = new Image[nrImgsHorizontal * nrImgsVertical];
        int smallImageWidth = Element.WIDTH;
        int smallImageHeight = Element.HEIGHT;
        int num = 0;
        for (int i = 0; i < nrImgsVertical; ++i) {
            for (int j = 0; j < nrImgsHorizontal; ++j) {
                smallImages[num] = Image.createImage((int)smallImageWidth, (int)smallImageHeight);
                Graphics g = smallImages[num].getGraphics();
                g.setClip(0, 0, smallImageWidth, smallImageHeight);
                g.drawImage(largeImage, -(j * smallImageWidth), -(i * smallImageHeight), 0);
                ++num;
            }
        }
        return smallImages;
    }

    public boolean solved() {
        for (int i = 0; i < this.ey; ++i) {
            for (int j = 0; j < this.ex; ++j) {
                try {
                    if (elements[j][i].correct()) continue;
                    boolean bl = false;
                    return bl;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
        return true;
    }

    private void scrambel() {
        int oldR = 1;
        int i = 0;
        while (i < 2 * Puzzle.ElementsInX * Puzzle.ElementsInY) {
            int r = (random.nextInt() >>> 1) % 4;
            if (oldR == 0 && r == 1 || oldR == 2 && r == 3 || oldR == 1 && r == 0 || oldR == 3 && r == 2) continue;
            try {
                switch (r) {
                    case 0: {
                        Element tmpElement = elements[actualXIndex][actualYIndex - 1];
                        Playfield.elements[Playfield.actualXIndex][Playfield.actualYIndex - 1] = null;
                        Playfield.elements[Playfield.actualXIndex][Playfield.actualYIndex] = tmpElement;
                        tmpElement.istIndex += Puzzle.ElementsInX;
                        tmpElement.yPos += Element.HEIGHT;
                        --actualYIndex;
                        break;
                    }
                    case 1: {
                        Element tmpElement = elements[actualXIndex][actualYIndex + 1];
                        Playfield.elements[Playfield.actualXIndex][Playfield.actualYIndex + 1] = null;
                        Playfield.elements[Playfield.actualXIndex][Playfield.actualYIndex] = tmpElement;
                        tmpElement.istIndex -= Puzzle.ElementsInX;
                        tmpElement.yPos -= Element.HEIGHT;
                        ++actualYIndex;
                        break;
                    }
                    case 2: {
                        Element tmpElement = elements[actualXIndex - 1][actualYIndex];
                        Playfield.elements[Playfield.actualXIndex - 1][Playfield.actualYIndex] = null;
                        Playfield.elements[Playfield.actualXIndex][Playfield.actualYIndex] = tmpElement;
                        ++tmpElement.istIndex;
                        tmpElement.xPos += Element.WIDTH;
                        --actualXIndex;
                        break;
                    }
                    case 3: {
                        Element tmpElement = elements[actualXIndex + 1][actualYIndex];
                        Playfield.elements[Playfield.actualXIndex + 1][Playfield.actualYIndex] = null;
                        Playfield.elements[Playfield.actualXIndex][Playfield.actualYIndex] = tmpElement;
                        --tmpElement.istIndex;
                        tmpElement.xPos -= Element.WIDTH;
                        ++actualXIndex;
                    }
                }
                oldR = r;
                ++i;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
    }

    private boolean proov(int number) {
        for (int i = 0; i < this.istNumbers.length; ++i) {
            if (this.istNumbers[i] != number) continue;
            return false;
        }
        return true;
    }

    public void paint(Graphics g) {
        for (int i = 0; i < this.ex; ++i) {
            for (int j = 0; j < this.ey; ++j) {
                try {
                    elements[i][j].paint(g);
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    }

    public void left() {
        try {
            this.actualElement = elements[actualXIndex + 1][actualYIndex];
            if (!isMoving && !this.solved()) {
                ++actualXIndex;
                this.actualElement.setMove(-4, 0);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void right() {
        try {
            this.actualElement = elements[actualXIndex - 1][actualYIndex];
            if (!isMoving && !this.solved()) {
                --actualXIndex;
                this.actualElement.setMove(4, 0);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void up() {
        try {
            this.actualElement = elements[actualXIndex][actualYIndex + 1];
            if (!isMoving && !this.solved()) {
                ++actualYIndex;
                this.actualElement.setMove(0, -4);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void down() {
        try {
            this.actualElement = elements[actualXIndex][actualYIndex - 1];
            if (!isMoving && !this.solved()) {
                --actualYIndex;
                this.actualElement.setMove(0, 4);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    static {
        OBEN = 0;
        UNTEN = 1;
        LINKS = 2;
        RECHTS = 3;
        STEP = 4;
        random = new Random();
        actualXIndex = 0;
        actualYIndex = 0;
    }
}

