/*
 * Decompiled with CFR 0.152.
 */
import com.bsg.siemens.BSCanvas;
import com.siemens.mp.color_game.Sprite;
import com.siemens.mp.color_game.TiledLayer;
import com.siemens.mp.game.Melody;
import com.siemens.mp.game.MelodyComposer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class HellsPitCanvas
extends BSCanvas
implements Runnable {
    private Image statusBarImage;
    private Image tiles;
    private Image optionsImage;
    private Image[] digits;
    private Image livesImage;
    private Image coinsImage;
    private Graphics statusBarSurface;
    private TiledLayer backGround;
    private Sprite playerSprite;
    private Sprite monsterSprite;
    private int screenHeight;
    private int halfScreenHeight;
    private int screenWidth = this.getWidth();
    private int halfScreenWidth = this.screenWidth / 2;
    private int statusBarHeight = 7;
    private int backBufferWidth;
    private int backBufferHeight;
    private int tileWidth = 8;
    private int tileHeight = 8;
    private int[][] teleporters;
    private int[][] holes;
    private int xOffSet;
    private int yOffSet;
    private int extraLifeCounter;
    private int difficulty;
    private int totalCoins;
    private int currentLevel;
    private int pWidth = 8;
    private int pHalfWidth;
    private int pHeight = 8;
    private int pHalfHeight;
    private int pXPos;
    private int pOrigXPos;
    private int pYPos;
    private int pOrigYPos;
    private int pDX;
    private int pMaxDX;
    private int pDY;
    private int pMaxDY;
    private int pTeleToX;
    private int pTeleToY;
    private int pCurrentMove;
    private int pCurrentFrame;
    private int pLives;
    private int pCoins;
    private int pTotalCoins;
    private int coinScore;
    private boolean[] keysPressed;
    private boolean running;
    private boolean levelClear;
    private boolean gameover;
    private boolean won;
    private boolean dead;
    private boolean start;
    private boolean keyPressed;
    private boolean updateStatus;
    private boolean extraLife;
    private boolean allowTeleport;
    private boolean gamecomplete;
    private boolean blankScreen;
    private Thread instance;
    private byte[][] level;
    private Monster[] monsters;
    public static final int P_UP = 0;
    public static final int P_DOWN = 1;
    public static final int P_LEFT = 2;
    public static final int P_RIGHT = 3;
    public static final int P_STOP = 4;
    public static final int P_DEAD = 5;
    public static final int[] P_FRAMES = new int[]{1, 1, 1, 1, 1, 4};
    public static final int M_FRAMES = 4;
    private Melody wonMelody;
    private Melody deadMelody;
    private Melody bonusMelody;
    private Melody monsterDeadMelody;
    private String[] endString;
    private int endStringCenterX;
    private int endStringTop;
    private boolean playerTalking;
    private boolean enemyTalking;
    private Font[] endStringFont;

    public HellsPitCanvas() {
        MelodyComposer melodyComposer;
        this.screenHeight = this.getHeight() - this.statusBarHeight;
        this.halfScreenHeight = this.screenHeight / 2;
        this.pHalfWidth = this.pWidth / 2;
        this.pHalfHeight = this.pHeight / 2;
        try {
            melodyComposer = new MelodyComposer();
            melodyComposer.setBPM(120);
            melodyComposer.appendNote(24, 4);
            melodyComposer.appendNote(26, 4);
            melodyComposer.appendNote(28, 4);
            melodyComposer.appendNote(29, 4);
            melodyComposer.appendNote(31, 4);
            this.wonMelody = melodyComposer.getMelody();
            melodyComposer.resetMelody();
            melodyComposer.setBPM(120);
            melodyComposer.appendNote(31, 4);
            melodyComposer.appendNote(29, 4);
            melodyComposer.appendNote(28, 4);
            melodyComposer.appendNote(26, 4);
            melodyComposer.appendNote(24, 4);
            this.deadMelody = melodyComposer.getMelody();
            melodyComposer.resetMelody();
            melodyComposer.setBPM(120);
            melodyComposer.appendNote(24, 3);
            melodyComposer.appendNote(28, 4);
            melodyComposer.appendNote(29, 4);
            melodyComposer.appendNote(31, 4);
            melodyComposer.appendNote(36, 3);
            melodyComposer.appendNote(12, 3);
            this.bonusMelody = melodyComposer.getMelody();
            melodyComposer.resetMelody();
            melodyComposer.setBPM(120);
            melodyComposer.appendNote(23, 4);
            melodyComposer.appendNote(19, 4);
            melodyComposer.appendNote(17, 4);
            melodyComposer.appendNote(12, 3);
            this.monsterDeadMelody = melodyComposer.getMelody();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.tiles = com.siemens.mp.ui.Image.createImageWithoutScaling((String)"/Tiles.png");
            this.playerSprite = new Sprite(Image.createImage((String)"/PlayerImages.png"), 8, 8);
            this.monsterSprite = new Sprite(Image.createImage((String)"/MonsterImages.png"), 8, 8);
            melodyComposer = Image.createImage((String)"/Status.png");
            this.livesImage = this.getImage((Image)melodyComposer, 7, 7, -30, 0);
            this.coinsImage = this.getImage((Image)melodyComposer, 7, 7, -37, 0);
            this.optionsImage = this.getImage((Image)melodyComposer, melodyComposer.getWidth() - 44, 7, -44, 0);
            this.digits = new Image[10];
            for (int i = 0; i < this.digits.length; ++i) {
                this.digits[i] = this.getImage((Image)melodyComposer, 3, 5, -3 * i, 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.statusBarImage = Image.createImage((int)this.screenWidth, (int)this.statusBarHeight);
        this.statusBarSurface = this.statusBarImage.getGraphics();
        this.pMaxDX = 2;
        this.pMaxDY = 2;
        this.keysPressed = new boolean[4];
    }

    public Image getImage(Image image, int n, int n2, int n3, int n4) {
        Image image2 = Image.createImage((int)n, (int)n2);
        Graphics graphics = image2.getGraphics();
        graphics.drawImage(image, n3, n4, 20);
        return image2;
    }

    public void startGame(int n, Gauge gauge) {
        this.difficulty = n;
        this.currentLevel = 0;
        try {
            this.loadLevel(gauge, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        gauge.setValue(100);
        this.score = 0;
        this.coinScore = 4 + 2 * this.difficulty;
        this.pOrigXPos = this.pXPos;
        this.pOrigYPos = this.pYPos;
        this.pDX = 0;
        this.pDY = 0;
        this.allowTeleport = true;
        this.pCurrentMove = 4;
        this.pCurrentFrame = 0;
        this.pLives = 5;
        this.pCoins = 0;
        this.pTotalCoins = 0;
        this.commandListener.commandAction(BSCanvas.DISPLAY_CANVAS, (Displayable)this);
    }

    public void loadLevel(Gauge gauge, DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        InputStream inputStream = this.getClass().getResourceAsStream(String.valueOf(String.valueOf(new StringBuffer("/Levels/level").append(this.currentLevel).append(".txt"))));
        DataInputStream dataInputStream2 = new DataInputStream(inputStream);
        gauge.setValue(20);
        int n3 = dataInputStream2.readInt();
        int n4 = dataInputStream2.readInt();
        if (dataInputStream == null) {
            this.pXPos = dataInputStream2.readInt() * this.tileWidth;
            this.pYPos = dataInputStream2.readInt() * this.tileHeight;
        } else {
            this.pOrigXPos = dataInputStream2.readInt() * this.tileWidth;
            this.pOrigYPos = dataInputStream2.readInt() * this.tileHeight;
        }
        this.level = new byte[n4][n3];
        this.backBufferWidth = n3 * this.tileWidth;
        this.backBufferHeight = n4 * this.tileHeight;
        this.backGround = new TiledLayer(n3, n4, this.tiles, 8, 8);
        gauge.setValue(30);
        this.totalCoins = 0;
        Vector<int[]> vector = new Vector<int[]>(5);
        if (dataInputStream == null) {
            for (n2 = 0; n2 < this.level[0].length; ++n2) {
                for (n = 0; n < this.level.length; ++n) {
                    this.level[n][n2] = dataInputStream2.readByte();
                    if (this.level[n][n2] == 99) {
                        ++this.totalCoins;
                    }
                    if (this.level[n][n2] == 60) {
                        vector.addElement(new int[]{n2 * this.tileWidth + this.tileWidth / 2, n * this.tileHeight + this.tileHeight / 2});
                    }
                    this.backGround.setCell(n2, n, this.level[n][n2] + 1);
                }
            }
        } else {
            n2 = dataInputStream.readInt();
            for (n = 0; n < n2; ++n) {
                this.level[dataInputStream.readInt()][dataInputStream.readInt()] = 99;
            }
            for (n = 0; n < this.level[0].length; ++n) {
                for (int i = 0; i < this.level.length; ++i) {
                    byte by = dataInputStream2.readByte();
                    if (by != 99) {
                        this.level[i][n] = by;
                    } else {
                        ++this.totalCoins;
                    }
                    if (this.level[i][n] == 60) {
                        vector.addElement(new int[]{n * this.tileWidth + this.tileWidth / 2, i * this.tileHeight + this.tileHeight / 2});
                    }
                    this.backGround.setCell(n, i, this.level[i][n] + 1);
                }
            }
        }
        this.holes = new int[vector.size()][2];
        for (n2 = 0; n2 < this.holes.length; ++n2) {
            this.holes[n2] = (int[])vector.elementAt(n2);
        }
        this.teleporters = new int[dataInputStream2.readByte() * 2][];
        for (n2 = 0; n2 < this.teleporters.length / 2; ++n2) {
            int[] nArray = new int[]{dataInputStream2.readInt() * this.tileWidth + this.tileWidth / 2, dataInputStream2.readInt() * this.tileHeight + this.tileHeight / 2, dataInputStream2.readInt() * this.tileWidth + this.tileWidth / 2, dataInputStream2.readInt() * this.tileHeight + this.tileHeight / 2};
            this.teleporters[n2 * 2] = new int[]{nArray[0], nArray[1], nArray[2], nArray[3]};
            this.teleporters[n2 * 2 + 1] = new int[]{nArray[2], nArray[3], nArray[0], nArray[1]};
        }
        this.monsters = new Monster[dataInputStream2.readByte()];
        for (n2 = 0; n2 < this.monsters.length; ++n2) {
            this.monsters[n2] = new Monster(this.level, this.teleporters, this.holes, this.monsterSprite, dataInputStream2.readInt() * this.tileWidth + this.tileWidth / 2, dataInputStream2.readInt() * this.tileHeight + this.tileHeight / 2, 3 - this.difficulty);
        }
        gauge.setValue(70);
        dataInputStream2.close();
        this.xOffSet = this.backBufferWidth < this.screenWidth ? (this.screenWidth - this.backBufferWidth) / 2 : 0;
        this.yOffSet = this.backBufferHeight < this.screenHeight ? (this.screenHeight - this.backBufferHeight) / 2 : 0;
        this.dead = false;
        this.gameover = false;
        this.levelClear = false;
        this.won = false;
        this.start = true;
        this.keyPressed = false;
        this.updateStatus = true;
        this.gamecomplete = false;
        this.blankScreen = true;
        this.extraLife = false;
    }

    public void nextLevel(Gauge gauge) {
        ++this.currentLevel;
        try {
            this.loadLevel(gauge, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        gauge.setValue(100);
        this.pOrigXPos = this.pXPos;
        this.pOrigYPos = this.pYPos;
        this.pDX = 0;
        this.pDY = 0;
        this.allowTeleport = true;
        this.pCurrentMove = 4;
        this.pCoins = 0;
        this.commandListener.commandAction(BSCanvas.DISPLAY_CANVAS, (Displayable)this);
    }

    public void loadGame(byte[] byArray, Gauge gauge) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            this.currentLevel = dataInputStream.readByte();
            this.difficulty = dataInputStream.readByte();
            this.pLives = dataInputStream.readByte();
            this.pXPos = dataInputStream.readInt();
            this.pYPos = dataInputStream.readInt();
            this.pDX = dataInputStream.readByte();
            this.pDY = dataInputStream.readByte();
            this.pTeleToX = dataInputStream.readInt();
            this.pTeleToY = dataInputStream.readInt();
            this.allowTeleport = dataInputStream.readBoolean();
            this.pCurrentMove = dataInputStream.readByte();
            this.pCoins = dataInputStream.readByte();
            this.pTotalCoins = dataInputStream.readInt();
            this.score = dataInputStream.readInt();
            this.loadLevel(gauge, dataInputStream);
            for (int i = 0; i < this.monsters.length; ++i) {
                if (!dataInputStream.readBoolean()) {
                    this.monsters[i] = null;
                    continue;
                }
                this.monsters[i].xPos = dataInputStream.readInt();
                this.monsters[i].yPos = dataInputStream.readInt();
                this.monsters[i].currentFrame = dataInputStream.readByte();
                this.monsters[i].teleToX = dataInputStream.readInt();
                this.monsters[i].teleToY = dataInputStream.readInt();
                this.monsters[i].moveToX = dataInputStream.readInt();
                this.monsters[i].moveToY = dataInputStream.readInt();
                this.monsters[i].allowTeleport = dataInputStream.readBoolean();
                this.monsters[i].dying = dataInputStream.readBoolean();
            }
            gauge.setValue(100);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte[] saveGame(Gauge gauge) {
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeByte(this.currentLevel);
            dataOutputStream.writeByte(this.difficulty);
            dataOutputStream.writeByte(this.pLives);
            dataOutputStream.writeInt(this.pXPos);
            dataOutputStream.writeInt(this.pYPos);
            dataOutputStream.writeByte(this.pDX);
            dataOutputStream.writeByte(this.pDY);
            dataOutputStream.writeInt(this.pTeleToX);
            dataOutputStream.writeInt(this.pTeleToY);
            dataOutputStream.writeBoolean(this.allowTeleport);
            dataOutputStream.writeByte(this.pCurrentMove);
            dataOutputStream.writeByte(this.pCoins);
            dataOutputStream.writeInt(this.pTotalCoins);
            dataOutputStream.writeInt(this.score);
            dataOutputStream.writeInt(this.totalCoins - this.pCoins);
            for (n = 0; n < this.level[0].length; ++n) {
                for (int i = 0; i < this.level.length; ++i) {
                    if (this.level[i][n] != 99) continue;
                    dataOutputStream.writeInt(i);
                    dataOutputStream.writeInt(n);
                }
            }
            for (n = 0; n < this.monsters.length; ++n) {
                if (this.monsters[n] == null) {
                    dataOutputStream.writeBoolean(false);
                    continue;
                }
                dataOutputStream.writeBoolean(true);
                dataOutputStream.writeInt(this.monsters[n].xPos);
                dataOutputStream.writeInt(this.monsters[n].yPos);
                dataOutputStream.writeByte(this.monsters[n].currentFrame);
                dataOutputStream.writeInt(this.monsters[n].teleToX);
                dataOutputStream.writeInt(this.monsters[n].teleToY);
                dataOutputStream.writeInt(this.monsters[n].moveToX);
                dataOutputStream.writeInt(this.monsters[n].moveToY);
                dataOutputStream.writeBoolean(this.monsters[n].allowTeleport);
                dataOutputStream.writeBoolean(this.monsters[n].dying);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception exception) {
            byte[] byArray = null;
            return byArray;
        }
    }

    public void paint(Graphics graphics) {
        if (this.blankScreen) {
            graphics.setColor(0xFFFFFF);
            graphics.setClip(0, 0, this.screenWidth, this.screenHeight + this.statusBarHeight);
            graphics.fillRect(0, 0, this.screenWidth, this.screenHeight + this.statusBarHeight);
            this.blankScreen = false;
        }
        if (!this.gamecomplete) {
            int n;
            if (this.updateStatus) {
                this.statusBarSurface.setColor(0xFFFFFF);
                this.statusBarSurface.fillRect(0, 0, this.screenWidth, this.statusBarHeight);
                this.statusBarSurface.drawImage(this.optionsImage, this.screenWidth - this.optionsImage.getWidth(), 0, 20);
                n = 0;
                int n2 = 100000;
                for (int i = 6; i > 0; --i) {
                    this.statusBarSurface.drawImage(this.digits[this.score / n2 % 10], n, 1, 20);
                    n2 /= 10;
                    n += this.digits[0].getWidth() + 1;
                }
                this.statusBarSurface.drawImage(this.livesImage, n, 0, 20);
                this.statusBarSurface.drawImage(this.digits[this.pLives / 10 % 10], n += this.livesImage.getWidth() + 1, 1, 20);
                this.statusBarSurface.drawImage(this.digits[this.pLives % 10], n += this.digits[0].getWidth() + 1, 1, 20);
                this.statusBarSurface.drawImage(this.coinsImage, n += this.digits[0].getWidth() + 1, 0, 20);
                this.statusBarSurface.drawImage(this.digits[this.pTotalCoins / 10 % 10], n += this.coinsImage.getWidth() + 1, 1, 20);
                this.statusBarSurface.drawImage(this.digits[this.pTotalCoins % 10], n += this.digits[0].getWidth() + 1, 1, 20);
                this.updateStatus = false;
            }
            if (this.pXPos > this.halfScreenWidth && this.backBufferWidth + this.xOffSet > this.screenWidth || this.pXPos < this.halfScreenWidth - this.xOffSet && this.xOffSet < 0) {
                this.xOffSet = this.halfScreenWidth - this.pXPos;
                if (this.backBufferWidth + this.xOffSet < this.screenWidth) {
                    this.xOffSet = -(this.backBufferWidth - this.screenWidth);
                } else if (this.xOffSet > 0) {
                    this.xOffSet = 0;
                }
            }
            if (this.pYPos > this.halfScreenHeight && this.backBufferHeight + this.yOffSet > this.screenHeight || this.pYPos < this.halfScreenHeight - this.yOffSet && this.yOffSet < 0) {
                this.yOffSet = this.halfScreenHeight - this.pYPos;
                if (this.backBufferHeight + this.yOffSet < this.screenHeight) {
                    this.yOffSet = -(this.backBufferHeight - this.screenHeight);
                } else if (this.yOffSet > 0) {
                    this.yOffSet = 0;
                }
            }
            this.backGround.setPosition(this.xOffSet, this.yOffSet);
            this.backGround.paint(graphics);
            for (n = 0; n < this.monsters.length; ++n) {
                if (this.monsters[n] == null) continue;
                this.monsters[n].paint(graphics, this.xOffSet, this.yOffSet);
            }
            this.playerSprite.setFrame(this.pCurrentMove * 4 + this.pCurrentFrame);
            this.playerSprite.setPosition(this.xOffSet + this.pXPos, this.yOffSet + this.pYPos);
            this.playerSprite.paint(graphics);
            graphics.drawImage(this.statusBarImage, 0, this.screenHeight, 20);
            if (this.extraLife) {
                this.drawText(graphics, this.parseString(this.langT[0]), this.getFont(this.langA[0]), true, this.halfScreenWidth, 5);
            }
            if (this.levelClear) {
                this.drawText(graphics, this.parseString(this.langT[1]), this.getFont(this.langA[1]), true, this.halfScreenWidth, this.halfScreenHeight);
            } else if (this.gameover) {
                this.drawText(graphics, this.parseString(this.langT[2]), this.getFont(this.langA[2]), true, this.halfScreenWidth, this.halfScreenHeight);
            }
            if (this.start) {
                this.drawText(graphics, this.parseString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.langT[3]))).append(this.currentLevel + 1)))), this.getFont(this.langA[3]), true, this.halfScreenWidth, this.halfScreenHeight);
            }
            if (this.paused) {
                this.drawText(graphics, this.parseString(this.langT[4]), this.getFont(this.langA[4]), true, this.halfScreenWidth, this.halfScreenHeight);
            }
        } else {
            this.backGround.setPosition(0, 0);
            this.backGround.paint(graphics);
            this.playerSprite.setFrame(this.pCurrentMove * 4 + this.pCurrentFrame);
            this.playerSprite.setPosition(this.pXPos, this.pYPos);
            this.playerSprite.paint(graphics);
            for (int i = 0; i < this.monsters.length; ++i) {
                if (this.monsters[i] == null) continue;
                this.monsters[i].paint(graphics, 0, 0);
            }
            if (this.playerTalking) {
                graphics.drawLine(this.pXPos + 6, this.pYPos - 6, this.endStringCenterX, this.endStringTop);
            }
            if (this.endString != null) {
                this.drawText(graphics, this.endString, this.endStringFont, true, this.endStringCenterX, this.endStringTop);
            }
        }
    }

    public void start() {
        if (this.instance == null || !this.running && !this.paused && !this.instance.isAlive()) {
            this.instance = new Thread(this);
            this.running = true;
            this.instance.start();
        } else if (this.instance.isAlive()) {
            this.running = true;
        }
        this.blankScreen = true;
    }

    public void pause() {
        this.running = false;
        if (!this.dead && !this.won) {
            this.keyPressed = false;
        }
    }

    public void destroy() {
        this.running = false;
        this.instance = null;
    }

    public void hideNotify() {
        this.pause();
    }

    public void showNotify() {
        this.start();
    }

    public void collectCoin(int n, int n2) {
        this.level[n2][n] = 0;
        ++this.pCoins;
        ++this.pTotalCoins;
        this.score += this.coinScore;
        this.updateStatus = true;
        this.backGround.setCell(n, n2, this.level[n2][n] + 1);
        if (this.pTotalCoins == 100) {
            this.pTotalCoins = 0;
            if (this.pLives != 99) {
                ++this.pLives;
            }
            this.extraLife = true;
            this.extraLifeCounter = 30;
            BSCanvas.playSound(this.bonusMelody);
        }
    }

    public void deadHole(int n, int n2) {
        int n3;
        --this.pLives;
        this.dead = true;
        this.updateStatus = true;
        for (n3 = 0; n3 < this.keysPressed.length; ++n3) {
            this.keysPressed[n3] = false;
        }
        this.repaint();
        try {
            n3 = this.pXPos + this.pHalfWidth - n;
            int n4 = this.pYPos + this.pHalfHeight - n2;
            while (n3 != 0 || n4 != 0) {
                if (n3 > 0) {
                    this.pCurrentMove = 3;
                    --this.pXPos;
                    --n3;
                } else if (n3 < 0) {
                    this.pCurrentMove = 2;
                    ++this.pXPos;
                    ++n3;
                }
                if (n4 > 0) {
                    this.pCurrentMove = 1;
                    --this.pYPos;
                    --n4;
                } else if (n4 < 0) {
                    this.pCurrentMove = 0;
                    ++this.pYPos;
                    ++n4;
                }
                this.repaint();
                Thread.sleep(66L);
            }
            this.pCurrentMove = 5;
            Thread.sleep(1000L);
            BSCanvas.playSound(this.deadMelody);
            BSCanvas.vibrate(50, 500);
            for (int i = 0; i < P_FRAMES[5] - 1; ++i) {
                ++this.pCurrentFrame;
                this.repaint();
                Thread.sleep(333L);
            }
            this.repaint();
            Thread.sleep(1000L);
            this.dead();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void deadMonster() {
        int n;
        --this.pLives;
        this.dead = true;
        this.updateStatus = true;
        for (n = 0; n < this.keysPressed.length; ++n) {
            this.keysPressed[n] = false;
        }
        this.repaint();
        try {
            Thread.sleep(1000L);
            BSCanvas.playSound(this.deadMelody);
            BSCanvas.vibrate(50, 500);
            for (n = 0; n < 30; ++n) {
                ++this.pCurrentMove;
                if (this.pCurrentMove >= 4) {
                    this.pCurrentMove = 0;
                }
                this.repaint();
                Thread.sleep(66L);
            }
            this.pCurrentMove = 5;
            this.repaint();
            Thread.sleep(1000L);
            this.dead();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dead() throws InterruptedException {
        if (this.pLives == 0) {
            this.gameover = true;
            this.repaint();
            Thread.sleep(1000L);
            this.commandListener.commandAction(BSCanvas.GAME_ENDED, (Displayable)this);
        }
        if (!this.gameover) {
            this.pXPos = this.pOrigXPos;
            this.pDX = 0;
            this.pYPos = this.pOrigYPos;
            this.pCurrentMove = 4;
            this.pCurrentFrame = 0;
            this.pDY = 0;
            for (int i = 0; i < this.monsters.length; ++i) {
                if (this.monsters[i] != null && this.monsters[i].dying) {
                    this.monsters[i] = null;
                    continue;
                }
                if (this.monsters[i] == null) continue;
                this.monsters[i].reset();
            }
            this.dead = false;
            this.repaint();
            Thread.sleep(1000L);
        }
    }

    public void run() {
        while (this.running) {
            try {
                if (this.start) {
                    this.repaint();
                    Thread.sleep(2000L);
                    this.start = false;
                    this.repaint();
                }
                if (this.levelClear || this.gameover || !this.keyPressed) continue;
                if (this.extraLife) {
                    --this.extraLifeCounter;
                    if (this.extraLifeCounter <= 0) {
                        this.extraLife = false;
                    }
                }
                if (this.keysPressed[0]) {
                    this.pCurrentMove = 0;
                    if (this.pDY > -this.pMaxDY) {
                        --this.pDY;
                    }
                } else if (this.keysPressed[1]) {
                    this.pCurrentMove = 1;
                    if (this.pDY < this.pMaxDY) {
                        ++this.pDY;
                    }
                } else if (this.pDY < 0) {
                    ++this.pDY;
                } else if (this.pDY > 0) {
                    --this.pDY;
                }
                if (this.keysPressed[2]) {
                    this.pCurrentMove = 2;
                    if (this.pDX > -this.pMaxDX) {
                        --this.pDX;
                    }
                } else if (this.keysPressed[3]) {
                    this.pCurrentMove = 3;
                    if (this.pDX < this.pMaxDX) {
                        ++this.pDX;
                    }
                } else if (this.pDX < 0) {
                    ++this.pDX;
                } else if (this.pDX > 0) {
                    --this.pDX;
                }
                if (!this.dead) {
                    int n;
                    int n2 = this.pDX;
                    int n3 = this.pDY;
                    if (n2 != 0 || n3 != 0) {
                        int n4;
                        n = 0;
                        int n5 = 0;
                        if (this.pDX > 0) {
                            n = 1;
                        } else if (this.pDX < 0) {
                            n = -1;
                        }
                        if (this.pDY > 0) {
                            n5 = 1;
                        } else if (this.pDY < 0) {
                            n5 = -1;
                        }
                        int n6 = 0;
                        int n7 = 0;
                        int n8 = 0;
                        int n9 = 0;
                        int n10 = 0;
                        int n11 = 0;
                        int n12 = 0;
                        int n13 = 0;
                        int n14 = 0;
                        int n15 = 0;
                        int n16 = 0;
                        int n17 = 0;
                        while (!(this.dead || n2 == 0 && n3 == 0)) {
                            if (n2 != 0) {
                                this.pXPos += n;
                                n2 -= n;
                            }
                            if (n3 != 0) {
                                this.pYPos += n5;
                                n3 -= n5;
                            }
                            n6 = this.pXPos + 2 >> 3;
                            n7 = this.pXPos + 6 >> 3;
                            n8 = this.pYPos >> 3;
                            if (this.level[n8][n6] > 64 || this.level[n8][n7] > 64) {
                                if (this.level[n8][n6] == 99) {
                                    this.collectCoin(n6, n8);
                                } else if (this.level[n8][n7] == 99) {
                                    this.collectCoin(n7, n8);
                                } else {
                                    n3 = 0;
                                    this.pDY = 0;
                                    this.pYPos = n8 + 1 << 3;
                                }
                            }
                            n9 = this.pXPos + 2 >> 3;
                            n10 = this.pXPos + 6 >> 3;
                            n11 = this.pYPos + 8 >> 3;
                            if (this.level[n11][n9] > 64 || this.level[n11][n10] > 64) {
                                if (this.level[n11][n9] == 99) {
                                    this.collectCoin(n9, n11);
                                } else if (this.level[n11][n10] == 99) {
                                    this.collectCoin(n10, n11);
                                } else {
                                    n3 = 0;
                                    this.pDY = 0;
                                    this.pYPos = n11 - 1 << 3;
                                }
                            }
                            n12 = this.pXPos >> 3;
                            n13 = this.pYPos + 2 >> 3;
                            n14 = this.pYPos + 6 >> 3;
                            if (this.level[n13][n12] > 64 || this.level[n14][n12] > 64) {
                                if (this.level[n13][n12] == 99) {
                                    this.collectCoin(n12, n13);
                                } else if (this.level[n14][n12] == 99) {
                                    this.collectCoin(n12, n14);
                                } else {
                                    n2 = 0;
                                    this.pDX = 0;
                                    this.pXPos = (n12 << 3) + 8;
                                }
                            }
                            n15 = this.pXPos + 8 >> 3;
                            n16 = this.pYPos + 2 >> 3;
                            n17 = this.pYPos + 6 >> 3;
                            if (this.level[n16][n15] <= 64 && this.level[n17][n15] <= 64) continue;
                            if (this.level[n16][n15] == 99) {
                                this.collectCoin(n15, n16);
                                continue;
                            }
                            if (this.level[n17][n15] == 99) {
                                this.collectCoin(n15, n17);
                                continue;
                            }
                            n2 = 0;
                            this.pDX = 0;
                            this.pXPos = (n15 << 3) - 8;
                        }
                        for (n4 = 0; n4 < this.holes.length; ++n4) {
                            if (this.pXPos + this.pHalfWidth <= this.holes[n4][0] - 8 || this.pXPos + this.pHalfWidth >= this.holes[n4][0] + 8 || this.pYPos + this.pHalfHeight <= this.holes[n4][1] - 8 || this.pYPos + this.pHalfHeight >= this.holes[n4][1] + 8) continue;
                            this.deadHole(this.holes[n4][0], this.holes[n4][1]);
                        }
                        if (!(this.allowTeleport || Math.abs(this.pXPos - this.pTeleToX) < 8 && Math.abs(this.pYPos - this.pTeleToY) < 8)) {
                            this.allowTeleport = true;
                        }
                        if (this.allowTeleport) {
                            for (n4 = 0; n4 < this.teleporters.length; ++n4) {
                                if (this.pXPos + this.pHalfWidth <= this.teleporters[n4][0] - 2 || this.pXPos + this.pHalfWidth >= this.teleporters[n4][0] + 2 || this.pYPos + this.pHalfHeight <= this.teleporters[n4][1] - 2 || this.pYPos + this.pHalfHeight >= this.teleporters[n4][1] + 2) continue;
                                this.pXPos = this.teleporters[n4][2] - this.pHalfWidth;
                                this.pYPos = this.teleporters[n4][3] - this.pHalfHeight;
                                this.pTeleToX = this.pXPos;
                                this.pTeleToY = this.pYPos;
                                n4 = this.teleporters.length;
                                this.allowTeleport = false;
                            }
                        }
                    }
                    if (this.pDX == 0 && this.pDY == 0) {
                        this.pCurrentMove = 4;
                    }
                    this.won = true;
                    for (n = 0; n < this.monsters.length; ++n) {
                        if (this.monsters[n] == null) continue;
                        this.won = false;
                        this.monsters[n].move(this.pXPos + this.pHalfWidth, this.pYPos + this.pHalfHeight);
                        if (this.monsters[n].getDead()) {
                            BSCanvas.playSound(this.monsterDeadMelody);
                            this.monsters[n] = null;
                            this.score += 100 * (this.difficulty + 1);
                            this.updateStatus = true;
                            continue;
                        }
                        if (!this.monsters[n].collide(this.pXPos, this.pYPos)) continue;
                        this.deadMonster();
                    }
                    if (this.won) {
                        this.repaint();
                        Thread.sleep(1000L);
                        this.extraLifeCounter = 0;
                        this.extraLife = false;
                        this.levelClear = true;
                        BSCanvas.playSound(this.wonMelody);
                        this.repaint();
                        Thread.sleep(3000L);
                        if (this.currentLevel == 19) {
                            this.runEndSequence();
                        } else {
                            this.blankScreen = true;
                            this.commandListener.commandAction(BSCanvas.LEVEL_ENDED, (Displayable)this);
                        }
                    }
                }
                this.repaint();
                Thread.sleep(66L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void runEndSequence() {
        try {
            int n;
            this.gamecomplete = true;
            this.playerTalking = false;
            this.enemyTalking = false;
            this.endString = null;
            this.endStringFont = new Font[]{this.getFont(this.langA[5]), this.getFont(this.langA[6]), this.getFont(this.langA[7])};
            this.endStringCenterX = this.halfScreenWidth;
            this.endStringTop = 5;
            int n2 = this.screenWidth / this.tileWidth + 1;
            int n3 = (this.screenHeight + this.statusBarHeight) / this.tileHeight + 1;
            int n4 = n2 / 2 - 0;
            int n5 = n3 / 2 - 0;
            this.pXPos = (n2 + 1) * this.tileWidth;
            this.pYPos = (n3 + 1) * this.tileHeight;
            this.teleporters = new int[0][];
            this.holes = new int[][]{{n4 * this.tileWidth + this.tileWidth / 2, n5 * this.tileHeight + this.tileHeight / 2}};
            this.monsters = new Monster[3];
            this.level = new byte[n3][n2];
            this.level[n5 - 1][n4] = 1;
            this.level[n5 - 1][n4 + 1] = 2;
            this.level[n5][n4 + 1] = 3;
            this.level[n5 + 1][n4 + 1] = 4;
            this.level[n5 + 1][n4] = 5;
            this.level[n5 + 1][n4 - 1] = 6;
            this.level[n5][n4 - 1] = 7;
            this.level[n5 - 1][n4 - 1] = 8;
            this.level[n5][n4] = 60;
            this.backGround = new TiledLayer(n2, n3, this.tiles, 8, 8);
            this.backBufferWidth = this.level[0].length * this.tileWidth;
            this.backBufferHeight = this.level.length * this.tileHeight;
            for (n = 0; n < n2; ++n) {
                for (int i = 0; i < n3; ++i) {
                    if (n == 0 || i == 0) {
                        this.level[i][n] = 65;
                    }
                    this.backGround.setCell(n, i, this.level[i][n] + 1);
                }
            }
            this.moveTo((n4 + 1) * this.tileWidth, n5 * this.tileHeight);
            this.endString = this.parseString(this.langT[5]);
            this.playerTalking = true;
            this.repaint();
            Thread.sleep(3000L);
            this.endString = null;
            this.playerTalking = false;
            this.monsters[0] = new Monster(this.level, this.teleporters, this.holes, this.monsterSprite, 1 * this.tileWidth + this.tileWidth / 2, 1 * this.tileHeight + this.tileHeight / 2, 1);
            this.monsters[1] = new Monster(this.level, this.teleporters, this.holes, this.monsterSprite, 2 * this.tileWidth + this.tileWidth / 2, 1 * this.tileHeight + this.tileHeight / 2, 1);
            this.monsters[2] = new Monster(this.level, this.teleporters, this.holes, this.monsterSprite, 1 * this.tileWidth + this.tileWidth / 2, 2 * this.tileHeight + this.tileHeight / 2, 1);
            this.repaint();
            Thread.sleep(1000L);
            this.endString = this.parseString(this.langT[6]);
            this.playerTalking = true;
            this.repaint();
            Thread.sleep(3000L);
            this.pCurrentMove = 3;
            this.endString = null;
            this.playerTalking = false;
            while (!(this.monsters[0].getDead() && this.monsters[1].getDead() && this.monsters[2].getDead())) {
                if (this.pXPos < (n2 + 1) * this.tileWidth) {
                    this.pXPos += 2;
                }
                for (n = 0; n < this.monsters.length; ++n) {
                    this.monsters[n].move(this.pXPos + this.pHalfWidth, this.pYPos + this.pHalfHeight);
                }
                this.repaint();
                Thread.sleep(66L);
            }
            this.moveTo((n4 + 1) * this.tileWidth, (n5 + 1) * this.tileHeight);
            this.endString = this.parseString(this.langT[7]);
            this.playerTalking = true;
            this.repaint();
            Thread.sleep(3000L);
            this.pCurrentMove = 4;
            this.endString = this.parseString(this.langT[8]);
            this.repaint();
            Thread.sleep(3000L);
            if (this.difficulty < 2) {
                this.endString = this.parseString(this.langT[9]);
                this.repaint();
                Thread.sleep(3000L);
                this.endString = this.parseString(this.langT[10]);
                this.repaint();
                Thread.sleep(3000L);
            } else {
                this.endString = this.parseString(this.langT[11]);
                this.repaint();
                Thread.sleep(3000L);
                this.endString = this.parseString(this.langT[12]);
                this.repaint();
                Thread.sleep(3000L);
                this.endString = null;
                this.playerTalking = false;
                this.moveTo(n4 * this.tileWidth, n5 * this.tileHeight);
                this.endString = this.parseString(this.langT[13]);
                this.playerTalking = true;
                this.pCurrentMove = 5;
                BSCanvas.vibrate(50, 500);
                this.repaint();
                Thread.sleep(1000L);
                for (n = 0; n < P_FRAMES[5] - 1; ++n) {
                    ++this.pCurrentFrame;
                    this.repaint();
                    Thread.sleep(1000L);
                }
            }
            this.endString = null;
            this.playerTalking = false;
            this.repaint();
            Thread.sleep(2000L);
            this.endString = this.parseString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.langT[14]))).append(",").append(this.langT[15]))));
            this.endStringFont = new Font[]{this.getFont(this.langA[14]), this.getFont(this.langA[15])};
            this.endStringCenterX = this.halfScreenWidth;
            this.endStringTop = this.halfScreenHeight - this.getFont(this.langA[14]).getHeight();
            this.repaint();
            Thread.sleep(3000L);
            this.commandListener.commandAction(BSCanvas.GAME_ENDED, (Displayable)this);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void moveTo(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        this.pDX = n3 - this.pXPos;
        this.pDY = n4 - this.pYPos;
        if (this.pDX > 0) {
            this.pDX = 2;
        } else if (this.pDX < 0) {
            this.pDX = -2;
        }
        if (this.pDY > 0) {
            this.pDY = 2;
        } else if (this.pDY < 0) {
            this.pDY = -2;
        }
        while (this.pXPos != n3 || this.pYPos != n4) {
            if (this.pXPos != n3) {
                if (Math.abs(n3 - (this.pXPos + Math.abs(this.pDX))) < Math.abs(this.pDX)) {
                    this.pXPos = n3;
                    this.pDX = 0;
                } else {
                    this.pXPos += this.pDX;
                }
            }
            if (this.pYPos != n4) {
                if (Math.abs(n4 - (this.pYPos + Math.abs(this.pDY))) < Math.abs(this.pDY)) {
                    this.pYPos = n4;
                    this.pDY = 0;
                } else {
                    this.pYPos += this.pDY;
                }
            }
            if (this.pDY > 0) {
                this.pCurrentMove = 1;
            }
            if (this.pDY < 0) {
                this.pCurrentMove = 0;
            }
            if (this.pDX > 0) {
                this.pCurrentMove = 3;
            }
            if (this.pDX < 0) {
                this.pCurrentMove = 2;
            }
            this.repaint();
            try {
                Thread.sleep(66L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void keyPressed(int n) {
        this.keyPressed = true;
        if (!this.dead && !this.won) {
            int n2 = this.getGameAction(n);
            if (n == -4) {
                this.commandListener.commandAction(BSCanvas.DISPLAY_MENU, (Displayable)this);
            } else {
                block0 : switch (n2) {
                    case 1: {
                        this.keysPressed[0] = true;
                        break;
                    }
                    case 6: {
                        this.keysPressed[1] = true;
                        break;
                    }
                    case 2: {
                        this.keysPressed[2] = true;
                        break;
                    }
                    case 5: {
                        this.keysPressed[3] = true;
                        break;
                    }
                    default: {
                        switch (n) {
                            case 49: {
                                this.keysPressed[0] = true;
                                this.keysPressed[2] = true;
                                break block0;
                            }
                            case 50: {
                                this.keysPressed[0] = true;
                                break block0;
                            }
                            case 51: {
                                this.keysPressed[0] = true;
                                this.keysPressed[3] = true;
                                break block0;
                            }
                            case 55: {
                                this.keysPressed[1] = true;
                                this.keysPressed[2] = true;
                                break block0;
                            }
                            case 56: {
                                this.keysPressed[1] = true;
                                break block0;
                            }
                            case 57: {
                                this.keysPressed[1] = true;
                                this.keysPressed[3] = true;
                                break block0;
                            }
                            case 52: {
                                this.keysPressed[2] = true;
                                break block0;
                            }
                            case 54: {
                                this.keysPressed[3] = true;
                            }
                        }
                    }
                }
            }
        }
    }

    public void keyReleased(int n) {
        int n2 = this.getGameAction(n);
        block0 : switch (n2) {
            case 1: {
                this.keysPressed[0] = false;
                break;
            }
            case 6: {
                this.keysPressed[1] = false;
                break;
            }
            case 2: {
                this.keysPressed[2] = false;
                break;
            }
            case 5: {
                this.keysPressed[3] = false;
                break;
            }
            default: {
                switch (n) {
                    case 49: {
                        this.keysPressed[0] = false;
                        this.keysPressed[2] = false;
                        break block0;
                    }
                    case 50: {
                        this.keysPressed[0] = false;
                        break block0;
                    }
                    case 51: {
                        this.keysPressed[0] = false;
                        this.keysPressed[3] = false;
                        break block0;
                    }
                    case 55: {
                        this.keysPressed[1] = false;
                        this.keysPressed[2] = false;
                        break block0;
                    }
                    case 56: {
                        this.keysPressed[1] = false;
                        break block0;
                    }
                    case 57: {
                        this.keysPressed[1] = false;
                        this.keysPressed[3] = false;
                        break block0;
                    }
                    case 52: {
                        this.keysPressed[2] = false;
                        break block0;
                    }
                    case 54: {
                        this.keysPressed[3] = false;
                    }
                }
            }
        }
    }

    public String[] parseString(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != ',') continue;
            ++n;
        }
        String[] stringArray = new String[n + 1];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = string.substring(0, string.indexOf(44));
            string = string.substring(string.indexOf(44) + 1);
        }
        stringArray[n] = string;
        return stringArray;
    }

    public void drawText(Graphics graphics, String[] stringArray, Font font, boolean bl, int n, int n2) {
        Font[] fontArray = new Font[stringArray.length];
        for (int i = 0; i < fontArray.length; ++i) {
            fontArray[i] = font;
        }
        this.drawText(graphics, stringArray, fontArray, bl, n, n2);
    }

    public void drawText(Graphics graphics, String[] stringArray, Font[] fontArray, boolean bl, int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            graphics.setFont(fontArray[n3]);
            n5 = Math.max(fontArray[n3].stringWidth(stringArray[n3]), n5);
            n7 += fontArray[n3].getHeight();
        }
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(n - n5 / 2 - 1, n2 - 2, n5 + 2, n7 + 1);
        graphics.setColor(0);
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            n4 = fontArray[n3].stringWidth(stringArray[n3]);
            graphics.setFont(fontArray[n3]);
            graphics.drawString(stringArray[n3], n, n2 + n6, 17);
            n6 += fontArray[n3].getHeight();
        }
        if (bl) {
            graphics.drawRect(n - n5 / 2 - 1, n2 - 2, n5 + 2, n7 + 1);
        }
    }
}

