/*
 * Decompiled with CFR 0.152.
 */
package gpong;

import gpong.Ball;
import gpong.Config;
import gpong.Level;
import gpong.PongCanvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Brick {
    private static final int P1 = 1;
    private static final int P2 = 2;
    private static final int P3 = 3;
    private static final int P4 = 4;
    public static int width;
    public static int height;
    private int xPos;
    private int yPos;
    public int xi;
    public int yi;
    private int p1x;
    private int p2x;
    private int p3x;
    private int p4x;
    private int p1y;
    private int p2y;
    private int p3y;
    private int p4y;
    private int liveCounter;

    public Brick(PongCanvas pc, int x, int y, int live, int xindex, int yindex) {
        width = Config.BRICKWIDTH;
        height = Config.BRICKHEIGHT;
        this.xPos = x;
        this.yPos = y;
        this.liveCounter = live;
        this.xi = xindex;
        this.yi = yindex;
    }

    public void decLive() {
        --this.liveCounter;
    }

    public int getLives() {
        return this.liveCounter;
    }

    public void paint(Graphics g, int xo, int yo) {
        Image im = Level.getImage(this.liveCounter);
        if (im != null) {
            g.drawImage(im, this.xPos + xo, this.yPos + yo, 20);
        }
    }

    public boolean collision(int x, int y) {
        return this.liveCounter != 0 && this.p1x < x && this.p4x > x && this.p1y < y && this.p4y > y;
    }

    public boolean collision(Ball b, int xo, int yo) {
        this.p1x = this.xPos + xo;
        this.p1y = this.yPos + yo;
        this.p2x = this.xPos + xo + Config.BRICKWIDTH;
        this.p2y = this.yPos + yo;
        this.p3x = this.xPos + xo;
        this.p3y = this.yPos + yo + Config.BRICKHEIGHT;
        this.p4x = this.xPos + xo + Config.BRICKWIDTH;
        this.p4y = this.yPos + yo + Config.BRICKHEIGHT;
        if (this.collision(b.getX() + Config.RADIUS / 2, b.getY() + Config.RADIUS)) {
            b.setDy(-Ball.step);
            return true;
        }
        if (this.collision(b.getX() + Config.RADIUS / 2, b.getY())) {
            b.setDy(Ball.step);
            return true;
        }
        if (this.collision(b.getX(), b.getY() + Config.RADIUS / 2)) {
            b.setDx(Ball.step);
            return true;
        }
        if (this.collision(b.getX() + Config.RADIUS + Config.RADIUS / 2, b.getY())) {
            b.setDx(-Ball.step);
            return true;
        }
        return false;
    }

    static {
        P1 = 1;
        P2 = 2;
        P3 = 3;
        P4 = 4;
    }
}

