/*
 * Decompiled with CFR 0.152.
 */
package gpong;

import gpong.Config;
import gpong.Config_generic;
import gpong.HotShot;
import gpong.PongCanvas;
import gpong.PongOptDisplay;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import whl.gui.DisplayScore;
import whl.gui.WaitDialog;

public class PongDisplayable
extends Canvas {
    Image logo;
    private Command start = new Command("Start", 2, 1);
    private Command getg = new Command("Global Scores", 8, 2);
    private Command getl = new Command("Local Scores", 8, 2);
    private Command sync = new Command("Sync Score", 8, 2);
    private Command opt = new Command("Options", 4, 1);
    private Command exit = new Command("Exit", 7, 1);
    private Command about = new Command("About", 8, 1);
    private PongOptDisplay optDisplay;
    private HotShot midlet;

    public PongDisplayable(HotShot p) {
        HotShot.config = new Config(this);
        this.midlet = p;
        this.optDisplay = new PongOptDisplay(p);
        this.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                PongDisplayable.this.this_commandPerformed(c, d);
            }
        });
        try {
            this.logo = Image.createImage((String)String.valueOf(String.valueOf(Config.RESOURCE)).concat("world.png"));
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.addCommand(this.start);
        this.addCommand(this.opt);
        this.addCommand(this.getl);
        this.addCommand(this.getg);
        this.addCommand(this.sync);
        if (!Config_generic.REGISTERED) {
            this.addCommand(this.about);
        }
        if (Config.EXITBUTTON) {
            this.addCommand(this.exit);
        }
    }

    public void this_commandPerformed(Command c, Displayable d) {
        WaitDialog wd;
        if (c == this.exit) {
            HotShot.quitApp();
        }
        if (c == this.start) {
            this.midlet.pCanvas = new PongCanvas(this.midlet);
            this.midlet.pCanvas.startThread();
            Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this.midlet.pCanvas);
        }
        if (c == this.getl) {
            DisplayScore ds = new DisplayScore(this.midlet.localList, this.midlet, this);
            ds.setListName("Local Scores");
            Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)ds);
        }
        if (c == this.getg) {
            wd = new WaitDialog(Display.getDisplay((MIDlet)this.midlet), "Load Global List", 0);
            wd.setDialogListener(this.midlet);
            wd.display();
            this.midlet.globalList.setGauge(wd.gauge);
            this.midlet.globalList.read();
        }
        if (c == this.sync) {
            wd = new WaitDialog(Display.getDisplay((MIDlet)this.midlet), "Sync List", 0);
            wd.setDialogListener(this.midlet);
            wd.display();
            this.midlet.localList.setGauge(wd.gauge);
            this.midlet.localList.sync(this.midlet.globalList, Config_generic.REGISTERED);
        }
        if (c == this.opt) {
            this.optDisplay.toMain = true;
            Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this.optDisplay);
        }
        if (c == this.about) {
            Alert a = new Alert("About", "HotShot unregistered Version !Please register at www.joerg-tuttas.de", null, AlertType.INFO);
            a.setTimeout(-2);
            Display.getDisplay((MIDlet)this.midlet).setCurrent(a, (Displayable)this);
        }
    }

    public void paint(Graphics g) {
        g.setColor(255, 255, 255);
        g.fillRect(0, 0, g.getClipWidth(), g.getClipHeight());
        g.drawImage(this.logo, Config.SCREENWIDTH / 2, Config.HEIGHT / 2, 3);
    }
}

