/*
 * Decompiled with CFR 0.152.
 */
package gpong;

import gpong.Ball;
import gpong.Config;
import gpong.Level;
import gpong.PongCanvas;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Player {
    static Random random = new Random();
    private static int width;
    private Image pImage;
    private static int step;
    private int x;
    private int y;
    private PongCanvas pCanvas;

    public Player(PongCanvas pc) {
        int xRandomPos;
        this.pCanvas = pc;
        this.x = xRandomPos = (random.nextInt() >>> 1) % (Config.WIDTH - Config.PANELWIDTH - Config.PLAYERWIDTH);
        this.y = Config.HEIGHT - Config.PLAYERHIGHT - 1;
        width = pc.playerWidth;
        this.pImage = Image.createImage((int)pc.playerWidth, (int)pc.playerHeight);
        Level.create3DImage(this.pImage, 0, 0, 255, 1, Config.PLAYERWIDTH, Config.PLAYERHIGHT);
    }

    public int getY() {
        return this.y;
    }

    protected void paint(Graphics g) {
        g.drawImage(this.pImage, this.x, this.y, 20);
    }

    public void moveLeft() {
        this.x -= step;
        if (this.x < 0) {
            this.x = 0;
        }
    }

    public int getX() {
        return this.x;
    }

    public void moveRight() {
        this.x += step;
        if (this.x > Config.WIDTH - Config.PANELWIDTH - this.pImage.getWidth()) {
            this.x = Config.WIDTH - Config.PANELWIDTH - this.pImage.getWidth();
        }
    }

    public boolean checkCollision(Ball b) {
        return b.lives == 0 && b.getX() + b.getR() / 2 >= this.x && b.getX() + b.getR() / 2 < this.x + width && b.getY() + b.getR() >= this.y;
    }

    static {
        step = Config.PLAYERSPEED;
    }
}

