/*
 * Decompiled with CFR 0.152.
 */
package gpong;

import gpong.Ball;
import gpong.Brick;
import gpong.Config;
import gpong.Config_generic;
import gpong.HotShot;
import gpong.InterrupAnimation;
import gpong.Level;
import gpong.Player;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import whl.Score;

public class PongCanvas
extends Canvas
implements Runnable {
    Thread runner;
    private Image offscreen = null;
    private Graphics saved;
    private Ball tmpBall;
    private Brick tmpBrick;
    public int gameWidth;
    public int gameHeight;
    public int brickWidth;
    public int brickHeight;
    public int playerWidth;
    public int playerHeight;
    public int ballRadius;
    public int centerX;
    public int centerY;
    private Command abort = new Command("Abort", 8, 1);
    public HotShot midlet;
    private Vector ballVector;
    public Player player;
    public Level level;
    private InterrupAnimation iAnimation;
    private String animationMsg;

    public PongCanvas(HotShot p) {
        this.midlet = p;
        this.offscreen = Image.createImage((int)Config.WIDTH, (int)Config.HEIGHT);
        this.centerX = (Config.WIDTH - Config.PANELWIDTH) / 2;
        this.centerY = Config.HEIGHT / 2;
        this.brickWidth = Config.BRICKWIDTH;
        this.brickHeight = Config.BRICKHEIGHT;
        this.gameWidth = this.brickWidth * 5;
        this.gameHeight = this.brickHeight * 4;
        this.ballRadius = this.brickHeight;
        this.playerHeight = this.brickHeight;
        this.playerWidth = Config.PLAYERWIDTH;
        this.player = new Player(this);
        this.level = new Level(this);
        this.newBalls();
        this.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                PongCanvas.this.this_commandPerformed(c, d);
            }
        });
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void newBalls() {
        int wait = 0;
        this.ballVector = new Vector();
        for (int i = 0; i < this.level.getBalls(); ++i) {
            this.ballVector.addElement(new Ball(this, wait));
            wait += 100;
        }
    }

    private void jbInit() throws Exception {
        this.addCommand(this.abort);
    }

    public void this_commandPerformed(Command c, Displayable d) {
        if (c == this.abort) {
            this.stopThread();
            int ranking = this.midlet.localList.add(new Score(this.level.score, this.midlet.user.name, this.midlet.user.location));
            if (ranking != 10) {
                HotShot.alert = new Alert("New Highscore", "You take place: #".concat(String.valueOf(String.valueOf(ranking))), null, AlertType.INFO);
                HotShot.alert.setTimeout(-2);
                Display.getDisplay((MIDlet)this.midlet).setCurrent(HotShot.alert, (Displayable)this.midlet.displayable);
            } else {
                Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this.midlet.displayable);
            }
        }
    }

    public void startThread() {
        if (this.runner == null) {
            this.runner = new Thread(this);
            this.runner.setPriority(10);
            this.runner.start();
        }
    }

    public void stopThread() {
        if (this.runner != null) {
            this.runner = null;
        }
    }

    protected void paint(Graphics g) {
        int i;
        this.saved = g;
        if (this.offscreen != null) {
            g = this.offscreen.getGraphics();
        }
        g.drawImage(this.level.getImage(), 0, 0, 20);
        if (this.iAnimation == null) {
            this.level.paintField(g);
            for (i = 0; i < this.ballVector.size(); ++i) {
                this.tmpBall = (Ball)this.ballVector.elementAt(i);
                this.tmpBall.paint(g);
            }
            this.player.paint(g);
            this.checkCollision();
        } else {
            this.iAnimation.paint(g);
        }
        for (i = 0; i < this.ballVector.size(); ++i) {
            this.tmpBall = (Ball)this.ballVector.elementAt(i);
            if (!this.tmpBall.isOutOfRange()) continue;
            this.level.decLives();
            if (this.level.gameOver()) {
                if (this.level.score != (long)0) {
                    int ranking = this.midlet.localList.add(new Score(this.level.score, this.midlet.user.name, this.midlet.user.location));
                    this.animationMsg = ranking != 10 ? "Rank #".concat(String.valueOf(String.valueOf(ranking))) : "No Rank";
                } else {
                    this.animationMsg = "No Rank";
                }
                this.iAnimation = new InterrupAnimation("Game Over", this.animationMsg, this.gameWidth + 4, Config.HEIGHT / 4, this.centerX, Config.HEIGHT / 2);
                this.newBalls();
                continue;
            }
            this.iAnimation = new InterrupAnimation("Lost Live", "Lives #".concat(String.valueOf(String.valueOf(this.level.lives))), this.gameWidth - 2, Config.HEIGHT / 4, this.centerX, Config.HEIGHT / 2);
            this.newBalls();
        }
        if (this.level.nextLevel() && this.iAnimation == null) {
            this.iAnimation = new InterrupAnimation("Next Level", Integer.toString(this.level.getLevel() + 1), this.gameWidth + 2, Config.HEIGHT / 4, this.centerX, Config.HEIGHT / 2);
        }
        if (g != this.saved) {
            this.saved.drawImage(this.offscreen, 0, 0, 20);
        }
    }

    private void checkCollision() {
        for (int i = 0; i < this.ballVector.size(); ++i) {
            this.tmpBall = (Ball)this.ballVector.elementAt(i);
            this.tmpBrick = this.level.collision(this.tmpBall);
            if (this.tmpBrick != null) {
                this.tmpBall.move();
                this.tmpBrick.decLive();
                this.level.incScore(10);
                Config.ping();
                if (this.tmpBrick.getLives() == 0) {
                    this.level.removeBricks(this.tmpBrick);
                }
            }
            if (!this.player.checkCollision(this.tmpBall)) continue;
            this.tmpBall.setDy(-Ball.step);
            Config.pong();
        }
    }

    public void keyPressed(int keyCode) {
        int action = this.getGameAction(keyCode);
        if (this.iAnimation != null) {
            if (this.iAnimation.isFinished()) {
                this.iAnimation = null;
                if (this.level.gameOver()) {
                    this.stopThread();
                    Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this.midlet.displayable);
                }
                if (this.level.nextLevel()) {
                    if (!Config_generic.REGISTERED) {
                        Alert a = new Alert("Shareware", "HotShot unregistered Version !Please register at www.joerg-tuttas.de", null, AlertType.INFO);
                        a.setTimeout(-2);
                        Display.getDisplay((MIDlet)this.midlet).setCurrent(a, (Displayable)this.midlet.displayable);
                    } else {
                        this.level.incLevel();
                    }
                }
                this.newBalls();
            }
        } else {
            switch (action) {
                case 1: {
                    this.fireBall();
                    break;
                }
                case 6: {
                    this.fireBall();
                    break;
                }
                case 2: {
                    this.player.moveLeft();
                    break;
                }
                case 5: {
                    this.player.moveRight();
                }
            }
        }
    }

    private void fireBall() {
        for (int i = 0; i < this.ballVector.size(); ++i) {
            this.tmpBall = (Ball)this.ballVector.elementAt(i);
            if (this.tmpBall.lives >= 99) continue;
            this.tmpBall.fire();
        }
    }

    public void run() {
        Thread thisThread = Thread.currentThread();
        while (this.runner == thisThread) {
            this.repaint();
            try {
                Thread.sleep(this.midlet.user.speed);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

