/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.sound.Sound;
import com.nokia.mid.ui.DeviceControl;
import java.io.InputStream;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class WarBoard
extends Canvas {
    public static final int MODE_CLASSIC = 0;
    public static final int MODE_CASINO = 1;
    private static final Random RANDOM = new Random();
    private War war;
    private boolean gameOver;
    private boolean isIden = false;
    boolean soundEnabled = true;
    private Sound nokiaSound;
    private byte[] bonusSound;
    private byte[] warningSound;
    private int bottomMargin;
    private int scoreBarWidth;
    private int scoreBarHeight;
    private Image offscreen;
    private Image fontImg;
    private Image bgClassicImg;
    private Image bgCasinoImg;
    private Image titleClassicImg;
    private Image titleCasinoImg;
    private Image youImg;
    private Image dealerImg;
    private Image betImg;
    private Image dollarImg;
    private Image scoreBarImg1;
    private Image scoreBarImg2;
    private Image winImg;
    private Image cardBackImg;
    private Font font = Font.getFont((int)Font.getDefaultFont().getFace(), (int)0, (int)8);
    private String boardMessage;
    private Vector fullHand = new Vector(52);
    private Vector warStackCards = new Vector(2);
    private Vector dealerHand = new Vector(26);
    private Vector playerHand = new Vector(26);
    private Card currentDealerCard;
    private Card currentPlayerCard;
    private int warCounter;
    int mode = 0;
    private int currentBet;
    int score;
    private boolean isColor;

    public WarBoard(War war) {
        this.war = war;
        this.isColor = Display.getDisplay((MIDlet)war).isColor();
        try {
            this.isIden = "PTT".equals(this.getKeyName(-50));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.bottomMargin = this.isIden ? 12 : 1;
        this.offscreen = Image.createImage((int)this.getWidth(), (int)this.getHeight());
        try {
            Class.forName("com.nokia.mid.sound.SoundListener");
            this.nokiaSound = new Sound(0, 1L);
            this.bonusSound = this.loadSound("/bonus.ott");
            this.warningSound = this.loadSound("/warning.ott");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.bgClassicImg = Image.createImage((String)"/bg_classic.png");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.bgCasinoImg = Image.createImage((String)"/bg_casino.png");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.titleClassicImg = Image.createImage((String)"/title_classic.png");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.titleCasinoImg = Image.createImage((String)"/title_casino.png");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.fontImg = Image.createImage((String)"/font.png");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.youImg = Image.createImage((String)"/you.png");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.dealerImg = Image.createImage((String)"/dealer.png");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.betImg = Image.createImage((String)"/bet.png");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.dollarImg = Image.createImage((String)"/dollar.png");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.cardBackImg = Image.createImage((String)"/card_back.png");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.getHeight() > 140) {
            Card.WIDTH = 20;
            Card.HEIGHT = 24;
        } else if (this.getHeight() > 90) {
            Card.WIDTH = 18;
            Card.HEIGHT = 22;
        }
        this.computeDimensions();
        if (this.scoreBarWidth > this.getWidth() || this.getHeight() < 90) {
            try {
                this.youImg = Image.createImage((String)"/you_sm.png");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.dealerImg = Image.createImage((String)"/dealer_sm.png");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.betImg = Image.createImage((String)"/bet_sm.png");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.dollarImg = Image.createImage((String)"/dollar_sm.png");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.computeDimensions();
        }
        int n = 2;
        while (n < 15) {
            int n2 = 1;
            while (n2 < 5) {
                this.fullHand.addElement(new Card(this, n, n2));
                ++n2;
            }
            ++n;
        }
    }

    private void computeDimensions() {
        this.scoreBarWidth = Math.max(this.youImg.getWidth(), this.dollarImg.getWidth()) + 5 + 30 + 2 + Math.max(this.dealerImg.getWidth(), this.betImg.getWidth()) + 5 + 12;
        this.scoreBarHeight = Math.max(Math.max(this.youImg.getHeight(), this.dollarImg.getHeight()), Math.max(this.dealerImg.getHeight(), this.betImg.getHeight())) + 2;
    }

    public void startClassic() {
        this.reset();
        this.mode = 0;
        this.scoreBarImg1 = this.youImg;
        this.scoreBarImg2 = this.dealerImg;
        WarBoard.shuffle(this.fullHand);
        int n = 0;
        while (n < 26) {
            this.dealerHand.addElement(this.fullHand.elementAt(n));
            ++n;
        }
        int n2 = 26;
        while (n2 < 52) {
            this.playerHand.addElement(this.fullHand.elementAt(n2));
            ++n2;
        }
    }

    public void startCasino() {
        this.reset();
        this.mode = 1;
        this.scoreBarImg1 = this.dollarImg;
        this.scoreBarImg2 = this.betImg;
        int n = 0;
        while (n < 52) {
            int n2 = 0;
            while (n2 < 4) {
                this.dealerHand.addElement(this.fullHand.elementAt(n));
                ++n2;
            }
            ++n;
        }
        WarBoard.shuffle(this.dealerHand);
    }

    private void reset() {
        this.gameOver = false;
        this.winImg = null;
        this.boardMessage = null;
        this.warCounter = 0;
        this.currentBet = 10;
        if (this.score <= 0) {
            this.score = 100;
        }
        this.dealerHand.removeAllElements();
        this.playerHand.removeAllElements();
        this.warStackCards.removeAllElements();
        this.currentDealerCard = null;
        this.currentPlayerCard = null;
    }

    private void playBonusSound() {
        if (!this.soundEnabled) {
            return;
        }
        if (this.nokiaSound != null) {
            this.playSound(this.bonusSound);
        } else {
            AlertType.CONFIRMATION.playSound(Display.getDisplay((MIDlet)this.war));
        }
    }

    private void playWarningSound() {
        if (!this.soundEnabled) {
            return;
        }
        if (this.nokiaSound != null) {
            this.playSound(this.warningSound);
        } else {
            AlertType.WARNING.playSound(Display.getDisplay((MIDlet)this.war));
        }
    }

    protected void playSound(byte[] byArray) {
        try {
            if (this.nokiaSound != null && byArray != null) {
                this.nokiaSound.init(byArray, 1);
                this.nokiaSound.play(1);
            }
        }
        catch (Throwable throwable) {}
    }

    protected byte[] loadSound(String string) throws Exception {
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(string);
        byte[] byArray = new byte[256];
        int n = inputStream.read(byArray);
        inputStream.close();
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    public void paint(Graphics graphics) {
        Graphics graphics2 = graphics;
        if (this.offscreen != null) {
            graphics = this.offscreen.getGraphics();
        }
        graphics.setFont(this.font);
        this.clear(graphics);
        this.drawBoard(graphics);
        graphics.setColor(0);
        graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - this.bottomMargin + (this.isIden ? 1 : 0));
        if (this.offscreen != null) {
            graphics2.drawImage(this.offscreen, 0, 0, 20);
        }
    }

    private void clear(Graphics graphics) {
        Image image;
        if (this.isColor) {
            Image image2 = image = this.mode == 0 ? this.bgClassicImg : this.bgCasinoImg;
            if (image != null) {
                int n = 0;
                while (n < this.getWidth()) {
                    int n2 = 0;
                    while (n2 < this.getHeight()) {
                        graphics.drawImage(image, n, n2, 20);
                        n2 += image.getHeight();
                    }
                    n += image.getWidth();
                }
            } else {
                graphics.setColor(0, 255, 0);
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        } else {
            graphics.setColor(255, 255, 255);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.winImg != null) {
            graphics.drawImage(this.winImg, this.getWidth() / 2, (this.getHeight() - this.bottomMargin + this.scoreBarHeight) / 2, 3);
        }
        Image image3 = image = this.mode == 0 ? this.titleClassicImg : this.titleCasinoImg;
        if (image != null) {
            graphics.drawImage(image, this.getWidth() / 2, (this.getHeight() - this.bottomMargin + this.scoreBarHeight) / 2 + (this.mode == 1 ? 3 : 0), 3);
        }
    }

    private void drawBoard(Graphics graphics) {
        int n;
        if (this.isColor) {
            graphics.setColor(64, 255, 255);
            graphics.fillRect(1, 1, this.getWidth() - 2, this.scoreBarHeight);
        }
        graphics.drawImage(this.scoreBarImg1, 1, 1, 20);
        String string = Integer.toString(this.mode == 0 ? this.playerHand.size() : this.score);
        int n2 = 0;
        while (n2 < string.length()) {
            int n3 = string.charAt(n2) - 48;
            graphics.setClip(this.scoreBarImg1.getWidth() + 5 + n2 * 6, 2, 6, 7);
            graphics.drawImage(this.fontImg, this.scoreBarImg1.getWidth() + 5 + n2 * 6 - n3 * 6, 2, 20);
            ++n2;
        }
        graphics.setClip(0, 0, this.getWidth(), this.getHeight());
        graphics.drawImage(this.scoreBarImg2, this.scoreBarImg1.getWidth() + 5 + 30 + 2, 1, 20);
        String string2 = Integer.toString(this.mode == 0 ? this.dealerHand.size() : this.currentBet);
        int n4 = 0;
        while (n4 < string2.length()) {
            n = string2.charAt(n4) - 48;
            graphics.setClip(this.scoreBarImg1.getWidth() + 5 + 30 + 2 + this.scoreBarImg2.getWidth() + 5 + n4 * 6, 2, 6, 7);
            graphics.drawImage(this.fontImg, this.scoreBarImg1.getWidth() + 5 + 30 + 2 + this.scoreBarImg2.getWidth() + 5 + n4 * 6 - n * 6, 2, 20);
            ++n4;
        }
        graphics.setClip(0, 0, this.getWidth(), this.getHeight());
        n = 0;
        while (n < this.dealerHand.size()) {
            if (this.isColor) {
                graphics.setColor(107, 107, 255);
            } else {
                graphics.setColor(255, 255, 255);
            }
            graphics.fillRoundRect(Card.WIDTH * n, this.scoreBarHeight + 1, Card.WIDTH, Card.HEIGHT, 4, 4);
            if (this.isColor) {
                graphics.drawImage(this.cardBackImg, Card.WIDTH * n + Card.WIDTH / 2, this.scoreBarHeight + 1 + Card.HEIGHT / 2, 3);
            }
            graphics.setColor(0);
            graphics.drawRoundRect(Card.WIDTH * n, this.scoreBarHeight + 1, Card.WIDTH, Card.HEIGHT, 4, 4);
            ++n;
        }
        int n5 = 0;
        if (this.mode == 0) {
            n5 = (this.warStackCards.size() - 2) / 2;
        } else if (this.warCounter > 0) {
            n5 = this.warCounter;
        }
        int n6 = 0;
        while (n6 < n5) {
            if (this.isColor) {
                graphics.setColor(107, 107, 255);
            } else {
                graphics.setColor(255, 255, 255);
            }
            graphics.fillRoundRect(this.getWidth() / 2 - Card.WIDTH / 2, Math.min(this.scoreBarHeight + 1 + (n6 + 1) * Card.HEIGHT / 4, this.getHeight() - this.bottomMargin - Card.HEIGHT), Card.WIDTH, Card.HEIGHT, 4, 4);
            if (this.isColor) {
                graphics.drawImage(this.cardBackImg, this.getWidth() / 2, Math.min(this.scoreBarHeight + 1 + (n6 + 1) * Card.HEIGHT / 4, this.getHeight() - this.bottomMargin - Card.HEIGHT) + Card.HEIGHT / 2, 3);
            }
            graphics.setColor(0);
            graphics.drawRoundRect(this.getWidth() / 2 - Card.WIDTH / 2, Math.min(this.scoreBarHeight + 1 + (n6 + 1) * Card.HEIGHT / 4, this.getHeight() - this.bottomMargin - Card.HEIGHT), Card.WIDTH, Card.HEIGHT, 4, 4);
            ++n6;
        }
        int n7 = 0;
        while (n7 < this.playerHand.size()) {
            if (this.isColor) {
                graphics.setColor(107, 107, 255);
            } else {
                graphics.setColor(255, 255, 255);
            }
            graphics.fillRoundRect(Card.WIDTH * n7, this.getHeight() - this.bottomMargin - Card.HEIGHT, Card.WIDTH, Card.HEIGHT, 4, 4);
            if (this.isColor) {
                graphics.drawImage(this.cardBackImg, Card.WIDTH * n7 + Card.WIDTH / 2, this.getHeight() - this.bottomMargin - Card.HEIGHT / 2, 3);
            }
            graphics.setColor(0);
            graphics.drawRoundRect(Card.WIDTH * n7, this.getHeight() - this.bottomMargin - Card.HEIGHT, Card.WIDTH, Card.HEIGHT, 4, 4);
            ++n7;
        }
        int n8 = 0;
        while (n8 < n5) {
            if (this.isColor) {
                graphics.setColor(107, 107, 255);
            } else {
                graphics.setColor(255, 255, 255);
            }
            graphics.fillRoundRect(this.getWidth() / 2 - Card.WIDTH / 2, Math.max(this.getHeight() - this.bottomMargin - Card.HEIGHT - (n8 + 1) * Card.HEIGHT / 4, this.scoreBarHeight + 1), Card.WIDTH, Card.HEIGHT, 4, 4);
            if (this.isColor) {
                graphics.drawImage(this.cardBackImg, this.getWidth() / 2, Math.max(this.getHeight() - this.bottomMargin - Card.HEIGHT - (n8 + 1) * Card.HEIGHT / 4, this.scoreBarHeight + 1) + Card.HEIGHT / 2, 3);
            }
            graphics.setColor(0);
            graphics.drawRoundRect(this.getWidth() / 2 - Card.WIDTH / 2, Math.max(this.getHeight() - this.bottomMargin - Card.HEIGHT - (n8 + 1) * Card.HEIGHT / 4, this.scoreBarHeight + 1), Card.WIDTH, Card.HEIGHT, 4, 4);
            ++n8;
        }
        if (this.currentDealerCard != null) {
            this.currentDealerCard.paint(graphics, this.getWidth() / 2 - Card.WIDTH / 2, this.scoreBarHeight + 1);
        }
        if (this.currentPlayerCard != null) {
            this.currentPlayerCard.paint(graphics, this.getWidth() / 2 - Card.WIDTH / 2, this.getHeight() - this.bottomMargin - Card.HEIGHT);
        }
        if (this.boardMessage != null) {
            int n9 = graphics.getFont().stringWidth(this.boardMessage);
            graphics.setColor(32, 32, 32);
            graphics.fillRoundRect(this.getWidth() / 2 - n9 / 2 - 1, (this.getHeight() - this.bottomMargin + this.scoreBarHeight) / 2 - graphics.getFont().getHeight() / 2 - 1, n9 + 6, graphics.getFont().getHeight() + 6, 4, 4);
            graphics.setColor(255, 255, 255);
            graphics.fillRoundRect(this.getWidth() / 2 - n9 / 2 - 3, (this.getHeight() - this.bottomMargin + this.scoreBarHeight) / 2 - graphics.getFont().getHeight() / 2 - 3, n9 + 6, graphics.getFont().getHeight() + 6, 4, 4);
            graphics.setColor(0);
            graphics.drawString(this.boardMessage, this.getWidth() / 2, (this.getHeight() - this.bottomMargin + this.scoreBarHeight) / 2 - graphics.getFont().getHeight() / 2, 17);
        }
    }

    private void showBoardMessage(String string) {
        this.boardMessage = string;
        this.repaint();
        this.serviceRepaints();
        try {
            Thread.currentThread();
            Thread.sleep(1500L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.boardMessage = null;
        this.repaint();
        this.serviceRepaints();
    }

    protected void pointerPressed(int n, int n2) {
        if (this.gameOver) {
            return;
        }
        if (this.mode == 0) {
            this.playClassicRound();
        } else if (this.mode == 1) {
            this.playCasinoRound();
        }
    }

    protected void keyPressed(int n) {
        if (this.gameOver) {
            return;
        }
        if (this.getGameAction(n) == 1) {
            if (this.currentBet + 10 <= this.score) {
                this.currentBet += 10;
            }
        } else if (this.getGameAction(n) == 6) {
            if (this.currentBet > 10) {
                this.currentBet -= 10;
            }
        } else if (this.getGameAction(n) == 8) {
            if (this.mode == 0) {
                this.playClassicRound();
            } else if (this.mode == 1) {
                this.playCasinoRound();
            }
        }
        this.repaint();
        this.serviceRepaints();
    }

    private void showGameOver(boolean bl) {
        this.gameOver = true;
        if (bl) {
            try {
                this.winImg = Image.createImage((String)(this.mode == 0 ? "/win_classic.png" : "/win_casino.png"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.soundEnabled) {
            try {
                if (this.nokiaSound != null) {
                    this.playWarningSound();
                    DeviceControl.startVibra(75, 250L);
                    DeviceControl.flashLights(200L);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.boardMessage = War.rb.getString("gameover.title");
        this.repaint();
        this.serviceRepaints();
    }

    public void playClassicRound() {
        if (this.gameOver) {
            return;
        }
        this.currentPlayerCard = (Card)this.playerHand.elementAt(0);
        this.playerHand.removeElementAt(0);
        this.warStackCards.addElement(this.currentPlayerCard);
        this.currentDealerCard = (Card)this.dealerHand.elementAt(0);
        this.dealerHand.removeElementAt(0);
        this.warStackCards.addElement(this.currentDealerCard);
        if (this.currentPlayerCard.rank > this.currentDealerCard.rank) {
            int n = 0;
            while (n < this.warStackCards.size()) {
                this.playerHand.addElement(this.warStackCards.elementAt(n));
                ++n;
            }
            this.warStackCards.removeAllElements();
            this.warCounter = 0;
            this.playBonusSound();
            this.showBoardMessage(War.rb.getString("play.youWin"));
            if (this.dealerHand.size() == 0) {
                this.showGameOver(true);
            }
        } else if (this.currentPlayerCard.rank < this.currentDealerCard.rank) {
            int n = 0;
            while (n < this.warStackCards.size()) {
                this.dealerHand.addElement(this.warStackCards.elementAt(n));
                ++n;
            }
            this.warStackCards.removeAllElements();
            this.warCounter = 0;
            this.playWarningSound();
            this.showBoardMessage(War.rb.getString("play.youLose"));
            if (this.playerHand.size() == 0) {
                this.showGameOver(false);
            }
        } else {
            ++this.warCounter;
            this.showBoardMessage(WarBoard.replace(War.rb.getString("play.warRound"), "{0}", Integer.toString(this.warCounter)));
            int n = 0;
            while (n < 3) {
                if (this.dealerHand.size() == 0) {
                    this.showBoardMessage(War.rb.getString("play.youWin"));
                    this.showGameOver(true);
                    return;
                }
                Card card = (Card)this.dealerHand.elementAt(0);
                this.dealerHand.removeElementAt(0);
                this.warStackCards.addElement(card);
                if (this.playerHand.size() == 0) {
                    this.showBoardMessage(War.rb.getString("play.youLose"));
                    this.showGameOver(false);
                    return;
                }
                Card card2 = (Card)this.playerHand.elementAt(0);
                this.playerHand.removeElementAt(0);
                this.warStackCards.addElement(card);
                this.repaint();
                this.serviceRepaints();
                try {
                    Thread.currentThread();
                    Thread.sleep(500L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ++n;
            }
            this.playClassicRound();
        }
        this.repaint();
        this.serviceRepaints();
    }

    public void playCasinoRound() {
        if (this.gameOver) {
            return;
        }
        this.currentPlayerCard = (Card)this.dealerHand.elementAt(0);
        this.dealerHand.removeElementAt(0);
        this.dealerHand.addElement(this.currentPlayerCard);
        this.currentDealerCard = (Card)this.dealerHand.elementAt(0);
        this.dealerHand.removeElementAt(0);
        this.dealerHand.addElement(this.currentDealerCard);
        if (this.currentPlayerCard.rank > this.currentDealerCard.rank) {
            this.playBonusSound();
            this.showBoardMessage(War.rb.getString("play.youWin"));
            this.score += this.currentBet;
        } else if (this.currentPlayerCard.rank < this.currentDealerCard.rank) {
            this.playWarningSound();
            this.showBoardMessage(War.rb.getString("play.youLose"));
            this.score -= this.currentBet;
            this.currentBet = Math.min(this.score, this.currentBet);
            if (this.score <= 0) {
                this.showGameOver(false);
            }
        } else {
            this.showBoardMessage(War.rb.getString("tie.title"));
            Display.getDisplay((MIDlet)this.war).setCurrent((Displayable)this.war.tieForm);
        }
        this.repaint();
        this.serviceRepaints();
    }

    public void performTieWar() {
        int n = 0;
        while (n < 3) {
            ++this.warCounter;
            this.repaint();
            this.serviceRepaints();
            try {
                Thread.currentThread();
                Thread.sleep(500L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < 4) {
            Card card = (Card)this.dealerHand.elementAt(0);
            this.dealerHand.removeElementAt(0);
            this.dealerHand.addElement(card);
            ++n2;
        }
        this.currentPlayerCard = (Card)this.dealerHand.elementAt(this.dealerHand.size() - 1);
        int n3 = 0;
        while (n3 < 4) {
            Card card = (Card)this.dealerHand.elementAt(0);
            this.dealerHand.removeElementAt(0);
            this.dealerHand.addElement(card);
            ++n3;
        }
        this.currentDealerCard = (Card)this.dealerHand.elementAt(this.dealerHand.size() - 1);
        if (this.currentPlayerCard.rank >= this.currentDealerCard.rank) {
            this.playBonusSound();
            this.showBoardMessage(War.rb.getString("play.youWin"));
            this.score += this.currentBet;
        } else if (this.currentPlayerCard.rank < this.currentDealerCard.rank) {
            this.playWarningSound();
            this.showBoardMessage(War.rb.getString("play.youLose"));
            this.score -= this.currentBet * 2;
            this.currentBet = Math.min(this.score, this.currentBet);
            if (this.score <= 0) {
                this.showGameOver(false);
            }
        }
        this.warCounter = 0;
        this.repaint();
        this.serviceRepaints();
    }

    public void performTieSurrender() {
        this.score -= this.currentBet / 2;
        this.currentBet = Math.min(this.score, this.currentBet);
        this.repaint();
        this.serviceRepaints();
    }

    public void performTieBet() {
        int n = 0;
        while (n < 3) {
            ++this.warCounter;
            this.repaint();
            this.serviceRepaints();
            try {
                Thread.currentThread();
                Thread.sleep(500L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < 4) {
            Card card = (Card)this.dealerHand.elementAt(0);
            this.dealerHand.removeElementAt(0);
            this.dealerHand.addElement(card);
            ++n2;
        }
        this.currentPlayerCard = (Card)this.dealerHand.elementAt(this.dealerHand.size() - 1);
        int n3 = 0;
        while (n3 < 4) {
            Card card = (Card)this.dealerHand.elementAt(0);
            this.dealerHand.removeElementAt(0);
            this.dealerHand.addElement(card);
            ++n3;
        }
        this.currentDealerCard = (Card)this.dealerHand.elementAt(this.dealerHand.size() - 1);
        if (this.currentPlayerCard.rank == this.currentDealerCard.rank) {
            this.playBonusSound();
            this.showBoardMessage(War.rb.getString("play.youWin"));
            this.score += this.currentBet * 10;
        } else {
            this.playWarningSound();
            this.showBoardMessage(War.rb.getString("play.youLose"));
            this.score -= this.currentBet * 10;
            this.currentBet = Math.min(this.score, this.currentBet);
            if (this.score <= 0) {
                this.showGameOver(false);
            }
        }
        this.warCounter = 0;
        this.repaint();
        this.serviceRepaints();
    }

    public static String replace(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null || string.indexOf(string2) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        while (true) {
            int n;
            if ((n = string.indexOf(string2)) == -1) break;
            stringBuffer.append(string.substring(0, n));
            stringBuffer.append(string3);
            string = string.substring(n + string2.length());
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static void shuffle(Vector vector) {
        int n;
        int n2 = n = vector.size();
        while (n2 > 1) {
            int n3 = Math.abs(RANDOM.nextInt()) % n2;
            Object e = vector.elementAt(n2 - 1);
            vector.setElementAt(vector.elementAt(n3), n2 - 1);
            vector.setElementAt(e, n3);
            --n2;
        }
    }
}

