/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.OutputStream;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public class War
extends MIDlet
implements CommandListener,
Runnable {
    static PropertyResourceBundle rb;
    static Image iconImg;
    static Image modeIconImg;
    static Image soundIconImg;
    protected List mainList = new List("", 3);
    private WarBoard board;
    private Command exitCmd;
    private Command quitCmd;
    private Command selectCmd;
    private Command playRoundCmd;
    private boolean showedSplash = false;
    private Displayable pausedDisplayable;
    public boolean initialized = false;
    private boolean expired = false;
    Form tieForm;
    private ChoiceGroup tieChoiceGroup;

    public void run() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        this.board = new WarBoard(this);
        boolean bl = false;
        try {
            bl = "Send".equals(this.board.getKeyName(-14)) || "Enter".equals(this.board.getKeyName(-14));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        rb = PropertyResourceBundle.getBundle("WarStrings", bl);
        try {
            iconImg = Image.createImage((String)"/icon.png");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            modeIconImg = Image.createImage((String)"/icon_mode.png");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            soundIconImg = Image.createImage((String)"/icon_sound.png");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Image image = null;
        try {
            image = Image.createImage((String)"/icon_help.png");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Image image2 = null;
        try {
            image2 = Image.createImage((String)"/icon_about.png");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.quitCmd = new Command(rb.getString("menu.quit"), 2, 4);
        this.exitCmd = new Command(rb.getString("menu.exit"), 7, 99);
        this.selectCmd = new Command(rb.getString("menu.select"), 1, 3);
        this.playRoundCmd = new Command(rb.getString("menu.playRound"), 1, 5);
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)"classicmode", (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(new byte[]{this.board.mode == 0 ? (byte)1 : 0}, 0, 1);
            } else {
                this.board.mode = recordStore.getRecord(1)[0] == 1 ? 0 : 1;
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                recordStore.closeRecordStore();
            }
            catch (Throwable throwable) {}
        }
        try {
            recordStore = RecordStore.openRecordStore((String)"sound", (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(new byte[]{this.board.soundEnabled ? (byte)1 : 0}, 0, 1);
            } else {
                this.board.soundEnabled = recordStore.getRecord(1)[0] == 1;
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                recordStore.closeRecordStore();
            }
            catch (Throwable throwable) {}
        }
        try {
            recordStore = RecordStore.openRecordStore((String)"score", (boolean)true);
            if (recordStore.getNumRecords() > 0) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(recordStore.getRecord(1));
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                this.board.score = dataInputStream.readInt();
                dataInputStream.close();
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                recordStore.closeRecordStore();
            }
            catch (Throwable throwable) {}
        }
        this.board.setCommandListener(this);
        this.board.addCommand(this.quitCmd);
        this.board.addCommand(this.playRoundCmd);
        this.mainList.setTitle(rb.getString("title"));
        this.mainList.setCommandListener((CommandListener)this);
        this.mainList.addCommand(this.selectCmd);
        this.mainList.addCommand(this.exitCmd);
        this.mainList.append(rb.getString("menu.newGame"), iconImg);
        this.mainList.append(this.board.mode == 0 ? rb.getString("menu.classicMode") : rb.getString("menu.casinoMode"), modeIconImg);
        this.mainList.append(this.board.soundEnabled ? rb.getString("menu.soundOff") : rb.getString("menu.soundOn"), soundIconImg);
        this.mainList.append(rb.getString("menu.help"), image);
        this.mainList.append(rb.getString("menu.about"), image2);
        this.tieForm = new Form(rb.getString("tie.title"));
        this.tieForm.setCommandListener((CommandListener)this);
        this.tieForm.addCommand(this.playRoundCmd);
        this.tieChoiceGroup = new ChoiceGroup(null, 1);
        this.tieChoiceGroup.append(rb.getString("menu.casinoWar"), null);
        this.tieChoiceGroup.append(rb.getString("menu.casinoSurrender"), null);
        this.tieChoiceGroup.append(rb.getString("menu.casinoTieBet"), null);
        this.tieForm.append((Item)this.tieChoiceGroup);
        this.initialized = true;
    }

    public void startApp() {
        if (!this.showedSplash) {
            Runnable runnable;
            this.showedSplash = true;
            Image image = null;
            Image image2 = null;
            try {
                image = Image.createImage((String)"/splash.png");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                image2 = Image.createImage((String)"/splash2.png");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            SplashScreen splashScreen = null;
            int n = Integer.parseInt(this.getAppProperty("Splash1-BG-Color") != null ? this.getAppProperty("Splash1-BG-Color") : "00ff00", 16);
            int n2 = Integer.parseInt(this.getAppProperty("Splash1-BG-BW") != null ? this.getAppProperty("Splash1-BG-BW") : "ffffff", 16);
            int n3 = Integer.parseInt(this.getAppProperty("Splash2-BG") != null ? this.getAppProperty("Splash2-BG") : "0", 16);
            if (image2 == null) {
                splashScreen = new SplashScreen(Display.getDisplay((MIDlet)this), (Displayable)this.mainList, image, null, 2500, Display.getDisplay((MIDlet)this).isColor() ? n : n2, this);
            } else {
                runnable = new SplashScreen(Display.getDisplay((MIDlet)this), (Displayable)this.mainList, image2, null, 2500, n3, this);
                splashScreen = new SplashScreen(Display.getDisplay((MIDlet)this), (Displayable)runnable, image, null, 2500, Display.getDisplay((MIDlet)this).isColor() ? n : n2, this);
            }
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)splashScreen);
            runnable = new Thread(this);
            ((Thread)runnable).start();
        } else {
            if (this.pausedDisplayable != null) {
                Display.getDisplay((MIDlet)this).setCurrent(this.pausedDisplayable);
            } else {
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.mainList);
            }
            this.pausedDisplayable = null;
        }
    }

    public void pauseApp() {
        this.pausedDisplayable = Display.getDisplay((MIDlet)this).getCurrent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyApp(boolean bl) {
        if (this.board.score > 0) {
            RecordStore recordStore = null;
            try {
                recordStore = RecordStore.openRecordStore((String)"score", (boolean)true);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream.writeInt(this.board.score);
                dataOutputStream.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                if (recordStore.getNumRecords() == 0) {
                    recordStore.addRecord(byArray, 0, byArray.length);
                } else {
                    recordStore.setRecord(1, byArray, 0, byArray.length);
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.mainList && (command == List.SELECT_COMMAND || command == this.selectCmd)) {
            String string = this.mainList.getString(this.mainList.getSelectedIndex());
            if (string.equals(rb.getString("menu.newGame")) && !this.expired) {
                if (this.board.mode == 0) {
                    this.board.startClassic();
                } else if (this.board.mode == 1) {
                    this.board.startCasino();
                }
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.board);
            } else if (string.equals(rb.getString("menu.classicMode"))) {
                this.setMode(1);
            } else if (string.equals(rb.getString("menu.casinoMode"))) {
                this.setMode(0);
            } else if (string.equals(rb.getString("menu.soundOff"))) {
                this.setSound(false);
            } else if (string.equals(rb.getString("menu.soundOn"))) {
                this.setSound(true);
            } else if (string.equals(rb.getString("menu.help"))) {
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.createHelpAlert());
            } else if (string.equals(rb.getString("menu.about"))) {
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.createAboutAlert());
            }
        } else if (command == this.quitCmd) {
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.mainList);
        } else if (command == this.playRoundCmd) {
            if (displayable == this.board) {
                if (this.board.mode == 0) {
                    this.board.playClassicRound();
                } else if (this.board.mode == 1) {
                    this.board.playCasinoRound();
                }
            } else if (displayable == this.tieForm) {
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.board);
                Thread thread = new Thread(){

                    public void run() {
                        try {
                            Thread.currentThread();
                            Thread.sleep(500L);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        String string = War.this.tieChoiceGroup.getString(War.this.tieChoiceGroup.getSelectedIndex());
                        if (string.equals(rb.getString("menu.casinoWar"))) {
                            War.this.board.performTieWar();
                        } else if (string.equals(rb.getString("menu.casinoSurrender"))) {
                            War.this.board.performTieSurrender();
                        } else if (string.equals(rb.getString("menu.casinoTieBet"))) {
                            War.this.board.performTieBet();
                        }
                    }
                };
                thread.start();
            }
        } else if (command == this.exitCmd) {
            this.destroyApp(false);
            this.notifyDestroyed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMode(int n) {
        this.board.mode = n;
        this.mainList.set(1, n == 0 ? rb.getString("menu.classicMode") : rb.getString("menu.casinoMode"), modeIconImg);
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)"classicmode", (boolean)true);
            recordStore.setRecord(1, new byte[]{n == 0 ? (byte)1 : 0}, 0, 1);
            recordStore.closeRecordStore();
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                recordStore.closeRecordStore();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSound(boolean bl) {
        this.board.soundEnabled = bl;
        this.mainList.set(2, bl ? rb.getString("menu.soundOff") : rb.getString("menu.soundOn"), soundIconImg);
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)"sound", (boolean)true);
            recordStore.setRecord(1, new byte[]{bl ? (byte)1 : 0}, 0, 1);
            recordStore.closeRecordStore();
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                recordStore.closeRecordStore();
            }
            catch (Throwable throwable) {}
        }
    }

    private Alert createHelpAlert() {
        Alert alert = new Alert(rb.getString("help.title"));
        alert.setTimeout(-2);
        String string = rb.getString("help.text");
        string = WarBoard.replace(string, "\\n", "\n");
        alert.setString(string);
        return alert;
    }

    private Alert createAboutAlert() {
        Alert alert = new Alert(rb.getString("about.title"));
        alert.setTimeout(-2);
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(rb.getString("title"));
        stringBuffer.append("\nCopyright JSmart\nTechnologies,\nInc. 2003");
        stringBuffer.append("\nwww.jsmart.com");
        stringBuffer.append("\ninfo@jsmart.com");
        stringBuffer.append("\nversion ").append(this.getAppProperty("MIDlet-Version"));
        stringBuffer.append("\nlocale ").append(System.getProperty("microedition.locale"));
        alert.setString(stringBuffer.toString());
        return alert;
    }

    public void splashScreenShown() {
        try {
            this.checkTrialExpiration(Integer.parseInt(this.getAppProperty("Trial-Expiration-Days")));
        }
        catch (Throwable throwable) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTrialExpiration(int n) {
        RecordStore recordStore = null;
        try {
            Object object;
            Closeable closeable;
            long l;
            long l2 = l = System.currentTimeMillis();
            recordStore = RecordStore.openRecordStore((String)"trial", (boolean)true);
            if (recordStore.getNumRecords() > 0) {
                closeable = new DataInputStream(new ByteArrayInputStream(recordStore.getRecord(1)));
                l2 = ((DataInputStream)closeable).readLong();
                ((FilterInputStream)closeable).close();
            } else {
                closeable = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)closeable);
                dataOutputStream.writeLong(l2);
                dataOutputStream.close();
                object = ((ByteArrayOutputStream)closeable).toByteArray();
                recordStore.addRecord(object, 0, ((byte[])object).length);
            }
            long l3 = (long)n - (l - l2) / 1000L / 60L / 60L / 24L;
            if (l3 < 0L) {
                l3 = 0L;
            }
            if (l3 < 1L) {
                this.expired = true;
            }
            object = new Alert(rb.getString("trial.title"), WarBoard.replace(rb.getString("trial.text"), "{0}", Long.toString(l3)), null, AlertType.INFO);
            object.setTimeout(4500);
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)object);
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                recordStore.closeRecordStore();
            }
            catch (Throwable throwable) {}
        }
    }
}

