/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.Reader;

public class BufferedReader
extends Reader {
    private Reader in;
    private char[] cb;
    private int nChars;
    private int nextChar;
    private static final int INVALIDATED = -2;
    private static final int UNMARKED = -1;
    private int markedChar = -1;
    private int readAheadLimit = 0;
    private static int defaultCharBufferSize = 8192;
    private static int defaultExpectedLineLength = 80;
    private boolean isSiemens = false;

    public BufferedReader(Reader reader, int n) {
        super((Object)reader);
        if (n <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.in = reader;
        this.nChars = 0;
        this.nextChar = 0;
        try {
            Class.forName("com.siemens.mp.game.Sound");
            this.isSiemens = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!this.isSiemens) {
            this.cb = new char[n];
        }
    }

    public BufferedReader(Reader reader) {
        this(reader, defaultCharBufferSize);
    }

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    private void fill() throws IOException {
        int n;
        int n2;
        if (this.markedChar <= -1) {
            n2 = 0;
        } else {
            n = this.nextChar - this.markedChar;
            if (n >= this.readAheadLimit) {
                this.markedChar = -2;
                this.readAheadLimit = 0;
                n2 = 0;
            } else if (this.readAheadLimit <= this.cb.length) {
                System.arraycopy(this.cb, this.markedChar, this.cb, 0, n);
                this.markedChar = 0;
                n2 = n;
            } else {
                char[] cArray = new char[this.readAheadLimit];
                System.arraycopy(this.cb, this.markedChar, cArray, 0, n);
                this.cb = cArray;
                this.markedChar = 0;
                n2 = n;
            }
        }
        while ((n = this.in.read(this.cb, n2, this.cb.length - n2)) == 0) {
        }
        if (n > 0) {
            this.nChars = n2 + n;
            this.nextChar = n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.nextChar >= this.nChars) {
                this.fill();
                if (this.nextChar >= this.nChars) {
                    return -1;
                }
            }
            return this.cb[this.nextChar++];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.nextChar >= this.nChars) {
                if (n2 >= this.cb.length && this.markedChar <= -1) {
                    return this.in.read(cArray, n, n2);
                }
                this.fill();
            }
            if (this.nextChar >= this.nChars) {
                return -1;
            }
            int n3 = Math.min(n2, this.nChars - this.nextChar);
            System.arraycopy(this.cb, this.nextChar, cArray, n, n3);
            this.nextChar += n3;
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readLine() throws IOException {
        if (this.isSiemens) {
            return this._readLine();
        }
        StringBuffer stringBuffer = new StringBuffer(defaultExpectedLineLength);
        Object object = this.lock;
        synchronized (object) {
            char c;
            boolean bl;
            this.ensureOpen();
            do {
                if (this.nextChar >= this.nChars) {
                    this.fill();
                }
                if (this.nextChar >= this.nChars) {
                    if (stringBuffer.length() > 0) {
                        return stringBuffer.toString();
                    }
                    return null;
                }
                bl = false;
                c = '\u0000';
                int n = this.nextChar;
                while (n < this.nChars) {
                    c = this.cb[n];
                    if (c == '\n' || c == '\r') {
                        bl = true;
                        break;
                    }
                    ++n;
                }
                stringBuffer.append(this.cb, this.nextChar, n - this.nextChar);
                this.nextChar = n;
            } while (!bl);
            ++this.nextChar;
            if (c == '\r') {
                if (this.nextChar >= this.nChars) {
                    this.fill();
                }
                if (this.nextChar < this.nChars && this.cb[this.nextChar] == '\n') {
                    ++this.nextChar;
                }
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.in == null) {
                return;
            }
            this.in.close();
            this.in = null;
            this.cb = null;
        }
    }

    private String _readLine() {
        StringBuffer stringBuffer;
        block4: {
            stringBuffer = new StringBuffer(defaultExpectedLineLength);
            try {
                int n;
                while ((n = this.in.read()) != -1) {
                    char c = (char)n;
                    if (c == '\r') continue;
                    if (c != '\n') {
                        stringBuffer.append(c);
                        continue;
                    }
                    break block4;
                }
            }
            catch (Throwable throwable) {}
            {
            }
        }
        return stringBuffer.toString();
    }
}

