/*
 * Decompiled with CFR 0.152.
 */
package jac;

import com.siemens.mp.color_game.GameCanvas;
import com.siemens.mp.color_game.Layer;
import com.siemens.mp.color_game.LayerManager;
import com.siemens.mp.color_game.Sprite;
import com.siemens.mp.game.Vibrator;
import jac.FallenTilesLayer;
import jac.StatusLayer;
import jac.TetrisTile;
import jac.jac;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class PlayGameCanvas
extends GameCanvas {
    private LayerManager graphicsManager;
    private TetrisTile tileLayer;
    private FallenTilesLayer gameLayer;
    private TetrisTile tileLayer2 = null;
    private FallenTilesLayer gameLayer2 = null;
    private StatusLayer statusLayer;
    private int level = 1;
    private int tileCounter = 0;
    private int score = 0;
    private jac gameObject;
    private int x = 0;
    private int y = 0;

    public PlayGameCanvas(boolean bl, jac jac2) {
        super(bl);
        this.gameObject = jac2;
        Image image = Image.createImage((int)101, (int)80);
        Graphics graphics = image.getGraphics();
        graphics.setColor(0, 90, 90);
        graphics.fillRect(0, 0, image.getWidth(), image.getHeight());
        this.graphicsManager = new LayerManager();
        this.graphicsManager.setViewWindow(0, 0, 101, 80);
        this.gameLayer = new FallenTilesLayer();
        this.gameLayer.setPosition(1, 1);
        this.tileLayer = TetrisTile.getTile(this.gameLayer);
        this.statusLayer = new StatusLayer();
        this.statusLayer.setPosition(56, 2);
        this.statusLayer.setNextTile(TetrisTile.getTile(this.gameLayer));
        try {
            this.graphicsManager.append((Layer)this.tileLayer);
            this.graphicsManager.append((Layer)this.gameLayer);
            if (this.tileLayer2 != null) {
                this.graphicsManager.append((Layer)this.tileLayer2);
            }
            if (this.gameLayer2 != null) {
                this.graphicsManager.append((Layer)this.gameLayer2);
            }
            this.graphicsManager.append((Layer)this.statusLayer);
            this.graphicsManager.append((Layer)new Sprite(image));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void processTile() {
        int n = 0;
        if (this.tileLayer.testOneDown()) {
            this.tileLayer.oneDown();
        } else {
            this.tileLayer.addTileToGameLayer();
            n = this.gameLayer.checkLines();
            if (n > 0) {
                Vibrator.triggerVibrator((int)500);
            }
            if (n > 3) {
                this.score += 60;
            }
            this.score += n * 10;
            this.graphicsManager.remove((Layer)this.tileLayer);
            this.tileLayer = this.statusLayer.getNextTile();
            this.statusLayer.setNextTile(TetrisTile.getTile(this.gameLayer));
            ++this.tileCounter;
            this.level = this.score < 100 ? 1 : (this.score < 200 ? 2 : (this.score < 300 ? 3 : (this.score < 500 ? 4 : (this.score < 750 ? 5 : (this.score < 1000 ? 6 : (this.score < 2000 ? 7 : (this.score < 3000 ? 8 : (this.score < 5000 ? 9 : 10))))))));
            this.graphicsManager.insert((Layer)this.tileLayer, 0);
            this.statusLayer.setLevel(this.level);
            this.statusLayer.setScore(this.score);
            if (!this.tileLayer.testPossiblePosition()) {
                this.gameObject.setGameOver();
            }
        }
        if (this.tileLayer2 != null) {
            if (this.tileLayer2.testOneDown()) {
                this.tileLayer2.oneDown();
            } else {
                this.tileLayer2.addTileToGameLayer();
                this.gameLayer2.checkLines();
                this.graphicsManager.remove((Layer)this.tileLayer2);
                this.tileLayer2 = TetrisTile.getTile(this.gameLayer2);
                if (!this.tileLayer2.testPossiblePosition()) {
                    this.graphicsManager.remove((Layer)this.gameLayer2);
                    this.gameLayer2 = new FallenTilesLayer();
                    this.gameLayer2.setPosition(50, 1);
                    this.graphicsManager.insert((Layer)this.gameLayer2, 0);
                }
                this.graphicsManager.insert((Layer)this.tileLayer2, 0);
            }
        }
    }

    public void paint(Graphics graphics) {
        this.graphicsManager.paint(graphics, 0, 0);
        if (this.gameObject.isGameOver()) {
            graphics.setColor(0, 0, 0);
            graphics.fillRect(13, 15, 74, 40);
            graphics.setColor(255, 255, 255);
            graphics.fillRect(14, 16, 72, 38);
            graphics.setColor(0, 0, 0);
            graphics.fillRect(15, 17, 70, 36);
            graphics.setColor(255, 255, 255);
            graphics.setFont(Font.getFont((int)64, (int)1, (int)16));
            graphics.drawString("Game Over", this.getWidth() / 2, this.getHeight() / 2, 65);
        }
    }

    protected void keyPressed(int n) {
        super.keyPressed(n);
        System.out.println(Integer.toString(n));
        switch (n) {
            case -59: 
            case 1: 
            case 50: {
                if (!this.tileLayer.testRotateLeft()) break;
                this.tileLayer.rotateLeft();
                this.repaint();
                break;
            }
            case 6: 
            case 56: {
                if (!this.tileLayer.testRotateRight()) break;
                this.tileLayer.rotateRight();
                this.repaint();
                break;
            }
            case -61: 
            case 2: 
            case 52: {
                if (!this.tileLayer.testOneLeft()) break;
                this.tileLayer.oneLeft();
                this.repaint();
                break;
            }
            case -62: 
            case 5: 
            case 54: {
                if (!this.tileLayer.testOneRight()) break;
                this.tileLayer.oneRight();
                this.repaint();
                break;
            }
            case -60: 
            case 8: 
            case 53: {
                while (this.tileLayer.testOneDown()) {
                    this.tileLayer.oneDown();
                }
                this.repaint();
            }
        }
    }

    public int getLevel() {
        return this.level;
    }
}

