/*
 * Decompiled with CFR 0.152.
 */
package jac;

import com.siemens.mp.color_game.Layer;
import jac.FallenTilesLayer;
import jac.TileEdge1;
import jac.TileEdge2;
import jac.TileLong;
import jac.TileSquare;
import jac.TileT;
import jac.TileZ1;
import jac.TileZ2;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class TetrisTile
extends Layer {
    public static final int baseSize = 4;
    private int gameFieldX;
    private int gameFieldY;
    private int gameFieldWidth;
    private int gameFieldHeight;
    protected static final Random rand = new Random();
    public static final int TILE_YELLOW = 1;
    public static final int TILE_BLUE = 2;
    public static final int TILE_GREEN = 3;
    public static final int TILE_RED = 4;
    public static final int TILE_VIOLET = 5;
    public static final int TILE_GREY = 6;
    public static final int TILE_BROWN = 7;
    public int myColor = 0;
    protected int posX;
    protected int posY;
    protected int tileWidth;
    protected int tileHeight;
    protected int angle;
    protected int[][][] tileArr;
    protected FallenTilesLayer fallenTilesLayer;

    public TetrisTile(int n, int n2, FallenTilesLayer fallenTilesLayer) {
        super(Image.createImage((int)(n * 4), (int)(n2 * 4)));
        this.gameFieldX = fallenTilesLayer.getX() + 1;
        this.gameFieldY = fallenTilesLayer.getY() - 4;
        this.gameFieldWidth = 4 * 12;
        this.gameFieldHeight = 4 * 20;
        this.tileWidth = n;
        this.tileHeight = n2;
        this.fallenTilesLayer = fallenTilesLayer;
        this.angle = 0;
        this.posX = rand.nextInt() % (12 - n - 1);
        if (this.posX < 0) {
            this.posX *= -1;
        }
        this.posY = 0;
        this.setPosition(this.gameFieldX + this.posX * 4, this.gameFieldY);
    }

    public static TetrisTile getTile(FallenTilesLayer fallenTilesLayer) {
        int n = rand.nextInt() % 7;
        if (n < 0) {
            n *= -1;
        }
        switch (n) {
            case 0: {
                return new TileEdge1(fallenTilesLayer);
            }
            case 1: {
                return new TileEdge2(fallenTilesLayer);
            }
            case 2: {
                return new TileSquare(fallenTilesLayer);
            }
            case 3: {
                return new TileLong(fallenTilesLayer);
            }
            case 4: {
                return new TileT(fallenTilesLayer);
            }
            case 5: {
                return new TileZ1(fallenTilesLayer);
            }
            case 6: {
                return new TileZ2(fallenTilesLayer);
            }
        }
        return null;
    }

    public void oneDown() {
        ++this.posY;
        this.setPosition(this.getX(), this.getY() + 4);
    }

    public boolean testPossiblePosition() {
        int n;
        int n2 = -1;
        int n3 = this.tileHeight;
        boolean bl = false;
        while (!bl) {
            --n3;
            ++n2;
            n = 0;
            while (n < this.tileWidth) {
                if (this.tileArr[this.angle][n][n3] != 0) {
                    bl = true;
                }
                ++n;
            }
        }
        if (20 < this.posY + this.tileHeight - n2) {
            return false;
        }
        n2 = -1;
        n = -1;
        bl = false;
        while (!bl) {
            ++n;
            ++n2;
            n3 = 0;
            while (n3 < this.tileHeight) {
                if (this.tileArr[this.angle][n][n3] != 0) {
                    bl = true;
                }
                ++n3;
            }
        }
        if (0 > this.posX + n2) {
            return false;
        }
        n2 = -1;
        n = this.tileWidth;
        bl = false;
        while (!bl) {
            --n;
            ++n2;
            n3 = 0;
            while (n3 < this.tileHeight) {
                if (this.tileArr[this.angle][n][n3] != 0) {
                    bl = true;
                }
                ++n3;
            }
        }
        if (12 < this.posX + this.tileWidth - n2) {
            return false;
        }
        n = 0;
        while (n < this.tileWidth) {
            n3 = 0;
            while (n3 < this.tileHeight) {
                if (this.tileArr[this.angle][n][n3] != 0 && this.fallenTilesLayer.getGameArr()[this.posX + n][this.posY + n3] != 0) {
                    return false;
                }
                ++n3;
            }
            ++n;
        }
        return true;
    }

    public boolean testOneDown() {
        ++this.posY;
        boolean bl = this.testPossiblePosition();
        --this.posY;
        return bl;
    }

    public boolean testOneLeft() {
        --this.posX;
        boolean bl = this.testPossiblePosition();
        ++this.posX;
        return bl;
    }

    public boolean testOneRight() {
        ++this.posX;
        boolean bl = this.testPossiblePosition();
        --this.posX;
        return bl;
    }

    public boolean testRotateLeft() {
        this.rotateLeft();
        boolean bl = this.testPossiblePosition();
        this.rotateRight();
        return bl;
    }

    public boolean testRotateRight() {
        this.rotateRight();
        boolean bl = this.testPossiblePosition();
        this.rotateLeft();
        return bl;
    }

    public void rotateLeft() {
        ++this.angle;
        if (this.angle > 3) {
            this.angle = 0;
        }
    }

    public void rotateRight() {
        --this.angle;
        if (this.angle < 0) {
            this.angle = 3;
        }
    }

    public void oneLeft() {
        --this.posX;
        this.setPosition(this.getX() - 4, this.getY());
    }

    public void oneRight() {
        ++this.posX;
        this.setPosition(this.getX() + 4, this.getY());
    }

    public void paint(Graphics graphics) {
        int n = 0;
        while (n < this.tileWidth) {
            int n2 = 0;
            while (n2 < this.tileHeight) {
                if (this.tileArr[this.angle][n][n2] != 0) {
                    TetrisTile.paintBaseTile(graphics, this.getX() + n * 4, this.getY() + n2 * 4, this.myColor);
                }
                ++n2;
            }
            ++n;
        }
    }

    public void paintAt(Graphics graphics, int n, int n2) {
        int n3 = this.getX();
        int n4 = this.getY();
        this.setPosition(n, n2);
        this.paint(graphics);
        this.setPosition(n3, n4);
    }

    public static void paintBaseTile(Graphics graphics, int n, int n2, int n3) {
        switch (n3) {
            case 1: {
                graphics.setColor(190, 0, 0);
                break;
            }
            case 2: {
                graphics.setColor(0, 190, 0);
                break;
            }
            case 3: {
                graphics.setColor(0, 0, 190);
                break;
            }
            case 4: {
                graphics.setColor(190, 190, 0);
                break;
            }
            case 5: {
                graphics.setColor(190, 0, 190);
                break;
            }
            case 6: {
                graphics.setColor(0, 190, 190);
                break;
            }
            case 7: {
                graphics.setColor(190, 190, 190);
            }
        }
        graphics.fillRect(n, n2 + 1, 3, 3);
        switch (n3) {
            case 1: {
                graphics.setColor(255, 0, 0);
                break;
            }
            case 2: {
                graphics.setColor(0, 255, 0);
                break;
            }
            case 3: {
                graphics.setColor(0, 0, 255);
                break;
            }
            case 4: {
                graphics.setColor(255, 255, 0);
                break;
            }
            case 5: {
                graphics.setColor(255, 0, 255);
                break;
            }
            case 6: {
                graphics.setColor(0, 255, 255);
                break;
            }
            case 7: {
                graphics.setColor(255, 255, 255);
            }
        }
        graphics.fillRect(n + 1, n2 + 2, 1, 1);
    }

    public void addTileToGameLayer() {
        int n = 0;
        while (n < this.tileWidth) {
            int n2 = 0;
            while (n2 < this.tileHeight) {
                if (this.tileArr[this.angle][n][n2] != 0) {
                    this.fallenTilesLayer.getGameArr()[this.posX + n][this.posY + n2] = this.myColor;
                }
                ++n2;
            }
            ++n;
        }
        this.fallenTilesLayer.updateLayer();
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }
}

