/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.sound.Sound;
import java.io.InputStream;

class SoundsEngine {
    private Sound jingle;
    private byte[] jingleBytes = new byte[65000];
    private InputStream tune;

    SoundsEngine() {
        try {
            this.tune = this.getClass().getResourceAsStream("/jingbell.wav");
            this.tune.read(this.jingleBytes, 0, this.jingleBytes.length);
            this.jingle = new Sound(this.jingleBytes, 5);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
            this.jingle = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("jingle exception");
            this.jingle = null;
        }
    }

    void playJingle() {
        if (this.jingle != null) {
            try {
                this.jingle.init(this.jingleBytes, 5);
                this.jingle.play(1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void mute() {
        if (this.jingle != null && this.jingle.getState() == 0) {
            this.jingle.stop();
        }
    }
}

