/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class PlayCanvas
extends TreeCanvas
implements Runnable {
    ChristmasTree midlet;
    SoundsEngine soundsEngine;
    MusicThread musicThread;
    boolean playSound;

    PlayCanvas(ChristmasTree christmasTree) {
        super(christmasTree);
        this.midlet = christmasTree;
        this.soundsEngine = new SoundsEngine();
        this.treeImg = christmasTree.getTree();
        this.toysArray = christmasTree.getToys();
        this.backImg = christmasTree.getBack();
    }

    PlayCanvas(ChristmasTree christmasTree, Vector vector) {
        super(christmasTree);
        this.midlet = christmasTree;
        this.soundsEngine = new SoundsEngine();
        this.setTree(vector);
    }

    void setTree(Vector vector) {
        this.treeEngine.init(vector);
    }

    public void paint(Graphics graphics) {
        if (this.backImg != null) {
            graphics.drawImage(this.backImg, this.screenWidth / 2, this.screenHeight / 2, 1 | 2);
        } else {
            graphics.setColor(255, 255, 255);
            graphics.fillRect(0, 0, this.screenWidth, this.screenHeight);
        }
        if (this.treeImg != null) {
            graphics.drawImage(this.treeImg, this.screenWidth / 2, this.moveDown, 1 | 0x10);
        }
        this.locations = null;
        this.locations = this.treeEngine.getToys();
        if (this.locations != null) {
            for (int i = 0; i < this.locations.size(); ++i) {
                this.currShape = ((Toy)this.locations.elementAt((int)i)).shape;
                this.currX = ((Toy)this.locations.elementAt((int)i)).x;
                this.currY = ((Toy)this.locations.elementAt((int)i)).y;
                this.currState = ((Toy)this.locations.elementAt((int)i)).state;
                graphics.drawImage(this.toysArray[this.currShape][this.currState], this.currX, this.currY, 1 | 2);
            }
        }
        graphics.drawImage(this.midlet.soundOnImg, 5, this.screenHeight - 5, 4 | 0x20);
        if (!this.midlet.isSound()) {
            graphics.drawImage(this.midlet.soundOffImg, 5, this.screenHeight - 5, 4 | 0x20);
        }
        graphics.setColor(120, 120, 120);
        graphics.setFont(this.bigFont);
        graphics.drawString("Stop", this.screenWidth - 5, this.height + 4, 8 | 0x10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        System.out.println("in run()");
        while (this.goOn) {
            if (this.goWait) {
                try {
                    PlayCanvas playCanvas = this;
                    synchronized (playCanvas) {
                        this.wait();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.repaint();
            this.serviceRepaints();
            this.treeEngine.toggle();
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void showNotify() {
        if (!this.playSound) {
            this.playSound = true;
        }
        if (this.musicThread == null) {
            this.musicThread = new MusicThread();
            this.musicThread.start();
        }
    }

    public void hideNotify() {
        this.playSound = false;
        this.soundsEngine.mute();
        this.musicThread = null;
        System.gc();
    }

    void startAnimation() {
        System.out.println("in startAnimation()");
        this.goOn = true;
        if (this.t == null) {
            this.t = new Thread(this);
            this.t.start();
        }
        this.pause = false;
        this.locations = this.treeEngine.getToys();
    }

    void pauseAnimation() {
        System.out.println("in pauseAnimation()");
        if (!this.goWait) {
            this.goWait = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resumeAnimation() {
        System.out.println("in resumeAnimation()");
        this.goWait = false;
        PlayCanvas playCanvas = this;
        synchronized (playCanvas) {
            this.notifyAll();
        }
    }

    void stopAnimation() {
        System.out.println("in stopAnimation()");
        this.goOn = false;
        this.t = null;
    }

    protected void keyPressed(int n) {
        if (n == -6) {
            this.midlet.switchSound();
            if (this.midlet.isSound()) {
                this.musicThread = null;
                this.musicThread = new MusicThread();
                this.musicThread.start();
            } else {
                this.soundsEngine.mute();
                this.musicThread = null;
                System.gc();
            }
            System.out.println("midlet.isSound() = " + this.midlet.isSound());
            System.out.println("musicThread = " + this.musicThread);
            System.out.println("playSound = " + this.playSound);
        } else if (n == -7) {
            this.stopAnimation();
            if (this.midlet.getAskIfSave()) {
                this.midlet.getQuestionForm();
            } else {
                this.midlet.getMainForm(true, true);
            }
        }
    }

    private class MusicThread
    extends Thread {
        private MusicThread() {
        }

        public void run() {
            System.out.println("in musicThread.run()");
            System.out.println("midlet.isSound() = " + PlayCanvas.this.midlet.isSound());
            System.out.println("musicThread = " + PlayCanvas.this.musicThread);
            System.out.println("playSound = " + PlayCanvas.this.playSound);
            while (PlayCanvas.this.midlet.isSound() && PlayCanvas.this.playSound) {
                PlayCanvas.this.soundsEngine.playJingle();
                try {
                    Thread.sleep(8500L);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

