/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.FullCanvas;
import java.util.Vector;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TreeCanvas
extends FullCanvas {
    int screenWidth;
    int screenHeight;
    int commandsHeight;
    int width;
    int height;
    int moveRight;
    int moveDown;
    protected int imgHeight;
    protected int imgWidth;
    int pX;
    int pY;
    int diam = 8;
    int step = 8;
    int dX;
    int dY;
    boolean play;
    protected Thread t = null;
    protected int delay;
    boolean goOn;
    boolean goWait;
    boolean firstTime;
    boolean afterPause;
    boolean pause;
    boolean newGame;
    protected Font smallFont;
    protected Font bigFont;
    protected Font bugsFont;
    protected Image[][] toysArray;
    protected Image treeImg;
    protected Image backImg;
    protected Vector locations;
    protected TreeEngine treeEngine;
    protected int currShape;
    protected int currState;
    protected int currX;
    protected int currY;
    protected ChristmasTree midlet;

    TreeCanvas(ChristmasTree christmasTree) {
        this.midlet = christmasTree;
        this.treeImg = this.midlet.getTree();
        this.backImg = this.midlet.getBack();
        this.toysArray = this.midlet.getToys();
        this.treeEngine = this.midlet.getTreeEngine();
        System.out.println("inside TreeCanvas constructor");
        this.smallFont = Font.getFont((int)0, (int)0, (int)8);
        this.bigFont = Font.getFont((int)0, (int)1, (int)16);
        this.bugsFont = Font.getFont((int)0, (int)1, (int)0);
        this.screenHeight = this.getHeight();
        this.screenWidth = this.getWidth();
        this.commandsHeight = this.bigFont.getHeight() + 10;
        this.height = this.screenHeight - this.commandsHeight;
        this.moveRight = (this.screenWidth - this.treeImg.getWidth()) / 2;
        this.moveDown = (this.screenHeight - this.treeImg.getHeight()) / 2 - 5;
    }

    void init() {
        this.treeEngine.init();
        this.pX = this.screenWidth / 2 - this.diam / 2;
        this.pY = this.screenHeight / 2 - this.diam / 2;
        this.dY = 0;
        this.dX = 0;
    }

    public void paint(Graphics graphics) {
        graphics.setClip(0, 0, this.screenWidth, this.screenHeight);
        if (this.backImg != null) {
            graphics.drawImage(this.backImg, this.screenWidth / 2, this.screenHeight / 2, 1 | 2);
        } else {
            graphics.setColor(255, 255, 255);
            graphics.fillRect(0, 0, this.screenWidth, this.screenHeight);
        }
        if (this.treeImg != null) {
            graphics.drawImage(this.treeImg, this.screenWidth / 2, this.moveDown, 1 | 0x10);
        }
        this.locations = null;
        this.locations = this.treeEngine.getToys();
        if (this.locations != null) {
            for (int i = 0; i < this.locations.size(); ++i) {
                this.currShape = ((Toy)this.locations.elementAt((int)i)).shape;
                this.currX = ((Toy)this.locations.elementAt((int)i)).x;
                this.currY = ((Toy)this.locations.elementAt((int)i)).y;
                this.currState = ((Toy)this.locations.elementAt((int)i)).state;
                graphics.drawImage(this.toysArray[this.currShape][this.currState], this.currX, this.currY, 1 | 2);
            }
        }
        if (this.dX < 0 && this.pX < this.moveRight) {
            this.dX = 0;
        }
        if (this.dX > 0 && this.pX > this.screenWidth - this.moveRight - this.diam) {
            this.dX = 0;
        }
        this.pX += this.dX;
        if (this.dY < 0 && this.pY < this.moveDown) {
            this.dY = 0;
        }
        if (this.dY > 0 && this.pY > this.height - 3 - this.diam) {
            this.dY = 0;
        }
        this.pY += this.dY;
        graphics.setColor(0xFFFF00);
        graphics.drawRect(this.pX, this.pY, this.diam, this.diam);
        graphics.setColor(120, 120, 120);
        graphics.setFont(this.bigFont);
        graphics.drawString("Toys", 5, this.height + 5, 4 | 0x10);
        graphics.drawString("Play", this.screenWidth - 5, this.height + 5, 8 | 0x10);
    }

    protected void keyReleased(int n) {
        this.dX = 0;
        this.dY = 0;
    }

    protected void keyRepeated(int n) {
        this.repaint();
        this.serviceRepaints();
    }

    protected void keyPressed(int n) {
        if (n == -6) {
            this.midlet.currentDisplayable = this.midlet.getToysList();
            this.midlet.display.setCurrent(this.midlet.currentDisplayable);
        } else if (n == -7) {
            this.midlet.goPlay();
        } else if (this.getGameAction(n) == 5) {
            this.dX = this.step;
        } else if (this.getGameAction(n) == 2) {
            this.dX = -1 * this.step;
        } else if (this.getGameAction(n) == 1) {
            this.dY = -1 * this.step;
        } else if (this.getGameAction(n) == 6) {
            this.dY = this.step;
        } else if (this.getGameAction(n) == 8) {
            if (this.midlet.isSound()) {
                AlertType.INFO.playSound(this.midlet.display);
            }
            this.treeEngine.addToy(this.pX + this.diam / 2, this.pY + this.diam / 2);
        }
        this.repaint();
        this.serviceRepaints();
    }
}

