/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.FullCanvas;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class DoubleJoker
extends MIDlet
implements CommandListener {
    static final boolean REAL_DEVICE = false;
    static final boolean DEBUG = true;
    Display display;
    Displayable currentDisplayable;
    Displayable previousDisplayable;
    public static int sum;
    private Form loadingForm;
    private Form helpForm;
    private Form aboutForm;
    Form resultForm;
    private SplashCanvas splashCanvas;
    private DoubleJokerCanvas doubleJokerCanvas;
    private Thread thread;
    private Gauge gauge;
    private boolean firstTime;
    private Command exitCommand;
    Command backCommand;
    List mainList;
    List levelList;
    String[] mainStr = new String[]{"Continue", "New game", "Help", "Sound on", "About"};
    private byte level = 1;
    final String APP_VERSION = "version " + this.getAppProperty("MIDlet-Version");
    final String APP_NAME;
    final String APP_SPLASH;
    final String MAIN_STR = this.getAppProperty("MIDlet-Description");
    final String ABOUT_STR;
    final String HELP_STR;

    public DoubleJoker() {
        this.APP_NAME = "Double Joker";
        this.APP_SPLASH = "/DoubleJokerSplash.png";
        this.ABOUT_STR = "Double Joker, version 1.0.0\nCopyright 2003 Zindell Technologies, Ltd. All rights reserved. Developed by Jacado www.jacado.com\nSoftware is provided \"AS IS\" without warranty of any kind. In no event, shall we be liable for any claim, damages or other liability.";
        this.HELP_STR = "Double Joker is played with 54 cards. The deck contains 2 jokers, which are wild cards. Press '1', '2', '3', '4' or '5' to bet on $1, $2, $3, $4 or $5. Press the Fire key to deal. Use the Navigation keys to hold/change your cards. The pay out table includes the following possibilities: 2-pairs (1:1), 3-of-a-kind (1:2), straight (1:3), flush (1:4), full house (1:5), 4-of-a-kind (1:8), straight flush (1:25), five of a kind (1:50), joker royal flush (1:100) and natural royal flash (1:500). For a detailed tutorial please visit at http://www.jacado.com/tutorials/doublejoker.html. For further assistance, please send us an email at DoubleJoker@jacado.com.";
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.exitCommand) {
            sum = this.doubleJokerCanvas.sum;
            this.saveBalance();
            this.exit();
        }
        if (displayable == this.mainList) {
            if (this.mainList.getString(this.mainList.getSelectedIndex()).equals("New game")) {
                this.doubleJokerCanvas.init(1000);
                this.currentDisplayable = this.doubleJokerCanvas;
                this.display.setCurrent(this.currentDisplayable);
            } else if (this.mainList.getString(this.mainList.getSelectedIndex()).equals("Continue")) {
                this.currentDisplayable = this.doubleJokerCanvas;
                this.display.setCurrent(this.currentDisplayable);
            } else if (this.mainList.getString(this.mainList.getSelectedIndex()).equals("Help")) {
                this.previousDisplayable = this.mainList;
                this.currentDisplayable = this.helpForm;
                this.display.setCurrent(this.currentDisplayable);
            } else if (this.mainList.getString(this.mainList.getSelectedIndex()).equals("About")) {
                this.currentDisplayable = this.aboutForm;
                this.display.setCurrent(this.currentDisplayable);
            } else if (this.mainList.getString(this.mainList.getSelectedIndex()).equals("Sound on")) {
                this.doubleJokerCanvas.sound = false;
                this.mainList.set(3, "Sound off", null);
            } else if (this.mainList.getString(this.mainList.getSelectedIndex()).equals("Sound off")) {
                this.doubleJokerCanvas.sound = true;
                this.mainList.set(3, "Sound on", null);
            }
        } else if (displayable == this.helpForm && command == this.backCommand) {
            this.currentDisplayable = this.previousDisplayable;
            this.display.setCurrent(this.currentDisplayable);
        } else if (displayable == this.aboutForm && command == this.backCommand) {
            this.currentDisplayable = this.mainList;
            this.display.setCurrent(this.currentDisplayable);
        }
    }

    public void startApp() {
        if (this.display == null) {
            this.thread = new Thread(){

                public void run() {
                    try {
                        DoubleJoker.this.display = Display.getDisplay((MIDlet)DoubleJoker.this);
                        DoubleJoker.this.loadingForm = new Form("Loading...");
                        DoubleJoker.this.currentDisplayable = DoubleJoker.this.loadingForm;
                        DoubleJoker.this.gauge = new Gauge("Please wait:", false, 27, 0);
                        DoubleJoker.this.loadingForm.append((Item)DoubleJoker.this.gauge);
                        DoubleJoker.this.gauge.setValue(0);
                        DoubleJoker.this.display.setCurrent((Displayable)DoubleJoker.this.loadingForm);
                        DoubleJoker.this.loadHighScore();
                        DoubleJoker.this.exitCommand = new Command("Exit", 7, 2);
                        DoubleJoker.this.backCommand = new Command("Back", 2, 2);
                        DoubleJoker.this.firstTime = true;
                        DoubleJoker.this.gauge.setValue(1);
                        DoubleJoker.this.mainList = new List("Double Joker", 3, DoubleJoker.this.mainStr, null);
                        DoubleJoker.this.mainList.addCommand(DoubleJoker.this.exitCommand);
                        DoubleJoker.this.mainList.setCommandListener((CommandListener)DoubleJoker.this);
                        DoubleJoker.this.gauge.setValue(2);
                        DoubleJoker.this.doubleJokerCanvas = new DoubleJokerCanvas(DoubleJoker.this, DoubleJoker.this.gauge);
                        DoubleJoker.this.doubleJokerCanvas.init(sum);
                        DoubleJoker.this.gauge.setValue(25);
                        DoubleJoker.this.aboutForm = new Form("About");
                        DoubleJoker.this.aboutForm.append("Double Joker, version 1.0.0\nCopyright 2003 Zindell Technologies, Ltd. All rights reserved. Developed by Jacado www.jacado.com\nSoftware is provided \"AS IS\" without warranty of any kind. In no event, shall we be liable for any claim, damages or other liability.");
                        DoubleJoker.this.aboutForm.addCommand(DoubleJoker.this.backCommand);
                        DoubleJoker.this.aboutForm.setCommandListener((CommandListener)DoubleJoker.this);
                        DoubleJoker.this.gauge.setValue(26);
                        DoubleJoker.this.helpForm = new Form("Help");
                        DoubleJoker.this.helpForm.append("Double Joker is played with 54 cards. The deck contains 2 jokers, which are wild cards. Press '1', '2', '3', '4' or '5' to bet on $1, $2, $3, $4 or $5. Press the Fire key to deal. Use the Navigation keys to hold/change your cards. The pay out table includes the following possibilities: 2-pairs (1:1), 3-of-a-kind (1:2), straight (1:3), flush (1:4), full house (1:5), 4-of-a-kind (1:8), straight flush (1:25), five of a kind (1:50), joker royal flush (1:100) and natural royal flash (1:500). For a detailed tutorial please visit at http://www.jacado.com/tutorials/doublejoker.html. For further assistance, please send us an email at DoubleJoker@jacado.com.");
                        DoubleJoker.this.helpForm.addCommand(DoubleJoker.this.backCommand);
                        DoubleJoker.this.helpForm.setCommandListener((CommandListener)DoubleJoker.this);
                        DoubleJoker.this.gauge.setValue(27);
                        DoubleJoker.this.currentDisplayable = DoubleJoker.this.mainList;
                        DoubleJoker.this.splashCanvas = new SplashCanvas();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            };
            this.thread.start();
        } else {
            this.display.setCurrent(this.currentDisplayable);
        }
    }

    public void pauseApp() {
        if (this.currentDisplayable != this.mainList) {
            this.currentDisplayable = this.display.getCurrent();
        }
    }

    public void exit() {
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public void destroyApp(boolean bl) {
        this.display = null;
        this.currentDisplayable = null;
        this.helpForm = null;
        this.aboutForm = null;
        this.mainList = null;
        this.loadingForm = null;
        this.gauge = null;
        this.exitCommand = null;
        this.backCommand = null;
        this.doubleJokerCanvas = null;
        this.splashCanvas = null;
        this.thread = null;
    }

    static byte[] calcScore(int n) {
        byte[] byArray = new byte[]{(byte)(n / 10000), (byte)(n % 10000 / 100), (byte)(n % 100)};
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadHighScore() {
        System.out.println("LoadHighScore");
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)"DoubleJoker", (boolean)true);
            byte[] byArray = recordStore.getRecord(1);
            sum = byArray[0] * 10000 + byArray[1] * 100 + byArray[2];
        }
        catch (RecordStoreException recordStoreException) {
            this.deleteScoresDatabase();
            try {
                recordStore = RecordStore.openRecordStore((String)"DoubleJoker", (boolean)true);
                byte[] byArray = DoubleJoker.calcScore(100);
                recordStore.addRecord(byArray, 0, 3);
                sum = 100;
            }
            catch (RecordStoreFullException recordStoreFullException) {
            }
            catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            }
            catch (RecordStoreNotOpenException recordStoreNotOpenException) {
            }
            catch (RecordStoreException recordStoreException2) {
                // empty catch block
            }
            recordStoreException.printStackTrace();
        }
        finally {
            try {
                recordStore.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {}
        }
    }

    private void deleteScoresDatabase() {
        try {
            RecordStore.deleteRecordStore((String)"DoubleJoker");
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveBalance() {
        RecordStore recordStore = null;
        byte[] byArray = new byte[3];
        try {
            recordStore = RecordStore.openRecordStore((String)"DoubleJoker", (boolean)false);
            byArray = DoubleJoker.calcScore(sum);
            recordStore.setRecord(1, byArray, 0, 3);
            System.out.println("data was writen to RMS");
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
        finally {
            try {
                recordStore.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {}
        }
        recordStore = null;
    }

    private class SplashCanvas
    extends FullCanvas {
        private Timer timer = new Timer();
        private Image splashImg;

        private SplashCanvas() {
            try {
                this.splashImg = Image.createImage((String)"/DoubleJokerSplash.png");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            DoubleJoker.this.display.setCurrent((Displayable)this);
        }

        protected void showNotify() {
            this.timer.schedule((TimerTask)new CountDown(), 4000L);
        }

        protected void keyPressed(int n) {
            this.dismiss();
        }

        protected void pointerPressed(int n, int n2) {
            this.dismiss();
        }

        protected void paint(Graphics graphics) {
            graphics.drawImage(this.splashImg, 0, 0, 20);
        }

        private void dismiss() {
            this.timer.cancel();
            DoubleJoker.this.currentDisplayable = DoubleJoker.this.mainList;
            DoubleJoker.this.display.setCurrent(DoubleJoker.this.currentDisplayable);
        }

        private class CountDown
        extends TimerTask {
            private CountDown() {
            }

            public void run() {
                SplashCanvas.this.dismiss();
            }
        }
    }
}

