/*
 * Decompiled with CFR 0.152.
 */
package JuegoDamas17;

import JuegoDamas17.Casillas;
import JuegoDamas17.Damas;
import JuegoDamas17.Fichas;
import JuegoDamas17.HandlerColor;
import JuegoDamas17.InicioPartida;
import JuegoDamas17.Jugadores;
import JuegoDamas17.LasDamas;
import JuegoDamas17.Operacion;
import JuegoDamas17.Tablas;
import java.util.Hashtable;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

public class Controlador
extends Canvas
implements CommandListener {
    private Display display;
    private Command iniciarCommand;
    private Command moveCommand;
    private Command exitCommand;
    private Graphics g;
    private Casillas[][] casillas;
    private Fichas[][] fichas;
    private Damas[] damas;
    private Jugadores[] jugadores;
    private int width;
    private int height;
    private int nrow;
    private int ncol;
    private int jugador = 1;
    private boolean finJugada = false;
    private boolean start = false;
    private boolean finPartida = false;
    private boolean seleccionFicha1 = false;
    private boolean seleccionFicha2 = false;
    private int rowSeleccionada = 5;
    private int colSeleccionada = 0;
    private int rowDeseleccionada = 5;
    private int colDeseleccionada = 0;
    private int row_0 = -1;
    private int col_0 = -1;
    private int row_1 = -1;
    private int col_1 = -1;
    private int row_comida = -1;
    private int col_comida = -1;
    private int row_comida2 = -1;
    private int col_comida2 = -1;
    private boolean movMaquina = false;
    private boolean continuarPartida = false;
    HandlerColor hc;
    private Thread t;
    private boolean startThread = false;
    int colorFondo;

    public Controlador(Display display) {
        this.display = display;
        this.initialize();
    }

    private void initialize() {
        int n;
        int n2;
        if (Display.getDisplay((MIDlet)LasDamas.getInstance()).isColor()) {
            n2 = 0xFFFFFF;
            n = 0;
            this.colorFondo = 0xC0C0C0;
        } else {
            n2 = 0xFFFFFF;
            n = 0xBFBFBF;
            this.colorFondo = 0x303030;
        }
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.nrow = 8;
        this.ncol = 8;
        int n3 = n2;
        int n4 = 0;
        boolean bl = false;
        int n5 = 0;
        int n6 = 0;
        this.casillas = new Casillas[this.nrow][this.ncol];
        this.fichas = new Fichas[this.nrow][this.ncol];
        this.jugadores = new Jugadores[2];
        this.damas = new Damas[2];
        int n7 = 0;
        while (n7 < this.nrow) {
            n4 = n7 > 0 && n7 < 3 ? (n4 == 2 ? 0 : 2) : (n7 == this.ncol - 3 ? 1 : (n7 > this.ncol - 3 ? (n4 == 1 ? 0 : 1) : 0));
            n6 = 0;
            while (n6 < this.ncol) {
                this.casillas[n7][n6] = new Casillas(this.width, this.height, n7, n6, n3, n4, bl, n5);
                this.fichas[n7][n6] = new Fichas(this.width, this.height, n4);
                n4 = n7 < 3 ? (n4 == 2 ? 0 : 2) : (n7 >= this.ncol - 3 ? (n4 == 1 ? 0 : 1) : 0);
                n3 = n3 == n2 ? n : n2;
                ++n6;
            }
            n3 = n3 == n2 ? n : n2;
            ++n7;
        }
        this.jugadores[0] = new Jugadores("Jugador1");
        this.jugadores[1] = new Jugadores("Jugador2");
        this.jugadores[0].setTurno(true);
        this.damas[0] = new Damas(1);
        this.damas[1] = new Damas(2);
        this.casillas[this.rowSeleccionada][this.colSeleccionada].setSeleccionado(true);
        this.moveCommand = new Command("Mover", 4, 1);
        this.iniciarCommand = new Command("Start", 1, 2);
        this.exitCommand = new Command("Exit", 1, 2);
        this.addCommand(this.iniciarCommand);
        this.addCommand(this.exitCommand);
        this.setCommandListener(this);
    }

    public void paint(Graphics graphics) {
        int n;
        this.g = graphics;
        if (!this.start || this.movMaquina || this.continuarPartida) {
            graphics.setColor(this.colorFondo);
            graphics.fillRect(0, 0, this.width, this.height);
            int n2 = 0;
            n = 0;
            while (n < this.nrow) {
                n2 = 0;
                while (n2 < this.ncol) {
                    this.casillas[n][n2].paint(graphics, n, n2);
                    this.fichas[n][n2].paint(graphics, n, n2);
                    ++n2;
                }
                ++n;
            }
            this.start = true;
            this.continuarPartida = false;
        } else {
            this.casillas[this.rowDeseleccionada][this.colDeseleccionada].paint(graphics, this.rowDeseleccionada, this.colDeseleccionada);
            this.casillas[this.rowSeleccionada][this.colSeleccionada].paint(graphics, this.rowSeleccionada, this.colSeleccionada);
            this.fichas[this.rowDeseleccionada][this.colDeseleccionada].paint(graphics, this.rowDeseleccionada, this.colDeseleccionada);
            this.fichas[this.rowSeleccionada][this.colSeleccionada].paint(graphics, this.rowSeleccionada, this.colSeleccionada);
            if (this.row_comida != -1 && this.col_comida != -1) {
                this.casillas[this.row_comida][this.col_comida].paint(graphics, this.row_comida, this.col_comida);
            }
            if (this.row_comida2 != -1 && this.col_comida2 != -1) {
                this.casillas[this.row_comida2][this.col_comida2].paint(graphics, this.row_comida2, this.col_comida2);
            }
        }
        n = 0;
        while (n < 2) {
            this.damas[n].paint(graphics, this.damas, this);
            ++n;
        }
        this.movMaquina = false;
        if (!this.startThread) {
            this.hc = new HandlerColor(graphics, this, this.casillas[this.rowSeleccionada][this.colSeleccionada]);
            this.t = new Thread(this.hc);
            this.t.start();
            this.startThread = true;
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.exitCommand) {
            this.hc.stop();
            LasDamas.getInstance().destroyApp(true);
            LasDamas.getInstance().notifyDestroyed();
        } else if (command == this.iniciarCommand) {
            this.display.setCurrent((Displayable)new InicioPartida(this.display, this));
        } else {
            String string = "";
            this.row_1 = this.rowSeleccionada;
            this.col_1 = this.colSeleccionada;
            this.rowDeseleccionada = this.row_0;
            this.colDeseleccionada = this.col_0;
            this.casillas[this.row_0][this.col_0].setMarcado(0);
            this.casillas[this.row_1][this.col_1].setMarcado(0);
            this.casillas[this.row_0][this.col_0].setEstado(0);
            this.fichas[this.row_0][this.col_0].setEstado(0);
            if (this.row_1 == 0) {
                this.damas[0].incrementarDamas(this.jugadores, 1);
                this.fichas[this.row_1][this.col_1].setEstado(0);
                this.casillas[this.row_1][this.col_1].setEstado(0);
            } else {
                this.fichas[this.row_1][this.col_1].setEstado(1);
                this.casillas[this.row_1][this.col_1].setEstado(1);
            }
            int n = Fichas.getFichasComidas();
            this.row_comida = -1;
            this.col_comida = -1;
            this.row_comida2 = -1;
            this.col_comida2 = -1;
            if (n > 0) {
                Hashtable hashtable = Fichas.getCoordenadasFichasComidas();
                this.row_comida = Integer.parseInt((String)hashtable.get("row_comida1"));
                this.col_comida = Integer.parseInt((String)hashtable.get("col_comida1"));
                if (n == 2) {
                    this.row_comida2 = Integer.parseInt((String)hashtable.get("row_comida2"));
                    this.col_comida2 = Integer.parseInt((String)hashtable.get("col_comida2"));
                    this.fichas[this.row_comida2][this.col_comida2].setEstado(0);
                    this.casillas[this.row_comida2][this.col_comida2].setEstado(0);
                }
                this.fichas[this.row_comida][this.col_comida].setEstado(0);
                this.casillas[this.row_comida][this.col_comida].setEstado(0);
                this.jugadores[1].comerFicha(n);
            }
            if (this.jugadores[0].getFichas() == 0 || this.jugadores[1].getFichas() == 0) {
                string = Jugadores.resultadoPartida(this.damas[0].getDamas(), this.damas[1].getDamas(), this.jugadores);
                this.finPartida = true;
            }
            this.seleccionFicha1 = false;
            this.seleccionFicha2 = false;
            this.jugadores[0].setTurno(false);
            this.jugadores[1].setTurno(true);
            if (!this.finPartida) {
                int n2 = Jugadores.juegaMaquina(this.fichas, this.casillas, this.damas, this.jugadores, 2);
                this.movMaquina = true;
                if (n2 == -1) {
                    Operacion.show(this.display, "Se ha producido tablas", (Displayable)new Controlador(this.display));
                } else {
                    this.jugadores[0].comerFicha(n2);
                }
                if (this.jugadores[0].getFichas() == 0 || this.jugadores[1].getFichas() == 0) {
                    string = Jugadores.resultadoPartida(this.damas[0].getDamas(), this.damas[1].getDamas(), this.jugadores);
                    this.finPartida = true;
                }
            }
            if (this.finPartida) {
                Operacion.show(this.display, string, (Displayable)new Controlador(this.display));
            }
            this.jugadores[0].setTurno(true);
            this.jugadores[1].setTurno(false);
            this.casillas[this.row_1][this.col_1].setSeleccionado(true);
            this.startThread = false;
            this.repaint();
            this.removeCommand(this.moveCommand);
            this.addCommand(this.exitCommand);
        }
    }

    public void keyPressed(int n) {
        this.movMaquina = false;
        this.hc.stop();
        int n2 = 0;
        int n3 = this.casillas[this.rowSeleccionada][this.colSeleccionada].getMarcado();
        if (this.start && !this.finPartida && this.jugadores[0].getTurno()) {
            switch (this.getGameAction(n)) {
                case 6: {
                    this.casillas[this.rowSeleccionada][this.colSeleccionada].setSeleccionado(false);
                    n2 = this.rowSeleccionada + 1;
                    if (n2 >= this.nrow) break;
                    this.rowDeseleccionada = this.rowSeleccionada++;
                    this.colDeseleccionada = this.colSeleccionada;
                    this.casillas[this.rowSeleccionada][this.colSeleccionada].setSeleccionado(true);
                    if (this.seleccionFicha1 && Fichas.moverFicha(this.row_0, this.col_0, this.rowSeleccionada, this.colSeleccionada, this.fichas) != -1 && this.rowSeleccionada < this.row_0) {
                        this.casillas[this.rowSeleccionada][this.colSeleccionada].setEstado(3);
                    }
                    this.startThread = false;
                    this.repaint();
                    break;
                }
                case 1: {
                    this.casillas[this.rowSeleccionada][this.colSeleccionada].setSeleccionado(false);
                    n2 = this.rowSeleccionada - 1;
                    if (n2 < 0) break;
                    this.rowDeseleccionada = this.rowSeleccionada--;
                    this.colDeseleccionada = this.colSeleccionada;
                    this.casillas[this.rowSeleccionada][this.colSeleccionada].setSeleccionado(true);
                    if (this.seleccionFicha1 && Fichas.moverFicha(this.row_0, this.col_0, this.rowSeleccionada, this.colSeleccionada, this.fichas) != -1 && this.rowSeleccionada >= 0) {
                        this.casillas[this.rowSeleccionada][this.colSeleccionada].setEstado(3);
                    }
                    this.startThread = false;
                    this.repaint();
                    break;
                }
                case 2: {
                    this.casillas[this.rowSeleccionada][this.colSeleccionada].setSeleccionado(false);
                    n2 = this.colSeleccionada - 1;
                    if (n2 < 0) break;
                    this.rowDeseleccionada = this.rowSeleccionada;
                    this.colDeseleccionada = this.colSeleccionada--;
                    this.casillas[this.rowSeleccionada][this.colSeleccionada].setSeleccionado(true);
                    if (this.seleccionFicha1 && Fichas.moverFicha(this.row_0, this.col_0, this.rowSeleccionada, this.colSeleccionada, this.fichas) != -1 && this.colSeleccionada >= 0) {
                        this.casillas[this.rowSeleccionada][this.colSeleccionada].setEstado(3);
                    }
                    this.startThread = false;
                    this.repaint();
                    break;
                }
                case 5: {
                    this.casillas[this.rowSeleccionada][this.colSeleccionada].setSeleccionado(false);
                    n2 = this.colSeleccionada + 1;
                    if (n2 >= this.ncol) break;
                    this.rowDeseleccionada = this.rowSeleccionada;
                    this.colDeseleccionada = this.colSeleccionada++;
                    this.casillas[this.rowSeleccionada][this.colSeleccionada].setSeleccionado(true);
                    if (this.seleccionFicha1 && Fichas.moverFicha(this.row_0, this.col_0, this.rowSeleccionada, this.colSeleccionada, this.fichas) != -1 && this.colSeleccionada < this.ncol) {
                        this.casillas[this.rowSeleccionada][this.colSeleccionada].setEstado(3);
                    }
                    this.startThread = false;
                    this.repaint();
                    break;
                }
                case 8: {
                    int n4 = this.rowSeleccionada;
                    int n5 = this.colSeleccionada;
                    int n6 = 16744272;
                    if (this.casillas[this.rowSeleccionada][this.colSeleccionada].getMarcado() == 1 && !this.seleccionFicha2) {
                        Casillas.reestablecerTablero(this.casillas);
                        this.casillas[this.rowSeleccionada][this.colSeleccionada].setSeleccionado(true);
                        this.casillas[this.rowSeleccionada][this.colSeleccionada].setMarcado(0);
                        this.seleccionFicha1 = false;
                        this.repaint();
                        break;
                    }
                    if (this.casillas[this.rowSeleccionada][this.colSeleccionada].getMarcado() == 2 && this.seleccionFicha1) {
                        Casillas.reestablecerTablero(this.casillas);
                        this.casillas[this.rowSeleccionada][this.colSeleccionada].setEstado(0);
                        this.casillas[this.rowSeleccionada][this.colSeleccionada].setSeleccionado(true);
                        this.casillas[this.rowSeleccionada][this.colSeleccionada].setMarcado(0);
                        this.seleccionFicha2 = false;
                        this.removeCommand(this.moveCommand);
                        this.addCommand(this.exitCommand);
                        this.repaint();
                        break;
                    }
                    if (!this.seleccionFicha1) {
                        if (Fichas.verificaSeleccionFicha(this.fichas, this.rowSeleccionada, this.colSeleccionada)) {
                            this.row_0 = n4;
                            this.col_0 = n5;
                            this.casillas[this.row_0][this.col_0].setSeleccionado(false);
                            this.casillas[this.row_0][this.col_0].setMarcado(1);
                            this.seleccionFicha1 = true;
                            this.repaint();
                            break;
                        }
                        if (!Tablas.existeTablas(0, this.fichas)) break;
                        Operacion.show(this.display, "Se ha producido tablas", (Displayable)new Controlador(this.display));
                        break;
                    }
                    if (this.rowSeleccionada >= this.row_0 || !this.seleccionFicha1 || Fichas.moverFicha(this.row_0, this.col_0, this.rowSeleccionada, this.colSeleccionada, this.fichas) == -1) break;
                    this.row_1 = n4;
                    this.col_1 = n5;
                    this.casillas[this.row_1][this.col_1].setSeleccionado(false);
                    this.casillas[this.row_1][this.col_1].setMarcado(2);
                    this.seleccionFicha2 = true;
                    this.removeCommand(this.iniciarCommand);
                    this.removeCommand(this.exitCommand);
                    this.addCommand(this.moveCommand);
                    this.addCommand(this.iniciarCommand);
                    this.repaint();
                }
            }
        }
    }

    public void setContinue() {
        this.continuarPartida = true;
    }

    public synchronized void repintar() {
        this.repaint();
    }
}

