/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public abstract class Brick {
    public static final String INITIAL = "initial";
    public static final String DOWN = "down";
    public static final String LEFT = "left";
    public static final String RIGHT = "right";
    public static final String ROTATE = "rotate";
    public static final String DROP = "drop";
    public Metris metris;
    public int[][][] brickBits;
    protected int widthBits;
    protected int heigthBits;
    public int orientation;
    public int nextOrientation;
    protected int outlineColour;
    protected int fillColour;
    protected int xPosition;
    protected int yPosition;
    protected String direction = "initial";

    public Brick() {
        this.initialise();
    }

    public void initialise() {
        this.xPosition = 0;
        this.orientation = this.nextOrientation;
        this.direction = INITIAL;
        this.calculateYPosition();
    }

    public abstract void setBrickBits();

    public void paint(Graphics graphics, int n, int n2, int n3) {
        if (this.metris == null) {
            System.out.println("fuck");
        }
        int n4 = this.calculateLeftIndex();
        int n5 = this.calculateRightIndex();
        int n6 = this.calculateTopIndex();
        int n7 = this.calculateBottomIndex();
        int n8 = (n5 - n4 + 1) * this.metris.pit.getBrickSize();
        int n9 = (n7 - n6 + 1) * this.metris.pit.getBrickSize();
        int n10 = n - n4 * this.metris.pit.getBrickSize() + (n3 - n8) / 2;
        int n11 = n2 - n6 * this.metris.pit.getBrickSize() + (n3 - n9) / 2;
        this.paintBrickBits(graphics, n10, n11);
    }

    private void paintBrickBits(Graphics graphics, int n, int n2) {
        int n3 = 0;
        while (n3 < this.brickBits[this.nextOrientation].length) {
            int n4 = 0;
            while (n4 < this.brickBits[this.nextOrientation][n3].length) {
                if (this.brickBits[this.nextOrientation][n3][n4] != 0) {
                    graphics.setColor(this.outlineColour);
                    graphics.drawRect(n + n3 * this.metris.pit.getBrickSize(), n2 + n4 * this.metris.pit.getBrickSize(), this.metris.pit.getBrickSize(), this.metris.pit.getBrickSize());
                    graphics.setColor(this.fillColour);
                    graphics.fillRect(n + n3 * this.metris.pit.getBrickSize() + 1, n2 + n4 * this.metris.pit.getBrickSize() + 1, this.metris.pit.getBrickSize() - 1, this.metris.pit.getBrickSize() - 1);
                }
                n4 = (short)(n4 + 1);
            }
            n3 = (short)(n3 + 1);
        }
    }

    public boolean testNewPositionOnPitBoard(Brick[][] brickArray) {
        int n = 0;
        while (n < this.widthBits) {
            int n2 = 0;
            while (n2 < this.heigthBits) {
                if (this.brickBits[this.orientation][n][n2] == 1) {
                    if (this.xPosition + n < 0 || this.xPosition + n >= brickArray.length) {
                        return false;
                    }
                    if (this.yPosition + n2 >= 0) {
                        if (this.yPosition + n2 >= brickArray[this.xPosition + n].length) {
                            return false;
                        }
                        if (brickArray[this.xPosition + n][this.yPosition + n2] != null) {
                            return false;
                        }
                    }
                }
                n2 = (short)(n2 + 1);
            }
            n = (short)(n + 1);
        }
        return true;
    }

    public boolean checkForGameOver(Brick[][] brickArray) {
        boolean bl = false;
        if (!this.testNewPositionOnPitBoard(brickArray)) {
            bl = true;
        }
        return bl;
    }

    public boolean move(Brick[][] brickArray) {
        boolean bl = false;
        if (this.direction.equals(DOWN)) {
            this.incrementYPosition();
            if (!this.testNewPositionOnPitBoard(brickArray)) {
                this.decrementYPosition();
                bl = true;
            }
        } else if (this.direction.equals(LEFT)) {
            this.decrementXPosition();
            if (!this.testNewPositionOnPitBoard(brickArray)) {
                this.incrementXPosition();
            }
        } else if (this.direction.equals(RIGHT)) {
            this.incrementXPosition();
            if (!this.testNewPositionOnPitBoard(brickArray)) {
                this.decrementXPosition();
            }
        } else if (this.direction.equals(ROTATE)) {
            this.incrementOrientation();
            if (!this.testNewPositionOnPitBoard(brickArray)) {
                this.decrementOrientation();
            }
        } else if (this.direction.equals(DROP)) {
            while (this.testNewPositionOnPitBoard(brickArray)) {
                this.incrementYPosition();
            }
            this.decrementYPosition();
            bl = true;
        }
        this.setDirection(DOWN);
        return bl;
    }

    public void setXPosition(int n) {
        this.xPosition = n;
    }

    public void calculateYPosition() {
        int n;
        int n2 = -1;
        int n3 = -1;
        if (this.brickBits == null) {
            return;
        }
        int n4 = 0;
        while (n4 <= this.brickBits[this.orientation].length) {
            n = 0;
            while (n < this.brickBits[this.orientation][n4].length) {
                if (this.brickBits[this.orientation][n][n4] == 1) {
                    n2 = n4;
                    break;
                }
                ++n;
            }
            if (n2 != -1) break;
            ++n4;
        }
        n = this.brickBits[this.orientation].length - 1;
        while (n >= 0) {
            int n5 = 0;
            while (n5 < this.brickBits[this.orientation][n].length) {
                if (this.brickBits[this.orientation][n5][n] == 1) {
                    n3 = n;
                    break;
                }
                ++n5;
            }
            if (n3 != -1) break;
            --n;
        }
        this.yPosition = n3 - n3 * 2;
        if (n3 - n2 > 1) {
            ++this.yPosition;
        }
    }

    public int calculateLeftIndex() {
        int n = -1;
        if (this.brickBits == null) {
            return 0;
        }
        int n2 = 0;
        while (n2 < this.brickBits[this.nextOrientation].length) {
            int n3 = 0;
            while (n3 < this.brickBits[this.nextOrientation][n2].length) {
                if (this.brickBits[this.nextOrientation][n2][n3] == 1) {
                    n = n2;
                    break;
                }
                ++n3;
            }
            if (n != -1) break;
            ++n2;
        }
        return n;
    }

    public int calculateRightIndex() {
        int n = -1;
        if (this.brickBits == null) {
            return 0;
        }
        int n2 = this.brickBits[this.nextOrientation].length - 1;
        while (n2 >= 0) {
            int n3 = 0;
            while (n3 < this.brickBits[this.nextOrientation][n2].length) {
                if (this.brickBits[this.nextOrientation][n2][n3] == 1) {
                    n = n2;
                    break;
                }
                ++n3;
            }
            if (n != -1) break;
            --n2;
        }
        return n;
    }

    public int calculateTopIndex() {
        int n = -1;
        if (this.brickBits == null) {
            return 0;
        }
        int n2 = 0;
        while (n2 <= this.brickBits[this.nextOrientation].length) {
            int n3 = 0;
            while (n3 < this.brickBits[this.nextOrientation][n2].length) {
                if (this.brickBits[this.nextOrientation][n3][n2] == 1) {
                    n = n2;
                    break;
                }
                ++n3;
            }
            if (n != -1) break;
            ++n2;
        }
        return n;
    }

    public int calculateBottomIndex() {
        int n = -1;
        if (this.brickBits == null) {
            return 0;
        }
        int n2 = this.brickBits[this.nextOrientation].length - 1;
        while (n2 >= 0) {
            int n3 = 0;
            while (n3 < this.brickBits[this.nextOrientation][n2].length) {
                if (this.brickBits[this.nextOrientation][n3][n2] == 1) {
                    n = n2;
                    break;
                }
                ++n3;
            }
            if (n != -1) break;
            --n2;
        }
        return n;
    }

    public void incrementOrientation() {
        ++this.orientation;
        this.orientation %= this.brickBits.length;
    }

    public void decrementOrientation() {
        --this.orientation;
        if (this.orientation < 0) {
            this.orientation = this.brickBits.length - 1;
        }
    }

    public void incrementXPosition() {
        ++this.xPosition;
    }

    public void decrementXPosition() {
        --this.xPosition;
    }

    public void incrementYPosition() {
        ++this.yPosition;
    }

    public void decrementYPosition() {
        --this.yPosition;
    }

    public int getOutlineColour() {
        return this.outlineColour;
    }

    public int getFillColour() {
        return this.fillColour;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String string) {
        this.direction = string;
    }
}

