/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Display;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public class Metris
extends MIDlet {
    public Pit pit;
    public InfoPanel infoPanel;
    public ScoreBoard scoreBoard;
    public ScreenTitle screenTitle;
    public ScreenControls screenControls;
    public ScreenScoreBoard screenScoreBoard;
    public ScreenOptions screenOptions;
    public ScreenConfigDisplay screenConfigDisplay;
    public ScreenGame screenGame;

    public Metris() {
        this.alterColours();
        this.pit = new Pit(this);
        this.infoPanel = new InfoPanel(this);
        this.scoreBoard = new ScoreBoard();
        this.screenTitle = new ScreenTitle(this);
        this.screenControls = new ScreenControls(this);
        this.screenScoreBoard = new ScreenScoreBoard(this);
        this.screenOptions = new ScreenOptions(this);
        this.screenConfigDisplay = new ScreenConfigDisplay(this);
        this.screenGame = new ScreenGame(this);
    }

    protected void startApp() {
        this.readPersistantInformation();
        this.findOptimumColours();
        this.screenTitle.display();
    }

    protected void pauseApp() {
    }

    protected void destroyApp(boolean bl) {
        this.storePersistantInformation();
    }

    public void readPersistantInformation() {
        block4: {
            byte[] byArray = null;
            try {
                RecordStore recordStore = RecordStore.openRecordStore((String)"Metris", (boolean)true);
                if (recordStore.getNumRecords() >= 1) {
                    byArray = recordStore.getRecord(1);
                    this.scoreBoard.loadFromByteArray(byArray);
                }
                if (recordStore.getNumRecords() >= 2) {
                    byArray = recordStore.getRecord(2);
                    this.pit.setX(byArray[0]);
                    this.pit.setY(byArray[1]);
                    this.pit.setPitWidth(byArray[2]);
                    this.pit.setPitHeight(byArray[3]);
                    this.pit.setBrickSize(byArray[4]);
                    this.infoPanel.setX(byArray[5]);
                    this.infoPanel.setY(byArray[6]);
                    this.screenOptions.gridChoiceGroup.setSelectedIndex((int)byArray[7], true);
                    this.screenOptions.nextChoiceGroup.setSelectedIndex((int)byArray[8], true);
                    break block4;
                }
                this.pit.setPitWidth(10);
                this.pit.setPitHeight(19);
                this.findOptimumLayout();
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception);
                this.findOptimumLayout();
            }
        }
    }

    public void storePersistantInformation() {
        block5: {
            byte[] byArray = this.scoreBoard.saveToByteArray();
            byte[] byArray2 = new byte[]{(byte)this.pit.getX(), (byte)this.pit.getY(), (byte)this.pit.getPitWidth(), (byte)this.pit.getPitHeight(), (byte)this.pit.getBrickSize(), (byte)this.infoPanel.getX(), (byte)this.infoPanel.getY(), (byte)this.screenOptions.gridChoiceGroup.getSelectedIndex(), (byte)this.screenOptions.nextChoiceGroup.getSelectedIndex()};
            try {
                RecordStore recordStore = RecordStore.openRecordStore((String)"Metris", (boolean)true);
                if (recordStore.getNumRecords() >= 1) {
                    recordStore.setRecord(1, byArray, 0, byArray.length);
                } else {
                    recordStore.addRecord(byArray, 0, byArray.length);
                }
                if (recordStore.getNumRecords() >= 2) {
                    recordStore.setRecord(2, byArray2, 0, byArray2.length);
                    break block5;
                }
                recordStore.addRecord(byArray2, 0, byArray2.length);
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception);
            }
        }
    }

    public void alterColours() {
        Display display = Display.getDisplay((MIDlet)this);
        if (!display.isColor() && display.numColors() < 256) {
            Colour.DARK_PINK = Colour.DARK_GREEN;
            Colour.LIGHT_PINK = Colour.LIGHT_GREEN;
            Colour.DARK_YELLOW = Colour.DARK_GREEN;
            Colour.LIGHT_YELLOW = Colour.LIGHT_GREEN;
        }
    }

    public void findOptimumColours() {
        Display display = Display.getDisplay((MIDlet)this);
        Pit.NO_BRICK_OUTLINE_COLOUR = !display.isColor() && display.numColors() < 256 ? 0x808080 : 0xD2D2D2;
    }

    public void findOptimumLayout() {
        this.pit.setBrickSize(1);
        while (this.calculateLayout()) {
            this.pit.setBrickSize(this.pit.getBrickSize() + 1);
        }
        this.setLayout();
    }

    public boolean calculateLayout() {
        boolean bl = true;
        int n = this.screenTitle.getWidth();
        int n2 = this.screenTitle.getHeight();
        int n3 = 2 + this.pit.getPitWidth() * this.pit.getBrickSize();
        int n4 = 1 + this.pit.getPitHeight() * this.pit.getBrickSize();
        int n5 = this.infoPanel.getWidth();
        int n6 = this.infoPanel.getHeight();
        if (n3 + n5 > n) {
            bl = false;
        }
        if (n4 > n2 || n6 > n2) {
            bl = false;
        }
        if (!bl) {
            this.pit.setBrickSize(this.pit.getBrickSize() - 1);
        }
        return bl;
    }

    public void setLayout() {
        int n;
        int n2 = this.screenTitle.getWidth();
        int n3 = this.screenTitle.getHeight();
        int n4 = 2 + this.pit.getPitWidth() * this.pit.getBrickSize();
        int n5 = 1 + this.pit.getPitHeight() * this.pit.getBrickSize();
        int n6 = this.infoPanel.getWidth();
        int n7 = this.infoPanel.getHeight();
        int n8 = n4 + n6;
        int n9 = n = n5 > n7 ? n5 : n7;
        if (n5 > n7) {
            this.pit.setX(0 + (n2 - n8) / 2);
            this.pit.setY(0 + (n3 - n5) / 2);
            this.infoPanel.setX(0 + (n2 - n8) / 2 + n4 + n6 / 2);
            this.infoPanel.setY(0 + (n3 - n5) / 2 + (n5 - n7) / 2);
        } else {
            this.pit.setX(0 + (n2 - n8) / 2);
            this.pit.setY(0 + (n3 - n7) / 2 + (n7 - n5) / 2);
            this.infoPanel.setX(0 + (n2 - n8) / 2 + n4 + n6 / 2);
            this.infoPanel.setY(0 + (n3 - n7) / 2);
        }
    }
}

