/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

public class ScreenConfigDisplay
extends Canvas
implements CommandListener {
    private Command CMD_PIT_POSITION = new Command("Pit Pos", 4, 1);
    private Command CMD_PIT_SIZE = new Command("Pit Size", 4, 1);
    private Command CMD_BRICK_SIZE = new Command("Brick Size", 4, 1);
    private Command CMD_INFO_POSITION = new Command("Info Pos", 4, 1);
    private Command CMD_OK = new Command("Ok", 2, 1);
    private Metris metris;
    private Display display;
    private String currentAdjustment;

    public ScreenConfigDisplay(Metris metris) {
        this.metris = metris;
        this.display = Display.getDisplay((MIDlet)metris);
        this.currentAdjustment = "Pit Pos";
        this.addCommand(this.CMD_OK);
        this.addCommand(this.CMD_PIT_POSITION);
    }

    public void paint(Graphics graphics) {
        GFX.clearScreen(this, graphics, 0xFFFFFF);
        this.metris.pit.paint(graphics);
        this.metris.infoPanel.paint(graphics);
    }

    public void display() {
        ScreenGame cfr_ignored_0 = this.metris.screenGame;
        this.metris.screenGame.gameState = 8;
        this.display.setCurrent((Displayable)this);
        this.setCommandListener(this);
        this.repaint();
    }

    public void keyPressed(int n) {
        switch (this.getGameAction(n)) {
            case 8: {
                this.metris.setLayout();
                this.repaint();
            }
        }
        if (this.currentAdjustment.equals("Pit Pos")) {
            switch (this.getGameAction(n)) {
                case 1: {
                    this.metris.pit.setY(this.metris.pit.getY() - 1);
                    this.repaint();
                    break;
                }
                case 2: {
                    this.metris.pit.setX(this.metris.pit.getX() - 1);
                    this.repaint();
                    break;
                }
                case 5: {
                    this.metris.pit.setX(this.metris.pit.getX() + 1);
                    this.repaint();
                    break;
                }
                case 6: {
                    this.metris.pit.setY(this.metris.pit.getY() + 1);
                    this.repaint();
                }
            }
        } else if (this.currentAdjustment.equals("Pit Size")) {
            switch (this.getGameAction(n)) {
                case 1: {
                    this.metris.pit.setPitHeight(this.metris.pit.getPitHeight() - 1);
                    this.repaint();
                    break;
                }
                case 2: {
                    this.metris.pit.setPitWidth(this.metris.pit.getPitWidth() - 1);
                    this.repaint();
                    break;
                }
                case 5: {
                    this.metris.pit.setPitWidth(this.metris.pit.getPitWidth() + 1);
                    this.repaint();
                    break;
                }
                case 6: {
                    this.metris.pit.setPitHeight(this.metris.pit.getPitHeight() + 1);
                    this.repaint();
                }
            }
        } else if (this.currentAdjustment.equals("Brick Size")) {
            switch (this.getGameAction(n)) {
                case 1: {
                    this.metris.pit.setBrickSize(this.metris.pit.getBrickSize() - 1);
                    this.repaint();
                    break;
                }
                case 2: {
                    this.metris.pit.setBrickSize(this.metris.pit.getBrickSize() - 1);
                    this.repaint();
                    break;
                }
                case 5: {
                    this.metris.pit.setBrickSize(this.metris.pit.getBrickSize() + 1);
                    this.repaint();
                    break;
                }
                case 6: {
                    this.metris.pit.setBrickSize(this.metris.pit.getBrickSize() + 1);
                    this.repaint();
                }
            }
            this.metris.infoPanel.setPanelSize(5 * this.metris.pit.getBrickSize());
        } else if (this.currentAdjustment.equals("Info Pos")) {
            switch (this.getGameAction(n)) {
                case 1: {
                    this.metris.infoPanel.setY(this.metris.infoPanel.getY() - 1);
                    this.repaint();
                    break;
                }
                case 2: {
                    this.metris.infoPanel.setX(this.metris.infoPanel.getX() - 1);
                    this.repaint();
                    break;
                }
                case 5: {
                    this.metris.infoPanel.setX(this.metris.infoPanel.getX() + 1);
                    this.repaint();
                    break;
                }
                case 6: {
                    this.metris.infoPanel.setY(this.metris.infoPanel.getY() + 1);
                    this.repaint();
                }
            }
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        String string = command.getLabel();
        if (string.equals("Ok")) {
            this.metris.screenTitle.display();
        } else if (string.equals("Pit Pos")) {
            this.removeCommand(this.CMD_PIT_POSITION);
            this.addCommand(this.CMD_PIT_SIZE);
            this.currentAdjustment = "Pit Size";
            this.repaint();
        } else if (string.equals("Pit Size")) {
            this.removeCommand(this.CMD_PIT_SIZE);
            this.addCommand(this.CMD_BRICK_SIZE);
            this.currentAdjustment = "Brick Size";
            this.repaint();
        } else if (string.equals("Brick Size")) {
            this.removeCommand(this.CMD_BRICK_SIZE);
            this.addCommand(this.CMD_INFO_POSITION);
            this.currentAdjustment = "Info Pos";
            this.repaint();
        } else if (string.equals("Info Pos")) {
            this.removeCommand(this.CMD_INFO_POSITION);
            this.addCommand(this.CMD_PIT_POSITION);
            this.currentAdjustment = "Pit Pos";
            this.repaint();
        }
    }
}

