/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class InfoPanel {
    private static int X_POSITION = 62;
    private static int Y_POSITION = 0;
    private static int PANEL_SIZE = 25;
    private Font boldFont = Font.getFont((int)0, (int)1, (int)8);
    private Font plainFont = Font.getFont((int)0, (int)0, (int)8);
    private Metris metris;

    public InfoPanel(Metris metris) {
        this.metris = metris;
    }

    public void setX(int n) {
        if (n >= 0) {
            X_POSITION = n;
        }
    }

    public int getX() {
        return X_POSITION;
    }

    public void setY(int n) {
        if (n >= 0) {
            Y_POSITION = n;
        }
    }

    public int getY() {
        return Y_POSITION;
    }

    public void setPanelSize(int n) {
        if (n >= 0) {
            PANEL_SIZE = n;
        }
    }

    public int getPanelSize() {
        return PANEL_SIZE;
    }

    public int getWidth() {
        int n = this.plainFont.stringWidth("Top: 8888");
        if (n > PANEL_SIZE) {
            return n;
        }
        return PANEL_SIZE;
    }

    public int getHeight() {
        return this.boldFont.getHeight() * 3 + this.plainFont.getHeight() * 2 + PANEL_SIZE + 3;
    }

    public void paint(Graphics graphics) {
        this.paintNextBrickPanel(graphics);
        this.paintLevel(graphics);
        this.paintScore(graphics);
        this.paintTopScore(graphics);
    }

    public void paintPartialNextBrickPanel(Graphics graphics) {
        int n = X_POSITION - PANEL_SIZE / 2;
        int n2 = Y_POSITION + this.boldFont.getHeight();
        graphics.setColor(Colour.LIGHT_TAN);
        graphics.fillRoundRect(n + 2, n2 + 2, PANEL_SIZE - 4, PANEL_SIZE - 4, 10, 10);
        if (this.metris.screenOptions.nextChoiceGroup.getSelectedIndex() == 0) {
            this.metris.pit.nextBrick.paint(graphics, n + 2, n2 + 2, PANEL_SIZE - 4);
        }
    }

    public void paintNextBrickPanel(Graphics graphics) {
        int n = X_POSITION - PANEL_SIZE / 2;
        int n2 = Y_POSITION + this.boldFont.getHeight();
        graphics.setColor(0);
        graphics.setFont(this.boldFont);
        graphics.drawString("Next", X_POSITION, Y_POSITION, 17);
        graphics.setColor(Colour.DARK_TAN);
        graphics.fillRoundRect(n, n2, PANEL_SIZE, PANEL_SIZE, 10, 10);
        graphics.setColor(Colour.MEDIUM_TAN);
        graphics.fillRoundRect(n + 1, n2 + 1, PANEL_SIZE - 2, PANEL_SIZE - 2, 10, 10);
        graphics.setColor(Colour.LIGHT_TAN);
        graphics.fillRoundRect(n + 2, n2 + 2, PANEL_SIZE - 4, PANEL_SIZE - 4, 10, 10);
        if (this.metris.screenOptions.nextChoiceGroup.getSelectedIndex() == 0) {
            this.metris.pit.nextBrick.paint(graphics, n + 2, n2 + 2, PANEL_SIZE - 4);
        }
    }

    public void paintPartialLevel(Graphics graphics) {
        if (this.metris.screenGame.previousLevel != this.metris.screenGame.level) {
            this.paintLevel(graphics);
            this.metris.screenGame.previousLevel = this.metris.screenGame.level;
        }
    }

    public void paintLevel(Graphics graphics) {
        String string = "Level: " + this.metris.screenGame.level;
        int n = X_POSITION - this.boldFont.stringWidth(string) / 2;
        int n2 = Y_POSITION + this.boldFont.getHeight() + PANEL_SIZE + 1;
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(n, n2, this.boldFont.stringWidth(string), this.boldFont.getHeight());
        graphics.setColor(0);
        graphics.setFont(this.boldFont);
        graphics.drawString(string, X_POSITION, n2, 17);
    }

    public void paintScore(Graphics graphics) {
        int n = X_POSITION - this.plainFont.stringWidth("8888") / 2;
        int n2 = Y_POSITION + this.boldFont.getHeight() * 2 + PANEL_SIZE + 2;
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(n, n2 + this.boldFont.getHeight(), this.plainFont.stringWidth("8888"), this.plainFont.getHeight());
        graphics.setColor(0);
        graphics.setFont(this.boldFont);
        graphics.drawString("Score", X_POSITION, n2, 17);
        graphics.setFont(this.plainFont);
        graphics.drawString("" + this.metris.screenGame.score, X_POSITION, n2 + this.boldFont.getHeight(), 17);
        this.metris.screenGame.previousScore = this.metris.screenGame.score;
    }

    public void paintTopScore(Graphics graphics) {
        String string = "Top: " + this.metris.scoreBoard.getTopScore();
        int n = Y_POSITION + this.boldFont.getHeight() * 3 + this.plainFont.getHeight() + PANEL_SIZE + 3;
        graphics.setColor(0x808080);
        graphics.setFont(this.plainFont);
        graphics.drawString(string, X_POSITION, n, 17);
    }
}

