/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class Pit {
    public static final int DEFAULT_PIT_WIDTH = 10;
    public static final int DEFAULT_PIT_HEIGHT = 19;
    private static int X_POSITION = 0;
    private static int Y_POSITION = 0;
    private static int PIT_WIDTH = 10;
    private static int PIT_HEIGHT = 19;
    private static int BRICK_SIZE = 5;
    public static int NO_BRICK_OUTLINE_COLOUR;
    private Metris metris;
    private RandomNumber randomNumber;
    private Brick[][] previousPitBoard;
    private Brick[][] currentPitBoard;
    private Brick[] bricks;
    public Brick fallingBrick;
    public Brick nextBrick;

    public Pit(Metris metris) {
        this.metris = metris;
        this.bricks = new Brick[7];
        this.bricks[0] = new BrickSquare(metris);
        this.bricks[1] = new BrickT(metris);
        this.bricks[2] = new BrickL(metris);
        this.bricks[3] = new BrickJ(metris);
        this.bricks[4] = new BrickS(metris);
        this.bricks[5] = new Brick2(metris);
        this.bricks[6] = new BrickI(metris);
        this.randomNumber = new RandomNumber();
        this.createNewBoards();
        this.getNewBrick();
    }

    public void createNewBoards() {
        this.previousPitBoard = new Brick[PIT_WIDTH][PIT_HEIGHT];
        this.currentPitBoard = new Brick[PIT_WIDTH][PIT_HEIGHT];
        this.clear();
    }

    public void setX(int n) {
        if (n >= 0) {
            X_POSITION = n;
        }
    }

    public int getX() {
        return X_POSITION;
    }

    public void setY(int n) {
        if (n >= 0) {
            Y_POSITION = n;
        }
    }

    public int getY() {
        return Y_POSITION;
    }

    public void setPitWidth(int n) {
        if (n >= 0) {
            PIT_WIDTH = n;
            this.createNewBoards();
        }
    }

    public int getPitWidth() {
        return PIT_WIDTH;
    }

    public void setPitHeight(int n) {
        if (n >= 0) {
            PIT_HEIGHT = n;
            this.createNewBoards();
        }
    }

    public int getPitHeight() {
        return PIT_HEIGHT;
    }

    public void setBrickSize(int n) {
        if (n >= 0) {
            BRICK_SIZE = n;
            this.metris.infoPanel.setPanelSize(5 * BRICK_SIZE);
        }
    }

    public int getBrickSize() {
        return BRICK_SIZE;
    }

    public void addFallingBrickToBoard() {
        int n = 0;
        while (n < this.fallingBrick.widthBits) {
            int n2 = 0;
            while (n2 < this.fallingBrick.heigthBits) {
                if (this.fallingBrick.yPosition + n2 >= 0 && this.fallingBrick.brickBits[this.fallingBrick.orientation][n][n2] == 1) {
                    this.currentPitBoard[this.fallingBrick.xPosition + n][this.fallingBrick.yPosition + n2] = this.fallingBrick;
                }
                n2 = (short)(n2 + 1);
            }
            n = (short)(n + 1);
        }
    }

    public void removeFallingBrickFromBoard() {
        int n = 0;
        while (n < this.fallingBrick.widthBits) {
            int n2 = 0;
            while (n2 < this.fallingBrick.heigthBits) {
                if (this.fallingBrick.yPosition + n2 >= 0 && this.fallingBrick.brickBits[this.fallingBrick.orientation][n][n2] == 1) {
                    this.currentPitBoard[this.fallingBrick.xPosition + n][this.fallingBrick.yPosition + n2] = null;
                }
                n2 = (short)(n2 + 1);
            }
            n = (short)(n + 1);
        }
    }

    public void paint(Graphics graphics) {
        this.paintEmptyPit(graphics);
        this.paintPitContents(graphics);
    }

    public void paintEmptyPit(Graphics graphics) {
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(X_POSITION - 1, Y_POSITION, PIT_WIDTH * BRICK_SIZE + 2, PIT_HEIGHT * BRICK_SIZE + 1);
        graphics.setColor(0);
        graphics.drawRect(X_POSITION - 1, Y_POSITION, PIT_WIDTH * BRICK_SIZE + 1, PIT_HEIGHT * BRICK_SIZE);
    }

    public synchronized void paintPitContentsSelective(Graphics graphics) {
        int n = 0;
        while (n < PIT_WIDTH) {
            int n2 = 0;
            while (n2 < PIT_HEIGHT) {
                if (this.previousPitBoard[n][n2] != this.currentPitBoard[n][n2]) {
                    int n3 = X_POSITION + n * BRICK_SIZE;
                    int n4 = Y_POSITION + n2 * BRICK_SIZE;
                    this.paintBrick(graphics, n3, n4, this.currentPitBoard[n][n2]);
                }
                n2 = (short)(n2 + 1);
            }
            n = (short)(n + 1);
        }
        this.copyPitBoard(this.previousPitBoard, this.currentPitBoard);
    }

    public synchronized void paintPitContents(Graphics graphics) {
        int n = 0;
        while (n < PIT_WIDTH) {
            int n2 = 0;
            while (n2 < PIT_HEIGHT) {
                int n3 = X_POSITION + n * BRICK_SIZE;
                int n4 = Y_POSITION + n2 * BRICK_SIZE;
                this.paintBrick(graphics, n3, n4, this.currentPitBoard[n][n2]);
                n2 = (short)(n2 + 1);
            }
            n = (short)(n + 1);
        }
        this.copyPitBoard(this.previousPitBoard, this.currentPitBoard);
    }

    public void paintBrick(Graphics graphics, int n, int n2, Brick brick) {
        int n3 = NO_BRICK_OUTLINE_COLOUR;
        int n4 = 0xFFFFFF;
        if (brick != null) {
            n3 = brick.getOutlineColour();
            n4 = brick.getFillColour();
        } else if (this.metris.screenOptions.gridChoiceGroup.getSelectedIndex() != 0) {
            ScreenGame cfr_ignored_0 = this.metris.screenGame;
            if (this.metris.screenGame.gameState != 8) {
                n3 = 0xFFFFFF;
                n4 = 0xFFFFFF;
            }
        }
        graphics.setColor(n3);
        graphics.drawRect(n, n2, BRICK_SIZE - 1, BRICK_SIZE - 1);
        graphics.setColor(n4);
        graphics.fillRect(n + 1, n2 + 1, BRICK_SIZE - 1, BRICK_SIZE - 1);
    }

    public void clear() {
        int n = 0;
        while (n < PIT_WIDTH) {
            int n2 = 0;
            while (n2 < PIT_HEIGHT) {
                this.previousPitBoard[n][n2] = null;
                this.currentPitBoard[n][n2] = null;
                n2 = (short)(n2 + 1);
            }
            n = (short)(n + 1);
        }
    }

    public void copyPitBoard(Brick[][] brickArray, Brick[][] brickArray2) {
        int n = 0;
        while (n < PIT_WIDTH) {
            int n2 = 0;
            while (n2 < PIT_HEIGHT) {
                brickArray[n][n2] = brickArray2[n][n2];
                n2 = (short)(n2 + 1);
            }
            n = (short)(n + 1);
        }
    }

    public void updatePitBoard() {
        this.updatePitBoard("user");
    }

    public synchronized void updatePitBoard(String string) {
        boolean bl = false;
        this.removeFallingBrickFromBoard();
        if (string.equals("system")) {
            this.fallingBrick.setDirection("down");
        }
        bl = this.fallingBrick.move(this.currentPitBoard);
        this.addFallingBrickToBoard();
        if (bl) {
            this.metris.screenGame.incrementScore(1);
            this.clearCompleteLines();
            this.getNewBrick();
            if (!this.fallingBrick.checkForGameOver(this.currentPitBoard)) {
                this.addFallingBrickToBoard();
            } else {
                this.metris.screenGame.paintGameOverScreen();
            }
        }
    }

    public void clearCompleteLines() {
        int n = 0;
        while (n < PIT_HEIGHT) {
            boolean bl = true;
            int n2 = 0;
            while (n2 < PIT_WIDTH) {
                if (this.currentPitBoard[n2][n] == null) {
                    bl = false;
                    break;
                }
                ++n2;
            }
            if (bl) {
                this.metris.screenGame.incrementScore(10);
                int n3 = 0;
                while (n3 < PIT_WIDTH) {
                    int n4 = n;
                    while (n4 > 0) {
                        this.currentPitBoard[n3][n4] = this.currentPitBoard[n3][n4 - 1];
                        --n4;
                    }
                    this.currentPitBoard[n3][0] = null;
                    ++n3;
                }
            }
            ++n;
        }
    }

    public void getNewBrick() {
        if (this.nextBrick == null) {
            this.nextBrick = this.bricks[this.randomNumber.next(0, this.bricks.length)];
            this.nextBrick.nextOrientation = this.nextBrick.orientation;
            this.fallingBrick = this.bricks[this.randomNumber.next(0, this.bricks.length)];
        } else {
            this.fallingBrick = this.nextBrick;
            this.nextBrick = this.bricks[this.randomNumber.next(0, this.bricks.length)];
            this.nextBrick.nextOrientation = this.nextBrick.orientation;
        }
        this.fallingBrick.initialise();
        this.fallingBrick.setXPosition(PIT_WIDTH / 2 - 2);
    }
}

