/*
 * Decompiled with CFR 0.152.
 */
public class ScoreBoard {
    private static final short MAX_ENTRIES = 8;
    private static final short MAX_NAME_STRING_SIZE = 16;
    private static final short MAX_SCORE_STRING_SIZE = 5;
    private String[][] boardData = new String[8][2];

    public int size() {
        return this.boardData.length;
    }

    public String getName(int n) {
        if (n >= 0 && n < this.size()) {
            return this.boardData[n][0];
        }
        return null;
    }

    public void setName(int n, String string) {
        if (n >= 0 && n < this.size()) {
            this.boardData[n][0] = string;
        }
    }

    public String getScore(int n) {
        if (n >= 0 && n < this.size()) {
            return this.boardData[n][1];
        }
        return null;
    }

    public void setScore(int n, String string) {
        if (n >= 0 && n < this.size()) {
            this.boardData[n][1] = string;
        }
    }

    public String getTopScore() {
        String string = "0";
        if (this.boardData[0][1] != null) {
            string = this.boardData[0][1].trim();
        }
        if (string.equals("")) {
            string = "0";
        }
        return string;
    }

    public int getBottomScore() {
        int n = 0;
        try {
            n = Integer.parseInt(this.getScore(this.size() - 1));
        }
        catch (Exception exception) {}
        return n;
    }

    private int getBoardDataSize() {
        return this.size() * 21;
    }

    public void loadFromByteArray(byte[] byArray) {
        byte[] byArray2 = new byte[16];
        byte[] byArray3 = new byte[5];
        int n = 0;
        int n2 = 0;
        while (n2 < this.size()) {
            int n3 = 0;
            while (n3 < 16) {
                int n4 = n;
                n = (short)(n + 1);
                byArray2[n3] = byArray[n4];
                n3 = (short)(n3 + 1);
            }
            int n5 = 0;
            while (n5 < 5) {
                int n6 = n;
                n = (short)(n + 1);
                byArray3[n5] = byArray[n6];
                n5 = (short)(n5 + 1);
            }
            this.setName(n2, new String(byArray2, 0, byArray2.length));
            this.setScore(n2, new String(byArray3, 0, byArray3.length).trim());
            n2 = (short)(n2 + 1);
        }
    }

    public byte[] saveToByteArray() {
        byte[] byArray = new byte[this.getBoardDataSize()];
        int n = 0;
        int n2 = 0;
        while (n2 < this.size()) {
            byte[] byArray2;
            byte[] byArray3;
            try {
                byArray3 = this.getName(n2).getBytes();
                byArray2 = this.getScore(n2).getBytes();
            }
            catch (Exception exception) {
                byArray3 = null;
                byArray2 = null;
            }
            int n3 = 0;
            while (n3 < 16) {
                if (byArray3 == null || n3 >= byArray3.length) {
                    int n4 = n;
                    n = (short)(n + 1);
                    byArray[n4] = 32;
                } else {
                    int n5 = n;
                    n = (short)(n + 1);
                    byArray[n5] = byArray3[n3];
                }
                n3 = (short)(n3 + 1);
            }
            int n6 = 0;
            while (n6 < 5) {
                if (byArray2 == null || n6 >= byArray2.length) {
                    int n7 = n;
                    n = (short)(n + 1);
                    byArray[n7] = 32;
                } else {
                    int n8 = n;
                    n = (short)(n + 1);
                    byArray[n8] = byArray2[n6];
                }
                n6 = (short)(n6 + 1);
            }
            n2 = (short)(n2 + 1);
        }
        return byArray;
    }

    public boolean update(String string, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.size()) {
            try {
                n2 = Integer.parseInt(this.getScore(n3));
            }
            catch (Exception exception) {
                n2 = 0;
            }
            if (n > n2) {
                this.insertNewScore(n3, string, n);
                return true;
            }
            n3 = (short)(n3 + 1);
        }
        return false;
    }

    private void insertNewScore(int n, String string, int n2) {
        int n3 = this.size() - 1;
        while (n3 > n) {
            this.setName(n3, this.getName(n3 - 1));
            this.setScore(n3, this.getScore(n3 - 1));
            --n3;
        }
        this.setName(n, string);
        this.setScore(n, "" + n2);
    }

    public String getScorePosition(int n) {
        String string = "";
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.size()) {
            try {
                n2 = Integer.parseInt(this.getScore(n3));
            }
            catch (Exception exception) {
                n2 = 0;
            }
            if (n > n2) break;
            n3 = (short)(n3 + 1);
        }
        if (n3 < this.size()) {
            n3 = (short)(n3 + 1);
            string = "" + n3;
            switch (n3) {
                case 1: {
                    string = string + "st";
                    break;
                }
                case 2: {
                    string = string + "nd";
                    break;
                }
                case 3: {
                    string = string + "rd";
                    break;
                }
                default: {
                    string = string + "th";
                }
            }
        }
        return string;
    }
}

