/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public class ScreenGame
extends Canvas
implements Runnable,
CommandListener {
    private static final int STATE_TITLE_SCREEN = 1;
    private static final int STATE_SCORE_BOARD = 2;
    private static final int STATE_CONTROLS = 3;
    private static final int STATE_START_GAME = 4;
    private static final int STATE_GAME_IN_PROGRESS = 5;
    private static final int STATE_GAME_PAUSED = 6;
    public static final int STATE_GAME_OVER = 7;
    public static final int STATE_CFG_DISPLAY = 8;
    private static final int START_PACE = 800;
    private static final int DROP_PACE = 100;
    private Command CMD_PAUSE = new Command("Pause", 4, 1);
    private Command CMD_CONTINUE = new Command("Continue", 4, 1);
    private Command CMD_OK = new Command("Ok", 4, 1);
    private Command CMD_QUIT = new Command("Quit", 2, 1);
    private Metris metris;
    private Display display;
    private Thread thread;
    private boolean paintEntireScreen;
    private int previousGameSpeed;
    private int gameSpeed;
    public int previousLevel;
    public int level;
    public int previousScore;
    public int score;
    public int gameState;
    private TextField nameTextField;

    public ScreenGame(Metris metris) {
        this.metris = metris;
        this.display = Display.getDisplay((MIDlet)metris);
        this.addCommand(this.CMD_PAUSE);
        this.addCommand(this.CMD_QUIT);
        try {
            if (this.thread == null) {
                this.thread = new Thread(this);
                this.thread.start();
            }
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
        }
    }

    public void display() {
        this.initialiseNewGame();
        this.removeCommand(this.CMD_PAUSE);
        this.removeCommand(this.CMD_CONTINUE);
        this.addCommand(this.CMD_PAUSE);
        this.addCommand(this.CMD_QUIT);
        this.gameState = 4;
        this.display.setCurrent((Displayable)this);
        this.setCommandListener(this);
        this.repaint();
    }

    private void initialiseNewGame() {
        this.previousLevel = -1;
        this.level = 1;
        this.previousScore = -1;
        this.score = 0;
        this.previousGameSpeed = 800;
        this.gameSpeed = 800;
        this.metris.pit.clear();
        this.metris.pit.getNewBrick();
        this.metris.pit.addFallingBrickToBoard();
    }

    public void paint(Graphics graphics) {
        if (this.gameState == 4 || this.paintEntireScreen) {
            this.paintEntireScreen(graphics);
            this.gameState = 5;
            this.paintEntireScreen = false;
        }
        if (this.gameState == 5) {
            this.paintPartialScreen(graphics);
        }
    }

    private void paintEntireScreen(Graphics graphics) {
        GFX.clearScreen(this, graphics, 0xFFFFFF);
        this.metris.pit.paintEmptyPit(graphics);
        this.metris.pit.paintPitContents(graphics);
        this.metris.infoPanel.paint(graphics);
    }

    public void paintPartialScreen(Graphics graphics) {
        this.metris.pit.paintPitContentsSelective(graphics);
        this.metris.infoPanel.paintPartialNextBrickPanel(graphics);
        this.metris.infoPanel.paintPartialLevel(graphics);
        this.metris.infoPanel.paintScore(graphics);
    }

    public void paintGameOverScreen() {
        TetrisAlert tetrisAlert = new TetrisAlert(this.display, AlertType.ERROR);
        Thread thread = new Thread(tetrisAlert);
        thread.start();
        this.gameState = 7;
        this.removeCommand(this.CMD_PAUSE);
        Form form = new Form("Game Over");
        form.append("Your score: " + this.score + "\n");
        if (this.score > this.metris.scoreBoard.getBottomScore()) {
            form.append(this.metris.scoreBoard.getScorePosition(this.score) + " place!");
            this.nameTextField = new TextField("Name:", "", 16, 0);
            form.append((Item)this.nameTextField);
        }
        form.addCommand(this.CMD_OK);
        form.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)form);
    }

    public void incrementScore(int n) {
        this.score += n;
        this.level = this.score / 100 + 1;
        this.gameSpeed = 800 - (this.level - 1) * 40;
        this.gameSpeed = this.gameSpeed <= 0 ? 1 : this.gameSpeed;
    }

    public void commandAction(Command command, Displayable displayable) {
        String string = command.getLabel();
        if (string.equals("Pause")) {
            this.removeCommand(this.CMD_PAUSE);
            this.addCommand(this.CMD_CONTINUE);
            this.display.setCurrent((Displayable)this);
            this.gameState = 6;
            this.repaint();
        } else if (string.equals("Continue")) {
            this.removeCommand(this.CMD_CONTINUE);
            this.addCommand(this.CMD_PAUSE);
            this.gameState = 5;
            this.paintEntireScreen = true;
            this.repaint();
        } else if (string.equals("Quit")) {
            this.removeCommand(this.CMD_CONTINUE);
            this.removeCommand(this.CMD_PAUSE);
            this.removeCommand(this.CMD_QUIT);
            this.gameState = 7;
            this.metris.screenTitle.display();
        } else if (string.equals("Ok")) {
            this.metris.scoreBoard.update(this.nameTextField.getString(), this.score);
            this.removeCommand(this.CMD_OK);
            this.gameState = 7;
            this.metris.screenTitle.display();
        }
    }

    public void keyPressed(int n) {
        if (this.gameState != 5) {
            return;
        }
        block0 : switch (this.getGameAction(n)) {
            case 1: {
                this.metris.pit.fallingBrick.setDirection("rotate");
                this.metris.pit.updatePitBoard();
                this.repaint();
                break;
            }
            case 2: {
                this.metris.pit.fallingBrick.setDirection("left");
                this.metris.pit.updatePitBoard();
                this.repaint();
                break;
            }
            case 5: {
                this.metris.pit.fallingBrick.setDirection("right");
                this.metris.pit.updatePitBoard();
                this.repaint();
                break;
            }
            case 6: {
                this.metris.pit.fallingBrick.setDirection("drop");
                this.metris.pit.updatePitBoard();
                this.repaint();
                break;
            }
            case 8: {
                this.previousGameSpeed = this.gameSpeed;
                this.gameSpeed = 100;
                this.metris.pit.updatePitBoard();
                this.repaint();
                break;
            }
            case 0: {
                switch (n) {
                    case 50: {
                        this.metris.pit.fallingBrick.setDirection("rotate");
                        this.metris.pit.updatePitBoard();
                        this.repaint();
                        break block0;
                    }
                    case 52: {
                        this.metris.pit.fallingBrick.setDirection("left");
                        this.metris.pit.updatePitBoard();
                        this.repaint();
                        break block0;
                    }
                    case 54: {
                        this.metris.pit.fallingBrick.setDirection("right");
                        this.metris.pit.updatePitBoard();
                        this.repaint();
                        break block0;
                    }
                    case 56: {
                        this.metris.pit.fallingBrick.setDirection("drop");
                        this.metris.pit.updatePitBoard();
                        this.repaint();
                        break block0;
                    }
                    case 53: {
                        this.previousGameSpeed = this.gameSpeed;
                        this.gameSpeed = 100;
                        this.metris.pit.updatePitBoard();
                        this.repaint();
                    }
                }
            }
        }
    }

    public void keyReleased(int n) {
        switch (this.getGameAction(n)) {
            case 8: {
                this.gameSpeed = this.previousGameSpeed;
                this.metris.pit.updatePitBoard();
                this.repaint();
                break;
            }
            case 0: {
                switch (n) {
                    case 53: {
                        this.gameSpeed = this.previousGameSpeed;
                        this.metris.pit.updatePitBoard();
                        this.repaint();
                    }
                }
            }
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    if (this.gameState == 5) {
                        this.metris.pit.updatePitBoard("system");
                        this.repaint();
                    }
                    Thread.sleep(this.gameSpeed);
                }
            }
            catch (Exception exception) {
                System.out.println("screenGame exception: " + exception);
                continue;
            }
            break;
        }
    }
}

