/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

public class ScreenScoreBoard
extends Canvas
implements CommandListener {
    private Command CMD_OK = new Command("Ok", 2, 1);
    private Font titleFont = Font.getFont((int)0, (int)5, (int)16);
    private Font textFont = Font.getFont((int)0, (int)0, (int)8);
    private Metris metris;
    private Display display;

    public ScreenScoreBoard(Metris metris) {
        this.metris = metris;
        this.display = Display.getDisplay((MIDlet)metris);
        this.addCommand(this.CMD_OK);
    }

    public void paint(Graphics graphics) {
        GFX.clearScreen(this, graphics, 0xFFFFFF);
        graphics.setColor(0);
        graphics.setFont(Font.getFont((int)0, (int)5, (int)16));
        graphics.drawString("Top Scores", this.getWidth() / 2, 15, 65);
        graphics.setFont(Font.getFont((int)64, (int)0, (int)8));
        int n = 0;
        while (n < this.metris.scoreBoard.size()) {
            if (this.metris.scoreBoard.getName(n) != null && this.metris.scoreBoard.getScore(n) != null) {
                graphics.drawString(this.metris.scoreBoard.getName(n), 1, 29 + n * 9, 68);
                graphics.drawString(this.metris.scoreBoard.getScore(n), this.getWidth() - 1, 29 + n * 9, 72);
            }
            ++n;
        }
    }

    public void display() {
        this.display.setCurrent((Displayable)this);
        this.setCommandListener(this);
        this.repaint();
    }

    public void commandAction(Command command, Displayable displayable) {
        String string = command.getLabel();
        if (string.equals("Ok")) {
            this.metris.screenTitle.display();
        }
    }
}

