/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class ConvexDB {
    private RecordStore rs = null;
    boolean firstTime;

    ConvexDB(String string) throws Exception {
        System.out.println("inside ConvexDB constructor");
        this.firstTime = false;
        try {
            this.rs = RecordStore.openRecordStore((String)string, (boolean)false);
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            this.rs = RecordStore.openRecordStore((String)string, (boolean)true);
            this.firstTime = true;
        }
    }

    public boolean isEmpty() throws RecordStoreNotOpenException {
        return this.rs.getNumRecords() <= 0;
    }

    int setSettings(ConvexExchange convexExchange) {
        int n = -1;
        this.deleteSettings();
        try {
            byte[] byArray = convexExchange.toBytes();
            n = this.rs.addRecord(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    void deleteSettings() {
        try {
            if (this.rs.getNumRecords() > 0) {
                this.rs.deleteRecord(this.getSettings().getId());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConvexExchange getSettings() {
        RecordEnumeration recordEnumeration = null;
        ConvexExchange convexExchange = null;
        try {
            recordEnumeration = this.rs.enumerateRecords(null, null, false);
            int n = 0;
            while (recordEnumeration.hasNextElement()) {
                n = recordEnumeration.nextRecordId();
                byte[] byArray = this.rs.getRecord(n);
                convexExchange = new ConvexExchange(n, byArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (recordEnumeration != null) {
                recordEnumeration.destroy();
            }
        }
        return convexExchange;
    }
}

