/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.FullCanvas;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStoreNotOpenException;

public class Convex
extends MIDlet
implements CommandListener {
    static final boolean DEBUG = true;
    private Display display;
    private Displayable currentDisplayable;
    private Displayable lastDisplayable;
    private SplashCanvas splashCanvas;
    private Form loadingForm;
    private Form settingForm1;
    private Form settingForm2;
    private Form mainForm;
    private Form aboutForm;
    private Form helpForm;
    private Form resultForm;
    private Form errorForm;
    private Gauge gauge;
    private Thread thread;
    private Alert alertMemError;
    private String firstCurrency;
    private String secondCurrency;
    private String rate;
    private int selectedRateCG;
    private int selectedSumCG;
    private ConvexDB convexDB;
    private ConvexExchange convex;
    private TextField firstCurrTF;
    private TextField secondCurrTF;
    private TextField rateTF;
    private String[] currencies;
    private ChoiceGroup rateCG;
    private TextField mainSumTF;
    private String[] conversions;
    private ChoiceGroup mainSumCG;
    private Command backCommand;
    private Command aboutCommand;
    private Command nextCommand;
    private Command helpCommand;
    private Command doneCommand;
    private Command settingCommand;
    final String APP_NAME = this.getAppProperty("MIDlet-Name");
    final String APP_VERSION = "ver " + this.getAppProperty("MIDlet-Version");
    final String APP_SPLASH_COL;
    final String APP_SPLASH_BW;
    final String ABOUT_TEXT = this.APP_NAME + ", \n" + Strings.VERSION_STR + " " + this.getAppProperty("MIDlet-Version") + "\nCopyright 2003 Zindell Technologies, Ltd." + Strings.COPYRIGHT_STR + this.getAppProperty("MIDlet-Vendor") + " " + this.getAppProperty("MIDlet-Info-URL") + Strings.AS_IS_STR;
    private boolean bColorDevice;

    public Convex() {
        this.APP_SPLASH_COL = "/ConvexSplash.png";
        this.APP_SPLASH_BW = "/ConvexSplash_bw.png";
    }

    public void commandAction(Command command, Displayable displayable) {
        try {
            if (command == this.aboutCommand) {
                this.lastDisplayable = this.currentDisplayable;
                this.currentDisplayable = this.aboutForm;
                this.display.setCurrent((Displayable)this.aboutForm);
            } else if (command == this.helpCommand) {
                this.lastDisplayable = this.currentDisplayable;
                this.currentDisplayable = this.helpForm;
                this.display.setCurrent((Displayable)this.helpForm);
            } else if (command == this.backCommand) {
                if (displayable == this.settingForm2) {
                    this.currentDisplayable = this.getSettingForm1();
                } else if (displayable == this.helpForm || displayable == this.aboutForm) {
                    this.currentDisplayable = this.currentDisplayable == this.helpForm && this.lastDisplayable == this.settingForm1 ? this.getSettingForm1() : this.lastDisplayable;
                } else if (displayable == this.resultForm) {
                    this.resultForm.delete(0);
                    this.currentDisplayable = this.mainForm;
                } else if (displayable == this.errorForm) {
                    this.errorForm.delete(0);
                    this.currentDisplayable = this.lastDisplayable;
                    this.lastDisplayable = this.mainForm;
                }
                this.display.setCurrent(this.currentDisplayable);
            } else if (command == this.settingCommand) {
                this.currentDisplayable = this.getSettingForm1();
                this.display.setCurrent(this.currentDisplayable);
            } else if (command == this.nextCommand) {
                if (displayable == this.settingForm1) {
                    if (this.firstCurrTF.getString().equals("") || this.secondCurrTF.getString().equals("")) {
                        throw new EmptySettingForm1Exception("EmptySettingForm1Exception");
                    }
                    this.firstCurrency = this.firstCurrTF.getString().trim();
                    this.secondCurrency = this.secondCurrTF.getString().trim();
                    this.currentDisplayable = this.getSettingForm2();
                    this.display.setCurrent(this.currentDisplayable);
                } else if (displayable == this.mainForm && ConvexMethods.isNumeric(1, this.mainSumTF.getString())) {
                    this.selectedSumCG = this.mainSumCG.getSelectedIndex();
                    String string = "still empty";
                    String string2 = this.mainSumTF.getString();
                    String string3 = null;
                    String string4 = null;
                    if (this.selectedSumCG == 0) {
                        string3 = this.firstCurrency;
                        string4 = this.secondCurrency;
                    } else {
                        string3 = this.secondCurrency;
                        string4 = this.firstCurrency;
                    }
                    System.out.println("NEXT pressed, " + string);
                    string = this.selectedRateCG == this.selectedSumCG ? ConvexMethods.getDividedRate(this.rate, string2) : ConvexMethods.getMultipliedRate(this.rate, string2);
                    this.resultForm.append(Strings.GIVEN_RATE_STR + "\n" + this.rate + " " + this.rateCG.getString(this.selectedRateCG) + ":\n" + string2 + " " + string3 + " = " + string + " " + string4);
                    this.currentDisplayable = this.resultForm;
                    this.display.setCurrent(this.currentDisplayable);
                }
            } else if (command == this.doneCommand && ConvexMethods.isNumeric(2, this.rateTF.getString())) {
                this.rate = this.rateTF.getString();
                this.selectedRateCG = this.rateCG.getSelectedIndex();
                this.convex = new ConvexExchange(this.firstCurrency, this.secondCurrency, this.rate, String.valueOf(this.selectedRateCG));
                this.convexDB.setSettings(this.convex);
                this.convex = null;
                if (this.mainForm != null) {
                    this.mainForm = null;
                }
                this.currentDisplayable = this.getMainForm();
                this.display.setCurrent(this.currentDisplayable);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
            this.alertMemError = new Alert("Out of memory...", "There is not enough memory to complete this operation. Press OK to exit the application.", null, AlertType.ERROR);
            this.alertMemError.setTimeout(-2);
            this.exit();
        }
        catch (EmptySettingForm1Exception emptySettingForm1Exception) {
            emptySettingForm1Exception.printStackTrace();
            if (this.errorForm.size() > 0) {
                this.errorForm.delete(0);
            }
            this.errorForm.append(Strings.NO_NAMES_STR);
            this.lastDisplayable = this.currentDisplayable;
            this.currentDisplayable = this.errorForm;
            this.display.setCurrent(this.currentDisplayable);
        }
        catch (EmptySettingForm2Exception emptySettingForm2Exception) {
            emptySettingForm2Exception.printStackTrace();
            this.errorForm.append(Strings.NO_RATE_STR);
            this.lastDisplayable = this.currentDisplayable;
            this.currentDisplayable = this.errorForm;
            this.display.setCurrent(this.currentDisplayable);
        }
        catch (EmptyMainFormException emptyMainFormException) {
            emptyMainFormException.printStackTrace();
            this.errorForm.append(Strings.NO_SUM_STR);
            this.lastDisplayable = this.currentDisplayable;
            this.currentDisplayable = this.errorForm;
            this.display.setCurrent(this.currentDisplayable);
        }
        catch (NumericException numericException) {
            numericException.printStackTrace();
            this.errorForm.append(Strings.ONLY_NUMBERS_STR);
            this.lastDisplayable = this.currentDisplayable;
            this.currentDisplayable = this.errorForm;
            this.display.setCurrent(this.currentDisplayable);
        }
    }

    public void initMIDlet() {
        this.display = Display.getDisplay((MIDlet)this);
        this.bColorDevice = this.display.isColor();
        this.loadingForm = new Form(Strings.LOAD_STR);
        this.currentDisplayable = this.loadingForm;
        this.gauge = new Gauge(Strings.WAIT_STR, false, 3, 0);
        this.loadingForm.append((Item)this.gauge);
        this.gauge.setValue(0);
        this.display.setCurrent((Displayable)this.loadingForm);
        this.thread = new Thread(){

            public void run() {
                try {
                    Convex.this.backCommand = new Command(Strings.BACK_STR, 2, 2);
                    Convex.this.aboutCommand = new Command(Strings.ABOUT_STR, 5, 5);
                    Convex.this.nextCommand = new Command(Strings.NEXT_STR, 4, 4);
                    Convex.this.helpCommand = new Command(Strings.HELP_STR, 5, 5);
                    Convex.this.doneCommand = new Command(Strings.OK_STR, 4, 4);
                    Convex.this.settingCommand = new Command(Strings.SETTING_STR, 4, 4);
                    Convex.this.convexDB = new ConvexDB("convex.db");
                    Convex.this.gauge.setValue(1);
                    Convex.this.aboutForm = new Form(Strings.ABOUT_STR);
                    Convex.this.aboutForm.append(Convex.this.ABOUT_TEXT);
                    Convex.this.aboutForm.addCommand(Convex.this.backCommand);
                    Convex.this.aboutForm.setCommandListener((CommandListener)Convex.this);
                    Convex.this.helpForm = new Form(Strings.HELP_STR);
                    Convex.this.helpForm.append(Strings.HELP_TEXT);
                    Convex.this.helpForm.addCommand(Convex.this.backCommand);
                    Convex.this.helpForm.setCommandListener((CommandListener)Convex.this);
                    Convex.this.gauge.setValue(2);
                    Convex.this.errorForm = new Form(Convex.this.APP_NAME);
                    Convex.this.errorForm.addCommand(Convex.this.backCommand);
                    Convex.this.errorForm.setCommandListener((CommandListener)Convex.this);
                    Convex.this.resultForm = new Form(Strings.RESULT_STR);
                    Convex.this.resultForm.addCommand(Convex.this.backCommand);
                    Convex.this.resultForm.setCommandListener((CommandListener)Convex.this);
                    Convex.this.gauge.setValue(3);
                    Convex.this.splashCanvas = new SplashCanvas();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        this.thread.start();
    }

    private Form getSettingForm1() {
        if (this.settingForm1 == null) {
            this.settingForm1 = new Form(Strings.SETTING_STR);
            String string = "";
            String string2 = "";
            if (this.firstCurrency != null) {
                string = this.firstCurrency;
            }
            if (this.secondCurrency != null) {
                string2 = this.secondCurrency;
            }
            this.firstCurrTF = new TextField(Strings.FIRST_CURRENCY_STR, string, 6, 0);
            this.secondCurrTF = new TextField(Strings.SECOND_CURRENCY_STR, string2, 6, 0);
            this.settingForm1.append((Item)this.firstCurrTF);
            this.settingForm1.append((Item)this.secondCurrTF);
            this.settingForm1.addCommand(this.nextCommand);
            this.settingForm1.addCommand(this.helpCommand);
            this.settingForm1.setCommandListener((CommandListener)this);
        }
        return this.settingForm1;
    }

    private Form getSettingForm2() {
        if (this.settingForm2 == null) {
            this.settingForm2 = new Form(Strings.SETTING_STR);
            String string = "";
            if (this.rate != null) {
                string = this.rate;
            }
            this.rateTF = new TextField(Strings.RATE_STR, string, 10, 0);
            this.currencies = new String[2];
            this.settingForm2.append((Item)this.rateTF);
            this.settingForm2.addCommand(this.doneCommand);
            this.settingForm2.addCommand(this.backCommand);
            this.settingForm2.setCommandListener((CommandListener)this);
        }
        this.currencies[0] = null;
        this.currencies[1] = null;
        if (this.firstCurrency.length() + this.secondCurrency.length() > 12) {
            this.currencies[0] = this.firstCurrency + "s \n" + Strings.FOR_1_STR + this.secondCurrency;
            this.currencies[1] = this.secondCurrency + "s \n" + Strings.FOR_1_STR + this.firstCurrency;
        } else {
            this.currencies[0] = this.firstCurrency + "s " + Strings.FOR_1_STR + this.secondCurrency;
            this.currencies[1] = this.secondCurrency + "s " + Strings.FOR_1_STR + this.firstCurrency;
        }
        this.rateCG = new ChoiceGroup("", 1, this.currencies, null);
        if (this.settingForm2.size() > 1) {
            this.settingForm2.delete(1);
        }
        this.settingForm2.append((Item)this.rateCG);
        return this.settingForm2;
    }

    private Form getMainForm() {
        if (this.mainForm == null) {
            this.mainForm = new Form(this.APP_NAME);
            this.mainSumTF = new TextField(Strings.SUM_STR, "", 22, 2);
            this.conversions = new String[2];
            this.mainForm.append((Item)this.mainSumTF);
            this.mainForm.addCommand(this.nextCommand);
            this.mainForm.addCommand(this.settingCommand);
            this.mainForm.addCommand(this.helpCommand);
            this.mainForm.addCommand(this.aboutCommand);
            this.mainForm.setCommandListener((CommandListener)this);
        }
        this.conversions[0] = null;
        this.conversions[1] = null;
        if (this.firstCurrency.length() + this.secondCurrency.length() > 12) {
            this.conversions[0] = this.firstCurrency + " \n" + Strings.TO_STR + this.secondCurrency;
            this.conversions[1] = this.secondCurrency + " \n" + Strings.TO_STR + this.firstCurrency;
        } else {
            this.conversions[0] = this.firstCurrency + " " + Strings.TO_STR + this.secondCurrency;
            this.conversions[1] = this.secondCurrency + " " + Strings.TO_STR + this.firstCurrency;
        }
        System.out.println("in getMainForm()");
        System.out.println("firstCurrency.length() = " + this.firstCurrency.length());
        System.out.println("secondCurrency.length() = " + this.secondCurrency.length());
        System.out.println("conversions[0] = " + this.conversions[0]);
        System.out.println("conversions[1] = " + this.conversions[1]);
        this.mainSumCG = new ChoiceGroup(Strings.CONVERT_STR, 1, this.conversions, null);
        if (this.mainForm.size() > 1) {
            this.mainForm.delete(1);
        }
        this.mainForm.append((Item)this.mainSumCG);
        return this.mainForm;
    }

    public void startApp() {
        if (this.display == null) {
            this.initMIDlet();
        } else {
            this.display.setCurrent(this.currentDisplayable);
        }
    }

    public void pauseApp() {
        if (this.currentDisplayable != this.mainForm) {
            this.currentDisplayable = this.display.getCurrent();
        }
    }

    public void exit() {
        this.notifyDestroyed();
        try {
            this.destroyApp(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void destroyApp(boolean bl) {
        this.display = null;
        this.currentDisplayable = null;
        this.lastDisplayable = null;
        this.splashCanvas = null;
        this.loadingForm = null;
        this.settingForm1 = null;
        this.settingForm2 = null;
        this.mainForm = null;
        this.aboutForm = null;
        this.helpForm = null;
        this.resultForm = null;
        this.errorForm = null;
        this.gauge = null;
        this.thread = null;
        this.alertMemError = null;
        this.firstCurrency = null;
        this.secondCurrency = null;
        this.rate = null;
        this.convexDB = null;
        this.convex = null;
        this.firstCurrTF = null;
        this.secondCurrTF = null;
        this.rateTF = null;
        this.rateCG = null;
        this.mainSumTF = null;
        this.mainSumCG = null;
        this.backCommand = null;
        this.aboutCommand = null;
        this.nextCommand = null;
        this.helpCommand = null;
        this.doneCommand = null;
        this.settingCommand = null;
    }

    private class SplashCanvas
    extends FullCanvas {
        private Timer timer = new Timer();
        private Image splashImg;
        private int width = this.getWidth();
        private int height = this.getHeight();
        private int x;
        private int y1;
        private int y2;
        private Font bigFont = Font.getFont((int)0, (int)1, (int)16);
        private Font smallFont = Font.getFont((int)0, (int)1, (int)0);

        private SplashCanvas() {
            try {
                this.splashImg = Convex.this.bColorDevice ? Image.createImage((String)"/ConvexSplash.png") : Image.createImage((String)"/ConvexSplash_bw.png");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.x = this.getWidth() / 2;
            this.y1 = this.getHeight() / 2;
            this.y2 = this.splashImg.getHeight() / 2;
            Convex.this.display.setCurrent((Displayable)this);
        }

        protected void showNotify() {
            this.timer.schedule((TimerTask)new CountDown(), 5000L);
        }

        protected void keyPressed(int n) {
            System.out.println("key pressed");
            this.dismiss();
        }

        protected void pointerPressed(int n, int n2) {
            this.dismiss();
        }

        protected void paint(Graphics graphics) {
            graphics.setColor(255, 255, 255);
            graphics.fillRect(0, 0, this.width, this.height);
            graphics.drawImage(this.splashImg, this.x, this.y1, 3);
            if (!Convex.this.bColorDevice) {
                graphics.setColor(0, 0, 0);
                graphics.drawString(Convex.this.APP_NAME, this.x, 2, 17);
                graphics.setFont(Font.getFont((int)64, (int)0, (int)8));
                graphics.drawString(Convex.this.APP_VERSION, this.x, this.getHeight() - 2, 33);
            }
        }

        private void dismiss() {
            this.timer.cancel();
            try {
                if (((Convex)Convex.this).convexDB.firstTime || Convex.this.convexDB.isEmpty()) {
                    Convex.this.currentDisplayable = (Displayable)Convex.this.getSettingForm1();
                } else {
                    String[] stringArray = ConvexMethods.initializeRate(Convex.this.convexDB);
                    Convex.this.firstCurrency = stringArray[0];
                    Convex.this.secondCurrency = stringArray[1];
                    Convex.this.rate = stringArray[2];
                    Convex.this.selectedRateCG = Integer.parseInt(stringArray[3]);
                    Convex.this.rateCG = new ChoiceGroup("", 1, new String[]{Convex.this.firstCurrency + "s " + Strings.FOR_1_STR + Convex.this.secondCurrency, Convex.this.secondCurrency + "s " + Strings.FOR_1_STR + Convex.this.firstCurrency}, null);
                    Convex.this.mainSumCG = new ChoiceGroup("to convert from", 1, new String[]{Convex.this.firstCurrency + " " + Strings.TO_STR + Convex.this.secondCurrency, Convex.this.secondCurrency + " " + Strings.TO_STR + Convex.this.firstCurrency}, null);
                    Convex.this.currentDisplayable = (Displayable)Convex.this.getMainForm();
                }
            }
            catch (RecordStoreNotOpenException recordStoreNotOpenException) {
                recordStoreNotOpenException.printStackTrace();
            }
            Convex.this.display.setCurrent(Convex.this.currentDisplayable);
        }

        private class CountDown
        extends TimerTask {
            private CountDown() {
            }

            public void run() {
                SplashCanvas.this.dismiss();
            }
        }
    }
}

