/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;

public class ConvexExchange {
    private String firstCurrency;
    private String secondCurrency;
    private String rate;
    private String fromTo;
    private int id;

    ConvexExchange(int n, byte[] byArray) {
        this.id = n;
        this.initialize(byArray);
    }

    ConvexExchange(String string, String string2, String string3, String string4) {
        this.firstCurrency = string;
        this.secondCurrency = string2;
        this.rate = string3;
        this.fromTo = string4;
    }

    String getFirstCurrency() {
        return this.firstCurrency;
    }

    String getSecondCurrency() {
        return this.secondCurrency;
    }

    String getRate() {
        return this.rate;
    }

    String getFromTo() {
        return this.fromTo;
    }

    int getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            filterInputStream = new DataInputStream(byteArrayInputStream);
            this.firstCurrency = ((DataInputStream)filterInputStream).readUTF();
            this.secondCurrency = ((DataInputStream)filterInputStream).readUTF();
            this.rate = ((DataInputStream)filterInputStream).readUTF();
            this.fromTo = ((DataInputStream)filterInputStream).readUTF();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                byteArrayInputStream.close();
                filterInputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toBytes() {
        byte[] byArray = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            filterOutputStream = new DataOutputStream(byteArrayOutputStream);
            ((DataOutputStream)filterOutputStream).writeUTF(this.firstCurrency);
            ((DataOutputStream)filterOutputStream).writeUTF(this.secondCurrency);
            ((DataOutputStream)filterOutputStream).writeUTF(this.rate);
            ((DataOutputStream)filterOutputStream).writeUTF(this.fromTo);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                byteArrayOutputStream.close();
                filterOutputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return byArray;
    }
}

