/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreNotFoundException;

public class TypeDB {
    private RecordStore rs = null;
    boolean firstTime = false;

    TypeDB(String string) throws Exception {
        try {
            this.rs = RecordStore.openRecordStore((String)string, (boolean)false);
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            this.rs = RecordStore.openRecordStore((String)string, (boolean)true);
            this.firstTime = true;
        }
    }

    int addType(String string, Type type) throws Exception {
        if (string.equals("")) {
            throw new NoNameException("no name");
        }
        if (!this.checkName(string)) {
            byte[] byArray = type.toBytes();
            return this.rs.addRecord(byArray, 0, byArray.length);
        }
        throw new SameNameException("same type name");
    }

    boolean checkName(String string) throws SameNameException {
        Vector vector = this.getTypes();
        int n = 0;
        while (n < vector.size()) {
            if (((Type)vector.elementAt(n)).getName().equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void deleteType(int n) throws Exception {
        this.rs.deleteRecord(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Vector getTypes() {
        RecordEnumeration recordEnumeration = null;
        Vector<Type> vector = new Vector<Type>();
        try {
            recordEnumeration = this.rs.enumerateRecords(null, null, false);
            int n = 0;
            while (recordEnumeration.hasNextElement()) {
                n = recordEnumeration.nextRecordId();
                byte[] byArray = this.rs.getRecord(n);
                vector.addElement(new Type(n, byArray));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (recordEnumeration != null) {
                recordEnumeration.destroy();
            }
        }
        return vector;
    }
}

