/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.FullCanvas;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public class Speedex
extends MIDlet
implements CommandListener {
    private Display display;
    private Displayable currentDisplayable;
    private SplashCanvas splashCanvas;
    private Form mainForm;
    private Form aboutForm;
    private Form helpForm;
    private Form resultForm;
    private Form errorForm;
    private StringItem errorSI;
    private StringItem helpSI;
    private StringItem aboutSI;
    private StringItem resultK;
    private StringItem resultM;
    private String km;
    private String mile;
    private String errorMsg = "";
    private String appSplash;
    private TextField speedTF;
    private ChoiceGroup speedCG;
    final String APP_NAME;
    final String APP_VERSION = "version " + this.getAppProperty("MIDlet-Version");
    final String APP_SPLASH;
    final String ABOUT_STR = "Speedex, version " + this.getAppProperty("MIDlet-Version") + "\nCopyright 2003 Zindell Technologies, Ltd. All rights reserved. Developed by " + this.getAppProperty("MIDlet-Vendor") + "\n" + this.getAppProperty("MIDlet-Info-URL") + "\nSoftware is provided \"AS IS\" without warranty of any kind. In no event, shall we be liable for any claim, damages or other liability.";
    final String HELP_STR;
    private Command exitCommand = new Command("Exit", 7, 5);
    private Command backCommand = new Command("Back", 2, 2);
    private Command aboutCommand = new Command("About", 5, 5);
    private Command nextCommand = new Command("Next", 4, 4);
    private Command helpCommand = new Command("Help", 5, 5);

    public Speedex() {
        this.APP_NAME = "Speedex";
        this.APP_SPLASH = "/SpeedexSplash.png";
        this.HELP_STR = "Enter the speed in km/hour or miles/hour, and select 'Next' to get the speed both in km/hour and in miles/hour.";
        this.errorSI = new StringItem("Pay attention:", this.errorMsg);
        System.out.println("creating the mainForm");
        this.mainForm = new Form("Speedex");
        this.speedTF = new TextField("Enter speed", "", 3, 2);
        this.speedCG = new ChoiceGroup("in", 1, new String[]{"km/hour", "miles/hour"}, null);
        this.mainForm.append((Item)this.speedTF);
        this.mainForm.append((Item)this.speedCG);
        this.mainForm.addCommand(this.nextCommand);
        this.mainForm.addCommand(this.exitCommand);
        this.mainForm.addCommand(this.helpCommand);
        this.mainForm.addCommand(this.aboutCommand);
        this.mainForm.setCommandListener((CommandListener)this);
        System.out.println("creating the aboutForm");
        this.aboutForm = new Form("About");
        this.aboutForm.append(this.ABOUT_STR);
        this.aboutForm.addCommand(this.backCommand);
        this.aboutForm.setCommandListener((CommandListener)this);
        System.out.println("creating the helpForm");
        this.helpForm = new Form("Help");
        this.helpForm.append("Enter the speed in km/hour or miles/hour, and select 'Next' to get the speed both in km/hour and in miles/hour.");
        this.helpForm.addCommand(this.backCommand);
        this.helpForm.setCommandListener((CommandListener)this);
        System.out.println("creating the errorForm");
        this.errorForm = new Form("Speedex");
        this.errorForm.append((Item)this.errorSI);
        this.errorForm.addCommand(this.backCommand);
        this.errorForm.setCommandListener((CommandListener)this);
        System.out.println("creating the resultForm");
        this.resultForm = new Form("Speedex");
        this.resultK = new StringItem("km/hour", "");
        this.resultM = new StringItem("miles/hour", "");
        this.resultForm.append((Item)this.resultK);
        this.resultForm.append((Item)this.resultM);
        this.resultForm.addCommand(this.backCommand);
        this.resultForm.setCommandListener((CommandListener)this);
    }

    public void exit() {
        this.notifyDestroyed();
        try {
            this.destroyApp(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void startApp() {
        if (this.display == null) {
            this.display = Display.getDisplay((MIDlet)this);
            System.out.println("getting splashCanvas");
            this.splashCanvas = new SplashCanvas();
        }
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
        this.display = null;
        this.currentDisplayable = null;
        this.splashCanvas = null;
        this.mainForm = null;
        this.aboutForm = null;
        this.helpForm = null;
        this.resultForm = null;
        this.errorForm = null;
        this.errorSI = null;
        this.helpSI = null;
        this.aboutSI = null;
        this.resultK = null;
        this.resultM = null;
        this.km = null;
        this.mile = null;
        this.errorMsg = null;
        this.appSplash = null;
        this.speedTF = null;
        this.speedCG = null;
        this.exitCommand = null;
        this.backCommand = null;
        this.aboutCommand = null;
        this.nextCommand = null;
        this.helpCommand = null;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.aboutCommand) {
            this.currentDisplayable = this.aboutForm;
            this.display.setCurrent((Displayable)this.aboutForm);
        } else if (command == this.exitCommand) {
            this.exit();
        } else if (command == this.backCommand) {
            this.currentDisplayable = this.mainForm;
            this.display.setCurrent((Displayable)this.mainForm);
        } else if (command == this.helpCommand) {
            this.currentDisplayable = this.helpForm;
            this.display.setCurrent((Displayable)this.helpForm);
        } else if (command == this.nextCommand) {
            System.out.println("NEXT was pressed");
            if (this.speedTF.getString().equals("")) {
                this.errorMsg = "Please, enter speed.";
                this.errorSI.setText(this.errorMsg);
                this.currentDisplayable = this.errorForm;
                this.display.setCurrent((Displayable)this.errorForm);
            } else {
                if (this.speedTF.getString().equals("0")) {
                    this.km = "0";
                    this.mile = "0";
                } else {
                    System.out.println("getting km string");
                    this.km = this.showKm();
                    System.out.println("getting miles string");
                    this.mile = this.showMiles();
                }
                System.out.println("setting StringItems");
                this.resultK.setText("   " + this.km);
                this.resultM.setText("   " + this.mile);
                System.out.println("setting display for result");
                this.currentDisplayable = this.resultForm;
                this.display.setCurrent((Displayable)this.resultForm);
            }
        }
    }

    public String showKm() {
        System.out.println("inside showKm");
        if (this.speedCG.getString(this.speedCG.getSelectedIndex()).equals("km/hour")) {
            return this.speedTF.getString();
        }
        int n = Integer.parseInt(this.speedTF.getString());
        System.out.println("a = " + n);
        String string = String.valueOf(n * 18);
        System.out.println("str = " + string);
        int n2 = string.length();
        System.out.println("len = " + n2);
        String string2 = string.substring(0, n2 - 1) + "." + string.substring(n2 - 1, n2);
        System.out.println("strResult = " + string2);
        return string2;
    }

    public String showMiles() {
        System.out.println("inside showMiles");
        if (this.speedCG.getString(this.speedCG.getSelectedIndex()).equals("km/hour")) {
            long l = Long.parseLong(this.speedTF.getString());
            System.out.println("a = " + l);
            long l2 = 10000L * l / 18L;
            System.out.println("b = " + l2);
            String string = String.valueOf(l2);
            System.out.println("str = " + string);
            int n = string.length();
            System.out.println("len = " + n);
            String string2 = string.substring(0, n - 3) + "." + string.substring(n - 3, n - 1);
            System.out.println("strResult = " + string2);
            return string2;
        }
        return this.speedTF.getString();
    }

    private class SplashCanvas
    extends FullCanvas {
        private Timer timer = new Timer();
        private Image splashImg;
        private int width = this.getWidth();
        private int height = this.getHeight();
        private int x;
        private int y1;
        private int y2;
        private Font bigFont = Font.getFont((int)0, (int)1, (int)16);
        private Font smallFont = Font.getFont((int)0, (int)1, (int)0);

        private SplashCanvas() {
            try {
                this.splashImg = Image.createImage((String)"/SpeedexSplash.png");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.x = this.getWidth() / 2;
            this.y1 = this.getHeight() / 2;
            this.y2 = this.splashImg.getHeight() / 2;
            Speedex.this.display.setCurrent((Displayable)this);
        }

        protected void showNotify() {
            this.timer.schedule((TimerTask)new CountDown(), 5000L);
        }

        protected void keyPressed(int n) {
            System.out.println("key pressed");
            this.dismiss();
        }

        protected void pointerPressed(int n, int n2) {
            this.dismiss();
        }

        protected void paint(Graphics graphics) {
            graphics.drawImage(this.splashImg, this.x, this.y1, 3);
        }

        private void dismiss() {
            this.timer.cancel();
            Speedex.this.currentDisplayable = (Displayable)Speedex.this.mainForm;
            Speedex.this.display.setCurrent((Displayable)Speedex.this.mainForm);
        }

        private class CountDown
        extends TimerTask {
            private CountDown() {
            }

            public void run() {
                SplashCanvas.this.dismiss();
            }
        }
    }
}

