/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;

public class GameNetwork {
    Win midletWin;
    boolean isNetworkFinished = true;
    boolean isWaitingForChallenge = false;
    private StreamConnection gameConnection = null;
    private OutputStream sendStream = null;
    private InputStream recvStream = null;
    String serverAddr = "203.84.28.249:7501";
    private int sectionID;
    private int seqID;
    String password;
    String tempstring;
    static final int COMMAND_LOGIN = 1;
    static final int COMMAND_REQ_RECORD_LIST = 2;
    static final int COMMAND_REQ_USER_INFO = 3;
    static final int COMMAND_REQ_COMPETITORS_LIST = 4;
    static final int COMMAND_WAIT_CHALLENGE = 5;
    static final int COMMAND_SELECT_COMPETITOR = 6;
    static final int COMMAND_SELECT_ICON = 7;
    static final int COMMAND_LOGOUT = 8;
    static final int COMMAND_REGISTER = 9;
    static final int COMMAND_COMPETITOR_REPLY = 10;
    Timer testtimer;

    void startTimer() {
        this.testtimer = new Timer();
        TimerTask timerTask = new TimerTask(){

            public void run() {
                GameNetwork.this.resetNetwork();
                GameNetwork.this.midletWin.showError("\u7db2\u8def\u903e\u6642, \u8acb\u91cd\u65b0\u767b\u5165!");
            }
        };
        this.testtimer.schedule(timerTask, 30000L);
    }

    void stopTimer() {
        this.testtimer.cancel();
        this.testtimer = null;
    }

    public GameNetwork(Win win) {
        this.midletWin = win;
        this.sectionID = 0;
        this.seqID = 0;
    }

    public void resetNetwork() {
        if (this.midletWin.isLogin) {
            this.logout();
        }
        this.closeNetwork();
        this.seqID = 0;
        this.sectionID = 0;
        this.isNetworkFinished = true;
    }

    public void register(String string) {
        this.password = string;
        this.isNetworkFinished = false;
        this.midletWin.showNetworkWaiting();
        this.startTimer();
        Thread thread = new Thread(){

            public void run() {
                try {
                    if (GameNetwork.this.gameConnection == null) {
                        GameNetwork.this.gameConnection = (StreamConnection)Connector.open((String)("socket://" + GameNetwork.this.serverAddr));
                        GameNetwork.this.sendStream = GameNetwork.this.gameConnection.openOutputStream();
                        GameNetwork.this.recvStream = GameNetwork.this.gameConnection.openInputStream();
                    }
                    String string = "";
                    string = string + GameNetwork.this.intToString(GameNetwork.this.midletWin.currentPlayer.photoID, 1);
                    int n = 0;
                    while (n < 10 - GameNetwork.this.midletWin.currentPlayer.name.length()) {
                        string = string + " ";
                        ++n;
                    }
                    string = string + GameNetwork.this.midletWin.currentPlayer.name;
                    string = string + GameNetwork.this.password;
                    GameNetwork.this.sendData(9, string);
                    String string2 = GameNetwork.this.recvData(9);
                    GameNetwork.this.stopTimer();
                    if (!GameNetwork.this.isNetworkFinished) {
                        GameNetwork.this.isNetworkFinished = true;
                        if (string2.compareTo("S") == 0) {
                            GameNetwork.this.midletWin.isLogin = true;
                            GameNetwork.this.midletWin.showMenu();
                            Alert alert = new Alert("\u5305\u526a\u939a", "\u767b\u8a18\u6210\u529f, \u8acb\u9078\u64c7\u76ee\u9304", null, AlertType.INFO);
                            alert.setTimeout(-2);
                            Display.getDisplay((MIDlet)GameNetwork.this.midletWin).setCurrent((Displayable)alert);
                        } else {
                            GameNetwork.this.seqID = 0;
                            GameNetwork.this.sectionID = 0;
                            GameNetwork.this.midletWin.userRegister();
                            Alert alert = new Alert("\u932f\u8aa4", "\u767b\u5165\u540d\u7a31\u91cd\u8907, \u8acb\u518d\u8f38\u5165", null, AlertType.ERROR);
                            alert.setTimeout(-2);
                            Display.getDisplay((MIDlet)GameNetwork.this.midletWin).setCurrent((Displayable)alert);
                        }
                    }
                }
                catch (Exception exception) {
                    GameNetwork.this.stopTimer();
                    GameNetwork.this.resetNetwork();
                    GameNetwork.this.midletWin.showError(exception.getMessage());
                }
            }
        };
        thread.start();
    }

    public void login(String string) {
        this.password = string;
        this.isNetworkFinished = false;
        this.midletWin.showNetworkWaiting();
        this.startTimer();
        Thread thread = new Thread(){

            public void run() {
                try {
                    if (GameNetwork.this.gameConnection == null) {
                        GameNetwork.this.gameConnection = (StreamConnection)Connector.open((String)("socket://" + GameNetwork.this.serverAddr));
                        GameNetwork.this.sendStream = GameNetwork.this.gameConnection.openOutputStream();
                        GameNetwork.this.recvStream = GameNetwork.this.gameConnection.openInputStream();
                    }
                    GameNetwork.this.sendData(1, GameNetwork.this.password);
                    String string = GameNetwork.this.recvData(1);
                    if (!GameNetwork.this.isNetworkFinished) {
                        GameNetwork.this.isNetworkFinished = true;
                        GameNetwork.this.midletWin.isLogin = true;
                        GameNetwork.this.midletWin.currentPlayer.photoID = GameNetwork.this.stringToInt(string.substring(0, 1)) - 1;
                        if (GameNetwork.this.midletWin.currentPlayer.photoID < 0) {
                            GameNetwork.this.stopTimer();
                            GameNetwork.this.midletWin.showError("Wrong Photo ID");
                            return;
                        }
                        GameNetwork.this.midletWin.currentPlayer.name = string.substring(1).trim();
                        GameNetwork.this.stopTimer();
                        switch (GameNetwork.this.midletWin.selectedGame) {
                            case 1: {
                                GameNetwork.this.requestCompetitorsList();
                                break;
                            }
                            case 2: {
                                GameNetwork.this.requestUserInfo();
                                break;
                            }
                            case 3: {
                                GameNetwork.this.requestRecordList();
                                break;
                            }
                            default: {
                                GameNetwork.this.midletWin.showError("Wrong Selected Game");
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    GameNetwork.this.stopTimer();
                    GameNetwork.this.resetNetwork();
                    GameNetwork.this.midletWin.showError(exception.getMessage());
                }
            }
        };
        thread.start();
    }

    public void selectCompetitorReply(boolean bl) {
        this.midletWin.showNetworkWaiting();
        this.isNetworkFinished = false;
        this.tempstring = bl ? "S" : "F";
        this.startTimer();
        Thread thread = new Thread(){

            public void run() {
                try {
                    GameNetwork.this.sendData(10, GameNetwork.this.tempstring);
                    String string = GameNetwork.this.recvData(10);
                    if (!GameNetwork.this.isNetworkFinished) {
                        GameNetwork.this.isNetworkFinished = true;
                        GameNetwork.this.stopTimer();
                        if (GameNetwork.this.tempstring.compareTo("F") == 0) {
                            GameNetwork.this.midletWin.selectPlayer();
                        } else {
                            GameNetwork.this.midletWin.startPlaying(false);
                        }
                    }
                }
                catch (Exception exception) {
                    GameNetwork.this.stopTimer();
                    GameNetwork.this.resetNetwork();
                    GameNetwork.this.midletWin.showError(exception.getMessage());
                }
            }
        };
        thread.start();
    }

    public void requestCompetitorsList() {
        this.midletWin.showNetworkWaiting();
        this.isNetworkFinished = false;
        this.startTimer();
        Thread thread = new Thread(){

            public void run() {
                try {
                    GameNetwork.this.sendData(4, "");
                    String string = GameNetwork.this.recvData(4);
                    if (!GameNetwork.this.isNetworkFinished) {
                        GameNetwork.this.isNetworkFinished = true;
                        GameNetwork.this.midletWin.playersCount = 8;
                        int n = 0;
                        while (n < GameNetwork.this.midletWin.playersCount) {
                            int n2 = GameNetwork.this.stringToInt(string.substring(n * 16, n * 16 + 5));
                            int n3 = GameNetwork.this.stringToInt(string.substring(n * 16 + 5, n * 16 + 6)) - 1;
                            if (n3 < 0) {
                                GameNetwork.this.stopTimer();
                                GameNetwork.this.midletWin.showError("Wrong photo ID");
                                return;
                            }
                            String string2 = string.substring(n * 16 + 6, n * 16 + 16).trim();
                            GameNetwork.this.midletWin.players[n] = GameNetwork.this.midletWin.NewPlayer(n2, n3, string2);
                            ++n;
                        }
                        GameNetwork.this.stopTimer();
                        GameNetwork.this.midletWin.selectPlayer();
                    }
                }
                catch (Exception exception) {
                    GameNetwork.this.stopTimer();
                    GameNetwork.this.resetNetwork();
                    GameNetwork.this.midletWin.showError(exception.getMessage());
                }
            }
        };
        thread.start();
    }

    public void waitForChallenge() {
        this.midletWin.showError("\u7b49\u5f85\u6311\u6230");
        this.isWaitingForChallenge = true;
        Thread thread = new Thread(){

            public void run() {
                try {
                    GameNetwork.this.sendData(5, "");
                    String string = GameNetwork.this.recvData(5);
                    if (GameNetwork.this.isWaitingForChallenge) {
                        GameNetwork.this.isWaitingForChallenge = false;
                        GameNetwork.this.midletWin.playersCount = 1;
                        int n = GameNetwork.this.stringToInt(string.substring(0, 1)) - 1;
                        if (n < 0) {
                            GameNetwork.this.midletWin.showError("Wrong Photo ID");
                            return;
                        }
                        String string2 = string.substring(1).trim();
                        GameNetwork.this.midletWin.players[0] = GameNetwork.this.midletWin.NewPlayer(0, n, string2);
                        GameNetwork.this.midletWin.selectedCompetitor = 0;
                        GameNetwork.this.midletWin.selectedByCompetitor();
                    }
                }
                catch (Exception exception) {
                    GameNetwork.this.resetNetwork();
                    GameNetwork.this.midletWin.showError(exception.getMessage());
                }
            }
        };
        thread.start();
    }

    public void requestUserInfo() {
        this.midletWin.showNetworkWaiting();
        this.isNetworkFinished = false;
        this.startTimer();
        Thread thread = new Thread(){

            public void run() {
                try {
                    GameNetwork.this.sendData(3, "");
                    String string = GameNetwork.this.recvData(3);
                    if (!GameNetwork.this.isNetworkFinished) {
                        GameNetwork.this.isNetworkFinished = true;
                        GameNetwork.this.midletWin.currentPlayer.matchTime = GameNetwork.this.stringToInt(string.substring(0, 3));
                        GameNetwork.this.midletWin.currentPlayer.winTime = GameNetwork.this.stringToInt(string.substring(3, 6));
                        GameNetwork.this.midletWin.currentPlayer.place = GameNetwork.this.stringToInt(string.substring(6, 11));
                        GameNetwork.this.stopTimer();
                        GameNetwork.this.midletWin.showGameHistory();
                    }
                }
                catch (Exception exception) {
                    GameNetwork.this.stopTimer();
                    GameNetwork.this.resetNetwork();
                    GameNetwork.this.midletWin.showError(exception.getMessage());
                }
            }
        };
        thread.start();
    }

    public void selectCompetitor() {
        this.midletWin.showNetworkWaiting();
        this.isNetworkFinished = false;
        this.startTimer();
        Thread thread = new Thread(){

            public void run() {
                try {
                    String string = GameNetwork.this.intToString(GameNetwork.this.midletWin.players[GameNetwork.this.midletWin.selectedCompetitor].ID, 5);
                    GameNetwork.this.sendData(6, string);
                    String string2 = GameNetwork.this.recvData(6);
                    if (!GameNetwork.this.isNetworkFinished) {
                        GameNetwork.this.isNetworkFinished = true;
                        GameNetwork.this.stopTimer();
                        if (string2.compareTo("S") == 0) {
                            GameNetwork.this.midletWin.startPlaying(false);
                        } else {
                            GameNetwork.this.midletWin.selectPlayer();
                            Alert alert = new Alert("\u5305\u526a\u939a", "\u5c0d\u6230\u73a9\u5bb6\u62d2\u7d55\u6bd4\u8cfd, \u8acb\u518d\u9078\u64c7", null, AlertType.INFO);
                            alert.setTimeout(-2);
                            Display.getDisplay((MIDlet)GameNetwork.this.midletWin).setCurrent((Displayable)alert);
                        }
                    }
                }
                catch (Exception exception) {
                    GameNetwork.this.stopTimer();
                    GameNetwork.this.resetNetwork();
                    GameNetwork.this.midletWin.showError(exception.getMessage());
                }
            }
        };
        thread.start();
    }

    public void logout() {
        this.midletWin.isLogin = false;
        try {
            if (this.gameConnection != null) {
                this.sendData(8, "");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendIcon() {
        this.startTimer();
        this.isNetworkFinished = false;
        Thread thread = new Thread(){

            public void run() {
                try {
                    String string = GameNetwork.this.intToString(GameNetwork.this.midletWin.bPlaying.selectedIcon + 1, 1);
                    GameNetwork.this.sendData(7, string);
                    String string2 = GameNetwork.this.recvData(7);
                    if (!GameNetwork.this.isNetworkFinished) {
                        GameNetwork.this.isNetworkFinished = true;
                        GameNetwork.this.stopTimer();
                        GameNetwork.this.midletWin.bPlaying.setResult(GameNetwork.this.stringToInt(string2) - 1);
                    }
                }
                catch (Exception exception) {
                    GameNetwork.this.stopTimer();
                    GameNetwork.this.midletWin.showError(exception.getMessage());
                }
            }
        };
        thread.start();
    }

    public void requestRecordList() {
        this.midletWin.showNetworkWaiting();
        this.startTimer();
        this.isNetworkFinished = false;
        Thread thread = new Thread(){

            public void run() {
                try {
                    GameNetwork.this.sendData(2, "");
                    String string = GameNetwork.this.recvData(2);
                    if (!GameNetwork.this.isNetworkFinished) {
                        GameNetwork.this.isNetworkFinished = true;
                        int n = 0;
                        while (n < 4) {
                            int n2 = GameNetwork.this.stringToInt(string.substring(n * 17, n * 17 + 1)) - 1;
                            if (n2 < 0) {
                                GameNetwork.this.stopTimer();
                                GameNetwork.this.midletWin.showError("Wrong Photo ID");
                                return;
                            }
                            String string2 = string.substring(n * 17 + 1, n * 17 + 11).trim();
                            GameNetwork.this.midletWin.recordlist[n] = GameNetwork.this.midletWin.NewPlayer(n, n2, string2);
                            GameNetwork.this.midletWin.recordlist[n].matchTime = GameNetwork.this.stringToInt(string.substring(n * 17 + 11, n * 17 + 14));
                            GameNetwork.this.midletWin.recordlist[n].winTime = GameNetwork.this.stringToInt(string.substring(n * 17 + 14, n * 17 + 17));
                            ++n;
                        }
                        GameNetwork.this.stopTimer();
                        GameNetwork.this.midletWin.showRecordList();
                    }
                }
                catch (Exception exception) {
                    GameNetwork.this.stopTimer();
                    GameNetwork.this.midletWin.showError(exception.getMessage());
                }
            }
        };
        thread.start();
    }

    private String intToString(int n, int n2) {
        String string = "" + n;
        int n3 = n2 - string.length();
        int n4 = 0;
        while (n4 < n3) {
            string = "0" + string;
            ++n4;
        }
        return string;
    }

    private int stringToInt(String string) {
        return Integer.parseInt(string);
    }

    private void sendData(int n, String string) throws Exception {
        String string2 = "";
        string2 = string2 + this.intToString(this.sectionID, 4);
        string2 = string2 + this.intToString(this.seqID, 4);
        string2 = string2 + this.intToString(n, 2);
        string = string2 + string;
        int n2 = string.length();
        byte[] byArray = new byte[n2];
        System.arraycopy(string.getBytes(), 0, byArray, 0, n2);
        this.sendStream.write(byArray);
    }

    private String recvData(int n) throws Exception {
        String string = "";
        int n2 = 0;
        int n3 = 0;
        switch (n) {
            case 1: {
                n2 = 21;
                break;
            }
            case 2: {
                n2 = 78;
                break;
            }
            case 3: {
                n2 = 21;
                break;
            }
            case 4: {
                n2 = 138;
                break;
            }
            case 5: {
                n2 = 21;
                break;
            }
            case 6: {
                n2 = 11;
                break;
            }
            case 7: {
                n2 = 11;
                break;
            }
            case 9: {
                n2 = 11;
                break;
            }
            case 10: {
                n2 = 10;
                break;
            }
            case 8: {
                return string;
            }
        }
        try {
            byte[] byArray = new byte[n2];
            int n4 = this.recvStream.read(byArray);
            n3 += n4;
            while (n3 < n2) {
                byte[] byArray2 = new byte[n2 - n3];
                n4 = this.recvStream.read(byArray);
                if (n4 <= 0) {
                    throw new Exception("Network Error");
                }
                System.arraycopy(byArray, n3, byArray2, 0, n4);
                n3 += n4;
            }
            string = new String(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            throw new Exception("receive " + exception.getMessage());
        }
        if (n == 1 || n == 9) {
            this.sectionID = this.stringToInt(string.substring(0, 4));
            if (this.sectionID == 0) {
                throw new Exception("Login Failed!");
            }
        } else if (this.sectionID != this.stringToInt(string.substring(0, 4))) {
            throw new Exception("Section Error!");
        }
        if (this.seqID != this.stringToInt(string.substring(4, 8))) {
            throw new Exception("Sequence Number Error");
        }
        if (n != this.stringToInt(string.substring(8, 10))) {
            throw new Exception("Command ID Error");
        }
        ++this.seqID;
        if (string.length() > 10) {
            return string.substring(10);
        }
        return "";
    }

    void closeNetwork() {
        try {
            if (this.sendStream != null) {
                this.sendStream.close();
            }
            if (this.recvStream != null) {
                this.recvStream.close();
            }
            if (this.gameConnection != null) {
                this.gameConnection.close();
            }
            this.sendStream = null;
            this.recvStream = null;
            this.gameConnection = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

