/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BoardMessage
extends Canvas
implements CommandListener {
    Win midletWin;
    String errorMessage = "";
    int status;
    static final int RESULTLOSS = 0;
    static final int RESULTWIN = 1;
    static final int NETWORKWAITING = 2;
    static final int SIMPLEMESSAGE = 3;
    static final int GAMEHISTORY = 4;
    static final int RECORDLIST = 5;
    Image winImage;
    Image lossImage;
    Image waitingImage;
    Image userInfoImage;
    Image recordListImage;

    public BoardMessage(Win win) {
        this.midletWin = win;
        this.status = 2;
        this.setCommandListener(this);
        this.addCommand(this.midletWin.BackCommand);
        try {
            this.winImage = Image.createImage((String)"/win_big.png");
            this.lossImage = Image.createImage((String)"/loss_big.png");
            this.waitingImage = Image.createImage((String)"/waiting.png");
            this.userInfoImage = Image.createImage((String)"/user_info_title.png");
            this.recordListImage = Image.createImage((String)"/list_title.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.midletWin.BackCommand) {
            this.midletWin.network.isNetworkFinished = true;
            this.midletWin.network.isWaitingForChallenge = false;
            this.midletWin.showMenu();
        }
    }

    public void paint(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        switch (this.status) {
            case 0: {
                graphics.drawImage(this.lossImage, 0, 0, 20);
                break;
            }
            case 1: {
                graphics.drawImage(this.winImage, 0, 0, 20);
                break;
            }
            case 2: {
                graphics.setColor(16541188);
                graphics.fillRect(0, 0, n, n2);
                graphics.setColor(0xFFFFFF);
                graphics.fillRoundRect(5, 4, 110, 129, 5, 5);
                graphics.drawImage(this.waitingImage, n / 2, 50, 17);
                break;
            }
            case 3: {
                graphics.setColor(10224132);
                graphics.fillRect(0, 0, n, n2);
                graphics.setColor(0xFFFFFF);
                graphics.drawString(this.errorMessage, n / 2, 50, 17);
                break;
            }
            case 4: {
                graphics.setColor(3952228);
                graphics.fillRect(0, 0, n, n2);
                graphics.setColor(0xFFFFFF);
                graphics.fillRoundRect(4, 4, 112, 130, 5, 5);
                graphics.drawImage(this.userInfoImage, n / 2, 4, 17);
                graphics.drawImage(this.midletWin.photo[this.midletWin.currentPlayer.photoID], 10, 26, 20);
                graphics.setColor(4549517);
                graphics.setFont(this.midletWin.titleFont);
                graphics.drawString("\u7528\u6236\u540d\u7a31:", 51, 43, 20);
                graphics.setFont(this.midletWin.nameFont);
                graphics.drawString(this.midletWin.currentPlayer.name, 51, 57, 20);
                graphics.setColor(0);
                String string = "\u53c3\u6230\u6b21\u6578 : " + this.midletWin.currentPlayer.matchTime;
                graphics.drawString(string, 10, 80, 20);
                string = "\u52dd\u51fa\u6b21\u6578 : " + this.midletWin.currentPlayer.winTime;
                graphics.drawString(string, 10, 95, 20);
                string = "\u7db2\u4e0a\u6392\u540d : " + this.midletWin.currentPlayer.place;
                graphics.drawString(string, 10, 110, 20);
                break;
            }
            case 5: {
                graphics.setColor(3952228);
                graphics.fillRect(0, 0, n, n2);
                graphics.setColor(0xFFFFFF);
                graphics.fillRoundRect(4, 4, 112, 130, 5, 5);
                graphics.drawImage(this.recordListImage, n / 2, 4, 17);
                graphics.setColor(0);
                graphics.setFont(this.midletWin.nameFont);
                graphics.translate(6, 25);
                int n3 = 0;
                while (n3 < 4) {
                    graphics.drawImage(this.midletWin.smallphoto[this.midletWin.recordlist[n3].photoID], 0, n3 * 26 + 2, 20);
                    graphics.drawString(this.midletWin.recordlist[n3].name, 20, n3 * 26, 20);
                    String string = this.midletWin.recordlist[n3].winTime + "/" + this.midletWin.recordlist[n3].matchTime;
                    graphics.drawString(string, 20, n3 * 26 + 13, 20);
                    ++n3;
                }
                break;
            }
        }
    }

    public void setErrorMessage(String string) {
        this.status = 3;
        this.errorMessage = string;
        this.repaint();
    }

    public void setRecordList() {
        this.status = 5;
        this.repaint();
    }

    public void setResult(boolean bl) {
        this.status = bl ? 1 : 0;
        this.repaint();
    }

    public void setNetworkWaiting() {
        this.status = 2;
        this.repaint();
    }

    public void setGameHistory() {
        this.status = 4;
        this.repaint();
    }
}

