/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BoardPlaying
extends Canvas
implements CommandListener {
    Win midletWin;
    Image[] icons;
    Image background;
    int userLossCount;
    int competitorLossCount;
    int selectedIcon;
    int competitorSelectedIcon;
    boolean isHolding;
    boolean isPlaying;
    Random rand;
    int result;
    String remainTimeString = "";
    int remainSeconds;
    String debugMessage = "";
    static final int PAPER = 0;
    static final int SCISSORS = 1;
    static final int STONE = 2;
    static final int DRAW = 0;
    static final int WIN = 1;
    static final int LOSS = 2;

    public BoardPlaying(Win win) {
        this.midletWin = win;
        this.isPlaying = false;
        try {
            this.icons = new Image[3];
            this.icons[0] = Image.createImage((String)"/paper_on.png");
            this.icons[1] = Image.createImage((String)"/scissor_on.png");
            this.icons[2] = Image.createImage((String)"/stone_on.png");
            this.background = Image.createImage((String)"/vs_bank.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.rand = new Random();
        this.userLossCount = 0;
        this.competitorLossCount = 0;
        this.selectedIcon = 0;
        this.competitorSelectedIcon = 0;
        this.isHolding = false;
        this.result = -1;
        this.setCommandListener(this);
        this.addCommand(this.midletWin.BackCommand);
        this.addCommand(this.midletWin.SelectCommand);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.midletWin.BackCommand) {
            this.userLossCount = 0;
            this.competitorLossCount = 0;
            this.selectedIcon = 0;
            this.competitorSelectedIcon = 0;
            this.isHolding = false;
            this.result = -1;
            this.isPlaying = false;
            this.midletWin.showMenu();
        } else if (command == this.midletWin.SelectCommand && !this.isHolding) {
            this.iconSelected();
        }
    }

    public void startRemainTime() {
        this.remainSeconds = 5;
        Thread thread = new Thread(){

            public void run() {
                try {
                    while (BoardPlaying.this.remainSeconds > 0 && !BoardPlaying.this.isHolding) {
                        if (!BoardPlaying.this.isPlaying) {
                            return;
                        }
                        BoardPlaying.this.remainTimeString = "\u8acb\u5728" + BoardPlaying.this.remainSeconds + "\u79d2\u5167\u9078\u64c7";
                        BoardPlaying.this.repaint();
                        --BoardPlaying.this.remainSeconds;
                        Thread.sleep(1000L);
                    }
                    if (BoardPlaying.this.remainSeconds <= 0 && !BoardPlaying.this.isHolding) {
                        BoardPlaying.this.remainTimeString = "\u6642\u9593\u5df2\u904e";
                        BoardPlaying.this.selectedIcon = -1;
                        BoardPlaying.this.repaint();
                        BoardPlaying.this.iconSelected();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        thread.start();
    }

    void setResult(int n) {
        this.competitorSelectedIcon = n;
        this.remainTimeString = "";
        if (this.selectedIcon == -1 && this.competitorSelectedIcon == -1) {
            this.result = 0;
        } else if (this.selectedIcon == -1) {
            this.result = 2;
            ++this.userLossCount;
        } else if (this.competitorSelectedIcon == -1) {
            ++this.competitorLossCount;
            this.result = 1;
        } else if (this.selectedIcon == this.competitorSelectedIcon) {
            this.result = 0;
        } else if ((this.selectedIcon - this.competitorSelectedIcon) % 3 == 1 || (this.selectedIcon - this.competitorSelectedIcon) % 3 == -2) {
            ++this.competitorLossCount;
            this.result = 1;
        } else {
            this.result = 2;
            ++this.userLossCount;
        }
        this.repaint();
        Thread thread = new Thread(){

            public void run() {
                try {
                    Thread.sleep(2000L);
                    if (BoardPlaying.this.userLossCount >= 5) {
                        BoardPlaying.this.userLossCount = 0;
                        BoardPlaying.this.competitorLossCount = 0;
                        BoardPlaying.this.selectedIcon = 0;
                        BoardPlaying.this.competitorSelectedIcon = 0;
                        BoardPlaying.this.isHolding = false;
                        BoardPlaying.this.result = -1;
                        BoardPlaying.this.midletWin.isWin = false;
                        BoardPlaying.this.midletWin.showResult();
                        return;
                    }
                    if (BoardPlaying.this.competitorLossCount >= 5) {
                        BoardPlaying.this.userLossCount = 0;
                        BoardPlaying.this.competitorLossCount = 0;
                        BoardPlaying.this.selectedIcon = 0;
                        BoardPlaying.this.competitorSelectedIcon = 0;
                        BoardPlaying.this.isHolding = false;
                        BoardPlaying.this.result = -1;
                        BoardPlaying.this.midletWin.isWin = true;
                        BoardPlaying.this.midletWin.showResult();
                        return;
                    }
                    BoardPlaying.this.selectedIcon = 0;
                    BoardPlaying.this.competitorSelectedIcon = 0;
                    BoardPlaying.this.isHolding = false;
                    BoardPlaying.this.result = -1;
                    BoardPlaying.this.startRemainTime();
                    BoardPlaying.this.repaint();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        thread.start();
    }

    void iconSelected() {
        if (!this.isPlaying) {
            return;
        }
        this.isHolding = true;
        if (this.midletWin.vsComputer) {
            this.competitorSelectedIcon = this.rand.nextInt() % 3;
            if (this.competitorSelectedIcon < 0) {
                this.competitorSelectedIcon += 3;
            }
            this.setResult(this.competitorSelectedIcon);
        } else {
            this.remainTimeString = "\u6578\u64da\u50b3\u9001\u4e2d....";
            this.repaint();
            this.midletWin.network.sendIcon();
        }
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.background, 0, 0, 20);
        graphics.setColor(0xFFFFFF);
        if (this.userLossCount > 0) {
            graphics.fillRect(this.getWidth() / 2 - 50, 7, 10 * this.userLossCount, 3);
        }
        if (this.competitorLossCount > 0) {
            graphics.fillRect(this.getWidth() / 2 + 50 - 10 * this.competitorLossCount, 7, 10 * this.competitorLossCount, 3);
        }
        graphics.setColor(0);
        graphics.drawImage(this.midletWin.photo[this.midletWin.currentPlayer.photoID], 5, 15, 20);
        graphics.drawImage(this.midletWin.photo[this.midletWin.players[this.midletWin.selectedCompetitor].photoID], this.getWidth() - 5, 15, 24);
        if (this.selectedIcon >= 0) {
            graphics.drawImage(this.icons[this.selectedIcon], 0, 78 + 19 * this.selectedIcon, 20);
        }
        if (this.result >= 0) {
            if (this.competitorSelectedIcon >= 0) {
                graphics.drawImage(this.icons[this.competitorSelectedIcon], 120, 78 + 19 * this.competitorSelectedIcon, 24);
            }
            graphics.setColor(0);
            switch (this.result) {
                case 0: {
                    graphics.drawString("\u6253\u548c!", this.getWidth() / 2, 100, 17);
                    break;
                }
                case 1: {
                    graphics.drawString("\u8d0f!", this.getWidth() / 2, 100, 17);
                    break;
                }
                case 2: {
                    graphics.drawString("\u8f38!", this.getWidth() / 2, 100, 17);
                }
            }
        }
        graphics.setColor(0);
        graphics.drawString(this.remainTimeString, this.getWidth() / 2, 63, 17);
    }

    public void keyPressed(int n) {
        if (this.isHolding) {
            return;
        }
        int n2 = this.getGameAction(n);
        if (n2 == 1 || n == 50) {
            --this.selectedIcon;
            if (this.selectedIcon < 0) {
                this.selectedIcon += 3;
            }
        } else if (n2 == 6 || n == 56) {
            ++this.selectedIcon;
            if (this.selectedIcon >= 3) {
                this.selectedIcon -= 3;
            }
        } else {
            if (n == 53) {
                this.iconSelected();
                return;
            }
            return;
        }
        this.repaint(0, 74, 120, 60);
    }
}

