/*
 * Decompiled with CFR 0.152.
 */
package com.softstar.richman.nokia7210;

import com.nokia.mid.ui.FullCanvas;
import com.softstar.richman.nokia7210.MIDlet1;
import com.softstar.richman.nokia7210.NokiaUIEffects;
import com.softstar.richman.nokia7210.TimerTaskComp;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;

public class GameFullCanvas
extends FullCanvas
implements Runnable {
    private MIDlet1 midlet1;
    private Image map;
    private volatile Thread thread = null;
    private static int GV_ItemSelect;
    private static int[] GV_PlayerPosition;
    private static int GV_Dice;
    private static int[][] GV_Cards;
    private static int[] GV_Stay;
    private static int[] GV_Sleep;
    private static int[] GV_LandStatus;
    private static int GV_Rank;
    private static int GV_GStatus;
    private static int[] GV_CharIndex;
    private static int GV_TextIndex;
    public static int GV_WhoMove;
    public static int[] GV_Money;
    private boolean hasChoosed;
    public NokiaUIEffects NokiaE;
    private Random random;
    private static Timer timer;
    private static Vector HouseVector;

    public GameFullCanvas(MIDlet1 midlet1) {
        this.midlet1 = midlet1;
        GV_PlayerPosition = new int[3];
        GV_Money = new int[3];
        GV_CharIndex = new int[3];
        GV_Cards = new int[3][5];
        GV_LandStatus = new int[56];
        GV_Stay = new int[3];
        GV_Sleep = new int[3];
        timer = new Timer();
        HouseVector = new Vector();
        Image ImageTemp = null;
        Graphics g1 = null;
        try {
            ImageTemp = Image.createImage((String)"/res/image/house.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 4; ++j) {
                Image image_element3 = Image.createImage((int)16, (int)16);
                g1 = image_element3.getGraphics();
                g1.drawImage(ImageTemp, -16 * j, -16 * i, 20);
                HouseVector.addElement(image_element3);
            }
        }
        ImageTemp = null;
        g1 = null;
        this.initializeGameValues();
        this.loadMAP();
        this.random = new Random();
        this.NokiaE = new NokiaUIEffects();
    }

    void loadMAP() {
        try {
            this.map = Image.createImage((String)"/res/image/map.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setCharIndex(int CharIndex) {
        GameFullCanvas.GV_CharIndex[0] = CharIndex;
        this.getcharEnemy(CharIndex);
    }

    private void getcharEnemy(int index) {
        int a = this.getRandom(2);
        int b = this.getRandom(2);
        while (a == index) {
            a = this.getRandom(2);
        }
        GameFullCanvas.GV_CharIndex[1] = a;
        while (b == index || b == a) {
            b = this.getRandom(2);
        }
        GameFullCanvas.GV_CharIndex[2] = b;
    }

    public void delayChangePlay(int index) {
        timer.schedule((TimerTask)new TimerTaskComp(this), index);
    }

    public void delayChangePlay(int index, int index2) {
        timer.schedule((TimerTask)new TimerTaskComp(this, index2), index);
    }

    public void changePlay(boolean index) {
        GV_ItemSelect = 0;
        GV_TextIndex = 0;
        if (index) {
            GV_WhoMove = 2;
        } else {
            this.repaint();
            this.serviceRepaints();
            try {
                Thread.sleep(600L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ++GV_WhoMove;
        if ((GV_WhoMove %= 3) == 0) {
            this.map = null;
            this.saveData();
            ++GV_Rank;
        }
        if (GV_Money[GV_WhoMove] < 0) {
            ++GV_WhoMove;
            GV_WhoMove %= 3;
        }
        if (GV_Money[0] < 0) {
            this.GameEnd(0);
            return;
        }
        if (GV_Money[1] < 0 && GV_Money[2] < 0) {
            this.GameEnd(1);
            return;
        }
        this.repaint();
        this.serviceRepaints();
        if (GV_Stay[GV_WhoMove] > 0) {
            if (this.takeThisCard(GV_WhoMove, 5)) {
                GameFullCanvas.GV_Stay[GameFullCanvas.GV_WhoMove] = 0;
                this.delayChangePlay(1000);
            } else {
                GV_TextIndex = 20;
                this.repaint();
                this.serviceRepaints();
                this.delayChangePlay(1000);
                int n = GV_WhoMove;
                GV_Stay[n] = GV_Stay[n] - 1;
            }
        } else if (GV_Sleep[GV_WhoMove] > 0) {
            GV_TextIndex = 30;
            this.repaint();
            this.serviceRepaints();
            this.delayChangePlay(1000);
            int n = GV_WhoMove;
            GV_Sleep[n] = GV_Sleep[n] - 1;
        } else if (GV_WhoMove != 0) {
            this.delayChangePlay(1000, 1);
        } else {
            this.hasChoosed = false;
        }
    }

    public void start(int GV) {
        GV_Dice = GV;
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public void run() {
        Thread currentThread = Thread.currentThread();
        int steps = 0;
        while (currentThread == this.thread) {
            try {
                Thread.sleep(300L);
                if (steps == GV_Dice) {
                    this.thread = null;
                    this.checkPosition();
                    continue;
                }
                this.goForward(++steps);
                this.repaint();
                this.serviceRepaints();
            }
            catch (Exception exception) {}
        }
    }

    private void goForward(int steps) {
        int n = GV_WhoMove;
        GV_PlayerPosition[n] = GV_PlayerPosition[n] + 1;
        this.checkMovingPosition();
        if (GV_PlayerPosition[GV_WhoMove] == 50) {
            if (steps != 1) {
                GV_TextIndex = 1;
                int n2 = GV_WhoMove;
                GV_Money[n2] = GV_Money[n2] + 200;
            }
            GameFullCanvas.GV_PlayerPosition[GameFullCanvas.GV_WhoMove] = 0;
        }
        this.repaint();
        this.serviceRepaints();
    }

    private void checkMovingPosition() {
        switch (GV_PlayerPosition[GV_WhoMove]) {
            case 5: 
            case 10: 
            case 14: 
            case 15: 
            case 27: 
            case 36: 
            case 41: 
            case 48: {
                ++GV_Dice;
            }
        }
    }

    private void checkPosition() {
        switch (GV_PlayerPosition[GV_WhoMove]) {
            case 2: 
            case 20: 
            case 42: {
                this.getChance();
                return;
            }
            case 6: 
            case 37: {
                this.goFlight();
                return;
            }
            case 11: 
            case 25: 
            case 32: {
                this.getCard(10);
                return;
            }
            case 16: {
                this.goJail();
                return;
            }
            case 28: 
            case 45: {
                GV_TextIndex = 10;
                this.repaint();
                this.serviceRepaints();
                this.delayChangePlay(1000);
                return;
            }
            case 49: {
                this.delayChangePlay(1000);
                return;
            }
        }
        this.checkPositionLand();
    }

    private void checkPositionLand() {
        if (GV_LandStatus[GV_PlayerPosition[GV_WhoMove]] <= 0) {
            if (GV_Money[GV_WhoMove] >= this.getLandPrice(GV_PlayerPosition[GV_WhoMove]) && GV_Money[GV_WhoMove] != 0) {
                this.wantBuy();
            } else {
                this.delayChangePlay(1000);
            }
        } else if (this.isitMyLand()) {
            if (GV_Money[GV_WhoMove] >= this.getLandPrice(GV_PlayerPosition[GV_WhoMove])) {
                int factor = 1;
                for (int i = 0; i < GV_WhoMove; ++i) {
                    factor *= 10;
                }
                if (GV_LandStatus[GV_PlayerPosition[GV_WhoMove]] == 4 * factor) {
                    this.delayChangePlay(1000);
                } else {
                    this.wantBuy();
                }
            } else {
                this.delayChangePlay(1000);
            }
        } else if (GV_Stay[this.whoseLand()] > 0 || GV_Sleep[this.whoseLand()] > 0) {
            this.delayChangePlay(1000);
        } else {
            this.changeMoney(this.whoseLand(), this.checkChain(GV_PlayerPosition[GV_WhoMove]));
        }
    }

    protected void paint(Graphics g) {
        if (GV_GStatus == 0) {
            int i;
            g.setColor(0, 163, 0);
            g.fillRect(0, 0, 128, 128);
            if (this.map == null) {
                this.loadMAP();
            }
            g.drawImage(this.map, 40 - this.giveMeX(GV_PlayerPosition[GV_WhoMove]), 56 - this.giveMeY(GV_PlayerPosition[GV_WhoMove]), 20);
            Image ImageTemp = null;
            Graphics g1 = null;
            for (i = 0; i < 50; ++i) {
                if (GV_LandStatus[i] == 0) continue;
                if (GV_LandStatus[i] == -1) {
                    try {
                        g.drawImage(Image.createImage((String)"/res/image/h3.png"), 40 - this.giveMeX(GV_PlayerPosition[GV_WhoMove]) + this.giveMeLandX(i), 56 - this.giveMeY(GV_PlayerPosition[GV_WhoMove]) + this.giveMeLandY(i), 20);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (GV_LandStatus[i] == -2) {
                    try {
                        g.drawImage(Image.createImage((String)"/res/image/h3.png"), 40 - this.giveMeX(GV_PlayerPosition[GV_WhoMove]) + this.giveMeLandX(i), 56 - this.giveMeY(GV_PlayerPosition[GV_WhoMove]) + this.giveMeLandY(i), 20);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (GV_LandStatus[i] < 10) {
                    g.drawImage((Image)HouseVector.elementAt(GV_CharIndex[0] * 4 + GV_LandStatus[i] - 1), 40 - this.giveMeX(GV_PlayerPosition[GV_WhoMove]) + this.giveMeLandX(i), 56 - this.giveMeY(GV_PlayerPosition[GV_WhoMove]) + this.giveMeLandY(i), 20);
                    continue;
                }
                if (GV_LandStatus[i] < 100) {
                    g.drawImage((Image)HouseVector.elementAt(GV_CharIndex[1] * 4 + GV_LandStatus[i] / 10 - 1), 40 - this.giveMeX(GV_PlayerPosition[GV_WhoMove]) + this.giveMeLandX(i), 56 - this.giveMeY(GV_PlayerPosition[GV_WhoMove]) + this.giveMeLandY(i), 20);
                    continue;
                }
                g.drawImage((Image)HouseVector.elementAt(GV_CharIndex[2] * 4 + GV_LandStatus[i] / 100 - 1), 40 - this.giveMeX(GV_PlayerPosition[GV_WhoMove]) + this.giveMeLandX(i), 56 - this.giveMeY(GV_PlayerPosition[GV_WhoMove]) + this.giveMeLandY(i), 20);
            }
            try {
                for (i = 0; i < 3; ++i) {
                    if (i == GV_WhoMove || GV_Money[i] < 0) continue;
                    g.drawImage(Image.createImage((String)String.valueOf(String.valueOf(new StringBuffer("/res/image/h").append(GV_CharIndex[i]).append(".png")))), 40 - this.giveMeX(GV_PlayerPosition[GV_WhoMove]) + this.giveMeX(GV_PlayerPosition[i]), 56 - this.giveMeY(GV_PlayerPosition[GV_WhoMove]) + this.giveMeY(GV_PlayerPosition[i]), 20);
                }
            }
            catch (Exception i2) {
                // empty catch block
            }
            Image gamepanel = null;
            try {
                gamepanel = Image.createImage((String)"/res/image/gamepanel.png");
                g.drawImage(gamepanel, 96, 0, 20);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (!NokiaUIEffects.soundOn) {
                    ImageTemp = Image.createImage((int)15, (int)14);
                    g1 = ImageTemp.getGraphics();
                    g1.drawImage(gamepanel, -9, -156, 20);
                    g.drawImage(ImageTemp, 105, 111, 20);
                    g1 = null;
                    ImageTemp = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (GV_CharIndex[GV_WhoMove] != 0) {
                    ImageTemp = Image.createImage((int)32, (int)14);
                    g1 = ImageTemp.getGraphics();
                    g1.drawImage(gamepanel, 0, -128 - 14 * (GV_CharIndex[GV_WhoMove] - 1), 20);
                    g.drawImage(ImageTemp, 96, 4, 20);
                    g1 = null;
                    ImageTemp = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ImageTemp = Image.createImage((String)String.valueOf(String.valueOf(new StringBuffer("/res/image/h").append(GV_CharIndex[GV_WhoMove]).append(".png"))));
                g.drawImage(ImageTemp, 104, 24, 20);
                if (GV_Money[GV_WhoMove] >= 0) {
                    g.drawImage(ImageTemp, 40, 56, 20);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            g.setColor(255, 42, 0);
            g.drawRect(102, 50 + GV_ItemSelect * 15, 19, 15);
            g.setColor(0, 0, 0);
            g.fillRect(95, 0, 1, 128);
        } else if (GV_GStatus != 1 && GV_GStatus == 2) {
            this.map = null;
            try {
                g.drawImage(Image.createImage((String)"/res/image/start00.png"), 0, -16, 20);
                g.drawImage(Image.createImage((String)"/res/image/ff01.png"), 3, 20, 20);
                g.drawImage(Image.createImage((String)"/res/image/ff02.png"), 92, 5, 20);
                g.drawImage(Image.createImage((String)"/res/image/ff03.png"), 72, 68, 20);
                g.drawImage(Image.createImage((String)"/res/image/win.png"), 34, 38, 20);
            }
            catch (Exception ImageTemp) {
                // empty catch block
            }
        }
        if (GV_GStatus == 3) {
            this.map = null;
            try {
                Image rm = Image.createImage((String)"/res/image/start00.png");
                g.drawImage(rm, 0, -16, 20);
                g.drawImage(rm, 0, 87, 20);
                g.setColor(0, 0, 0);
                g.fillRect(0, 103, this.getWidth(), this.getHeight() - 103);
                g.drawImage(Image.createImage((String)"/res/image/lost.png"), 28, 38, 20);
                Object var2_2 = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (GV_TextIndex == 30) {
            this.drawBoard(g, "Sleep");
        } else if (GV_TextIndex == 20) {
            this.drawBoard(g, "Jail");
        } else if (GV_TextIndex == 10) {
            this.drawBoard(g, "Park");
        } else if (GV_TextIndex > 0) {
            this.drawBoard(g, "+US$200");
            GV_TextIndex = GV_TextIndex == 4 ? 0 : (GV_TextIndex = GV_TextIndex + 1);
        }
    }

    private void drawBoard(Graphics g, String text) {
        g.setColor(0, 0, 0);
        g.fillRect(8, 29, 80, 30);
        g.setColor(255, 255, 255);
        g.fillRect(10, 31, 76, 26);
        g.setColor(255, 0, 0);
        g.setFont(Font.getFont((int)0, (int)1, (int)16));
        g.drawString(text, 48, 49, 65);
    }

    public void keyPressed(int keyCode) {
        if (GV_GStatus > 1) {
            MIDlet1.quitApp();
        }
        if (GV_WhoMove != 0 || this.hasChoosed) {
            return;
        }
        block0 : switch (this.getGameAction(keyCode)) {
            case 1: {
                if (--GV_ItemSelect == -1) {
                    GV_ItemSelect = 4;
                }
                this.repaint();
                this.serviceRepaints();
                break;
            }
            case 6: {
                if (++GV_ItemSelect == 5) {
                    GV_ItemSelect = 0;
                }
                this.repaint();
                this.serviceRepaints();
                break;
            }
            case 8: {
                switch (GV_ItemSelect) {
                    case 0: {
                        this.map = null;
                        this.midlet1.rqDiceCanvas();
                        this.hasChoosed = true;
                        break block0;
                    }
                    case 1: {
                        if (GV_Cards[GV_WhoMove][0] == 16) {
                            this.midlet1.rqNoCard();
                            break block0;
                        }
                        this.map = null;
                        this.midlet1.rqUseCard(GV_Cards[GV_WhoMove]);
                        break block0;
                    }
                    case 2: {
                        this.midlet1.rqGameStatus(GV_Money[0], GV_Money[1], GV_Money[2], this.howmanyThing(1), this.howmanyThing(10), this.howmanyThing(100), this.howmanyThing(2) + this.howmanyThing(3), this.howmanyThing(20) + this.howmanyThing(30), this.howmanyThing(200) + this.howmanyThing(300), this.howmanyThing(4), this.howmanyThing(40), this.howmanyThing(400), GV_CharIndex);
                        break block0;
                    }
                    case 3: {
                        MIDlet1.quitApp();
                        break block0;
                    }
                    case 4: {
                        NokiaUIEffects.soundOn = !NokiaUIEffects.soundOn;
                        this.repaint();
                        this.serviceRepaints();
                    }
                }
            }
        }
    }

    private void getChance() {
        int index = this.getRandom(9);
        String Textcontent = "";
        switch (index) {
            case 0: {
                int n = GV_WhoMove;
                GV_Stay[n] = GV_Stay[n] + 2;
                GameFullCanvas.GV_PlayerPosition[GameFullCanvas.GV_WhoMove] = 16;
                Textcontent = "Jail(carying drugs)two days";
                break;
            }
            case 1: {
                int n = GV_WhoMove;
                GV_Money[n] = GV_Money[n] + 300;
                Textcontent = "Win the lottery +US$300";
                break;
            }
            case 2: {
                Textcontent = "Capital gain 10%\n +US$".concat(String.valueOf(String.valueOf(GV_Money[GV_WhoMove] * 110 / 100)));
                GameFullCanvas.GV_Money[GameFullCanvas.GV_WhoMove] = GV_Money[GV_WhoMove] * 110 / 100;
                break;
            }
            case 3: {
                Textcontent = "Revenueloss 10%\n +US$".concat(String.valueOf(String.valueOf(GV_Money[GV_WhoMove] * 90 / 100)));
                GameFullCanvas.GV_Money[GameFullCanvas.GV_WhoMove] = GV_Money[GV_WhoMove] * 90 / 100;
                break;
            }
            case 4: {
                Textcontent = "Income tax 5%\n -US$".concat(String.valueOf(String.valueOf(GV_Money[GV_WhoMove] / 20)));
                GameFullCanvas.GV_Money[GameFullCanvas.GV_WhoMove] = GV_Money[GV_WhoMove] * 95 / 100;
                break;
            }
            case 5: {
                Textcontent = "Property tax 5%\n -US$".concat(String.valueOf(String.valueOf(this.totalHousePrice() / 20)));
                int n = GV_WhoMove;
                GV_Money[n] = GV_Money[n] - this.totalHousePrice() / 20;
                break;
            }
            case 6: {
                this.getRandomBlock(15);
                this.NokiaE.vibrate();
                Textcontent = "Earthquake";
                break;
            }
            case 7: {
                this.getRandomBlock(25);
                this.NokiaE.flashLights();
                Textcontent = "Tornado";
                break;
            }
            case 8: {
                this.getFire();
                this.NokiaE.vibrate();
                Textcontent = "Fire alert";
                break;
            }
            case 9: {
                int n = GV_WhoMove;
                GV_Money[n] = GV_Money[n] + 200;
                Textcontent = "RealEstate Investme\n+US$200";
            }
        }
        this.map = null;
        if (index != 6 && index != 7 && index != 8) {
            this.midlet1.rqChance(Textcontent);
        }
    }

    private void goJail() {
        int n = GV_WhoMove;
        GV_Stay[n] = GV_Stay[n] + 3;
        this.midlet1.rqJail();
    }

    private void goFlight() {
        this.midlet1.rqNews("Proceed to the next airport.", null, true, "Airport");
    }

    public void Flight() {
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (GV_PlayerPosition[GV_WhoMove]) {
            case 6: {
                GameFullCanvas.GV_PlayerPosition[GameFullCanvas.GV_WhoMove] = 37;
                break;
            }
            case 37: {
                GameFullCanvas.GV_PlayerPosition[GameFullCanvas.GV_WhoMove] = 6;
            }
        }
        this.delayChangePlay(1000);
    }

    void useCard(int index) {
        this.takeThisCard(GV_WhoMove, index);
        switch (index) {
            case 0: {
                int takethis = this.getOneCard();
                if (takethis == -1) {
                    this.midlet1.rqCardInfo("There are no cards to steal.");
                    break;
                }
                this.getCard(takethis);
                break;
            }
            case 1: {
                int total = 0;
                for (int i = 0; i < 3; ++i) {
                    if (i == GV_WhoMove) continue;
                    int n = i;
                    GV_Money[n] = GV_Money[n] / 2;
                    total += GV_Money[i];
                }
                int n = GV_WhoMove;
                GV_Money[n] = GV_Money[n] + total;
                this.midlet1.rqCardInfo("Get +US$".concat(String.valueOf(String.valueOf(total))));
                break;
            }
            case 2: {
                if (!this.isitMyLand()) {
                    this.changeToMe();
                    break;
                }
                this.midlet1.rqCardInfo("You cannot use the card in here.");
                break;
            }
            case 3: {
                int target = this.getRandom(2);
                while (target == GV_WhoMove) {
                    target = this.getRandom(2);
                }
                int n = target;
                GV_Sleep[n] = GV_Sleep[n] + 3;
                GameFullCanvas.GV_Stay[target] = 0;
                this.midlet1.rqCardInfo("Player cannot move for three turns.");
                break;
            }
            case 5: {
                this.getRandomBlock(5);
                this.NokiaE.vibrate();
                break;
            }
            case 6: {
                this.getRandomBlock(11);
                break;
            }
            case 7: {
                this.midlet1.rqDiceMoney(GV_Money, GV_WhoMove);
                break;
            }
            case 8: {
                if (this.isPlain(GV_PlayerPosition[GV_WhoMove])) {
                    GameFullCanvas.GV_LandStatus[GameFullCanvas.GV_PlayerPosition[GameFullCanvas.GV_WhoMove]] = -1;
                    this.delayChangePlay(1000);
                    break;
                }
                this.midlet1.rqCardInfo("You cannot use it here.");
                break;
            }
            case 9: {
                if (this.isPlain(GV_PlayerPosition[GV_WhoMove])) {
                    GameFullCanvas.GV_LandStatus[GameFullCanvas.GV_PlayerPosition[GameFullCanvas.GV_WhoMove]] = -2;
                    this.delayChangePlay(1000);
                    break;
                }
                this.midlet1.rqCardInfo("You cannot use it here.");
                break;
            }
        }
    }

    private boolean isPlain(int index) {
        return index != 2 && index != 6 && index != 11 && index != 16 && index != 20 && index != 25 && index != 28 && index != 32 && index != 37 && index != 42 && index != 45 && index != 49 && GV_LandStatus[index] == 0;
    }

    private void changeToMe() {
        while (GV_LandStatus[GV_PlayerPosition[GV_WhoMove]] > 9) {
            int n = GV_PlayerPosition[GV_WhoMove];
            GV_LandStatus[n] = GV_LandStatus[n] / 10;
        }
        switch (GV_WhoMove) {
            case 2: {
                int n = GV_PlayerPosition[GV_WhoMove];
                GV_LandStatus[n] = GV_LandStatus[n] * 10;
            }
            case 1: {
                int n = GV_PlayerPosition[GV_WhoMove];
                GV_LandStatus[n] = GV_LandStatus[n] * 10;
            }
        }
        this.midlet1.rqCardInfo("This area is yours now.");
    }

    private boolean takeThisCard(int GV_WhoMove, int index) {
        int i;
        boolean stats = false;
        for (i = 0; i < GV_Cards[0].length; ++i) {
            if (GV_Cards[GV_WhoMove][i] != index) continue;
            stats = true;
        }
        if (!stats) {
            return false;
        }
        for (i = 0; i < 5; ++i) {
            if (GV_Cards[GV_WhoMove][i] != index) continue;
            GameFullCanvas.GV_Cards[GV_WhoMove][i] = 16;
            i = 5;
        }
        for (i = 0; i < 4; ++i) {
            if (GV_Cards[GV_WhoMove][i] != 16) continue;
            GameFullCanvas.GV_Cards[GV_WhoMove][i] = GV_Cards[GV_WhoMove][i + 1];
            GameFullCanvas.GV_Cards[GV_WhoMove][i + 1] = 16;
        }
        return true;
    }

    private int getOneCard() {
        if (GV_WhoMove == 0 && GV_Cards[1][0] == 16 && GV_Cards[2][0] == 16 || GV_WhoMove == 1 && GV_Cards[0][0] == 16 && GV_Cards[2][0] == 16 || GV_WhoMove == 2 && GV_Cards[0][0] == 16 && GV_Cards[1][0] == 16) {
            return -1;
        }
        int thisone = 16;
        int who = 0;
        while (thisone == 16) {
            who = this.getRandomBesides(2, GV_WhoMove);
            thisone = GV_Cards[who][this.getRandom(4)];
        }
        this.takeThisCard(who, thisone);
        return thisone;
    }

    private void getCard(int cardN) {
        this.map = null;
        if (cardN == 10) {
            cardN = this.getRandom(9);
        }
        for (int i = 0; i < 5; ++i) {
            if (GV_Cards[GV_WhoMove][i] != 16) continue;
            GameFullCanvas.GV_Cards[GameFullCanvas.GV_WhoMove][i] = cardN;
            this.midlet1.rqGetCard(cardN);
            this.NokiaE.playSound(2);
            return;
        }
        this.cardIsFull(cardN);
    }

    private void cardIsFull(int cardN) {
        for (int i = 0; i < 4; ++i) {
            GameFullCanvas.GV_Cards[GameFullCanvas.GV_WhoMove][i] = GV_Cards[GV_WhoMove][i + 1];
        }
        GameFullCanvas.GV_Cards[GameFullCanvas.GV_WhoMove][4] = cardN;
        this.midlet1.rqGetCard(cardN);
        this.NokiaE.playSound(2);
    }

    private int getRandom(int index) {
        return (this.random.nextInt() % (index + 1) + (index + 1)) % (index + 1);
    }

    private int getRandomBesides(int index, int num) {
        int thisone = this.getRandom(index);
        while (thisone == num) {
            thisone = this.getRandom(index);
        }
        return thisone;
    }

    private void getFire() {
        int land1 = this.getRandomLand();
        int land2 = this.getRandomLand();
        while (this.whichBlock(land1) != this.whichBlock(land2) || land2 == land1) {
            land2 = this.getRandomLand();
        }
        this.doTheseLands(land1, land1 + 1, 1);
        this.doTheseLands(land2, land2 + 1, 1);
        this.repaint();
        this.serviceRepaints();
        int[] a = new int[]{land1, land2};
        this.midlet1.rqNews("These areas were ravaged by fire:", a, GV_WhoMove != 0, "Fire alert");
    }

    private void doTheseLands(int start, int end, int effect) {
        for (int i = start; i < end + 1; ++i) {
            if (GV_LandStatus[i] == 0) continue;
            GameFullCanvas.GV_LandStatus[i] = GV_LandStatus[i] < 10 ? 1 : (GV_LandStatus[i] < 100 ? 10 : 100);
        }
    }

    private int getRandomLand() {
        int index = this.getRandom(47);
        if (index == 2 || index == 5 || index == 6 || index == 10 || index == 11 || index == 14 || index == 15 || index == 16 || index == 20 || index == 25 || index == 27 || index == 28 || index == 32 || index == 36 || index == 37 || index == 41 || index == 42 || index == 45) {
            index = this.getRandomLand();
        }
        return index;
    }

    private int whichBlock(int index) {
        return index < 2 ? 0 : (index < 5 ? 1 : (index < 10 ? 2 : (index < 14 ? 3 : (index < 20 ? 4 : (index < 25 ? 5 : (index < 32 ? 6 : (index < 36 ? 7 : (index < 41 ? 8 : 9))))))));
    }

    private void getRandomBlock(int index) {
        int[] a = null;
        switch (this.getRandomBesides(8, 6)) {
            case 0: {
                this.startAction(0, 1, index);
                a = new int[]{0, 1};
                break;
            }
            case 1: {
                this.startAction(3, 4, index);
                a = new int[]{3, 4};
                break;
            }
            case 2: {
                this.startAction(7, 9, index);
                a = new int[]{7, 8, 9};
                break;
            }
            case 3: {
                this.startAction(12, 13, index);
                a = new int[]{12, 13};
                break;
            }
            case 4: {
                this.startAction(17, 19, index);
                a = new int[]{17, 18, 19};
                break;
            }
            case 5: {
                this.startAction(21, 24, index);
                a = new int[]{21, 22, 23, 24};
                break;
            }
            case 6: {
                this.startAction(26, 31, index);
                GameFullCanvas.GV_LandStatus[27] = 0;
                GameFullCanvas.GV_LandStatus[28] = 0;
                a = new int[]{26, 29, 30, 31};
                break;
            }
            case 7: {
                this.startAction(33, 35, index);
                a = new int[]{33, 34, 35};
                break;
            }
            case 8: {
                this.startAction(38, 47, index);
                a = new int[]{38, 39, 40, 43, 44, 46, 47};
            }
        }
        if (index == 11) {
            this.midlet1.rqNews("These areas were blessed by angel:", a, GV_WhoMove != 0, "News Report");
        } else if (index == 5) {
            this.midlet1.rqNews("These areas were attacked by monster:", a, GV_WhoMove != 0, "News Report");
        } else if (index == 15) {
            this.midlet1.rqNews("These areas were destroyed by earthquake:", a, GV_WhoMove != 0, "Earthquake");
        } else if (index == 25) {
            this.midlet1.rqNews("These areas were damaged by tornado:", a, GV_WhoMove != 0, "Tornado");
        }
        this.repaint();
        this.serviceRepaints();
    }

    private void startAction(int start, int end, int action) {
        switch (action) {
            case 11: {
                for (int index = start; index < end + 1; ++index) {
                    if (GV_LandStatus[index] >= 100) {
                        GameFullCanvas.GV_LandStatus[index] = 100;
                    } else if (GV_LandStatus[index] >= 10) {
                        int n = index;
                        GV_LandStatus[n] = GV_LandStatus[n] + 10;
                    } else if (GV_LandStatus[index] > 0) {
                        int n = index;
                        GV_LandStatus[n] = GV_LandStatus[n] + 1;
                    }
                    this.updateThisLand(index);
                }
                break;
            }
            case 15: {
                for (int i = start; i < end + 1; ++i) {
                    GameFullCanvas.GV_LandStatus[i] = 0;
                }
                break;
            }
            default: {
                this.doTheseLands(start, end);
                break;
            }
        }
    }

    private void doTheseLands(int start, int end) {
        for (int i = start; i < end + 1; ++i) {
            if (GV_LandStatus[i] == 0) continue;
            GameFullCanvas.GV_LandStatus[i] = GV_LandStatus[i] < 10 ? 1 : (GV_LandStatus[i] < 100 ? 10 : 100);
        }
    }

    private void updateThisLand(int index) {
        GameFullCanvas.GV_LandStatus[index] = GV_LandStatus[index] == 5 ? 4 : (GV_LandStatus[index] == 50 ? 40 : (GV_LandStatus[index] == 500 ? 400 : GV_LandStatus[index]));
    }

    private int totalHousePrice() {
        int i;
        int total = 0;
        int factor = 1;
        for (i = 0; i < GV_WhoMove; ++i) {
            factor *= 10;
        }
        for (i = 0; i < GV_LandStatus.length; ++i) {
            if (GV_LandStatus[i] == 1 * factor) {
                total += this.getLandPrice(i);
                continue;
            }
            if (GV_LandStatus[i] == 2 * factor) {
                total += this.getLandPrice(i) * 8 * 5 / 100;
                continue;
            }
            if (GV_LandStatus[i] == 3 * factor) {
                total += this.getLandPrice(i) * 8 * 15 / 100;
                continue;
            }
            if (GV_LandStatus[i] != 4 * factor) continue;
            total += this.getLandPrice(i) * 8 * 125 / 100;
        }
        return total;
    }

    private boolean isitMyLand() {
        if (GV_LandStatus[GV_PlayerPosition[GV_WhoMove]] == 0) {
            return true;
        }
        return GV_WhoMove == (GV_LandStatus[GV_PlayerPosition[GV_WhoMove]] < 10 ? 0 : (GV_LandStatus[GV_PlayerPosition[GV_WhoMove]] < 100 ? 1 : 2));
    }

    private void wantBuy() {
        int LS = GV_LandStatus[GV_PlayerPosition[GV_WhoMove]];
        for (int i = 0; i < 2; ++i) {
            if (LS <= 10) continue;
            LS /= 10;
        }
        this.map = null;
        this.midlet1.rqBuyLand(GV_PlayerPosition[GV_WhoMove], this.getLandPrice(GV_PlayerPosition[GV_WhoMove]), GV_WhoMove != 0, LS);
    }

    private void changeMoney(int index, int money) {
        int n = GV_WhoMove;
        GV_Money[n] = GV_Money[n] - money;
        int n2 = index;
        GV_Money[n2] = GV_Money[n2] + money;
        if (GV_Money[GV_WhoMove] < 0) {
            switch (GV_WhoMove) {
                case 0: {
                    for (int i = 0; i < GV_LandStatus.length; ++i) {
                        if (GV_LandStatus[i] >= 10 || GV_LandStatus[i] <= 0) continue;
                        GameFullCanvas.GV_LandStatus[i] = 0;
                    }
                    break;
                }
                case 1: {
                    for (int i = 0; i < GV_LandStatus.length; ++i) {
                        if (GV_LandStatus[i] < 10 || GV_LandStatus[i] >= 100) continue;
                        GameFullCanvas.GV_LandStatus[i] = 0;
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < GV_LandStatus.length; ++i) {
                        if (GV_LandStatus[i] < 100) continue;
                        GameFullCanvas.GV_LandStatus[i] = 0;
                    }
                    break;
                }
            }
        }
        this.midlet1.rqPayFee(money, GV_WhoMove != 0);
    }

    private int whoseLand() {
        if (GV_LandStatus[GV_PlayerPosition[GV_WhoMove]] < 10) {
            return 0;
        }
        if (GV_LandStatus[GV_PlayerPosition[GV_WhoMove]] < 100) {
            return 1;
        }
        return 2;
    }

    private int getLandPrice(int index) {
        switch (index) {
            case 0: {
                return 82;
            }
            case 1: 
            case 13: {
                return 80;
            }
            case 3: 
            case 8: {
                return 100;
            }
            case 4: 
            case 7: 
            case 9: 
            case 31: 
            case 38: 
            case 44: {
                return 120;
            }
            case 12: 
            case 29: 
            case 34: {
                return 90;
            }
            case 17: 
            case 23: 
            case 24: 
            case 30: 
            case 46: 
            case 47: {
                return 110;
            }
            case 18: {
                return 130;
            }
            case 19: {
                return 95;
            }
            case 21: 
            case 43: {
                return 150;
            }
            case 22: 
            case 40: {
                return 140;
            }
            case 26: {
                return 105;
            }
            case 33: 
            case 35: {
                return 85;
            }
            case 39: {
                return 125;
            }
        }
        return 0;
    }

    private int checkChain(int index) {
        int factor;
        int howmuch = 0;
        int index2 = index;
        int n = GV_LandStatus[index] < 10 ? 1 : (factor = GV_LandStatus[index] < 100 ? 10 : 100);
        if (index2 != 0) {
            while (GV_LandStatus[index2 - 1] != 0 && GV_LandStatus[index2 - 1] >= factor && GV_LandStatus[index2 - 1] <= factor * 4) {
                howmuch += this.getChain(GV_LandStatus[index2 - 1], index2 - 1);
                if (--index2 != 0) continue;
            }
        }
        index2 = index;
        while (GV_LandStatus[index2 + 1] != 0 && GV_LandStatus[index2 + 1] >= factor && GV_LandStatus[index2 + 1] <= factor * 4) {
            howmuch += this.getChain(GV_LandStatus[index2 + 1], index2 + 1);
            if (++index2 != 49) continue;
        }
        howmuch = howmuch == 0 ? this.getPayFee(index) : (howmuch += this.getChain(GV_LandStatus[index], index));
        return howmuch;
    }

    private int getChain(int status, int index) {
        switch (status) {
            case 1: 
            case 10: 
            case 100: {
                return this.getLandPrice(index);
            }
        }
        return 500;
    }

    private int getPayFee(int index) {
        switch (GV_LandStatus[index]) {
            case 1: 
            case 10: 
            case 100: {
                return this.getLandPrice(index) * 4 / 5;
            }
            case 2: 
            case 20: 
            case 200: {
                return this.getLandPrice(index) * 2;
            }
            case 3: 
            case 30: 
            case 300: {
                return this.getLandPrice(index) * 14 / 5;
            }
            case 4: 
            case 40: 
            case 400: {
                return this.getLandPrice(index) * 4;
            }
        }
        return 0;
    }

    private int howmanyThing(int index) {
        int thisone = 0;
        for (int i = 0; i < GV_LandStatus.length; ++i) {
            if (GV_LandStatus[i] != index) continue;
            ++thisone;
        }
        return thisone;
    }

    private int giveMeX(int index) {
        return index > 44 || index < 3 ? 16 : (index < 7 ? 32 + 16 * (index - 3) : (index < 12 ? 80 : (index < 16 ? 96 + 16 * (index - 12) : (index < 21 ? 144 : (index < 25 ? 160 + 16 * (index - 21) : (index < 33 ? 224 : (index < 45 ? 208 - 16 * (index - 33) : 0)))))));
    }

    private int giveMeY(int index) {
        return index < 3 ? 96 + 16 * index : (index < 7 ? 128 : (index < 11 ? 112 - 16 * (index - 7) : (index < 16 ? 48 : (index < 20 ? 64 + 16 * (index - 16) : (index < 26 ? 128 : (index < 32 ? 112 - 16 * (index - 26) : (index < 46 ? 16 : (index < 50 ? 32 + 16 * (index - 46) : 0))))))));
    }

    private int giveMeLandX(int index) {
        return index < 2 ? 0 : (index < 5 ? 32 + 16 * (index - 3) : (index < 10 ? 64 : (index < 14 ? 96 + 16 * (index - 12) : (index < 20 ? 128 : (index < 25 ? 160 + 16 * (index - 21) : (index < 32 ? 240 : (index < 45 ? 208 - 16 * (index - 33) : (index < 48 ? 0 : -200))))))));
    }

    private int giveMeLandY(int index) {
        return index < 2 ? 96 + 16 * index : (index < 5 ? 144 : (index < 10 ? 112 - 16 * (index - 7) : (index < 14 ? 64 : (index < 20 ? 80 + 16 * (index - 17) : (index < 25 ? 144 : (index < 32 ? 112 - 16 * (index - 26) : (index < 45 ? 0 : (index < 48 ? 32 + 16 * (index - 46) : 0))))))));
    }

    public void initializeGameValues() {
        int i;
        for (i = 0; i < 3; ++i) {
            GameFullCanvas.GV_PlayerPosition[i] = 49;
            GameFullCanvas.GV_Money[i] = 3500;
            GameFullCanvas.GV_Stay[i] = 0;
            GameFullCanvas.GV_Sleep[i] = 0;
        }
        GV_ItemSelect = 0;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 5; ++j) {
                GameFullCanvas.GV_Cards[i][j] = 16;
            }
        }
        GV_GStatus = 0;
        GV_Rank = 0;
        GV_WhoMove = 0;
        this.hasChoosed = false;
    }

    private void GameEnd(int index) {
        if (index == 1) {
            GV_GStatus = 2;
            this.repaint();
            this.serviceRepaints();
            this.NokiaE.playSound(3);
            this.midlet1.updateHighScore(GV_CharIndex[0], GV_Rank);
        } else {
            GV_GStatus = 3;
            this.repaint();
            this.serviceRepaints();
            this.NokiaE.playSound(4);
        }
    }

    public void saveData() {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"RichMan", (boolean)true);
            byte[] data = this.putInData();
            if (rs.getNumRecords() != 1) {
                rs.addRecord(data, 0, data.length);
            } else {
                rs.setRecord(1, data, 0, data.length);
            }
            rs.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean loadData() {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"RichMan", (boolean)false);
            if (rs == null) {
                boolean bl = false;
                return bl;
            }
            this.readInData(rs.getRecord(1));
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        this.changePlay(true);
        return true;
    }

    public byte[] putInData() {
        byte[] thisone = null;
        try {
            int i;
            ByteArrayOutputStream baoutputstream = new ByteArrayOutputStream();
            DataOutputStream doutputstream = new DataOutputStream(baoutputstream);
            for (i = 0; i < 3; ++i) {
                doutputstream.writeInt(GV_PlayerPosition[i]);
                doutputstream.writeInt(GV_Money[i]);
                doutputstream.writeInt(GV_CharIndex[i]);
                doutputstream.writeInt(GV_Stay[i]);
            }
            for (i = 0; i < 3; ++i) {
                for (int j = 0; j < 5; ++j) {
                    doutputstream.writeInt(GV_Cards[i][j]);
                }
            }
            for (i = 0; i < GV_LandStatus.length; ++i) {
                doutputstream.writeInt(GV_LandStatus[i]);
            }
            doutputstream.writeInt(GV_Rank);
            thisone = baoutputstream.toByteArray();
            baoutputstream.close();
            doutputstream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return thisone;
    }

    public void readInData(byte[] data) {
        try {
            int i;
            ByteArrayInputStream bainputstream = new ByteArrayInputStream(data);
            DataInputStream dinputstream = new DataInputStream(bainputstream);
            for (i = 0; i < 3; ++i) {
                GameFullCanvas.GV_PlayerPosition[i] = dinputstream.readInt();
                GameFullCanvas.GV_Money[i] = dinputstream.readInt();
                GameFullCanvas.GV_CharIndex[i] = dinputstream.readInt();
                GameFullCanvas.GV_Stay[i] = dinputstream.readInt();
            }
            for (i = 0; i < 3; ++i) {
                for (int j = 0; j < 5; ++j) {
                    GameFullCanvas.GV_Cards[i][j] = dinputstream.readInt();
                }
            }
            for (i = 0; i < GV_LandStatus.length; ++i) {
                GameFullCanvas.GV_LandStatus[i] = dinputstream.readInt();
            }
            GV_Rank = dinputstream.readInt();
            bainputstream.close();
            dinputstream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void buyLand() {
        switch (GV_LandStatus[GV_PlayerPosition[GV_WhoMove]]) {
            case 0: {
                int n = GV_WhoMove;
                GV_Money[n] = GV_Money[n] - this.getLandPrice(GV_PlayerPosition[GV_WhoMove]);
                break;
            }
            case 1: 
            case 10: 
            case 100: {
                int n = GV_WhoMove;
                GV_Money[n] = GV_Money[n] - this.getLandPrice(GV_PlayerPosition[GV_WhoMove]) * 2 / 5;
                break;
            }
            case 2: 
            case 20: 
            case 200: {
                int n = GV_WhoMove;
                GV_Money[n] = GV_Money[n] - this.getLandPrice(GV_PlayerPosition[GV_WhoMove]) * 14 / 25;
                break;
            }
            case 3: 
            case 30: 
            case 300: {
                int n = GV_WhoMove;
                GV_Money[n] = GV_Money[n] - this.getLandPrice(GV_PlayerPosition[GV_WhoMove]) * 4 / 5;
                break;
            }
            case -2: {
                int n = GV_WhoMove;
                GV_Money[n] = GV_Money[n] - this.getLandPrice(GV_PlayerPosition[GV_WhoMove]);
            }
        }
        if (GV_LandStatus[GV_PlayerPosition[GV_WhoMove]] == -2) {
            GameFullCanvas.GV_LandStatus[GameFullCanvas.GV_PlayerPosition[GameFullCanvas.GV_WhoMove]] = 0;
        } else {
            int n = GV_PlayerPosition[GV_WhoMove];
            GV_LandStatus[n] = GV_LandStatus[n] + (GV_WhoMove == 0 ? 1 : (GV_WhoMove == 1 ? 10 : 100));
        }
        this.updateThisLand(GV_PlayerPosition[GV_WhoMove]);
    }

    void turnPC() {
        int useThisCard = -1;
        if (GV_Cards[GV_WhoMove][0] != 16) {
            useThisCard = this.shouldIuseCard();
        }
        if (GV_Cards[GV_WhoMove][0] != 16 && useThisCard != -1) {
            GV_ItemSelect = 1;
            this.repaint();
            this.serviceRepaints();
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.map = null;
            this.midlet1.rqUseCardPC(GV_Cards[GV_WhoMove], useThisCard);
        } else {
            this.map = null;
            this.midlet1.rqDiceCanvas();
            this.hasChoosed = true;
        }
    }

    private int shouldIuseCard() {
        int i;
        int lll = 0;
        for (i = 0; i < 5; ++i) {
            if (GV_Cards[GV_WhoMove][i] == 16) continue;
            ++lll;
        }
        block6: for (i = 0; i < lll; ++i) {
            switch (GV_Cards[GV_WhoMove][i]) {
                case 2: {
                    if (this.isitMyLand()) continue block6;
                    return i;
                }
                case 8: 
                case 9: {
                    if (GV_LandStatus[GV_PlayerPosition[GV_WhoMove]] != 0 || GV_PlayerPosition[GV_WhoMove] == 2 || GV_PlayerPosition[GV_WhoMove] == 5 || GV_PlayerPosition[GV_WhoMove] == 11 || GV_PlayerPosition[GV_WhoMove] == 16 || GV_PlayerPosition[GV_WhoMove] == 20 || GV_PlayerPosition[GV_WhoMove] == 28 || GV_PlayerPosition[GV_WhoMove] == 25 || GV_PlayerPosition[GV_WhoMove] == 28 || GV_PlayerPosition[GV_WhoMove] == 37 || GV_PlayerPosition[GV_WhoMove] == 42 || GV_PlayerPosition[GV_WhoMove] == 45 || GV_PlayerPosition[GV_WhoMove] == 55) continue block6;
                    return i;
                }
                case 0: 
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    return i;
                }
            }
        }
        return -1;
    }
}

