/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class PlayerShip {
    public static final int MODE_NORMAL = 1;
    public static final int MODE_INVINC = 2;
    public static final int MODE_DEPLOY = 3;
    public static final int MODE_DEAD = 4;
    int maxSp = 6;
    int acc = 3;
    int mode;
    int cnt;
    int x;
    int y;
    int xsp;
    int ysp;
    boolean moveLeft;
    boolean moveRight;
    boolean moveUp;
    boolean moveDown;
    boolean firePressed;
    boolean fireHeld;
    int shield;
    int shieldMax;
    int shieldDecimal;
    int shieldRate;
    int lives;
    int points;
    Weaponry weapons;
    Explosions explosions;
    Enemies enemies;
    int minX;
    int minY;
    int maxX;
    int maxY;
    Image[] shipImages = new Image[5];

    public PlayerShip(int n, int n2, int n3, int n4) {
        for (int i = 0; i < this.shipImages.length; ++i) {
            this.shipImages[i] = GameMidlet.getImage("ship".concat(String.valueOf(String.valueOf(i))));
        }
        this.minX = n;
        this.minY = n2;
        this.maxX = n3;
        this.maxY = n4;
        this.weapons = new Weaponry();
        this.resetShip();
    }

    public Image getImage() {
        int n = this.xsp > 3 ? 4 : (this.xsp > 0 ? 3 : (this.xsp == 0 ? 2 : (this.xsp < -3 ? 0 : 1)));
        return this.shipImages[n];
    }

    public void resetShipPos() {
        this.moveLeft = false;
        this.moveRight = false;
        this.moveUp = false;
        this.moveDown = false;
        this.shield = 100;
        this.shieldDecimal = 0;
        this.mode = 3;
        this.cnt = 10;
        this.x = (this.minX + this.maxX) / 2;
        this.y = this.maxY + 14;
        this.xsp = 0;
        this.ysp = 0;
    }

    public void resetShip() {
        this.resetShipPos();
        this.weapons.resetWeapons();
        this.shieldRate = 3;
        this.lives = 3;
        this.points = 0;
    }

    public void resetControls() {
        this.fireHeld = false;
        this.firePressed = false;
        this.moveDown = false;
        this.moveUp = false;
        this.moveRight = false;
        this.moveLeft = false;
    }

    public void update(Graphics graphics) {
        if (this.mode == 3) {
            this.y = this.maxY - 10 + this.cnt * 3;
            this.x = (this.minX + this.maxX) / 2;
            --this.cnt;
            if (this.cnt == 0) {
                this.mode = 2;
                this.cnt = 12;
            }
        } else if (this.mode == 2) {
            --this.cnt;
            if (this.cnt == 0) {
                this.mode = 1;
            }
        } else if (this.mode == 4) {
            --this.cnt;
            if (this.cnt == 0) {
                GameScreen.instance.mode = 3;
            }
        }
        if (this.mode != 4 && (this.mode == 1 || this.cnt % 2 != 0)) {
            graphics.drawImage(this.getImage(), this.x, this.y, 3);
        }
        graphics.setColor(140, 60, 40);
        int n = this.shield / 2;
        graphics.drawRect(1, 48, 2, 50);
        graphics.setColor(20, 200, 20);
        graphics.fillRect(1, 98 - n, 5, n);
        graphics.setColor(200, 20, 20);
        graphics.fillRect(1, 49, 5, 49 - n);
        graphics.setColor(150, 130, 250);
        graphics.setColor(240, 20, 20);
        if (graphics.getClipHeight() == 208) {
            graphics.fillRect(0, 0, 33, 14);
            graphics.fillRect(0, 34, 8, 14);
            graphics.setColor(0, 0, 0);
        }
        graphics.drawString(Integer.toString(this.points), 0, 0, 20);
        graphics.drawString(Integer.toString(this.lives), 0, 46, 68);
        if (this.mode == 1 || this.mode == 2) {
            int n2;
            this.xsp = this.moveLeft ? -5 : (this.moveRight ? 5 : 0);
            this.ysp = this.moveUp ? -5 : (this.moveDown ? 5 : 0);
            if (this.x < this.minX) {
                this.x = this.minX;
                this.xsp = 0;
            }
            if (this.y < this.minY) {
                this.y = this.minY;
                this.ysp = 0;
            }
            if (this.x > this.maxX) {
                this.x = this.maxX;
                this.xsp = 0;
            }
            if (this.y > this.maxY) {
                this.y = this.maxY;
                this.ysp = 0;
            }
            if (this.firePressed || this.fireHeld) {
                this.weapons.fire(this.x, this.y, this.firePressed);
                this.firePressed = false;
            }
            this.weapons.load();
            if (this.shield < 0) {
                this.shield = 0;
            }
            this.shieldDecimal += this.shieldRate;
            while (this.shieldDecimal >= 10) {
                this.shieldDecimal -= 10;
                ++this.shield;
            }
            if (this.shield > 100) {
                this.shield = 100;
            }
            if (this.mode == 1 && (n2 = this.enemies.isHit(this.x, this.y, 6, 6, 100)) > 0) {
                this.hit(Enemies.ramDamage[n2]);
            }
            this.x += this.xsp;
            this.y += this.ysp;
        }
    }

    public void hit(int n) {
        this.shield -= n;
        if (this.shield < 0) {
            --this.lives;
            this.explosions.makeNormalExplosion(this.x, this.y);
            if (this.lives == 0) {
                this.mode = 4;
                this.shield = 0;
                this.cnt = 20;
            } else {
                this.mode = 3;
                this.x = 48;
                this.cnt = 10;
                this.shield = 100;
            }
        }
        Effects.playSound2();
        Effects.vibrate();
    }

    static {
        MODE_NORMAL = 1;
        MODE_INVINC = 2;
        MODE_DEPLOY = 3;
        MODE_DEAD = 4;
    }
}

